;======================================================================================================================
; Game Constants
;======================================================================================================================

; Screen Values
ScreenWidth				equ		320						; Screen Width
ScreenHeight			equ		256		; 256				; Screen Height

BitplaneSize			equ		(320/8)*256	; 256!			; Size of 1 Bitplanes
NoOfBpls				equ		4						; Number of Bitplanes

NoOfColours				equ		16						; Number of Colours for our Background

; Font Size
FonthWidth				equ		8						; Font Width 
FontHeight				equ		8						; Fonth Height

; Print Info
LineBytes				equ		ScreenWidth/8			; Number of bytes on the X Axis

NextCharRow				equ		LineBytes*FontHeight	; This is font height * number of bytes on the X Axis

StartRowOffset			equ		31						; HUD starting postion is X = 30, X = 0 is at start of Line

; Player possible X-Positions
Middle					equ		112						; Postion of Player in the Middle
Left					equ		Middle-16				; Position of Player on the Left Side
Right					equ		Middle+16				; Position of Player on the Right Side

; Player Animation Delay
AnimFrameDelay			equ		10						; Delay for Animation of Player

; Player Start Position
PlayerX					equ		Left					; Player Start Position on the X Axis
PlayerY					equ		16*2					; Player Start Position on the Y Axis

SpritesHeight			equ		16						; All Sprites are of same height

; Maximun Enemies On The Screen
MaxEnemiesOnScreen		equ		6						; Maximun is 6 sprites on screen as enemies

; Maximun Enemies On The Screen
JoystickFrames			equ		5						; Every 5 frames Read Joystick	

; Falling Speed
FastFall				equ		2						; Fast falling speed of player
NormalFall				equ		1						; Normal Speed of player falling down

; Middle Fall Timer
MiddleFallTimer			equ		100						; Falling Timer of Player (50 frames = 1 second)

; Energy and Depth Bar Position in the HUD (Specified in Line characters)
EnergyBarPos			equ		13
DepthBarPos				equ		19

; Energy Bar Length
BarLength				equ		8						; The Energy Bar Length in Characters

; No Of Pixels of the Energy Bar
EnergyStrength			equ		(8*8)+1					; EnergySrength

; Depth Position
DepthLevel				equ		1

; Depth Timer
; Time to go to the next level
; Every 50 it is 1 second
DepthTimer				equ		50*15					; 50 = 1 second

; Points Per Enemy
PointsPerEnemy			equ		10						; By how much the score is increment for each level

; Maximum number of Frames
; For a sprite to be respawned
MaxRespawm				equ		127						; Every 50 is 1 second hence 2.5+ seconds

; Minimum number of Frames
; For a sprite to be respawned
MinRespawm				equ		27						; Every 50 is 1 second hence 2.5+ seconds