/*
 * Decompiled with CFR 0.152.
 */
package demo.view.renderers;

import demo.model.Demo;
import demo.model.Layer;
import demo.view.AssetLoader;
import demo.view.IObjectView;
import demo.view.LayerRenderer;
import demo.view.LayerView;
import demo.view.ObjectRenderer;
import demo.view.ObjectView;
import demo.view.PaintView;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;
import org.openrndr.Program;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.extra.mesh.MeshData;
import org.openrndr.extra.mesh.MeshDataExtensionsKt;
import org.openrndr.extra.objloader.OBJLoaderKt;
import org.openrndr.math.Matrix44;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015R\u00020\u0016H\u0016R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldemo/view/renderers/MeshInstanceRenderer;", "Ldemo/view/ObjectRenderer;", "<init>", "()V", "program", "Lorg/openrndr/Program;", "getProgram", "()Lorg/openrndr/Program;", "program$delegate", "Lkotlin/Lazy;", "demo", "Ldemo/model/Demo;", "getDemo", "()Ldemo/model/Demo;", "demo$delegate", "meshes", "Ldemo/view/AssetLoader;", "Ldemo/view/renderers/MeshInstanceRenderer$MeshAsset;", "draw", "", "objectContext", "Ldemo/view/LayerRenderer$ObjectContext;", "Ldemo/view/LayerRenderer;", "MeshAsset", "deminityy"})
@SourceDebugExtension(value={"SMAP\nMeshInstanceRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MeshInstanceRenderer.kt\ndemo/view/renderers/MeshInstanceRenderer\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n58#2,6:75\n58#2,6:81\n1#3:87\n*S KotlinDebug\n*F\n+ 1 MeshInstanceRenderer.kt\ndemo/view/renderers/MeshInstanceRenderer\n*L\n19#1:75,6\n20#1:81,6\n*E\n"})
public final class MeshInstanceRenderer
extends ObjectRenderer {
    @NotNull
    private final Lazy program$delegate;
    @NotNull
    private final Lazy demo$delegate;
    @NotNull
    private final AssetLoader<MeshAsset> meshes;

    public MeshInstanceRenderer() {
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.program$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<Program>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final Program invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(Program.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(Program.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.demo$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<Demo>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final Demo invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(Demo.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(Demo.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        this.meshes = new AssetLoader(this.getProgram(), this.getDemo().getAssetPath(), null, null, MeshInstanceRenderer::meshes$lambda$0, 12, null);
    }

    @NotNull
    public final Program getProgram() {
        Lazy lazy = this.program$delegate;
        return (Program)lazy.getValue();
    }

    @NotNull
    public final Demo getDemo() {
        Lazy lazy = this.demo$delegate;
        return (Demo)lazy.getValue();
    }

    @Override
    public void draw(@NotNull LayerRenderer.ObjectContext objectContext) {
        Intrinsics.checkNotNullParameter(objectContext, "objectContext");
        IObjectView iObjectView = objectContext.getObjectView();
        Intrinsics.checkNotNull(iObjectView, "null cannot be cast to non-null type demo.view.ObjectView");
        ObjectView ov = (ObjectView)iObjectView;
        double ot = objectContext.getObjectTime();
        LayerView layerView = objectContext.getLayerView();
        List<VertexBuffer> transforms = MeshInstanceRenderer.draw$transforms(ov, ot);
        List<VertexBuffer> geometry = MeshInstanceRenderer.draw$geometry(ov, ot, this, objectContext);
        if (objectContext.getAssetName() != null) {
            DrawerKt.isolated(this.getDrawer(), arg_0 -> MeshInstanceRenderer.draw$lambda$2(ov, this, objectContext, ot, geometry, transforms, layerView, arg_0));
        }
    }

    private static final MeshAsset meshes$lambda$0(File file, String string) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(string, "<unused var>");
        MeshData meshData = OBJLoaderKt.loadOBJMeshData(file).toMeshData();
        return new MeshAsset(MeshDataExtensionsKt.toVertexBuffer$default(meshData, 0, null, 3, null), meshData);
    }

    private static final List<VertexBuffer> draw$transforms(ObjectView ov, double ot) {
        Function1<Double, Object> function1 = ov.getFunctions1().get("transforms");
        Object object = function1 != null ? function1.invoke(ot) : null;
        List list = object instanceof List ? (List)object : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final List<VertexBuffer> draw$geometry(ObjectView ov, double ot, MeshInstanceRenderer this$0, LayerRenderer.ObjectContext $objectContext) {
        Function1<Double, Object> function1 = ov.getFunctions1().get("geometry");
        Object object = function1 != null ? function1.invoke(ot) : null;
        List<VertexBuffer> list = object instanceof List ? (List<VertexBuffer>)object : null;
        if (list == null) {
            AssetLoader<MeshAsset> assetLoader = this$0.meshes;
            String string = $objectContext.getAssetName();
            Intrinsics.checkNotNull(string);
            list = CollectionsKt.listOf(assetLoader.get(string).getVertexBuffer());
        }
        return list;
    }

    private static final Unit draw$lambda$2(ObjectView $ov, MeshInstanceRenderer this$0, LayerRenderer.ObjectContext $objectContext, double $ot, List $geometry, List $transforms, LayerView $layerView, Drawer $this$isolated) {
        PaintView paint;
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        Pair<Layer.Paint, Map<String, Double>> pair = $ov.getEffectivePaint();
        if (pair != null) {
            Pair<Layer.Paint, Map<String, Double>> it = pair;
            boolean bl = false;
            v1 = $layerView.getPaints().get(it);
        } else {
            v1 = paint = null;
        }
        if (paint != null) {
            paint.apply(this$0.getDrawer(), this$0.getTargetManager(), this$0.getImages(), ((Number)$objectContext.getFunctions().getPaintTime().invoke($ot)).doubleValue());
            this$0.getDrawer().setShadeStyle(paint.getShadeStyle());
        }
        Matrix44 modelTransform = Matrix44.Companion.getIDENTITY();
        modelTransform = modelTransform.times($objectContext.getTransform());
        Drawer drawer = this$0.getDrawer();
        drawer.setModel(drawer.getModel().times(modelTransform));
        this$0.getDrawer().setFill($objectContext.getFunctions().getFill().invoke($ot));
        Drawer.vertexBufferInstances$default(this$0.getDrawer(), $geometry, $transforms, DrawPrimitive.TRIANGLES, !((Collection)$transforms).isEmpty() ? ((VertexBuffer)CollectionsKt.first($transforms)).getVertexCount() : $ov.getInstanceCount(), 0, 0, 48, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Ldemo/view/renderers/MeshInstanceRenderer$MeshAsset;", "", "vertexBuffer", "Lorg/openrndr/draw/VertexBuffer;", "meshData", "Lorg/openrndr/extra/mesh/MeshData;", "<init>", "(Lorg/openrndr/draw/VertexBuffer;Lorg/openrndr/extra/mesh/MeshData;)V", "getVertexBuffer", "()Lorg/openrndr/draw/VertexBuffer;", "getMeshData", "()Lorg/openrndr/extra/mesh/MeshData;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "deminityy"})
    public static final class MeshAsset {
        @NotNull
        private final VertexBuffer vertexBuffer;
        @NotNull
        private final MeshData meshData;

        public MeshAsset(@NotNull VertexBuffer vertexBuffer, @NotNull MeshData meshData) {
            Intrinsics.checkNotNullParameter(vertexBuffer, "vertexBuffer");
            Intrinsics.checkNotNullParameter(meshData, "meshData");
            this.vertexBuffer = vertexBuffer;
            this.meshData = meshData;
        }

        @NotNull
        public final VertexBuffer getVertexBuffer() {
            return this.vertexBuffer;
        }

        @NotNull
        public final MeshData getMeshData() {
            return this.meshData;
        }

        @NotNull
        public final VertexBuffer component1() {
            return this.vertexBuffer;
        }

        @NotNull
        public final MeshData component2() {
            return this.meshData;
        }

        @NotNull
        public final MeshAsset copy(@NotNull VertexBuffer vertexBuffer, @NotNull MeshData meshData) {
            Intrinsics.checkNotNullParameter(vertexBuffer, "vertexBuffer");
            Intrinsics.checkNotNullParameter(meshData, "meshData");
            return new MeshAsset(vertexBuffer, meshData);
        }

        public static /* synthetic */ MeshAsset copy$default(MeshAsset meshAsset, VertexBuffer vertexBuffer, MeshData meshData, int n, Object object) {
            if ((n & 1) != 0) {
                vertexBuffer = meshAsset.vertexBuffer;
            }
            if ((n & 2) != 0) {
                meshData = meshAsset.meshData;
            }
            return meshAsset.copy(vertexBuffer, meshData);
        }

        @NotNull
        public String toString() {
            return "MeshAsset(vertexBuffer=" + this.vertexBuffer + ", meshData=" + this.meshData + ")";
        }

        public int hashCode() {
            int result = this.vertexBuffer.hashCode();
            result = result * 31 + this.meshData.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MeshAsset)) {
                return false;
            }
            MeshAsset meshAsset = (MeshAsset)other;
            if (!Intrinsics.areEqual(this.vertexBuffer, meshAsset.vertexBuffer)) {
                return false;
            }
            return Intrinsics.areEqual(this.meshData, meshAsset.meshData);
        }
    }
}

