/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.hocon;

import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.config.ConfigValueType;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.hocon.AbstractHoconEncoder;
import kotlinx.serialization.hocon.Hocon;
import kotlinx.serialization.hocon.HoconExceptionsKt;
import org.jetbrains.annotations.NotNull;

@ExperimentalSerializationApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\b\u0001\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0006H\u0014J\b\u0010\u0013\u001a\u00020\u0006H\u0014J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0006H\u0002R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkotlinx/serialization/hocon/HoconConfigMapEncoder;", "Lkotlinx/serialization/hocon/AbstractHoconEncoder;", "hocon", "Lkotlinx/serialization/hocon/Hocon;", "configConsumer", "Lkotlin/Function1;", "Lcom/typesafe/config/ConfigValue;", "", "<init>", "(Lkotlinx/serialization/hocon/Hocon;Lkotlin/jvm/functions/Function1;)V", "configMap", "", "", "key", "isKey", "", "encodeTaggedConfigValue", "tag", "value", "getCurrent", "unwrappedNullable", "", "kotlinx-serialization-hocon"})
public final class HoconConfigMapEncoder
extends AbstractHoconEncoder {
    @NotNull
    private final Map<String, ConfigValue> configMap;
    private String key;
    private boolean isKey;

    public HoconConfigMapEncoder(@NotNull Hocon hocon, @NotNull Function1<? super ConfigValue, Unit> configConsumer) {
        Intrinsics.checkNotNullParameter(hocon, "hocon");
        Intrinsics.checkNotNullParameter(configConsumer, "configConsumer");
        super(hocon, configConsumer);
        this.configMap = new LinkedHashMap();
        this.isKey = true;
    }

    @Override
    protected void encodeTaggedConfigValue(@NotNull String tag, @NotNull ConfigValue value) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(value, "value");
        if (this.isKey) {
            ConfigValueType configValueType = value.valueType();
            switch (configValueType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[configValueType.ordinal()]) {
                case 1: 
                case 2: {
                    throw HoconExceptionsKt.InvalidKeyKindException(value);
                }
            }
            this.key = String.valueOf(this.unwrappedNullable(value));
            this.isKey = false;
        } else {
            Map<String, ConfigValue> map2 = this.configMap;
            String string = this.key;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException("key");
                string = null;
            }
            map2.put(string, value);
            this.isKey = true;
        }
    }

    @Override
    @NotNull
    protected ConfigValue getCurrent() {
        ConfigObject configObject = ConfigValueFactory.fromMap(this.configMap);
        Intrinsics.checkNotNullExpressionValue(configObject, "fromMap(...)");
        return configObject;
    }

    private final Object unwrappedNullable(ConfigValue $this$unwrappedNullable) {
        return $this$unwrappedNullable.unwrapped();
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConfigValueType.values().length];
            try {
                nArray[ConfigValueType.OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigValueType.LIST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

