/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.egl.EGL10;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.SharedLibrary;

public final class EGL {
    private static @Nullable FunctionProvider functionProvider;
    private static @Nullable EGLCapabilities caps;

    private EGL() {
    }

    public static void create() {
        EGL.create(Library.loadNative(EGL.class, "org.lwjgl.egl", Configuration.EGL_LIBRARY_NAME, Configuration.EGL_LIBRARY_NAME_DEFAULTS()));
    }

    public static void create(String libName) {
        EGL.create(Library.loadNative(EGL.class, "org.lwjgl.egl", libName));
    }

    private static void create(SharedLibrary EGL2) {
        try {
            EGL.create((FunctionProvider)new SharedLibrary.Delegate(EGL2){
                private final long eglGetProcAddress;
                {
                    this.eglGetProcAddress = this.library.getFunctionAddress("eglGetProcAddress");
                    if (this.eglGetProcAddress == 0L) {
                        throw new IllegalStateException("A core EGL function is missing. Make sure that EGL is available.");
                    }
                }

                @Override
                public long getFunctionAddress(ByteBuffer functionName) {
                    long address = JNI.callPP(MemoryUtil.memAddress(functionName), this.eglGetProcAddress);
                    if (address == 0L && (address = this.library.getFunctionAddress(functionName)) == 0L && Checks.DEBUG_FUNCTIONS) {
                        APIUtil.apiLogMissing("EGL", functionName);
                    }
                    return address;
                }
            });
        }
        catch (RuntimeException e) {
            EGL2.free();
            throw e;
        }
    }

    public static void create(FunctionProvider functionProvider) {
        if (EGL.functionProvider != null) {
            throw new IllegalStateException("EGL has already been created.");
        }
        EGL.functionProvider = functionProvider;
        caps = EGL.createClientCapabilities();
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        caps = null;
        if (functionProvider instanceof NativeResource) {
            ((NativeResource)((Object)functionProvider)).free();
        }
        functionProvider = null;
    }

    static <T> T check(@Nullable T t) {
        if (t == null) {
            throw new IllegalStateException("EGL library has not been loaded.");
        }
        return t;
    }

    public static FunctionProvider getFunctionProvider() {
        return EGL.check(functionProvider);
    }

    public static EGLCapabilities getCapabilities() {
        return EGL.check(caps);
    }

    private static EGLCapabilities createClientCapabilities() {
        FunctionProvider functionProvider = EGL.functionProvider;
        if (functionProvider == null) {
            throw new IllegalStateException("EGL library has not been loaded.");
        }
        HashSet<String> supportedExtensions = new HashSet<String>(32);
        long QueryString = functionProvider.getFunctionAddress("eglQueryString");
        long extensionsString = JNI.callPP(0L, 12373, QueryString);
        if (extensionsString == 0L) {
            JNI.callI(functionProvider.getFunctionAddress("eglGetError"));
        } else {
            String versionString = MemoryUtil.memASCIISafe(JNI.callPP(0L, 12372, QueryString));
            if (versionString == null) {
                JNI.callI(functionProvider.getFunctionAddress("eglGetError"));
            } else {
                APIUtil.APIVersion version = APIUtil.apiParseVersion(versionString);
                EGL.addEGLVersions(version.major, version.minor, supportedExtensions);
            }
        }
        APIUtil.apiFilterExtensions(supportedExtensions, Configuration.EGL_EXTENSION_FILTER);
        return new EGLCapabilities(functionProvider, supportedExtensions);
    }

    public static EGLCapabilities createDisplayCapabilities(long dpy) {
        String versionString = EGL10.eglQueryString(dpy, 12372);
        if (versionString == null) {
            throw new IllegalArgumentException("Invalid EGLDisplay handle specified.");
        }
        APIUtil.APIVersion version = APIUtil.apiParseVersion(versionString);
        return EGL.createDisplayCapabilities(dpy, version.major, version.minor);
    }

    public static EGLCapabilities createDisplayCapabilities(long dpy, int majorVersion, int minorVersion) {
        FunctionProvider functionProvider = EGL.functionProvider;
        if (functionProvider == null) {
            throw new IllegalStateException("EGL library has not been loaded.");
        }
        HashSet<String> supportedExtensions = new HashSet<String>(32);
        EGL.addEGLVersions(majorVersion, minorVersion, supportedExtensions);
        String extensionsString = EGL10.eglQueryString(dpy, 12373);
        if (extensionsString != null) {
            EGL.addExtensions(extensionsString, supportedExtensions);
        }
        return new EGLCapabilities(Objects.requireNonNull(caps), supportedExtensions);
    }

    private static void addEGLVersions(int MAJOR, int MINOR, Set<String> supportedExtensions) {
        int[][] versions = new int[][]{{0, 1, 2, 3, 4, 5}};
        block0: for (int M = 1; M <= Math.min(MAJOR, versions.length); ++M) {
            for (int m : versions[M - 1]) {
                if (M == MAJOR && MINOR < m) continue block0;
                supportedExtensions.add("EGL" + M + m);
            }
        }
    }

    private static void addExtensions(String extensionsString, Set<String> supportedExtensions) {
        StringTokenizer tokenizer = new StringTokenizer(extensionsString);
        while (tokenizer.hasMoreTokens()) {
            supportedExtensions.add(tokenizer.nextToken());
        }
    }

    static {
        if (!Configuration.EGL_EXPLICIT_INIT.get(false).booleanValue()) {
            EGL.create();
        }
    }
}

