/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class EXTDevicePersistentID {
    public static final int EGL_DRIVER_NAME_EXT = 13150;
    public static final int EGL_DEVICE_UUID_EXT = 13148;
    public static final int EGL_DRIVER_UUID_EXT = 13149;

    protected EXTDevicePersistentID() {
        throw new UnsupportedOperationException();
    }

    public static int neglQueryDeviceBinaryEXT(long device, int name, int max_size, long value, long size) {
        long __functionAddress = EGL.getCapabilities().eglQueryDeviceBinaryEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        return JNI.callPPPI(device, name, max_size, value, size, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryDeviceBinaryEXT(@NativeType(value="EGLDeviceEXT") long device, @NativeType(value="EGLint") int name, @NativeType(value="void *") @Nullable ByteBuffer value, @NativeType(value="EGLint *") IntBuffer size) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)size, 1);
        }
        return EXTDevicePersistentID.neglQueryDeviceBinaryEXT(device, name, Checks.remainingSafe(value), MemoryUtil.memAddressSafe(value), MemoryUtil.memAddress(size)) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryDeviceBinaryEXT(@NativeType(value="EGLDeviceEXT") long device, @NativeType(value="EGLint") int name, @NativeType(value="void *") @Nullable ByteBuffer value, @NativeType(value="EGLint *") int[] size) {
        long __functionAddress = EGL.getCapabilities().eglQueryDeviceBinaryEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
            Checks.check(size, 1);
        }
        return JNI.callPPPI(device, name, Checks.remainingSafe(value), MemoryUtil.memAddressSafe(value), size, __functionAddress) != 0;
    }
}

