/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.nfd;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.nfd.NFDWindowHandle;

@NativeType(value="struct nfdpickfolderu8args_t")
public class NFDPickFolderArgs
extends Struct<NFDPickFolderArgs>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DEFAULTPATH;
    public static final int PARENTWINDOW;

    protected NFDPickFolderArgs(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected NFDPickFolderArgs create(long address, @Nullable ByteBuffer container) {
        return new NFDPickFolderArgs(address, container);
    }

    public NFDPickFolderArgs(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NFDPickFolderArgs.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="nfdchar_t const *")
    public @Nullable ByteBuffer defaultPath() {
        return NFDPickFolderArgs.ndefaultPath(this.address());
    }

    @NativeType(value="nfdchar_t const *")
    public @Nullable String defaultPathString() {
        return NFDPickFolderArgs.ndefaultPathString(this.address());
    }

    @NativeType(value="nfdwindowhandle_t")
    public NFDWindowHandle parentWindow() {
        return NFDPickFolderArgs.nparentWindow(this.address());
    }

    public NFDPickFolderArgs defaultPath(@NativeType(value="nfdchar_t const *") @Nullable ByteBuffer value) {
        NFDPickFolderArgs.ndefaultPath(this.address(), value);
        return this;
    }

    public NFDPickFolderArgs parentWindow(@NativeType(value="nfdwindowhandle_t") NFDWindowHandle value) {
        NFDPickFolderArgs.nparentWindow(this.address(), value);
        return this;
    }

    public NFDPickFolderArgs parentWindow(Consumer<NFDWindowHandle> consumer) {
        consumer.accept(this.parentWindow());
        return this;
    }

    public NFDPickFolderArgs set(@Nullable ByteBuffer defaultPath, NFDWindowHandle parentWindow) {
        this.defaultPath(defaultPath);
        this.parentWindow(parentWindow);
        return this;
    }

    public NFDPickFolderArgs set(NFDPickFolderArgs src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NFDPickFolderArgs malloc() {
        return new NFDPickFolderArgs(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static NFDPickFolderArgs calloc() {
        return new NFDPickFolderArgs(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static NFDPickFolderArgs create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new NFDPickFolderArgs(MemoryUtil.memAddress(container), container);
    }

    public static NFDPickFolderArgs create(long address) {
        return new NFDPickFolderArgs(address, null);
    }

    public static @Nullable NFDPickFolderArgs createSafe(long address) {
        return address == 0L ? null : new NFDPickFolderArgs(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(NFDPickFolderArgs.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NFDPickFolderArgs.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static NFDPickFolderArgs malloc(MemoryStack stack) {
        return new NFDPickFolderArgs(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NFDPickFolderArgs calloc(MemoryStack stack) {
        return new NFDPickFolderArgs(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static @Nullable ByteBuffer ndefaultPath(long struct) {
        return MemoryUtil.memByteBufferNT1Safe(MemoryUtil.memGetAddress(struct + (long)DEFAULTPATH));
    }

    public static @Nullable String ndefaultPathString(long struct) {
        return MemoryUtil.memUTF8Safe(MemoryUtil.memGetAddress(struct + (long)DEFAULTPATH));
    }

    public static NFDWindowHandle nparentWindow(long struct) {
        return NFDWindowHandle.create(struct + (long)PARENTWINDOW);
    }

    public static void ndefaultPath(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(value);
        }
        MemoryUtil.memPutAddress(struct + (long)DEFAULTPATH, MemoryUtil.memAddressSafe(value));
    }

    public static void nparentWindow(long struct, NFDWindowHandle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PARENTWINDOW, NFDWindowHandle.SIZEOF);
    }

    static {
        Struct.Layout layout = NFDPickFolderArgs.__struct(NFDPickFolderArgs.__member(POINTER_SIZE), NFDPickFolderArgs.__member(NFDWindowHandle.SIZEOF, NFDWindowHandle.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DEFAULTPATH = layout.offsetof(0);
        PARENTWINDOW = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NFDPickFolderArgs, Buffer>
    implements NativeResource {
        private static final NFDPickFolderArgs ELEMENT_FACTORY = NFDPickFolderArgs.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected NFDPickFolderArgs getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="nfdchar_t const *")
        public @Nullable ByteBuffer defaultPath() {
            return NFDPickFolderArgs.ndefaultPath(this.address());
        }

        @NativeType(value="nfdchar_t const *")
        public @Nullable String defaultPathString() {
            return NFDPickFolderArgs.ndefaultPathString(this.address());
        }

        @NativeType(value="nfdwindowhandle_t")
        public NFDWindowHandle parentWindow() {
            return NFDPickFolderArgs.nparentWindow(this.address());
        }

        public Buffer defaultPath(@NativeType(value="nfdchar_t const *") @Nullable ByteBuffer value) {
            NFDPickFolderArgs.ndefaultPath(this.address(), value);
            return this;
        }

        public Buffer parentWindow(@NativeType(value="nfdwindowhandle_t") NFDWindowHandle value) {
            NFDPickFolderArgs.nparentWindow(this.address(), value);
            return this;
        }

        public Buffer parentWindow(Consumer<NFDWindowHandle> consumer) {
            consumer.accept(this.parentWindow());
            return this;
        }
    }
}

