/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.binpack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.binpack.PackNode;
import org.openrndr.binpack.Splitter;
import org.openrndr.shape.IntRectangle;
import org.openrndr.shape.IntRectangleKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/openrndr/binpack/GreedySplitter;", "Lorg/openrndr/binpack/Splitter;", "<init>", "()V", "horizontalBias", "", "getHorizontalBias", "()D", "setHorizontalBias", "(D)V", "verticalBias", "getVerticalBias", "setVerticalBias", "horizontalDivisions", "", "getHorizontalDivisions", "()I", "setHorizontalDivisions", "(I)V", "verticalDivisions", "getVerticalDivisions", "setVerticalDivisions", "split", "", "Lorg/openrndr/binpack/PackNode;", "node", "rectangle", "Lorg/openrndr/shape/IntRectangle;", "openrndr-binpack"})
@SourceDebugExtension(value={"SMAP\nPacker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Packer.kt\norg/openrndr/binpack/GreedySplitter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,395:1\n1557#2:396\n1628#2,3:397\n*S KotlinDebug\n*F\n+ 1 Packer.kt\norg/openrndr/binpack/GreedySplitter\n*L\n293#1:396\n293#1:397,3\n*E\n"})
public final class GreedySplitter
implements Splitter {
    private double horizontalBias;
    private double verticalBias;
    private int horizontalDivisions = 1;
    private int verticalDivisions = 1;

    public final double getHorizontalBias() {
        return this.horizontalBias;
    }

    public final void setHorizontalBias(double d) {
        this.horizontalBias = d;
    }

    public final double getVerticalBias() {
        return this.verticalBias;
    }

    public final void setVerticalBias(double d) {
        this.verticalBias = d;
    }

    public final int getHorizontalDivisions() {
        return this.horizontalDivisions;
    }

    public final void setHorizontalDivisions(int n) {
        this.horizontalDivisions = n;
    }

    public final int getVerticalDivisions() {
        return this.verticalDivisions;
    }

    public final void setVerticalDivisions(int n) {
        this.verticalDivisions = n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PackNode> split(@NotNull PackNode node, @NotNull IntRectangle rectangle) {
        void $this$mapTo$iv$iv;
        int i;
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(rectangle, "rectangle");
        int hc = this.horizontalDivisions * 2 + 1;
        int vc = this.verticalDivisions * 2 + 1;
        double hb = (this.horizontalBias + 1.0) / (double)2;
        double vb = (this.verticalBias + 1.0) / (double)2;
        double leftMargin = hb * (double)(node.getArea().width() - rectangle.width()) / (double)this.horizontalDivisions;
        double topMargin = vb * (double)(node.getArea().height() - rectangle.height()) / (double)this.verticalDivisions;
        double rightMargin = (1.0 - hb) * (double)(node.getArea().width() - rectangle.width()) / (double)this.horizontalDivisions;
        double bottomMargin = (1.0 - vb) * (double)(node.getArea().height() - rectangle.height()) / (double)this.verticalDivisions;
        IntRectangle[] rects = new IntRectangle[hc * vc];
        double x = node.getArea().x();
        double y = node.getArea().y();
        double[] xpos = new double[hc];
        double[] ypos = new double[vc];
        double[] widths = new double[hc];
        double[] heights = new double[vc];
        for (i = 0; i < hc; ++i) {
            xpos[i] = x;
            if (i < hc / 2) {
                x += leftMargin;
                widths[i] = leftMargin;
                continue;
            }
            if (i == hc / 2) {
                x += (double)rectangle.width();
                widths[i] = rectangle.width();
                continue;
            }
            x += rightMargin;
            widths[i] = rightMargin;
        }
        for (i = 0; i < vc; ++i) {
            ypos[i] = y;
            if (i < vc / 2) {
                y += topMargin;
                heights[i] = topMargin;
                continue;
            }
            if (i == vc / 2) {
                y += (double)rectangle.height();
                heights[i] = rectangle.height();
                continue;
            }
            y += bottomMargin;
            heights[i] = bottomMargin;
        }
        for (int j = 0; j < vc; ++j) {
            for (int i2 = 0; i2 < hc; ++i2) {
                rects[j * hc + i2] = IntRectangleKt.IntRectangle((int)xpos[i2], (int)ypos[j], (int)widths[i2], (int)heights[j]);
            }
        }
        int[] order = new int[hc * vc];
        order[0] = vc / 2 * hc + hc / 2;
        int count2 = 0;
        int n = order.length;
        for (int i3 = 1; i3 < n; ++i3) {
            order[i3] = count2++;
            if (count2 != order[0]) continue;
            ++count2;
        }
        Iterable $this$map$iv = RangesKt.until(0, hc * vc);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IntRectangle intRectangle = rects[order[it]];
            Intrinsics.checkNotNull(intRectangle);
            collection.add(new PackNode(intRectangle, null, 2, null));
        }
        return (List)destination$iv$iv;
    }
}

