/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.binpack;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.openrndr.binpack.PackNode;
import org.openrndr.binpack.Splitter;
import org.openrndr.shape.IntRectangle;
import org.openrndr.shape.IntRectangleKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00128\b\u0002\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/openrndr/binpack/RandomBinarySplitter;", "Lorg/openrndr/binpack/Splitter;", "enclosement", "Lorg/openrndr/shape/IntRectangle;", "invert", "", "constraints", "Lkotlin/Function2;", "Lorg/openrndr/binpack/PackNode;", "Lkotlin/ParameterName;", "name", "node", "rectangle", "<init>", "(Lorg/openrndr/shape/IntRectangle;ZLkotlin/jvm/functions/Function2;)V", "split", "", "openrndr-binpack"})
public final class RandomBinarySplitter
implements Splitter {
    @NotNull
    private final IntRectangle enclosement;
    private final boolean invert;
    @NotNull
    private final Function2<PackNode, IntRectangle, Boolean> constraints;

    public RandomBinarySplitter(@NotNull IntRectangle enclosement, boolean invert, @NotNull Function2<? super PackNode, ? super IntRectangle, Boolean> constraints) {
        Intrinsics.checkNotNullParameter(enclosement, "enclosement");
        Intrinsics.checkNotNullParameter(constraints, "constraints");
        this.enclosement = enclosement;
        this.invert = invert;
        this.constraints = constraints;
    }

    public /* synthetic */ RandomBinarySplitter(IntRectangle intRectangle, boolean bl, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            function2 = RandomBinarySplitter::_init_$lambda$0;
        }
        this(intRectangle, bl, function2);
    }

    @Override
    @NotNull
    public List<PackNode> split(@NotNull PackNode node, @NotNull IntRectangle rectangle) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(rectangle, "rectangle");
        if (!this.constraints.invoke(node, rectangle).booleanValue()) {
            return CollectionsKt.emptyList();
        }
        int dw = node.getArea().width() - rectangle.width();
        int dh = node.getArea().height() - rectangle.height();
        IntRectangle lrect = null;
        IntRectangle rrect = null;
        if (dw > dh) {
            if (Random.Default.nextDouble() < 0.5) {
                lrect = IntRectangleKt.IntRectangle(node.getArea().x(), node.getArea().y(), rectangle.width(), node.getArea().height());
                rrect = IntRectangleKt.IntRectangle(node.getArea().x() + rectangle.width(), node.getArea().y(), node.getArea().width() - rectangle.width(), node.getArea().height());
            } else {
                int ew = node.getArea().width() - rectangle.width();
                rrect = IntRectangleKt.IntRectangle(node.getArea().x(), node.getArea().y(), ew, node.getArea().height());
                lrect = IntRectangleKt.IntRectangle(node.getArea().x() + ew, node.getArea().y(), rectangle.width(), node.getArea().height());
            }
        } else if (Random.Default.nextDouble() < 0.5) {
            lrect = IntRectangleKt.IntRectangle(node.getArea().x(), node.getArea().y(), node.getArea().width(), rectangle.height());
            rrect = IntRectangleKt.IntRectangle(node.getArea().x(), node.getArea().y() + rectangle.height(), node.getArea().width(), node.getArea().height() - rectangle.height());
        } else {
            int eh = node.getArea().height() - rectangle.height();
            rrect = IntRectangleKt.IntRectangle(node.getArea().x(), node.getArea().y(), node.getArea().width(), eh);
            lrect = IntRectangleKt.IntRectangle(node.getArea().x(), node.getArea().y() + eh, node.getArea().width(), rectangle.height());
        }
        PackNode[] packNodeArray = new PackNode[]{new PackNode(lrect, node), new PackNode(rrect, node)};
        return CollectionsKt.listOf(packNodeArray);
    }

    private static final boolean _init_$lambda$0(PackNode packNode, IntRectangle intRectangle) {
        Intrinsics.checkNotNullParameter(packNode, "<unused var>");
        Intrinsics.checkNotNullParameter(intRectangle, "<unused var>");
        return true;
    }
}

