/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.BatchesKt;
import org.openrndr.draw.Session;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00060\u0001j\u0002`\u0002:\u0001\u0011B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/openrndr/draw/CircleBatch;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "geometry", "Lorg/openrndr/draw/VertexBuffer;", "drawStyle", "<init>", "(Lorg/openrndr/draw/VertexBuffer;Lorg/openrndr/draw/VertexBuffer;)V", "getGeometry", "()Lorg/openrndr/draw/VertexBuffer;", "getDrawStyle", "size", "", "getSize", "()I", "close", "", "Companion", "openrndr-draw"})
public final class CircleBatch
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VertexBuffer geometry;
    @NotNull
    private final VertexBuffer drawStyle;

    public CircleBatch(@NotNull VertexBuffer geometry, @NotNull VertexBuffer drawStyle) {
        Intrinsics.checkNotNullParameter(geometry, "geometry");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        this.geometry = geometry;
        this.drawStyle = drawStyle;
        if (!Intrinsics.areEqual(this.geometry.getVertexFormat(), BatchesKt.getCircleFormat())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!Intrinsics.areEqual(this.drawStyle.getVertexFormat(), BatchesKt.getDrawStyleFormat())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.geometry.getVertexCount() == this.drawStyle.getVertexCount())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final VertexBuffer getGeometry() {
        return this.geometry;
    }

    @NotNull
    public final VertexBuffer getDrawStyle() {
        return this.drawStyle;
    }

    public final int getSize() {
        return this.geometry.getVertexCount();
    }

    @Override
    public void close() {
        this.geometry.destroy();
        this.drawStyle.destroy();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"Lorg/openrndr/draw/CircleBatch$Companion;", "", "<init>", "()V", "create", "Lorg/openrndr/draw/CircleBatch;", "size", "", "session", "Lorg/openrndr/draw/Session;", "openrndr-draw"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CircleBatch create(int size, @Nullable Session session) {
            return new CircleBatch(VertexBufferKt.vertexBuffer(BatchesKt.getCircleFormat(), size, session), VertexBufferKt.vertexBuffer(BatchesKt.getDrawStyleFormat(), size, session));
        }

        public static /* synthetic */ CircleBatch create$default(Companion companion, int n, Session session, int n2, Object object) {
            if ((n2 & 2) != 0) {
                session = Session.Companion.getActive();
            }
            return companion.create(n, session);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

