/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.composition;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.extra.composition.Align;
import org.openrndr.extra.composition.AspectRatio;
import org.openrndr.extra.composition.CompositionDimensions;
import org.openrndr.extra.composition.CompositionKt;
import org.openrndr.extra.composition.CompositionNode;
import org.openrndr.extra.composition.CompositionStyleSheetKt;
import org.openrndr.extra.composition.DocumentStyle;
import org.openrndr.extra.composition.GroupNode;
import org.openrndr.extra.composition.ImageNode;
import org.openrndr.extra.composition.Length;
import org.openrndr.extra.composition.MeetOrSlice;
import org.openrndr.extra.composition.ShapeNode;
import org.openrndr.extra.composition.Style;
import org.openrndr.extra.composition.ViewBox;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.transforms.TransformBuilder;
import org.openrndr.math.transforms.TransformBuilderKt;
import org.openrndr.shape.Rectangle;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\tJ\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"J\u0010\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010%\u001a\u00020\u0012J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\"J\u0010\u0010(\u001a\u0004\u0018\u00010'2\u0006\u0010%\u001a\u00020\u0012J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\"J\u0010\u0010+\u001a\u0004\u0018\u00010*2\u0006\u0010%\u001a\u00020\u0012J\r\u0010,\u001a\u0004\u0018\u00010-\u00a2\u0006\u0002\u0010.J\r\u0010/\u001a\u000200H\u0000\u00a2\u0006\u0002\b1J\u0006\u00102\u001a\u000203R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u00064"}, d2={"Lorg/openrndr/extra/composition/Composition;", "", "root", "Lorg/openrndr/extra/composition/CompositionNode;", "bounds", "Lorg/openrndr/extra/composition/CompositionDimensions;", "<init>", "(Lorg/openrndr/extra/composition/CompositionNode;Lorg/openrndr/extra/composition/CompositionDimensions;)V", "Lorg/openrndr/shape/Rectangle;", "(Lorg/openrndr/extra/composition/CompositionNode;Lorg/openrndr/shape/Rectangle;)V", "getRoot", "()Lorg/openrndr/extra/composition/CompositionNode;", "getBounds", "()Lorg/openrndr/extra/composition/CompositionDimensions;", "setBounds", "(Lorg/openrndr/extra/composition/CompositionDimensions;)V", "namespaces", "", "", "getNamespaces", "()Ljava/util/Map;", "style", "Lorg/openrndr/extra/composition/Style;", "getStyle", "()Lorg/openrndr/extra/composition/Style;", "setStyle", "(Lorg/openrndr/extra/composition/Style;)V", "documentStyle", "Lorg/openrndr/extra/composition/DocumentStyle;", "getDocumentStyle", "()Lorg/openrndr/extra/composition/DocumentStyle;", "setDocumentStyle", "(Lorg/openrndr/extra/composition/DocumentStyle;)V", "findShapes", "", "Lorg/openrndr/extra/composition/ShapeNode;", "findShape", "id", "findImages", "Lorg/openrndr/extra/composition/ImageNode;", "findImage", "findGroups", "Lorg/openrndr/extra/composition/GroupNode;", "findGroup", "clear", "", "()Lkotlin/Unit;", "normalizedDiagonalLength", "", "normalizedDiagonalLength$orx_composition", "calculateViewportTransform", "Lorg/openrndr/math/Matrix44;", "orx-composition"})
public final class Composition {
    @NotNull
    private final CompositionNode root;
    @NotNull
    private CompositionDimensions bounds;
    @NotNull
    private final Map<String, String> namespaces;
    @NotNull
    private Style style;
    @NotNull
    private DocumentStyle documentStyle;

    public Composition(@NotNull CompositionNode root, @NotNull CompositionDimensions bounds) {
        Intrinsics.checkNotNullParameter(root, "root");
        Intrinsics.checkNotNullParameter(bounds, "bounds");
        this.root = root;
        this.bounds = bounds;
        this.namespaces = new LinkedHashMap();
        this.style = new Style();
        this.documentStyle = new DocumentStyle();
        CompositionDimensions compositionDimensions = this.bounds;
        Length x = compositionDimensions.component1();
        Length y = compositionDimensions.component2();
        Length width = compositionDimensions.component3();
        Length height = compositionDimensions.component4();
        CompositionStyleSheetKt.setX(this.style, x);
        CompositionStyleSheetKt.setY(this.style, y);
        CompositionStyleSheetKt.setWidth(this.style, width);
        CompositionStyleSheetKt.setHeight(this.style, height);
    }

    public /* synthetic */ Composition(CompositionNode compositionNode, CompositionDimensions compositionDimensions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            compositionDimensions = CompositionKt.getDefaultCompositionDimensions();
        }
        this(compositionNode, compositionDimensions);
    }

    @NotNull
    public final CompositionNode getRoot() {
        return this.root;
    }

    @NotNull
    public final CompositionDimensions getBounds() {
        return this.bounds;
    }

    public final void setBounds(@NotNull CompositionDimensions compositionDimensions) {
        Intrinsics.checkNotNullParameter(compositionDimensions, "<set-?>");
        this.bounds = compositionDimensions;
    }

    public Composition(@NotNull CompositionNode root, @NotNull Rectangle bounds) {
        Intrinsics.checkNotNullParameter(root, "root");
        Intrinsics.checkNotNullParameter(bounds, "bounds");
        this(root, new CompositionDimensions(bounds));
    }

    @NotNull
    public final Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    @NotNull
    public final Style getStyle() {
        return this.style;
    }

    public final void setStyle(@NotNull Style style) {
        Intrinsics.checkNotNullParameter(style, "<set-?>");
        this.style = style;
    }

    @NotNull
    public final DocumentStyle getDocumentStyle() {
        return this.documentStyle;
    }

    public final void setDocumentStyle(@NotNull DocumentStyle documentStyle) {
        Intrinsics.checkNotNullParameter(documentStyle, "<set-?>");
        this.documentStyle = documentStyle;
    }

    @NotNull
    public final List<ShapeNode> findShapes() {
        return CompositionKt.findShapes(this.root);
    }

    @Nullable
    public final ShapeNode findShape(@NotNull String id) {
        Intrinsics.checkNotNullParameter(id, "id");
        CompositionNode compositionNode = CompositionKt.find(this.root, arg_0 -> Composition.findShape$lambda$0(id, arg_0));
        return compositionNode instanceof ShapeNode ? (ShapeNode)compositionNode : null;
    }

    @NotNull
    public final List<ImageNode> findImages() {
        return CompositionKt.findImages(this.root);
    }

    @Nullable
    public final ImageNode findImage(@NotNull String id) {
        Intrinsics.checkNotNullParameter(id, "id");
        CompositionNode compositionNode = CompositionKt.find(this.root, arg_0 -> Composition.findImage$lambda$1(id, arg_0));
        return compositionNode instanceof ImageNode ? (ImageNode)compositionNode : null;
    }

    @NotNull
    public final List<GroupNode> findGroups() {
        return CompositionKt.findGroups(this.root);
    }

    @Nullable
    public final GroupNode findGroup(@NotNull String id) {
        Intrinsics.checkNotNullParameter(id, "id");
        CompositionNode compositionNode = CompositionKt.find(this.root, arg_0 -> Composition.findGroup$lambda$2(id, arg_0));
        return compositionNode instanceof GroupNode ? (GroupNode)compositionNode : null;
    }

    @Nullable
    public final Unit clear() {
        Unit unit;
        CompositionNode compositionNode = this.root;
        Object object = compositionNode instanceof GroupNode ? (GroupNode)compositionNode : null;
        if (object != null && (object = ((GroupNode)object).getChildren()) != null) {
            object.clear();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public final double normalizedDiagonalLength$orx_composition() {
        return Math.sqrt(this.bounds.getDimensions().squaredLength() / 2.0);
    }

    @NotNull
    public final Matrix44 calculateViewportTransform() {
        Matrix44 matrix44;
        ViewBox viewBox = CompositionStyleSheetKt.getViewBox(this.documentStyle);
        if (Intrinsics.areEqual(viewBox, ViewBox.None.INSTANCE)) {
            matrix44 = Matrix44.Companion.getIDENTITY();
        } else if (viewBox instanceof ViewBox.Value) {
            ViewBox viewBox2 = CompositionStyleSheetKt.getViewBox(this.documentStyle);
            Intrinsics.checkNotNull(viewBox2, "null cannot be cast to non-null type org.openrndr.extra.composition.ViewBox.Value");
            Rectangle vb = ((ViewBox.Value)viewBox2).getValue();
            if (Intrinsics.areEqual(vb, Rectangle.Companion.getEMPTY())) {
                matrix44 = Matrix44.Companion.getZERO();
            } else {
                Vector2 vbCorner = vb.corner();
                Vector2 vbDims = vb.dimensions();
                Vector2 eCorner = this.bounds.getPosition();
                Vector2 eDims = this.bounds.getDimensions();
                AspectRatio aspectRatio = CompositionStyleSheetKt.getPreserveAspectRatio(this.documentStyle);
                Align align = aspectRatio.component1();
                MeetOrSlice meetOrSlice = aspectRatio.component2();
                Vector2 it = eDims.div(vbDims);
                boolean bl = false;
                Vector2 scale = align != Align.NONE ? (meetOrSlice == MeetOrSlice.MEET ? new Vector2(Math.min(it.x(), it.y())) : new Vector2(Math.max(it.x(), it.y()))) : it;
                Vector2 it2 = eCorner.minus(vbCorner.times(scale));
                boolean bl2 = false;
                double cx = eDims.x() - vbDims.x() * scale.x();
                double cy = eDims.y() - vbDims.y() * scale.y();
                Vector2 translate = it2.plus(switch (WhenMappings.$EnumSwitchMapping$0[align.ordinal()]) {
                    case 1 -> Vector2.Companion.getZERO();
                    case 2 -> Vector2.Companion.getZERO();
                    case 3 -> new Vector2(cx / (double)2, 0.0);
                    case 4 -> new Vector2(cx, 0.0);
                    case 5 -> new Vector2(0.0, cy / (double)2);
                    case 6 -> new Vector2(cx / (double)2, cy / (double)2);
                    case 7 -> new Vector2(cx, cy / (double)2);
                    case 8 -> new Vector2(0.0, cy);
                    case 9 -> new Vector2(cx / (double)2, cy);
                    case 10 -> new Vector2(cx, cy);
                    default -> throw new NoWhenBranchMatchedException();
                });
                matrix44 = TransformBuilderKt.buildTransform$default(null, arg_0 -> Composition.calculateViewportTransform$lambda$5(translate, scale, arg_0), 1, null);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return matrix44;
    }

    private static final boolean findShape$lambda$0(String $id, CompositionNode it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it instanceof ShapeNode && Intrinsics.areEqual(it.getId(), $id);
    }

    private static final boolean findImage$lambda$1(String $id, CompositionNode it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it instanceof ImageNode && Intrinsics.areEqual(it.getId(), $id);
    }

    private static final boolean findGroup$lambda$2(String $id, CompositionNode it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it instanceof GroupNode && Intrinsics.areEqual(it.getId(), $id);
    }

    private static final Unit calculateViewportTransform$lambda$5(Vector2 $translate, Vector2 $scale, TransformBuilder $this$buildTransform) {
        Intrinsics.checkNotNullParameter($this$buildTransform, "$this$buildTransform");
        $this$buildTransform.translate($translate);
        $this$buildTransform.scale($scale.x(), $scale.y(), 1.0);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Align.values().length];
            try {
                nArray[Align.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Align.X_MIN_Y_MIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Align.X_MID_Y_MIN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Align.X_MAX_Y_MIN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Align.X_MIN_Y_MID.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Align.X_MID_Y_MID.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Align.X_MAX_Y_MID.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Align.X_MIN_Y_MAX.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Align.X_MID_Y_MAX.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Align.X_MAX_Y_MAX.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

