/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.composition;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.Drawer;
import org.openrndr.extra.composition.AttributeOrPropertyValue;
import org.openrndr.extra.composition.Composition;
import org.openrndr.extra.composition.CompositionNode;
import org.openrndr.extra.composition.CompositionStyleSheetKt;
import org.openrndr.extra.composition.GroupNode;
import org.openrndr.extra.composition.ImageNode;
import org.openrndr.extra.composition.Length;
import org.openrndr.extra.composition.Numeric;
import org.openrndr.extra.composition.Paint;
import org.openrndr.extra.composition.Shade;
import org.openrndr.extra.composition.ShapeNode;
import org.openrndr.extra.composition.TextNode;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"composition", "", "Lorg/openrndr/draw/Drawer;", "Lorg/openrndr/extra/composition/Composition;", "orx-composition"})
@SourceDebugExtension(value={"SMAP\nDrawerExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DrawerExtensions.kt\norg/openrndr/extra/composition/DrawerExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1863#2,2:95\n*S KotlinDebug\n*F\n+ 1 DrawerExtensions.kt\norg/openrndr/extra/composition/DrawerExtensionsKt\n*L\n86#1:95,2\n*E\n"})
public final class DrawerExtensionsKt {
    public static final void composition(@NotNull Drawer $this$composition, @NotNull Composition composition) {
        Intrinsics.checkNotNullParameter($this$composition, "<this>");
        Intrinsics.checkNotNullParameter(composition, "composition");
        $this$composition.pushModel();
        $this$composition.pushStyle();
        $this$composition.setModel($this$composition.getModel().times(composition.calculateViewportTransform()));
        DrawerExtensionsKt.composition$node($this$composition, composition, composition.getRoot());
        $this$composition.popModel();
        $this$composition.popStyle();
    }

    private static final void composition$node(Drawer $this_composition, Composition $composition, CompositionNode compositionNode) {
        $this_composition.pushModel();
        $this_composition.pushStyle();
        $this_composition.setModel($this_composition.getModel().times(CompositionStyleSheetKt.getTransform(compositionNode.getStyle()).getValue()));
        Shade shade = CompositionStyleSheetKt.getShadeStyle(compositionNode.getStyle());
        Intrinsics.checkNotNull(shade, "null cannot be cast to non-null type org.openrndr.extra.composition.Shade.Value");
        $this_composition.setShadeStyle(((Shade.Value)shade).getValue());
        CompositionNode compositionNode2 = compositionNode;
        if (compositionNode2 instanceof ShapeNode) {
            ColorRGBa colorRGBa;
            ColorRGBa colorRGBa2;
            double d;
            ColorRGBa colorRGBa3;
            ColorRGBa colorRGBa4;
            AttributeOrPropertyValue it = CompositionStyleSheetKt.getStroke(compositionNode.getStyle());
            boolean bl = false;
            AttributeOrPropertyValue attributeOrPropertyValue = it;
            if (attributeOrPropertyValue instanceof Paint.RGB) {
                colorRGBa4 = ColorRGBa.copy$default(((Paint.RGB)it).getValue(), 0.0, 0.0, 0.0, 1.0, null, 23, null);
            } else if (Intrinsics.areEqual(attributeOrPropertyValue, Paint.None.INSTANCE)) {
                colorRGBa4 = null;
            } else if (Intrinsics.areEqual(attributeOrPropertyValue, Paint.CurrentColor.INSTANCE)) {
                colorRGBa4 = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            $this_composition.setStroke(colorRGBa4);
            it = CompositionStyleSheetKt.getStrokeOpacity(compositionNode.getStyle());
            boolean bl2 = false;
            if (it instanceof Numeric.Rational) {
                colorRGBa3 = $this_composition.getStroke();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            $this_composition.setStroke(colorRGBa3 != null ? colorRGBa3.opacify(((Numeric.Rational)it).getValue()) : null);
            it = CompositionStyleSheetKt.getStrokeWeight(compositionNode.getStyle());
            boolean bl3 = false;
            attributeOrPropertyValue = it;
            if (attributeOrPropertyValue instanceof Length.Pixels) {
                d = ((Length.Pixels)it).getValue();
            } else if (attributeOrPropertyValue instanceof Length.Percent) {
                d = $composition.normalizedDiagonalLength$orx_composition() * ((Length.Percent)it).getValue() / 100.0;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            $this_composition.setStrokeWeight(d);
            it = CompositionStyleSheetKt.getMiterLimit(compositionNode.getStyle());
            boolean bl4 = false;
            if (!(it instanceof Numeric.Rational)) {
                throw new NoWhenBranchMatchedException();
            }
            $this_composition.setMiterLimit(((Numeric.Rational)it).getValue());
            it = CompositionStyleSheetKt.getLineCap(compositionNode.getStyle());
            boolean bl5 = false;
            $this_composition.setLineCap(it.getValue());
            it = CompositionStyleSheetKt.getLineJoin(compositionNode.getStyle());
            boolean bl6 = false;
            $this_composition.setLineJoin(it.getValue());
            it = CompositionStyleSheetKt.getFill(compositionNode.getStyle());
            boolean bl7 = false;
            attributeOrPropertyValue = it;
            if (attributeOrPropertyValue instanceof Paint.RGB) {
                colorRGBa2 = ColorRGBa.copy$default(((Paint.RGB)it).getValue(), 0.0, 0.0, 0.0, 1.0, null, 23, null);
            } else if (attributeOrPropertyValue instanceof Paint.None) {
                colorRGBa2 = null;
            } else if (attributeOrPropertyValue instanceof Paint.CurrentColor) {
                colorRGBa2 = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            $this_composition.setFill(colorRGBa2);
            it = CompositionStyleSheetKt.getFillOpacity(compositionNode.getStyle());
            boolean bl8 = false;
            if (it instanceof Numeric.Rational) {
                colorRGBa = $this_composition.getFill();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            $this_composition.setFill(colorRGBa != null ? colorRGBa.opacify(((Numeric.Rational)it).getValue()) : null);
            it = CompositionStyleSheetKt.getOpacity(compositionNode.getStyle());
            boolean bl9 = false;
            if (!(it instanceof Numeric.Rational)) {
                throw new NoWhenBranchMatchedException();
            }
            ColorRGBa colorRGBa5 = $this_composition.getStroke();
            $this_composition.setStroke(colorRGBa5 != null ? colorRGBa5.opacify(((Numeric.Rational)it).getValue()) : null);
            ColorRGBa colorRGBa6 = $this_composition.getFill();
            $this_composition.setFill(colorRGBa6 != null ? colorRGBa6.opacify(((Numeric.Rational)it).getValue()) : null);
            $this_composition.shape(((ShapeNode)compositionNode).getShape());
        } else if (compositionNode2 instanceof ImageNode) {
            $this_composition.image(((ImageNode)compositionNode).getImage());
        } else {
            if (compositionNode2 instanceof TextNode) {
                throw new NotImplementedError(null, 1, null);
            }
            if (compositionNode2 instanceof GroupNode) {
                Iterable $this$forEach$iv = ((GroupNode)compositionNode).getChildren();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CompositionNode it = (CompositionNode)element$iv;
                    boolean bl = false;
                    DrawerExtensionsKt.composition$node($this_composition, $composition, it);
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        $this_composition.popModel();
        $this_composition.popStyle();
    }
}

