/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.compositor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.Filter;
import org.openrndr.draw.Filter2to1;
import org.openrndr.draw.ProgramRenderTarget;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetBuilder;
import org.openrndr.draw.RenderTargetKt;
import org.openrndr.extra.compositor.ColorBufferCache;
import org.openrndr.extra.compositor.ColorBufferCacheKey;
import org.openrndr.extra.compositor.CompositorKt;
import org.openrndr.extra.compositor.LayerType;
import org.openrndr.extra.parameters.BooleanParameter;
import org.openrndr.extra.parameters.Description;

@Description(title="Layer")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B\u001b\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010J\u001a\u00020\u00112\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0004J\u0010\u0010O\u001a\u0002052\u0006\u0010P\u001a\u00020GH\u0002J \u0010Q\u001a\u00020\u00112\u0006\u0010P\u001a\u00020G2\u0006\u0010K\u001a\u00020L2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0012\u0010R\u001a\u00020\u0011*\u00020L2\u0006\u0010S\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00000\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R9\u0010\u001a\u001a!\u0012\u0004\u0012\u00020\u001c\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00110\u001d\u00a2\u0006\u0002\b\u001e\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"RB\u0010#\u001a3\u0012/\u0012-\u0012\u0004\u0012\u00020\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00000%\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00110\u001d\u00a2\u0006\u0002\b\u001e0$0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0019R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010/\u001a\u0004\u0018\u00010.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R$\u00104\u001a\u0002058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b6\u00107\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R$\u0010<\u001a\u0002058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b=\u00107\u001a\u0004\b>\u00109\"\u0004\b?\u0010;R\u001c\u0010@\u001a\u0004\u0018\u00010AX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u0010\u0010F\u001a\u0004\u0018\u00010GX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010H\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\bI\u00101\u00a8\u0006T"}, d2={"Lorg/openrndr/extra/compositor/Layer;", "", "type", "Lorg/openrndr/extra/compositor/LayerType;", "bufferMultisample", "Lorg/openrndr/draw/BufferMultisample;", "<init>", "(Lorg/openrndr/extra/compositor/LayerType;Lorg/openrndr/draw/BufferMultisample;)V", "getType", "()Lorg/openrndr/extra/compositor/LayerType;", "maskLayer", "getMaskLayer", "()Lorg/openrndr/extra/compositor/Layer;", "setMaskLayer", "(Lorg/openrndr/extra/compositor/Layer;)V", "drawFunc", "Lkotlin/Function0;", "", "getDrawFunc", "()Lkotlin/jvm/functions/Function0;", "setDrawFunc", "(Lkotlin/jvm/functions/Function0;)V", "children", "", "getChildren", "()Ljava/util/List;", "blendFilter", "Lkotlin/Pair;", "Lorg/openrndr/draw/Filter;", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "getBlendFilter", "()Lkotlin/Pair;", "setBlendFilter", "(Lkotlin/Pair;)V", "postFilters", "Lkotlin/Triple;", "", "getPostFilters", "colorType", "Lorg/openrndr/draw/ColorType;", "getColorType", "()Lorg/openrndr/draw/ColorType;", "setColorType", "(Lorg/openrndr/draw/ColorType;)V", "unresolvedAccumulation", "Lorg/openrndr/draw/ColorBuffer;", "accumulation", "getAccumulation", "()Lorg/openrndr/draw/ColorBuffer;", "setAccumulation", "(Lorg/openrndr/draw/ColorBuffer;)V", "enabled", "", "getEnabled$annotations", "()V", "getEnabled", "()Z", "setEnabled", "(Z)V", "invertMask", "getInvertMask$annotations", "getInvertMask", "setInvertMask", "clearColor", "Lorg/openrndr/color/ColorRGBa;", "getClearColor", "()Lorg/openrndr/color/ColorRGBa;", "setClearColor", "(Lorg/openrndr/color/ColorRGBa;)V", "layerTarget", "Lorg/openrndr/draw/RenderTarget;", "result", "getResult", "drawLayer", "drawer", "Lorg/openrndr/draw/Drawer;", "cache", "Lorg/openrndr/extra/compositor/ColorBufferCache;", "shouldCreateLayerTarget", "activeRenderTarget", "createLayerTarget", "image", "layer", "orx-compositor"})
@SourceDebugExtension(value={"SMAP\nCompositor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Compositor.kt\norg/openrndr/extra/compositor/Layer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,385:1\n1863#2,2:386\n774#2:396\n865#2,2:397\n1863#2,2:399\n774#2:401\n865#2,2:402\n1863#2,2:404\n11158#3:388\n11493#3,3:389\n37#4:392\n36#4,3:393\n*S KotlinDebug\n*F\n+ 1 Compositor.kt\norg/openrndr/extra/compositor/Layer\n*L\n117#1:386,2\n102#1:396\n102#1:397,2\n102#1:399,2\n110#1:401\n110#1:402,2\n110#1:404,2\n124#1:388\n124#1:389,3\n125#1:392\n125#1:393,3\n*E\n"})
public class Layer {
    @NotNull
    private final LayerType type;
    @NotNull
    private final BufferMultisample bufferMultisample;
    @Nullable
    private Layer maskLayer;
    @NotNull
    private Function0<Unit> drawFunc;
    @NotNull
    private final List<Layer> children;
    @Nullable
    private Pair<? extends Filter, ? extends Function1<? super Filter, Unit>> blendFilter;
    @NotNull
    private final List<Triple<Filter, Layer[], Function1<Filter, Unit>>> postFilters;
    @NotNull
    private ColorType colorType;
    @Nullable
    private ColorBuffer unresolvedAccumulation;
    @Nullable
    private ColorBuffer accumulation;
    private boolean enabled;
    private boolean invertMask;
    @Nullable
    private ColorRGBa clearColor;
    @Nullable
    private RenderTarget layerTarget;

    public Layer(@NotNull LayerType type, @NotNull BufferMultisample bufferMultisample) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(bufferMultisample, "bufferMultisample");
        this.type = type;
        this.bufferMultisample = bufferMultisample;
        this.drawFunc = Layer::drawFunc$lambda$0;
        this.children = new ArrayList();
        this.postFilters = new ArrayList();
        this.colorType = ColorType.UINT8_SRGB;
        this.enabled = true;
        this.clearColor = ColorRGBa.Companion.getTRANSPARENT();
    }

    public /* synthetic */ Layer(LayerType layerType, BufferMultisample bufferMultisample, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bufferMultisample = BufferMultisample.Disabled.INSTANCE;
        }
        this(layerType, bufferMultisample);
    }

    @NotNull
    public final LayerType getType() {
        return this.type;
    }

    @Nullable
    public final Layer getMaskLayer() {
        return this.maskLayer;
    }

    public final void setMaskLayer(@Nullable Layer layer) {
        this.maskLayer = layer;
    }

    @NotNull
    public final Function0<Unit> getDrawFunc() {
        return this.drawFunc;
    }

    public final void setDrawFunc(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, "<set-?>");
        this.drawFunc = function0;
    }

    @NotNull
    public final List<Layer> getChildren() {
        return this.children;
    }

    @Nullable
    public final Pair<Filter, Function1<Filter, Unit>> getBlendFilter() {
        return this.blendFilter;
    }

    public final void setBlendFilter(@Nullable Pair<? extends Filter, ? extends Function1<? super Filter, Unit>> pair) {
        this.blendFilter = pair;
    }

    @NotNull
    public final List<Triple<Filter, Layer[], Function1<Filter, Unit>>> getPostFilters() {
        return this.postFilters;
    }

    @NotNull
    public final ColorType getColorType() {
        return this.colorType;
    }

    public final void setColorType(@NotNull ColorType colorType) {
        Intrinsics.checkNotNullParameter((Object)colorType, "<set-?>");
        this.colorType = colorType;
    }

    @Nullable
    public final ColorBuffer getAccumulation() {
        return this.accumulation;
    }

    public final void setAccumulation(@Nullable ColorBuffer colorBuffer) {
        this.accumulation = colorBuffer;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @BooleanParameter(label="enabled")
    public static /* synthetic */ void getEnabled$annotations() {
    }

    public final boolean getInvertMask() {
        return this.invertMask;
    }

    public final void setInvertMask(boolean bl) {
        this.invertMask = bl;
    }

    @BooleanParameter(label="Invert mask")
    public static /* synthetic */ void getInvertMask$annotations() {
    }

    @Nullable
    public final ColorRGBa getClearColor() {
        return this.clearColor;
    }

    public final void setClearColor(@Nullable ColorRGBa colorRGBa) {
        this.clearColor = colorRGBa;
    }

    @NotNull
    public final ColorBuffer getResult() {
        AutoCloseable autoCloseable = this.layerTarget;
        if (autoCloseable == null || (autoCloseable = autoCloseable.colorBuffer(0)) == null) {
            throw new IllegalStateException("layer result not ready".toString());
        }
        return autoCloseable;
    }

    /*
     * WARNING - void declaration
     */
    protected final void drawLayer(@NotNull Drawer drawer, @NotNull ColorBufferCache cache2) {
        block17: {
            ColorBuffer[] colorBufferArray;
            ColorBuffer layerPost;
            RenderTarget target2;
            RenderTarget activeRenderTarget;
            block18: {
                Object object;
                ColorBuffer colorBuffer;
                Intrinsics.checkNotNullParameter(drawer, "drawer");
                Intrinsics.checkNotNullParameter(cache2, "cache");
                if (!this.enabled) {
                    return;
                }
                activeRenderTarget = RenderTarget.Companion.getActive();
                if (this.shouldCreateLayerTarget(activeRenderTarget)) {
                    this.createLayerTarget(activeRenderTarget, drawer, this.bufferMultisample);
                }
                RenderTarget renderTarget = this.layerTarget;
                if (renderTarget == null) break block17;
                target2 = renderTarget;
                boolean bl = false;
                Layer layer = this.maskLayer;
                if (layer != null) {
                    Layer it = layer;
                    boolean bl2 = false;
                    if (it.shouldCreateLayerTarget(activeRenderTarget)) {
                        it.createLayerTarget(activeRenderTarget, drawer, it.bufferMultisample);
                    }
                    RenderTarget renderTarget2 = it.layerTarget;
                    if (renderTarget2 != null) {
                        RenderTarget maskRt = renderTarget2;
                        boolean bl3 = false;
                        DrawerKt.isolatedWithTarget(drawer, maskRt, arg_0 -> Layer.drawLayer$lambda$15$lambda$3$lambda$2$lambda$1(drawer, it, arg_0));
                    }
                }
                DrawerKt.isolatedWithTarget(drawer, target2, arg_0 -> Layer.drawLayer$lambda$15$lambda$9(this, drawer, cache2, arg_0));
                if (this.postFilters.isEmpty()) {
                    colorBuffer = target2.colorBuffer(0);
                } else {
                    List<Triple<Filter, Layer[], Function1<Filter, Unit>>> filters = this.postFilters;
                    boolean bl4 = false;
                    List<ColorBuffer> targets = cache2.get(new ColorBufferCacheKey(this.colorType, target2.getContentScale()));
                    Iterable $this$forEach$iv = targets;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ColorBuffer it = (ColorBuffer)element$iv;
                        boolean bl5 = false;
                        ColorBuffer.fill$default(it, ColorRGBa.Companion.getTRANSPARENT(), 0, 2, null);
                    }
                    ColorBuffer localSource = target2.colorBuffer(0);
                    object = ((Iterable)filters).iterator();
                    int n = 0;
                    while (object.hasNext()) {
                        void $this$toTypedArray$iv;
                        void $this$mapTo$iv$iv;
                        Collection $this$map$iv;
                        int i = n++;
                        Triple filter2 = (Triple)object.next();
                        Object bl5 = filter2.getFirst();
                        ((Function1)filter2.getThird()).invoke(bl5);
                        Object[] objectArray = new ColorBuffer[]{localSource};
                        ColorBuffer[] colorBufferArray2 = objectArray;
                        objectArray = (Object[])filter2.getSecond();
                        ColorBuffer[] colorBufferArray3 = colorBufferArray2;
                        boolean $i$f$map = false;
                        void var18_26 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                        boolean $i$f$mapTo = false;
                        for (void item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Layer layer2 = (Layer)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl6 = false;
                            collection.add(it.getResult());
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv = $this$toTypedArray$iv;
                        ColorBuffer[] sources = ArraysKt.plus(colorBufferArray3, thisCollection$iv.toArray(new ColorBuffer[0]));
                        objectArray = new ColorBuffer[]{targets.get(i % targets.size())};
                        Filter.apply$default((Filter)filter2.getFirst(), sources, (ColorBuffer[])objectArray, null, 4, null);
                        localSource = targets.get(i % targets.size());
                    }
                    colorBuffer = targets.get(CollectionsKt.getLastIndex(this.postFilters) % targets.size());
                }
                layerPost = colorBuffer;
                Layer layer3 = this.maskLayer;
                if (layer3 != null) {
                    Layer it = layer3;
                    boolean bl7 = false;
                    Filter2to1 maskFilter = this.invertMask ? (Filter2to1)CompositorKt.access$getSourceOut$p() : (Filter2to1)CompositorKt.access$getSourceIn$p();
                    Filter filter3 = maskFilter;
                    object = new ColorBuffer[2];
                    object[0] = layerPost;
                    RenderTarget renderTarget3 = it.layerTarget;
                    Intrinsics.checkNotNull(renderTarget3);
                    object[1] = renderTarget3.colorBuffer(0);
                    Filter.apply$default(filter3, (ColorBuffer[])object, layerPost, null, 4, null);
                }
                if (this.type != LayerType.ASIDE) break block18;
                if (!(!((Collection)this.postFilters).isEmpty())) break block17;
                if (!(!Intrinsics.areEqual(layerPost, this.getResult()))) {
                    colorBufferArray = "Failed requirement.";
                    throw new IllegalArgumentException(colorBufferArray.toString());
                }
                ColorBuffer.copyTo$default(layerPost, this.getResult(), 0, 0, null, 14, null);
                break block17;
            }
            if (this.type != LayerType.LAYER) break block17;
            Pair<? extends Filter, ? extends Function1<? super Filter, Unit>> localBlendFilter = this.blendFilter;
            if (localBlendFilter == null) {
                DrawerKt.isolated(drawer, arg_0 -> Layer.drawLayer$lambda$15$lambda$14(drawer, this, layerPost, arg_0));
            } else {
                colorBufferArray = localBlendFilter.getFirst();
                localBlendFilter.getSecond().invoke((Filter)colorBufferArray);
                ColorBuffer colorBuffer = activeRenderTarget.colorBuffer(0);
                ColorBuffer colorBuffer2 = this.unresolvedAccumulation;
                Intrinsics.checkNotNull(colorBuffer2);
                ColorBuffer.copyTo$default(colorBuffer, colorBuffer2, 0, 0, null, 14, null);
                if (Intrinsics.areEqual(this.bufferMultisample, BufferMultisample.Disabled.INSTANCE)) {
                    colorBufferArray = new ColorBuffer[2];
                    Intrinsics.checkNotNull(this.unresolvedAccumulation);
                    colorBufferArray[1] = layerPost;
                    ColorBuffer colorBuffer3 = this.unresolvedAccumulation;
                    Intrinsics.checkNotNull(colorBuffer3);
                    Filter.apply$default(localBlendFilter.getFirst(), colorBufferArray, colorBuffer3, null, 4, null);
                } else {
                    ColorBuffer colorBuffer4 = this.accumulation;
                    Intrinsics.checkNotNull(colorBuffer4);
                    ColorBuffer.copyTo$default(layerPost, colorBuffer4, 0, 0, null, 14, null);
                    colorBufferArray = new ColorBuffer[2];
                    Intrinsics.checkNotNull(this.unresolvedAccumulation);
                    Intrinsics.checkNotNull(this.accumulation);
                    ColorBuffer colorBuffer5 = this.unresolvedAccumulation;
                    Intrinsics.checkNotNull(colorBuffer5);
                    Filter.apply$default(localBlendFilter.getFirst(), colorBufferArray, colorBuffer5, null, 4, null);
                }
                if (!(activeRenderTarget instanceof ProgramRenderTarget)) {
                    ColorBuffer colorBuffer6 = this.unresolvedAccumulation;
                    Intrinsics.checkNotNull(colorBuffer6);
                    ColorBuffer.copyTo$default(colorBuffer6, target2.colorBuffer(0), 0, 0, null, 14, null);
                }
                ColorBuffer colorBuffer7 = this.unresolvedAccumulation;
                Intrinsics.checkNotNull(colorBuffer7);
                ColorBuffer.copyTo$default(colorBuffer7, activeRenderTarget.colorBuffer(0), 0, 0, null, 14, null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldCreateLayerTarget(RenderTarget activeRenderTarget) {
        if (this.layerTarget == null) return true;
        RenderTarget renderTarget = this.layerTarget;
        boolean bl = renderTarget != null ? renderTarget.getWidth() == activeRenderTarget.getWidth() : false;
        if (bl) {
            boolean bl2;
            RenderTarget renderTarget2 = this.layerTarget;
            if (renderTarget2 != null) {
                if (renderTarget2.getHeight() == activeRenderTarget.getHeight()) {
                    return false;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return false;
        }
        if (activeRenderTarget.getWidth() <= 0) return false;
        if (activeRenderTarget.getHeight() <= 0) return false;
        return true;
    }

    private final void createLayerTarget(RenderTarget activeRenderTarget, Drawer drawer, BufferMultisample bufferMultisample) {
        block4: {
            RenderTarget renderTarget = this.layerTarget;
            if (renderTarget != null) {
                CompositorKt.deepDestroy(renderTarget);
            }
            this.layerTarget = RenderTargetKt.renderTarget$default(activeRenderTarget.getWidth(), activeRenderTarget.getHeight(), activeRenderTarget.getContentScale(), bufferMultisample, null, arg_0 -> Layer.createLayerTarget$lambda$16(this, arg_0), 16, null);
            if (!Intrinsics.areEqual(bufferMultisample, BufferMultisample.Disabled.INSTANCE)) {
                ColorBuffer colorBuffer = this.accumulation;
                if (colorBuffer != null) {
                    colorBuffer.destroy();
                }
                this.accumulation = ColorBufferKt.colorBuffer$default(activeRenderTarget.getWidth(), activeRenderTarget.getHeight(), activeRenderTarget.getContentScale(), null, this.colorType, null, 0, null, 232, null);
            }
            ColorBuffer colorBuffer = this.unresolvedAccumulation;
            if (colorBuffer != null) {
                colorBuffer.destroy();
            }
            this.unresolvedAccumulation = ColorBufferKt.colorBuffer$default(activeRenderTarget.getWidth(), activeRenderTarget.getHeight(), activeRenderTarget.getContentScale(), null, this.colorType, null, 0, null, 232, null);
            RenderTarget renderTarget2 = this.layerTarget;
            if (renderTarget2 == null) break block4;
            RenderTarget it = renderTarget2;
            boolean bl = false;
            drawer.withTarget(it, arg_0 -> Layer.createLayerTarget$lambda$18$lambda$17(drawer, arg_0));
        }
    }

    public final void image(@NotNull Drawer $this$image, @NotNull Layer layer) {
        Intrinsics.checkNotNullParameter($this$image, "<this>");
        Intrinsics.checkNotNullParameter(layer, "layer");
        ColorBuffer cb = layer.getResult();
        $this$image.image(cb);
    }

    private static final Unit drawFunc$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit drawLayer$lambda$15$lambda$3$lambda$2$lambda$1(Drawer $drawer, Layer $it, Drawer $this$isolatedWithTarget) {
        Intrinsics.checkNotNullParameter($this$isolatedWithTarget, "$this$isolatedWithTarget");
        $drawer.setFill(ColorRGBa.Companion.getWHITE());
        $drawer.setStroke(ColorRGBa.Companion.getWHITE());
        $drawer.clear(ColorRGBa.Companion.getTRANSPARENT());
        $it.drawFunc.invoke();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit drawLayer$lambda$15$lambda$9(Layer this$0, Drawer $drawer, ColorBufferCache $cache, Drawer $this$isolatedWithTarget) {
        Object it;
        void $this$forEach$iv;
        Layer it2;
        Object element$iv$iv;
        Iterator $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$isolatedWithTarget, "$this$isolatedWithTarget");
        Iterable $this$filter$iv = this$0.children;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            it2 = (Layer)element$iv$iv;
            boolean bl = false;
            if (!(it2.type == LayerType.ASIDE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            Object element$iv = $this$filterTo$iv$iv.next();
            Layer it3 = (Layer)element$iv;
            boolean bl = false;
            it3.drawLayer($drawer, $cache);
        }
        ColorRGBa colorRGBa = this$0.clearColor;
        if (colorRGBa != null) {
            it = colorRGBa;
            boolean bl = false;
            $drawer.clear((ColorRGBa)it);
        }
        this$0.drawFunc.invoke();
        $this$filter$iv = this$0.children;
        $i$f$filter = false;
        it = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            it2 = (Layer)element$iv$iv;
            boolean bl2 = false;
            if (!(it2.type == LayerType.LAYER)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Layer it4 = (Layer)element$iv;
            boolean bl3 = false;
            it4.drawLayer($drawer, $cache);
        }
        return Unit.INSTANCE;
    }

    private static final Unit drawLayer$lambda$15$lambda$14(Drawer $drawer, Layer this$0, ColorBuffer $layerPost, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        $drawer.defaults();
        if (Intrinsics.areEqual(this$0.bufferMultisample, BufferMultisample.Disabled.INSTANCE)) {
            $drawer.image($layerPost, $layerPost.getBounds(), $drawer.getBounds());
        } else {
            ColorBuffer colorBuffer = this$0.accumulation;
            Intrinsics.checkNotNull(colorBuffer);
            ColorBuffer.copyTo$default($layerPost, colorBuffer, 0, 0, null, 14, null);
            ColorBuffer colorBuffer2 = this$0.accumulation;
            Intrinsics.checkNotNull(colorBuffer2);
            $drawer.image(colorBuffer2, $layerPost.getBounds(), $drawer.getBounds());
        }
        return Unit.INSTANCE;
    }

    private static final Unit createLayerTarget$lambda$16(Layer this$0, RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        RenderTargetBuilder.colorBuffer$default($this$renderTarget, null, this$0.colorType, 1, null);
        RenderTargetBuilder.depthBuffer$default($this$renderTarget, null, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createLayerTarget$lambda$18$lambda$17(Drawer $drawer, Drawer $this$withTarget) {
        Intrinsics.checkNotNullParameter($this$withTarget, "$this$withTarget");
        $drawer.clear(ColorRGBa.Companion.getTRANSPARENT());
        return Unit.INSTANCE;
    }
}

