/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.dnk3;

import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.openrndr.Dispatcher;
import org.openrndr.extra.dnk3.Feature;
import org.openrndr.extra.dnk3.SceneKt;
import org.openrndr.extra.dnk3.SceneNode;
import org.openrndr.math.Matrix44;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/openrndr/extra/dnk3/Scene;", "", "root", "Lorg/openrndr/extra/dnk3/SceneNode;", "dispatcher", "Lorg/openrndr/Dispatcher;", "<init>", "(Lorg/openrndr/extra/dnk3/SceneNode;Lorg/openrndr/Dispatcher;)V", "getRoot", "()Lorg/openrndr/extra/dnk3/SceneNode;", "getDispatcher", "()Lorg/openrndr/Dispatcher;", "features", "", "Lorg/openrndr/extra/dnk3/Feature;", "getFeatures", "()Ljava/util/List;", "hashCode", "", "hash", "", "update", "", "deminityy"})
public final class Scene {
    @NotNull
    private final SceneNode root;
    @NotNull
    private final Dispatcher dispatcher;
    @NotNull
    private final List<Feature> features;

    public Scene(@NotNull SceneNode root, @NotNull Dispatcher dispatcher) {
        Intrinsics.checkNotNullParameter(root, "root");
        Intrinsics.checkNotNullParameter(dispatcher, "dispatcher");
        this.root = root;
        this.dispatcher = dispatcher;
        this.features = new ArrayList();
    }

    public /* synthetic */ Scene(SceneNode sceneNode, Dispatcher dispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            sceneNode = new SceneNode();
        }
        if ((n & 2) != 0) {
            dispatcher = new Dispatcher();
        }
        this(sceneNode, dispatcher);
    }

    @NotNull
    public final SceneNode getRoot() {
        return this.root;
    }

    @NotNull
    public final Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    @NotNull
    public final List<Feature> getFeatures() {
        return this.features;
    }

    public int hashCode() {
        int result = this.root.hashCode();
        result = result * 31 + ((Object)this.features).hashCode();
        return result;
    }

    @NotNull
    public final String hash() {
        Base64.Encoder encoder = Base64.getEncoder();
        String string = String.valueOf(this.hashCode());
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        String string2 = encoder.encodeToString(byArray);
        Intrinsics.checkNotNullExpressionValue(string2, "encodeToString(...)");
        return string2;
    }

    public final void update() {
        this.dispatcher.execute();
        SceneKt.scan(this.root, Matrix44.Companion.getIDENTITY(), Scene::update$lambda$0);
    }

    private static final Matrix44 update$lambda$0(SceneNode $this$scan, Matrix44 p) {
        Intrinsics.checkNotNullParameter($this$scan, "$this$scan");
        Intrinsics.checkNotNullParameter(p, "p");
        $this$scan.setWorldTransform(p.times($this$scan.getTransform()));
        return $this$scan.getWorldTransform();
    }

    public Scene() {
        this(null, null, 3, null);
    }
}

