/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.dnk3.cubemap;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.ArrayTexture;
import org.openrndr.draw.BlendMode;
import org.openrndr.draw.BufferTexture;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.Cubemap;
import org.openrndr.draw.CubemapSide;
import org.openrndr.draw.DepthBuffer;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.MagnifyingFilter;
import org.openrndr.draw.MinifyingFilter;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetBuilder;
import org.openrndr.draw.RenderTargetKt;
import org.openrndr.draw.Session;
import org.openrndr.draw.Shader;
import org.openrndr.draw.ShaderWatcher;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexFormat;
import org.openrndr.extra.dnk3.cubemap.CubemapFilterKt;
import org.openrndr.internal.Driver;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Matrix55;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 )2\u00020\u0001:\u0001)B\u001f\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J)\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016\u00a2\u0006\u0002\u0010\u001fJ!\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020 \u00a2\u0006\u0002\u0010!J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dJ!\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\u0002\u0010\"J!\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0002\u0010#J\u0006\u0010$\u001a\u00020\u001aR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010%\u001a\u00020&8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006*"}, d2={"Lorg/openrndr/extra/dnk3/cubemap/CubemapFilter;", "", "shader", "Lorg/openrndr/draw/Shader;", "watcher", "Lorg/openrndr/draw/ShaderWatcher;", "<init>", "(Lorg/openrndr/draw/Shader;Lorg/openrndr/draw/ShaderWatcher;)V", "parameters", "", "", "getParameters", "()Ljava/util/Map;", "padding", "", "getPadding", "()I", "setPadding", "(I)V", "depthBufferOut", "Lorg/openrndr/draw/DepthBuffer;", "getDepthBufferOut", "()Lorg/openrndr/draw/DepthBuffer;", "setDepthBufferOut", "(Lorg/openrndr/draw/DepthBuffer;)V", "apply", "", "source", "", "Lorg/openrndr/draw/Cubemap;", "target", "([Lorg/openrndr/draw/Cubemap;[Lorg/openrndr/draw/Cubemap;)V", "Lorg/openrndr/draw/RenderTarget;", "([Lorg/openrndr/draw/Cubemap;Lorg/openrndr/draw/RenderTarget;)V", "(Lorg/openrndr/draw/Cubemap;[Lorg/openrndr/draw/Cubemap;)V", "([Lorg/openrndr/draw/Cubemap;Lorg/openrndr/draw/Cubemap;)V", "untrack", "format", "Lorg/openrndr/draw/VertexFormat;", "getFormat", "()Lorg/openrndr/draw/VertexFormat;", "Companion", "deminityy"})
@SourceDebugExtension(value={"SMAP\nCubemapFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CubemapFilter.kt\norg/openrndr/extra/dnk3/cubemap/CubemapFilter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n13402#2,2:188\n13467#2,3:190\n216#3,2:193\n1#4:195\n*S KotlinDebug\n*F\n+ 1 CubemapFilter.kt\norg/openrndr/extra/dnk3/cubemap/CubemapFilter\n*L\n59#1:188,2\n104#1:190,3\n117#1:193,2\n*E\n"})
public class CubemapFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Shader shader;
    @Nullable
    private final ShaderWatcher watcher;
    @NotNull
    private final Map<String, Object> parameters;
    private int padding;
    @Nullable
    private DepthBuffer depthBufferOut;

    public CubemapFilter(@Nullable Shader shader, @Nullable ShaderWatcher watcher) {
        this.shader = shader;
        this.watcher = watcher;
        this.parameters = new LinkedHashMap();
    }

    public /* synthetic */ CubemapFilter(Shader shader, ShaderWatcher shaderWatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            shader = null;
        }
        if ((n & 2) != 0) {
            shaderWatcher = null;
        }
        this(shader, shaderWatcher);
    }

    @NotNull
    public final Map<String, Object> getParameters() {
        return this.parameters;
    }

    public final int getPadding() {
        return this.padding;
    }

    public final void setPadding(int n) {
        this.padding = n;
    }

    @Nullable
    public final DepthBuffer getDepthBufferOut() {
        return this.depthBufferOut;
    }

    public final void setDepthBufferOut(@Nullable DepthBuffer depthBuffer) {
        this.depthBufferOut = depthBuffer;
    }

    public void apply(@NotNull Cubemap[] source, @NotNull Cubemap[] target2) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target2, "target");
        if (target2.length == 0) {
            return;
        }
        for (CubemapSide side : CubemapSide.values()) {
            RenderTarget renderTarget = RenderTargetKt.renderTarget$default(target2[0].getWidth(), target2[0].getWidth(), 1.0, null, null, CubemapFilter::apply$lambda$0, 24, null);
            Shader shader = this.shader;
            if (shader != null) {
                shader.begin();
            }
            Shader shader2 = this.shader;
            if (shader2 != null) {
                shader2.uniform("sideNormal", side.getForward());
            }
            Shader shader3 = this.shader;
            if (shader3 != null) {
                shader3.uniform("sideUp", side.getUp());
            }
            Shader shader4 = this.shader;
            if (shader4 != null) {
                shader4.uniform("sideRight", side.getForward().cross(side.getUp()));
            }
            Shader shader5 = this.shader;
            if (shader5 != null) {
                shader5.end();
            }
            Cubemap[] $this$forEach$iv = target2;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Cubemap element$iv;
                Cubemap it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                RenderTarget.DefaultImpls.attach$default(renderTarget, it, side, 0, null, 8, null);
            }
            int n2 = target2.length;
            for (int i = 1; i < n2; ++i) {
                renderTarget.blendMode(i, BlendMode.REPLACE);
            }
            this.apply(source, renderTarget);
            if (this.depthBufferOut != null) {
                DepthBuffer it;
                boolean bl = false;
                RenderTarget.DefaultImpls.attach$default(renderTarget, it, false, 2, null);
            }
            if (this.depthBufferOut != null) {
                renderTarget.detachDepthBuffer();
            }
            renderTarget.detachColorAttachments();
            renderTarget.destroy();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void apply(@NotNull Cubemap[] source, @NotNull RenderTarget target2) {
        Shader shader;
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target2, "target");
        if (this.watcher != null) {
            Shader shader2 = this.watcher.getShader();
            shader = shader2;
            Intrinsics.checkNotNull(shader2);
        } else {
            Shader shader3 = this.shader;
            shader = shader3;
            Intrinsics.checkNotNull(shader3);
        }
        Shader shader4 = shader;
        target2.bind();
        if (CubemapFilterKt.access$getFilterQuad$p() == null) {
            BufferWriter bufferWriter;
            VertexBuffer fq = VertexBuffer.Companion.createDynamic(CubemapFilterKt.access$getFilterQuadFormat$p(), 6, Session.Companion.getRoot());
            BufferWriter $this$apply_u24lambda_u243 = bufferWriter = fq.getShadow().writer();
            boolean bl = false;
            $this$apply_u24lambda_u243.write(new Vector2(0.0, 1.0));
            $this$apply_u24lambda_u243.write(new Vector2(0.0, 0.0));
            $this$apply_u24lambda_u243.write(new Vector2(0.0, 0.0));
            $this$apply_u24lambda_u243.write(new Vector2(0.0, 1.0));
            $this$apply_u24lambda_u243.write(new Vector2(1.0, 0.0));
            $this$apply_u24lambda_u243.write(new Vector2(1.0, 1.0));
            $this$apply_u24lambda_u243.write(new Vector2(0.0, 1.0));
            $this$apply_u24lambda_u243.write(new Vector2(0.0, 0.0));
            $this$apply_u24lambda_u243.write(new Vector2(1.0, 1.0));
            $this$apply_u24lambda_u243.write(new Vector2(1.0, 0.0));
            $this$apply_u24lambda_u243.write(new Vector2(1.0, 0.0));
            $this$apply_u24lambda_u243.write(new Vector2(1.0, 1.0));
            VertexBufferShadow.DefaultImpls.upload$default(fq.getShadow(), 0, 0, 3, null);
            fq.getShadow().destroy();
            CubemapFilterKt.access$setFilterQuad$p(fq);
        }
        shader4.begin();
        Cubemap[] $this$forEachIndexed$iv = source;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Cubemap item$iv : $this$forEachIndexed$iv) {
            void cubemap;
            int n = index$iv++;
            Cubemap cubemap2 = item$iv;
            int index = n;
            boolean bl = false;
            cubemap.bind(index);
            cubemap.filter(MinifyingFilter.LINEAR, MagnifyingFilter.LINEAR);
            shader4.uniform("tex" + index, index);
        }
        Driver.Companion.getInstance().setState(CubemapFilterKt.access$getFilterDrawStyle$p());
        shader4.uniform("projectionMatrix", TransformsKt.ortho(0.0, target2.getWidth(), target2.getHeight(), 0.0, -1.0, 1.0));
        shader4.uniform("targetSize", new Vector2(target2.getWidth(), target2.getHeight()));
        shader4.uniform("padding", new Vector2(this.padding, this.padding));
        int textureIndex = 0;
        textureIndex = source.length + 0;
        Map<String, Object> $this$forEach$iv = this.parameters;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, Object> element$iv;
            Map.Entry<String, Object> entry = element$iv = iterator2.next();
            boolean bl = false;
            String uniform = entry.getKey();
            Object value = entry.getValue();
            Object object = value;
            if (object instanceof Boolean) {
                shader4.uniform(uniform, (Boolean)value);
                continue;
            }
            if (object instanceof Float) {
                shader4.uniform(uniform, ((Number)value).floatValue());
                continue;
            }
            if (object instanceof Double) {
                shader4.uniform(uniform, (float)((Number)value).doubleValue());
                continue;
            }
            if (object instanceof Matrix44) {
                shader4.uniform(uniform, (Matrix44)value);
                continue;
            }
            if (object instanceof Vector2) {
                shader4.uniform(uniform, (Vector2)value);
                continue;
            }
            if (object instanceof Vector3) {
                shader4.uniform(uniform, (Vector3)value);
                continue;
            }
            if (object instanceof Vector4) {
                shader4.uniform(uniform, (Vector4)value);
                continue;
            }
            if (object instanceof ColorRGBa) {
                shader4.uniform(uniform, (ColorRGBa)value);
                continue;
            }
            if (object instanceof Integer) {
                shader4.uniform(uniform, ((Number)value).intValue());
                continue;
            }
            if (object instanceof Matrix55) {
                shader4.uniform(uniform, ((Matrix55)value).floatArray());
                continue;
            }
            if (object instanceof float[]) {
                shader4.uniform(uniform, (float[])value);
                continue;
            }
            if (object instanceof Object[]) {
                if (((Object[])value).length <= 0) continue;
                Object object2 = ((Object[])value)[0];
                if (object2 instanceof Vector2) {
                    Object object3 = value;
                    Intrinsics.checkNotNull(object3, "null cannot be cast to non-null type kotlin.Array<org.openrndr.math.Vector2>");
                    shader4.uniform(uniform, (Vector2[])object3);
                    continue;
                }
                if (object2 instanceof Vector3) {
                    Object object4 = value;
                    Intrinsics.checkNotNull(object4, "null cannot be cast to non-null type kotlin.Array<org.openrndr.math.Vector3>");
                    shader4.uniform(uniform, (Vector3[])object4);
                    continue;
                }
                if (object2 instanceof Vector4) {
                    Object object5 = value;
                    Intrinsics.checkNotNull(object5, "null cannot be cast to non-null type kotlin.Array<org.openrndr.math.Vector4>");
                    shader4.uniform(uniform, (Vector4[])object5);
                    continue;
                }
                Object object6 = ((Object[])value)[0];
                Intrinsics.checkNotNull(object6);
                throw new IllegalArgumentException("unsupported array value: " + object6.getClass());
            }
            if (object instanceof DepthBuffer) {
                shader4.uniform(String.valueOf(uniform), textureIndex);
                ((DepthBuffer)value).bind(textureIndex);
                ++textureIndex;
                continue;
            }
            if (object instanceof ColorBuffer) {
                shader4.uniform(String.valueOf(uniform), textureIndex);
                ((ColorBuffer)value).bind(textureIndex);
                ++textureIndex;
                continue;
            }
            if (object instanceof Cubemap) {
                shader4.uniform(String.valueOf(uniform), textureIndex);
                ((Cubemap)value).bind(textureIndex);
                ++textureIndex;
                continue;
            }
            if (object instanceof ArrayTexture) {
                shader4.uniform(String.valueOf(uniform), textureIndex);
                ((ArrayTexture)value).bind(textureIndex);
                ++textureIndex;
                continue;
            }
            if (!(object instanceof BufferTexture)) continue;
            shader4.uniform(String.valueOf(uniform), textureIndex);
            ((BufferTexture)value).bind(textureIndex);
            ++textureIndex;
        }
        Driver driver = Driver.Companion.getInstance();
        VertexBuffer vertexBuffer = CubemapFilterKt.access$getFilterQuad$p();
        Intrinsics.checkNotNull(vertexBuffer);
        Driver.DefaultImpls.drawVertexBuffer$default(driver, shader4, CollectionsKt.listOf(vertexBuffer), DrawPrimitive.TRIANGLES, 0, 6, 0, 32, null);
        shader4.end();
        target2.unbind();
    }

    public final void apply(@NotNull Cubemap source, @NotNull Cubemap target2) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target2, "target");
        Cubemap[] cubemapArray = new Cubemap[]{source};
        Cubemap[] cubemapArray2 = cubemapArray;
        cubemapArray = new Cubemap[]{target2};
        this.apply(cubemapArray2, cubemapArray);
    }

    public final void apply(@NotNull Cubemap source, @NotNull Cubemap[] target2) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target2, "target");
        Cubemap[] cubemapArray = new Cubemap[]{source};
        this.apply(cubemapArray, target2);
    }

    public final void apply(@NotNull Cubemap[] source, @NotNull Cubemap target2) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target2, "target");
        Cubemap[] cubemapArray = new Cubemap[]{target2};
        this.apply(source, cubemapArray);
    }

    public final void untrack() {
        block0: {
            Shader shader = this.shader;
            if (shader == null) break block0;
            Shader it = shader;
            boolean bl = false;
            Session.Companion.getActive().untrack(this.shader);
        }
    }

    @NotNull
    protected final VertexFormat getFormat() {
        return CubemapFilterKt.access$getFilterQuadFormat$p();
    }

    private static final Unit apply$lambda$0(RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        return Unit.INSTANCE;
    }

    public CubemapFilter() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/openrndr/extra/dnk3/cubemap/CubemapFilter$Companion;", "", "<init>", "()V", "filterVertexCode", "", "getFilterVertexCode", "()Ljava/lang/String;", "deminityy"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFilterVertexCode() {
            return Driver.Companion.getInstance().internalShaderResource("filter.vert");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

