/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.dnk3.dsl;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.extra.dnk3.Geometry;
import org.openrndr.extra.dnk3.Material;
import org.openrndr.extra.dnk3.Mesh;
import org.openrndr.extra.dnk3.MeshPrimitive;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0016\u001a\u00020\u0017R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lorg/openrndr/extra/dnk3/dsl/SimpleMeshBuilder;", "", "<init>", "()V", "vertexBuffer", "Lorg/openrndr/draw/VertexBuffer;", "getVertexBuffer", "()Lorg/openrndr/draw/VertexBuffer;", "setVertexBuffer", "(Lorg/openrndr/draw/VertexBuffer;)V", "primitive", "Lorg/openrndr/draw/DrawPrimitive;", "getPrimitive", "()Lorg/openrndr/draw/DrawPrimitive;", "setPrimitive", "(Lorg/openrndr/draw/DrawPrimitive;)V", "material", "Lorg/openrndr/extra/dnk3/Material;", "getMaterial", "()Lorg/openrndr/extra/dnk3/Material;", "setMaterial", "(Lorg/openrndr/extra/dnk3/Material;)V", "build", "Lorg/openrndr/extra/dnk3/Mesh;", "deminityy"})
public final class SimpleMeshBuilder {
    @Nullable
    private VertexBuffer vertexBuffer;
    @NotNull
    private DrawPrimitive primitive = DrawPrimitive.TRIANGLES;
    @Nullable
    private Material material;

    @Nullable
    public final VertexBuffer getVertexBuffer() {
        return this.vertexBuffer;
    }

    public final void setVertexBuffer(@Nullable VertexBuffer vertexBuffer) {
        this.vertexBuffer = vertexBuffer;
    }

    @NotNull
    public final DrawPrimitive getPrimitive() {
        return this.primitive;
    }

    public final void setPrimitive(@NotNull DrawPrimitive drawPrimitive) {
        Intrinsics.checkNotNullParameter((Object)drawPrimitive, "<set-?>");
        this.primitive = drawPrimitive;
    }

    @Nullable
    public final Material getMaterial() {
        return this.material;
    }

    public final void setMaterial(@Nullable Material material) {
        this.material = material;
    }

    @NotNull
    public final Mesh build() {
        VertexBuffer vertexBuffer = this.vertexBuffer;
        if (vertexBuffer == null) {
            throw new IllegalStateException("no vertex buffer".toString());
        }
        VertexBuffer vertexBuffer2 = this.vertexBuffer;
        if (vertexBuffer2 == null) {
            throw new IllegalStateException("no vertex buffer".toString());
        }
        Geometry geometry = new Geometry(CollectionsKt.listOf(vertexBuffer), null, this.primitive, 0, vertexBuffer2.getVertexCount());
        Material material = this.material;
        if (material == null) {
            throw new IllegalStateException("no material".toString());
        }
        MeshPrimitive primitive = new MeshPrimitive(geometry, material);
        return new Mesh(CollectionsKt.listOf(primitive));
    }
}

