/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.dnk3.gltf;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.extra.dnk3.gltf.GltfFile;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/openrndr/extra/dnk3/gltf/GltfBuffer;", "", "byteLength", "", "uri", "", "<init>", "(ILjava/lang/String;)V", "getByteLength", "()I", "getUri", "()Ljava/lang/String;", "contents", "Ljava/nio/ByteBuffer;", "gltfFile", "Lorg/openrndr/extra/dnk3/gltf/GltfFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "deminityy"})
public final class GltfBuffer {
    private final int byteLength;
    @Nullable
    private final String uri;

    public GltfBuffer(int byteLength, @Nullable String uri) {
        this.byteLength = byteLength;
        this.uri = uri;
    }

    public final int getByteLength() {
        return this.byteLength;
    }

    @Nullable
    public final String getUri() {
        return this.uri;
    }

    @NotNull
    public final ByteBuffer contents(@NotNull GltfFile gltfFile) {
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter(gltfFile, "gltfFile");
        if (this.uri != null) {
            ByteBuffer byteBuffer2;
            if (StringsKt.startsWith$default(this.uri, "data:", false, 2, null)) {
                String string = this.uri.substring(StringsKt.indexOf$default((CharSequence)this.uri, ",", 0, false, 6, null) + 1);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                String base64 = string;
                byte[] decoded = Base64.getDecoder().decode(base64);
                ByteBuffer buffer = ByteBuffer.allocateDirect(decoded.length);
                buffer.order(ByteOrder.nativeOrder());
                buffer.put(decoded);
                buffer.rewind();
                byteBuffer2 = buffer;
            } else {
                RandomAccessFile raf = new RandomAccessFile(new File(gltfFile.getFile().getParentFile(), this.uri), "r");
                ByteBuffer buffer = ByteBuffer.allocateDirect(this.byteLength);
                buffer.order(ByteOrder.nativeOrder());
                buffer.rewind();
                raf.getChannel().read(buffer);
                buffer.rewind();
                byteBuffer2 = buffer;
            }
            ByteBuffer byteBuffer3 = byteBuffer2;
            Intrinsics.checkNotNull(byteBuffer3);
            byteBuffer = byteBuffer3;
        } else {
            byteBuffer = gltfFile.getBufferBuffer();
            if (byteBuffer == null) {
                throw new IllegalStateException("no embedded buffer from glb".toString());
            }
        }
        return byteBuffer;
    }

    public final int component1() {
        return this.byteLength;
    }

    @Nullable
    public final String component2() {
        return this.uri;
    }

    @NotNull
    public final GltfBuffer copy(int byteLength, @Nullable String uri) {
        return new GltfBuffer(byteLength, uri);
    }

    public static /* synthetic */ GltfBuffer copy$default(GltfBuffer gltfBuffer, int n, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = gltfBuffer.byteLength;
        }
        if ((n2 & 2) != 0) {
            string = gltfBuffer.uri;
        }
        return gltfBuffer.copy(n, string);
    }

    @NotNull
    public String toString() {
        return "GltfBuffer(byteLength=" + this.byteLength + ", uri=" + this.uri + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.byteLength);
        result = result * 31 + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GltfBuffer)) {
            return false;
        }
        GltfBuffer gltfBuffer = (GltfBuffer)other;
        if (this.byteLength != gltfBuffer.byteLength) {
            return false;
        }
        return Intrinsics.areEqual(this.uri, gltfBuffer.uri);
    }
}

