/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.dnk3.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Cubemap;
import org.openrndr.draw.ProgramRenderTarget;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleKt;
import org.openrndr.draw.ShadeStyleOutput;
import org.openrndr.extra.dnk3.FacetCombiner;
import org.openrndr.extra.dnk3.Material;
import org.openrndr.extra.dnk3.MaterialContext;
import org.openrndr.extra.dnk3.PrimitiveContext;
import org.openrndr.extra.dnk3.RenderPassKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u001eH\u0016J\b\u0010'\u001a\u00020\u001aH\u0016J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010+\u001a\u00020\u00112\b\u0010,\u001a\u0004\u0018\u00010-H\u00d6\u0003J\t\u0010.\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006/"}, d2={"Lorg/openrndr/extra/dnk3/tools/SkyboxMaterial;", "Lorg/openrndr/extra/dnk3/Material;", "cubemap", "Lorg/openrndr/draw/Cubemap;", "intensity", "", "<init>", "(Lorg/openrndr/draw/Cubemap;D)V", "getCubemap", "()Lorg/openrndr/draw/Cubemap;", "getIntensity", "()D", "name", "", "getName", "()Ljava/lang/String;", "doubleSided", "", "getDoubleSided", "()Z", "setDoubleSided", "(Z)V", "transparent", "getTransparent", "setTransparent", "fragmentID", "", "getFragmentID", "()I", "generateShadeStyle", "Lorg/openrndr/draw/ShadeStyle;", "materialContext", "Lorg/openrndr/extra/dnk3/MaterialContext;", "primitiveContext", "Lorg/openrndr/extra/dnk3/PrimitiveContext;", "applyToShadeStyle", "", "context", "shadeStyle", "hashCode", "component1", "component2", "copy", "equals", "other", "", "toString", "deminityy"})
@SourceDebugExtension(value={"SMAP\nSkybox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Skybox.kt\norg/openrndr/extra/dnk3/tools/SkyboxMaterial\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1557#2:85\n1628#2,3:86\n1557#2:89\n1628#2,3:90\n*S KotlinDebug\n*F\n+ 1 Skybox.kt\norg/openrndr/extra/dnk3/tools/SkyboxMaterial\n*L\n21#1:85\n21#1:86,3\n42#1:89\n42#1:90,3\n*E\n"})
public final class SkyboxMaterial
implements Material {
    @NotNull
    private final Cubemap cubemap;
    private final double intensity;
    @NotNull
    private final String name;
    private boolean doubleSided;
    private boolean transparent;
    private final int fragmentID;

    public SkyboxMaterial(@NotNull Cubemap cubemap, double intensity) {
        Intrinsics.checkNotNullParameter(cubemap, "cubemap");
        this.cubemap = cubemap;
        this.intensity = intensity;
        this.name = "skybox";
    }

    public /* synthetic */ SkyboxMaterial(Cubemap cubemap, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        this(cubemap, d);
    }

    @NotNull
    public final Cubemap getCubemap() {
        return this.cubemap;
    }

    public final double getIntensity() {
        return this.intensity;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean getDoubleSided() {
        return this.doubleSided;
    }

    @Override
    public void setDoubleSided(boolean bl) {
        this.doubleSided = bl;
    }

    @Override
    public boolean getTransparent() {
        return this.transparent;
    }

    @Override
    public void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    @Override
    public int getFragmentID() {
        return this.fragmentID;
    }

    @Override
    @NotNull
    public ShadeStyle generateShadeStyle(@NotNull MaterialContext materialContext, @NotNull PrimitiveContext primitiveContext) {
        Intrinsics.checkNotNullParameter(materialContext, "materialContext");
        Intrinsics.checkNotNullParameter(primitiveContext, "primitiveContext");
        return ShadeStyleKt.shadeStyle(arg_0 -> SkyboxMaterial.generateShadeStyle$lambda$2(materialContext, arg_0));
    }

    @Override
    public void applyToShadeStyle(@NotNull MaterialContext context, @NotNull ShadeStyle shadeStyle) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(shadeStyle, "shadeStyle");
        shadeStyle.parameter("skybox", this.cubemap);
        shadeStyle.parameter("intensity", this.intensity);
    }

    public int hashCode() {
        int result = Double.hashCode(this.intensity);
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + Boolean.hashCode(this.getDoubleSided());
        result = 31 * result + Boolean.hashCode(this.getTransparent());
        result = 31 * result + this.getFragmentID();
        return result;
    }

    @NotNull
    public final Cubemap component1() {
        return this.cubemap;
    }

    public final double component2() {
        return this.intensity;
    }

    @NotNull
    public final SkyboxMaterial copy(@NotNull Cubemap cubemap, double intensity) {
        Intrinsics.checkNotNullParameter(cubemap, "cubemap");
        return new SkyboxMaterial(cubemap, intensity);
    }

    public static /* synthetic */ SkyboxMaterial copy$default(SkyboxMaterial skyboxMaterial, Cubemap cubemap, double d, int n, Object object) {
        if ((n & 1) != 0) {
            cubemap = skyboxMaterial.cubemap;
        }
        if ((n & 2) != 0) {
            d = skyboxMaterial.intensity;
        }
        return skyboxMaterial.copy(cubemap, d);
    }

    @NotNull
    public String toString() {
        return "SkyboxMaterial(cubemap=" + this.cubemap + ", intensity=" + this.intensity + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SkyboxMaterial)) {
            return false;
        }
        SkyboxMaterial skyboxMaterial = (SkyboxMaterial)other;
        if (!Intrinsics.areEqual(this.cubemap, skyboxMaterial.cubemap)) {
            return false;
        }
        return Double.compare(this.intensity, skyboxMaterial.intensity) == 0;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit generateShadeStyle$lambda$2(MaterialContext $materialContext, ShadeStyle $this$shadeStyle) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter($this$shadeStyle, "$this$shadeStyle");
        $this$shadeStyle.setVertexTransform("vec2 i = vec2(1.0, 0.0); \nx_viewMatrix = x_viewNormalMatrix;");
        Iterable $this$map$iv = $materialContext.getPass().combiners();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            FacetCombiner facetCombiner = (FacetCombiner)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.generateShader());
        }
        String combinerFS = CollectionsKt.joinToString$default((List)destination$iv$iv, "\n", null, null, 0, null, null, 62, null);
        $this$shadeStyle.setFragmentPreamble("vec4 f_diffuse = vec4(0.0, 0.0, 0.0, 1.0);\nvec3 f_specular = vec3(0.0);\nvec3 f_ambient = vec3(0.0);\nvec3 f_emission = vec3(0.0);\nint f_fragmentID = 0;\nvec4 m_color = vec4(1.0);\nvec4 f_fog = vec4(0.0);\n");
        $this$shadeStyle.setFragmentTransform("\n                f_diffuse = texture(p_skybox, va_position);\n                f_diffuse.rgb *= p_intensity;\n            " + combinerFS);
        $this$shadeStyle.setSuppressDefaultOutput(true);
        RenderTarget rt = RenderTarget.Companion.getActive();
        Iterable $this$map$iv2 = $materialContext.getPass().combiners();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FacetCombiner bl = (FacetCombiner)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            if (rt instanceof ProgramRenderTarget || $materialContext.getPass() == RenderPassKt.getDefaultPass() || $materialContext.getPass() == RenderPassKt.getDefaultOpaquePass() || $materialContext.getPass() == RenderPassKt.getDefaultTransparentPass()) {
                $this$shadeStyle.output(it.getTargetOutput(), new ShadeStyleOutput(0, null, null, 6, null));
            } else {
                Integer n = rt.colorAttachmentIndexByName(it.getTargetOutput());
                if (n == null) {
                    throw new IllegalStateException(("attachment " + it.getTargetOutput() + " not found").toString());
                }
                int index = n;
                ColorType type = rt.colorBuffer(index).getType();
                ColorFormat format = rt.colorBuffer(index).getFormat();
                $this$shadeStyle.output(it.getTargetOutput(), new ShadeStyleOutput(index, format, type));
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv2;
        return Unit.INSTANCE;
    }
}

