/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.fcurve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.extra.fcurve.FCurve$;
import org.openrndr.extra.fcurve.FCurveKt;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.transforms.TransformBuilder;
import org.openrndr.math.transforms.TransformBuilderKt;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.RectangleKt;
import org.openrndr.shape.Segment2D;
import org.openrndr.shape.Segment2D$;
import org.openrndr.shape.ShapeContour;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 B2\u00020\u0001:\u0002ABB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B+\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u0006\u0010\u000e\u001a\u00020\u0000J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0016J\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u001e2\b\b\u0002\u0010\u001f\u001a\u00020 J\u001a\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00162\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u0004J(\u0010*\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00040+2\u0006\u0010(\u001a\u00020\u00162\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\u0004J \u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00032\b\b\u0002\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u000200J\u000f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u00103\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u00104\u001a\u00020 2\b\u00105\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00106\u001a\u00020\bH\u00d6\u0001J\t\u00107\u001a\u000208H\u00d6\u0001J%\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0001\u00a2\u0006\u0002\b@R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010!\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0018R\u0011\u0010#\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0018R\u0011\u0010%\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0018\u00a8\u0006C"}, d2={"Lorg/openrndr/extra/fcurve/FCurve;", "", "segments", "", "Lorg/openrndr/shape/Segment2D;", "<init>", "(Ljava/util/List;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getSegments", "()Ljava/util/List;", "reverse", "bounds", "Lorg/openrndr/shape/Rectangle;", "getBounds", "()Lorg/openrndr/shape/Rectangle;", "bounds$delegate", "Lkotlin/Lazy;", "min", "", "getMin", "()D", "max", "getMax", "changeSpeed", "speed", "sampler", "Lkotlin/Function1;", "normalized", "", "duration", "getDuration", "start", "getStart", "end", "getEnd", "value", "t", "segment", "valueWithSegment", "Lkotlin/Pair;", "cachedSegment", "contours", "Lorg/openrndr/shape/ShapeContour;", "scale", "Lorg/openrndr/math/Vector2;", "offset", "component1", "copy", "equals", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$orx_fcurve", "$serializer", "Companion", "orx-fcurve"})
@SourceDebugExtension(value={"SMAP\nFCurve.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FCurve.kt\norg/openrndr/extra/fcurve/FCurve\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,581:1\n1557#2:582\n1628#2,3:583\n1557#2:586\n1628#2,3:587\n1557#2:590\n1628#2,3:591\n1557#2:594\n1628#2,3:595\n*S KotlinDebug\n*F\n+ 1 FCurve.kt\norg/openrndr/extra/fcurve/FCurve\n*L\n96#1:582\n96#1:583,3\n137#1:586\n137#1:587,3\n100#1:590\n100#1:591,3\n100#1:594\n100#1:595,3\n*E\n"})
public final class FCurve {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Segment2D> segments;
    @NotNull
    private final Lazy bounds$delegate;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    public FCurve(@NotNull List<Segment2D> segments) {
        Intrinsics.checkNotNullParameter(segments, "segments");
        this.segments = segments;
        this.bounds$delegate = LazyKt.lazy(() -> FCurve.bounds_delegate$lambda$3(this));
    }

    @NotNull
    public final List<Segment2D> getSegments() {
        return this.segments;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FCurve reverse() {
        void $this$mapTo$iv$iv;
        double d = this.getDuration();
        Matrix44 t = TransformBuilderKt.buildTransform$default(null, arg_0 -> FCurve.reverse$lambda$0(d, arg_0), 1, null);
        Iterable $this$map$iv = this.segments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment2D segment2D = (Segment2D)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getReverse().transform(t));
        }
        List list = (List)destination$iv$iv;
        return new FCurve(list);
    }

    @NotNull
    public final Rectangle getBounds() {
        Lazy lazy = this.bounds$delegate;
        return (Rectangle)lazy.getValue();
    }

    public final double getMin() {
        if (this.segments.isEmpty()) {
            return 0.0;
        }
        return this.getBounds().position(0.0, 0.0).y();
    }

    public final double getMax() {
        if (this.segments.isEmpty()) {
            return 0.0;
        }
        return this.getBounds().position(1.0, 1.0).y();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FCurve changeSpeed(double speed) {
        FCurve fCurve;
        FCurve c2 = speed < 0.0 ? this.reverse() : this;
        if (speed == 1.0) {
            fCurve = c2;
        } else {
            void $this$mapTo$iv$iv;
            Matrix44 t = TransformBuilderKt.buildTransform$default(null, arg_0 -> FCurve.changeSpeed$lambda$4(speed, arg_0), 1, null);
            Iterable $this$map$iv = c2.segments;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Segment2D segment2D = (Segment2D)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.transform(t));
            }
            List list = (List)destination$iv$iv;
            fCurve = new FCurve(list);
        }
        return fCurve;
    }

    @NotNull
    public final Function1<Double, Double> sampler(boolean normalized) {
        Ref.ObjectRef cachedSegment = new Ref.ObjectRef();
        if (!normalized) {
            return arg_0 -> FCurve.sampler$lambda$6(this, cachedSegment, arg_0);
        }
        double d = this.getDuration();
        return arg_0 -> FCurve.sampler$lambda$7(this, d, cachedSegment, arg_0);
    }

    public static /* synthetic */ Function1 sampler$default(FCurve fCurve, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return fCurve.sampler(bl);
    }

    public final double getDuration() {
        return this.segments.isEmpty() ? 0.0 : this.getEnd() - this.getStart();
    }

    public final double getStart() {
        return this.segments.isEmpty() ? 0.0 : CollectionsKt.first(this.segments).getStart().x();
    }

    public final double getEnd() {
        return this.segments.isEmpty() ? 0.0 : CollectionsKt.last(this.segments).getEnd().x();
    }

    public final double value(double t, @Nullable Segment2D segment) {
        return ((Number)this.valueWithSegment(t, segment).getFirst()).doubleValue();
    }

    public static /* synthetic */ double value$default(FCurve fCurve, double d, Segment2D segment2D, int n, Object object) {
        if ((n & 2) != 0) {
            segment2D = null;
        }
        return fCurve.value(d, segment2D);
    }

    @NotNull
    public final Pair<Double, Segment2D> valueWithSegment(double t, @Nullable Segment2D cachedSegment) {
        Segment2D segment;
        if (cachedSegment != null && t >= cachedSegment.getStart().x() && t < cachedSegment.getEnd().x()) {
            return new Pair<Double, Segment2D>(FCurveKt.access$yForX(cachedSegment, t), cachedSegment);
        }
        if (this.segments.isEmpty()) {
            return new Pair<Double, Object>(0.0, null);
        }
        if (t <= CollectionsKt.first(this.segments).getStart().x()) {
            Segment2D segment2 = CollectionsKt.first(this.segments);
            return new Pair<Double, Segment2D>(segment2.getStart().y(), segment2);
        }
        if (t > CollectionsKt.last(this.segments).getEnd().x()) {
            Segment2D segment3 = CollectionsKt.last(this.segments);
            return new Pair<Double, Segment2D>(segment3.getEnd().y(), segment3);
        }
        int segmentIndex = CollectionsKt.binarySearch$default(this.segments, 0, 0, arg_0 -> FCurve.valueWithSegment$lambda$8(t, arg_0), 3, null);
        Segment2D segment2D = segment = CollectionsKt.getOrNull(this.segments, segmentIndex);
        return new Pair<Double, Segment2D>(segment2D != null ? FCurveKt.access$yForX(segment2D, t) : 0.0, segment);
    }

    public static /* synthetic */ Pair valueWithSegment$default(FCurve fCurve, double d, Segment2D segment2D, int n, Object object) {
        if ((n & 2) != 0) {
            segment2D = null;
        }
        return fCurve.valueWithSegment(d, segment2D);
    }

    @NotNull
    public final List<ShapeContour> contours(@NotNull Vector2 scale, @NotNull Vector2 offset) {
        Intrinsics.checkNotNullParameter(scale, "scale");
        Intrinsics.checkNotNullParameter(offset, "offset");
        List active = new ArrayList();
        List result = new ArrayList();
        for (Segment2D segment : this.segments) {
            boolean bl;
            Segment2D tsegment = segment.transform(TransformBuilderKt.buildTransform$default(null, arg_0 -> FCurve.contours$lambda$9(offset, scale, arg_0), 1, null));
            if (active.isEmpty()) {
                bl = active.add(tsegment);
                continue;
            }
            double dy = Math.abs(((Segment2D)CollectionsKt.last(active)).getEnd().y() - tsegment.getStart().y());
            if (dy > 0.001) {
                result.add(ShapeContour.Companion.fromSegments$default(ShapeContour.Companion, active, false, null, 0.0, 12, null));
                active = new ArrayList();
            }
            bl = active.add(tsegment);
        }
        if (!((Collection)active).isEmpty()) {
            result.add(ShapeContour.Companion.fromSegments$default(ShapeContour.Companion, active, false, null, 0.0, 12, null));
        }
        return result;
    }

    public static /* synthetic */ List contours$default(FCurve fCurve, Vector2 vector2, Vector2 vector22, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = new Vector2(1.0, -1.0);
        }
        if ((n & 2) != 0) {
            vector22 = Vector2.Companion.getZERO();
        }
        return fCurve.contours(vector2, vector22);
    }

    @NotNull
    public final List<Segment2D> component1() {
        return this.segments;
    }

    @NotNull
    public final FCurve copy(@NotNull List<Segment2D> segments) {
        Intrinsics.checkNotNullParameter(segments, "segments");
        return new FCurve(segments);
    }

    public static /* synthetic */ FCurve copy$default(FCurve fCurve, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = fCurve.segments;
        }
        return fCurve.copy(list);
    }

    @NotNull
    public String toString() {
        return "FCurve(segments=" + this.segments + ")";
    }

    public int hashCode() {
        return ((Object)this.segments).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FCurve)) {
            return false;
        }
        FCurve fCurve = (FCurve)other;
        return Intrinsics.areEqual(this.segments, fCurve.segments);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$orx_fcurve(FCurve self, CompositeEncoder output, SerialDescriptor serialDesc) {
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], self.segments);
    }

    public /* synthetic */ FCurve(int seen0, List segments, SerializationConstructorMarker serializationConstructorMarker) {
        if (1 != (1 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 1, $serializer.INSTANCE.getDescriptor());
        }
        this.segments = segments;
        this.bounds$delegate = LazyKt.lazy(() -> FCurve._init_$lambda$11(this));
    }

    private static final Unit reverse$lambda$0(double $d, TransformBuilder $this$buildTransform) {
        Intrinsics.checkNotNullParameter($this$buildTransform, "$this$buildTransform");
        TransformBuilder.translate$default($this$buildTransform, $d, 0.0, 0.0, 4, null);
        TransformBuilder.scale$default($this$buildTransform, -1.0, 1.0, 0.0, 4, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Rectangle bounds_delegate$lambda$3(FCurve this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.segments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment2D segment2D = (Segment2D)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getBounds());
        }
        return RectangleKt.getRectangleBounds((List)destination$iv$iv);
    }

    private static final Unit changeSpeed$lambda$4(double $speed, TransformBuilder $this$buildTransform) {
        Intrinsics.checkNotNullParameter($this$buildTransform, "$this$buildTransform");
        TransformBuilder.scale$default($this$buildTransform, 1.0 / $speed, 1.0, 0.0, 4, null);
        return Unit.INSTANCE;
    }

    private static final double sampler$lambda$6(FCurve this$0, Ref.ObjectRef $cachedSegment, double t) {
        Pair<Double, Segment2D> r = this$0.valueWithSegment(t, (Segment2D)$cachedSegment.element);
        $cachedSegment.element = r.getSecond();
        return ((Number)r.getFirst()).doubleValue();
    }

    private static final double sampler$lambda$7(FCurve this$0, double $d, Ref.ObjectRef $cachedSegment, double t) {
        Pair<Double, Segment2D> r = this$0.valueWithSegment(t * $d, (Segment2D)$cachedSegment.element);
        $cachedSegment.element = r.getSecond();
        return ((Number)r.getFirst()).doubleValue();
    }

    private static final int valueWithSegment$lambda$8(double $t, Segment2D it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $t < it.getStart().x() ? 1 : ($t > it.getEnd().x() ? -1 : 0);
    }

    private static final Unit contours$lambda$9(Vector2 $offset, Vector2 $scale, TransformBuilder $this$buildTransform) {
        Intrinsics.checkNotNullParameter($this$buildTransform, "$this$buildTransform");
        $this$buildTransform.translate($offset);
        TransformBuilder.scale$default($this$buildTransform, $scale.x(), $scale.y(), 0.0, 4, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Rectangle _init_$lambda$11(FCurve this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.segments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment2D segment2D = (Segment2D)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getBounds());
        }
        return RectangleKt.getRectangleBounds((List)destination$iv$iv);
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{new ArrayListSerializer(Segment2D$.serializer.INSTANCE)};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/extra/fcurve/FCurve$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/openrndr/extra/fcurve/FCurve;", "orx-fcurve"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<FCurve> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

