/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.fcurve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.fcurve.FCurve;
import org.openrndr.extra.fcurve.FCurveKt;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Segment2D;
import org.openrndr.shape.Segment2DKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ \u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ0\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ@\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ \u0010\"\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ0\u0010\"\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010#\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010$\u001a\u00020%R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006&"}, d2={"Lorg/openrndr/extra/fcurve/FCurveBuilder;", "", "<init>", "()V", "segments", "", "Lorg/openrndr/shape/Segment2D;", "getSegments", "()Ljava/util/List;", "cursor", "Lorg/openrndr/math/Vector2;", "getCursor", "()Lorg/openrndr/math/Vector2;", "setCursor", "(Lorg/openrndr/math/Vector2;)V", "path", "", "getPath", "()Ljava/lang/String;", "setPath", "(Ljava/lang/String;)V", "moveTo", "", "y", "", "relative", "", "lineTo", "x", "curveTo", "x0", "y0", "x1", "y1", "continueTo", "hold", "build", "Lorg/openrndr/extra/fcurve/FCurve;", "orx-fcurve"})
@SourceDebugExtension(value={"SMAP\nFCurve.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FCurve.kt\norg/openrndr/extra/fcurve/FCurveBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,581:1\n1#2:582\n*E\n"})
public final class FCurveBuilder {
    @NotNull
    private final List<Segment2D> segments = new ArrayList();
    @NotNull
    private Vector2 cursor = new Vector2(0.0, 0.0);
    @NotNull
    private String path = "";

    @NotNull
    public final List<Segment2D> getSegments() {
        return this.segments;
    }

    @NotNull
    public final Vector2 getCursor() {
        return this.cursor;
    }

    public final void setCursor(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter(vector2, "<set-?>");
        this.cursor = vector2;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final void setPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.path = string;
    }

    public final void moveTo(double y, boolean relative) {
        this.cursor = !relative ? Vector2.copy$default(this.cursor, 0.0, y, 1, null) : Vector2.copy$default(this.cursor, 0.0, this.cursor.y() + y, 1, null);
        this.path = this.path + (relative ? "m" : "M") + y;
    }

    public static /* synthetic */ void moveTo$default(FCurveBuilder fCurveBuilder, double d, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        fCurveBuilder.moveTo(d, bl);
    }

    public final void lineTo(double x, double y, boolean relative) {
        double r = relative ? 1.0 : 0.0;
        this.segments.add(Segment2DKt.Segment2D$default(this.cursor, new Vector2(x + this.cursor.x(), y + this.cursor.y() * r), false, 4, null));
        this.cursor = new Vector2(this.cursor.x() + x, this.cursor.y() * r + y);
        this.path = this.path + (relative ? "l" : "L") + x + "," + y;
    }

    public static /* synthetic */ void lineTo$default(FCurveBuilder fCurveBuilder, double d, double d2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        fCurveBuilder.lineTo(d, d2, bl);
    }

    public final void curveTo(double x0, double y0, double x, double y, boolean relative) {
        double r = relative ? 1.0 : 0.0;
        this.segments.add(Segment2DKt.Segment2D$default(this.cursor, new Vector2(this.cursor.x() + x0, this.cursor.y() * r + y0), new Vector2(this.cursor.x() + x, this.cursor.y() * r + y), false, 8, null));
        this.cursor = new Vector2(this.cursor.x() + x, this.cursor.y() * r + y);
        this.path = this.path + (relative ? "q" : "Q") + x0 + "," + y0 + "," + x + "," + y;
    }

    public static /* synthetic */ void curveTo$default(FCurveBuilder fCurveBuilder, double d, double d2, double d3, double d4, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        fCurveBuilder.curveTo(d, d2, d3, d4, bl);
    }

    public final void curveTo(double x0, double y0, double x1, double y1, double x, double y, boolean relative) {
        double r = relative ? 1.0 : 0.0;
        this.segments.add(FCurveKt.scaleTangents$default(Segment2DKt.Segment2D$default(this.cursor, new Vector2(this.cursor.x() + x0, this.cursor.y() * r + y0), new Vector2(this.cursor.x() + x1, this.cursor.y() * r + y1), new Vector2(this.cursor.x() + x, this.cursor.y() * r + y), false, 16, null), null, 1, null));
        this.cursor = new Vector2(this.cursor.x() + x, this.cursor.y() * r + y);
        this.path = this.path + (relative ? "c" : "C") + x0 + "," + y0 + "," + x + "," + y;
    }

    public static /* synthetic */ void curveTo$default(FCurveBuilder fCurveBuilder, double d, double d2, double d3, double d4, double d5, double d6, boolean bl, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl = false;
        }
        fCurveBuilder.curveTo(d, d2, d3, d4, d5, d6, bl);
    }

    public final void continueTo(double x, double y, boolean relative) {
        double r = relative ? 1.0 : 0.0;
        if (!((Collection)this.segments).isEmpty()) {
            Segment2D lastSegment = CollectionsKt.last(this.segments);
            Vector2 outTangent = CollectionsKt.last(this.segments).getLinear() ? lastSegment.getEnd() : CollectionsKt.last(CollectionsKt.last(this.segments).getControl());
            Vector2 outPos = lastSegment.getEnd();
            Vector2 d = outPos.minus(outTangent);
            double ts = 1.0;
            v0 = this.segments.add(FCurveKt.scaleTangents$default(Segment2DKt.Segment2D$default(this.cursor, this.cursor.plus(d.times(ts)), new Vector2(this.cursor.x() + x, this.cursor.y() * r + y), false, 8, null), null, 1, null));
        } else {
            v0 = this.segments.add(Segment2DKt.Segment2D$default(this.cursor, new Vector2(this.cursor.x() + x, this.cursor.y() * r + y), false, 4, null).getQuadratic());
        }
        this.cursor = new Vector2(this.cursor.x() + x, this.cursor.y() * r + y);
        this.path = this.path + (relative ? "t" : "T") + x + "," + y;
    }

    public static /* synthetic */ void continueTo$default(FCurveBuilder fCurveBuilder, double d, double d2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        fCurveBuilder.continueTo(d, d2, bl);
    }

    public final void continueTo(double x1, double y1, double x, double y, boolean relative) {
        double r = relative ? 1.0 : 0.0;
        Segment2D lastSegment = CollectionsKt.last(this.segments);
        Vector2 outTangent = lastSegment.getLinear() ? lastSegment.position(0.5) : CollectionsKt.last(CollectionsKt.last(this.segments).getControl());
        double dx = this.cursor.x() - outTangent.x();
        double dy = this.cursor.y() - outTangent.y();
        this.segments.add(FCurveKt.scaleTangents$default(Segment2DKt.Segment2D$default(this.cursor, new Vector2(this.cursor.x() + dx, this.cursor.y() + dy), new Vector2(this.cursor.x() + x1, this.cursor.y() * r + y1), new Vector2(this.cursor.x() + x, this.cursor.y() * r + y), false, 16, null), null, 1, null));
        this.cursor = new Vector2(this.cursor.x() + x, this.cursor.y() * r + y);
        this.path = this.path + (relative ? "s" : "S") + x1 + "," + y1 + "," + x + "," + y;
    }

    public static /* synthetic */ void continueTo$default(FCurveBuilder fCurveBuilder, double d, double d2, double d3, double d4, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        fCurveBuilder.continueTo(d, d2, d3, d4, bl);
    }

    public final void hold(double x, boolean relative) {
        if (relative) {
            FCurveBuilder.lineTo$default(this, x, this.cursor.y(), false, 4, null);
        } else {
            if (!this.segments.isEmpty()) {
                boolean bl = false;
                String string = "absolute hold (H " + x + ") is only allowed when used as first command";
                throw new IllegalArgumentException(string.toString());
            }
            this.cursor = Vector2.copy$default(this.cursor, x, 0.0, 2, null);
        }
        this.path = this.path + "h" + x;
    }

    public static /* synthetic */ void hold$default(FCurveBuilder fCurveBuilder, double d, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        fCurveBuilder.hold(d, bl);
    }

    @NotNull
    public final FCurve build() {
        return new FCurve(this.segments);
    }
}

