/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.kdtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.collections.PriorityQueue;
import org.openrndr.extra.kdtree.KDTreeNode;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\u001aE\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u0002H\u00022\u0006\u0010\u0004\u001a\u0002H\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\bH\u0002\u00a2\u0006\u0002\u0010\t\u001a&\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\f0\u000b\"\u0004\b\u0000\u0010\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00020\f\u001aA\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000b\"\u0004\b\u0000\u0010\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00020\f2\u0006\u0010\u000f\u001a\u0002H\u00022\u0006\u0010\u0010\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013\u001a5\u0010\u0014\u001a\u0004\u0018\u0001H\u0002\"\u0004\b\u0000\u0010\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00020\f2\u0006\u0010\u000f\u001a\u0002H\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0015\u001aA\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000b\"\u0004\b\u0000\u0010\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00020\f2\u0006\u0010\u000f\u001a\u0002H\u00022\u0006\u0010\u0017\u001a\u00020\u00012\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0018\u001aQ\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00020\f\"\u0004\b\u0000\u0010\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00020\f2\u0006\u0010\u001a\u001a\u0002H\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\bH\u0002\u00a2\u0006\u0002\u0010\u001b\u001a>\u0010\u001c\u001a\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\f\"\u0004\b\u0000\u0010\u00022\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00020\f2\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\bH\u0002\u00a8\u0006\u001e"}, d2={"sqrDistance", "", "T", "left", "right", "dimensions", "", "mapper", "Lkotlin/Function2;", "(Ljava/lang/Object;Ljava/lang/Object;ILkotlin/jvm/functions/Function2;)D", "findAllNodes", "", "Lorg/openrndr/extra/kdtree/KDTreeNode;", "root", "findKNearest", "query", "k", "includeQuery", "", "(Lorg/openrndr/extra/kdtree/KDTreeNode;Ljava/lang/Object;IZ)Ljava/util/List;", "findNearest", "(Lorg/openrndr/extra/kdtree/KDTreeNode;Ljava/lang/Object;Z)Ljava/lang/Object;", "findAllInRadius", "radius", "(Lorg/openrndr/extra/kdtree/KDTreeNode;Ljava/lang/Object;DZ)Ljava/util/List;", "insert", "item", "(Lorg/openrndr/extra/kdtree/KDTreeNode;Ljava/lang/Object;ILkotlin/jvm/functions/Function2;)Lorg/openrndr/extra/kdtree/KDTreeNode;", "remove", "toRemove", "orx-kdtree"})
public final class KDTreeKt {
    private static final <T> double sqrDistance(T left, T right, int dimensions, Function2<? super T, ? super Integer, Double> mapper) {
        double distance = 0.0;
        for (int i = 0; i < dimensions; ++i) {
            double d = ((Number)mapper.invoke(left, i)).doubleValue() - ((Number)mapper.invoke(right, i)).doubleValue();
            distance += d * d;
        }
        return distance;
    }

    @NotNull
    public static final <T> List<KDTreeNode<T>> findAllNodes(@NotNull KDTreeNode<T> root) {
        Intrinsics.checkNotNullParameter(root, "root");
        List stack = new ArrayList();
        List all2 = new ArrayList();
        stack.add(root);
        while (!stack.isEmpty()) {
            KDTreeNode node = (KDTreeNode)CollectionsKt.removeLast(stack);
            all2.add(node);
            if (node.getChildren()[0] != null) {
                KDTreeNode kDTreeNode = node.getChildren()[0];
                Intrinsics.checkNotNull(kDTreeNode);
                stack.add(kDTreeNode);
            }
            if (node.getChildren()[1] == null) continue;
            KDTreeNode kDTreeNode = node.getChildren()[1];
            Intrinsics.checkNotNull(kDTreeNode);
            stack.add(kDTreeNode);
        }
        return all2;
    }

    private static final <T> List<T> findKNearest(KDTreeNode<T> root, T query, int k, boolean includeQuery) {
        PriorityQueue<Pair<KDTreeNode<T>, Double>> queue = new PriorityQueue<Pair<KDTreeNode<T>, Double>>(k + 1, KDTreeKt::findKNearest$lambda$0);
        KDTreeKt.findKNearest$nearest(query, includeQuery, queue, k, root);
        return CollectionsKt.reversed((Iterable)SequencesKt.toList(SequencesKt.filterNotNull(SequencesKt.map(SequencesKt.generateSequence(() -> KDTreeKt.findKNearest$lambda$1(queue)), KDTreeKt::findKNearest$lambda$2))));
    }

    static /* synthetic */ List findKNearest$default(KDTreeNode kDTreeNode, Object object, int n, boolean bl, int n2, Object object2) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        return KDTreeKt.findKNearest(kDTreeNode, object, n, bl);
    }

    private static final <T> T findNearest(KDTreeNode<T> root, T query, boolean includeQuery) {
        Ref.DoubleRef nearest = new Ref.DoubleRef();
        nearest.element = Double.POSITIVE_INFINITY;
        Ref.ObjectRef<KDTreeNode<T>> nearestArg = new Ref.ObjectRef<KDTreeNode<T>>();
        KDTreeKt.findNearest$nearest$3(root, query, nearest, includeQuery, nearestArg, root);
        KDTreeNode kDTreeNode = (KDTreeNode)nearestArg.element;
        return (T)(kDTreeNode != null ? kDTreeNode.getItem() : null);
    }

    static /* synthetic */ Object findNearest$default(KDTreeNode kDTreeNode, Object object, boolean bl, int n, Object object2) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return KDTreeKt.findNearest(kDTreeNode, object, bl);
    }

    private static final <T> List<T> findAllInRadius(KDTreeNode<T> root, T query, double radius, boolean includeQuery) {
        double sqrMaxDist = radius * radius;
        ArrayDeque queue = new ArrayDeque();
        queue.add(root);
        List results = new ArrayList();
        while (!((Collection)queue).isEmpty()) {
            KDTreeNode c2;
            double d;
            int route;
            int n;
            KDTreeNode node = (KDTreeNode)queue.removeFirst();
            double dimensionValue = ((Number)node.getMapper().invoke(query, node.getDimension())).doubleValue();
            Object t = node.getItem();
            if (t == null) {
                throw new IllegalStateException("item is null".toString());
            }
            double distance = KDTreeKt.sqrDistance(query, t, node.getDimensions(), node.getMapper());
            if (distance <= sqrMaxDist && (includeQuery || !Intrinsics.areEqual(node.getItem(), query))) {
                results.add(node.getItem());
            }
            if ((dimensionValue < node.getMedian() || node.getChildren()[1] == null) && node.getChildren()[0] != null) {
                KDTreeNode kDTreeNode = node.getChildren()[0];
                Intrinsics.checkNotNull(kDTreeNode);
                queue.add(kDTreeNode);
                n = 0;
            } else if (node.getChildren()[1] != null) {
                KDTreeNode kDTreeNode = node.getChildren()[1];
                Intrinsics.checkNotNull(kDTreeNode);
                queue.add(kDTreeNode);
                n = 1;
            } else {
                n = -1;
            }
            if ((route = n) == -1 || !((d = Math.abs(node.getMedian() - dimensionValue)) * d <= sqrMaxDist) || (c2 = node.getChildren()[1 - route]) == null) continue;
            queue.add(c2);
        }
        return CollectionsKt.filterNotNull(results);
    }

    static /* synthetic */ List findAllInRadius$default(KDTreeNode kDTreeNode, Object object, double d, boolean bl, int n, Object object2) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return KDTreeKt.findAllInRadius(kDTreeNode, object, d, bl);
    }

    private static final <T> KDTreeNode<T> insert(KDTreeNode<T> root, T item, int dimensions, Function2<? super T, ? super Integer, Double> mapper) {
        List stack = new ArrayList();
        stack.add(root);
        while (true) {
            boolean bl;
            KDTreeNode node;
            double value;
            if ((value = ((Number)mapper.invoke(item, (node = (KDTreeNode)CollectionsKt.last(stack)).getDimension())).doubleValue()) < node.getMedian()) {
                if (node.getChildren()[0] != null) {
                    KDTreeNode kDTreeNode = node.getChildren()[0];
                    Intrinsics.checkNotNull(kDTreeNode);
                    bl = stack.add(kDTreeNode);
                    continue;
                }
                node.getChildren()[0] = new KDTreeNode<T>(dimensions, mapper);
                KDTreeNode<T> kDTreeNode = node.getChildren()[0];
                if (kDTreeNode != null) {
                    kDTreeNode.setItem(item);
                }
                KDTreeNode kDTreeNode2 = node.getChildren()[0];
                if (kDTreeNode2 != null) {
                    kDTreeNode2.setDimension((node.getDimension() + 1) % dimensions);
                }
                KDTreeNode kDTreeNode3 = node.getChildren()[0];
                if (kDTreeNode3 != null) {
                    kDTreeNode3.setMedian(((Number)mapper.invoke(item, (node.getDimension() + 1) % dimensions)).doubleValue());
                }
                KDTreeNode kDTreeNode4 = node.getChildren()[0];
                if (kDTreeNode4 != null) {
                    kDTreeNode4.setParent(node);
                }
                KDTreeNode kDTreeNode5 = node.getChildren()[0];
                if (kDTreeNode5 == null) {
                    throw new IllegalStateException("child is null");
                }
                return kDTreeNode5;
            }
            if (node.getChildren()[1] != null) {
                KDTreeNode kDTreeNode = node.getChildren()[1];
                Intrinsics.checkNotNull(kDTreeNode);
                bl = stack.add(kDTreeNode);
                continue;
            }
            node.getChildren()[1] = new KDTreeNode<T>(dimensions, mapper);
            KDTreeNode<T> kDTreeNode = node.getChildren()[1];
            if (kDTreeNode != null) {
                kDTreeNode.setItem(item);
            }
            KDTreeNode kDTreeNode6 = node.getChildren()[1];
            if (kDTreeNode6 != null) {
                kDTreeNode6.setDimension((node.getDimension() + 1) % dimensions);
            }
            KDTreeNode kDTreeNode7 = node.getChildren()[1];
            if (kDTreeNode7 != null) {
                kDTreeNode7.setMedian(((Number)mapper.invoke(item, (node.getDimension() + 1) % dimensions)).doubleValue());
            }
            KDTreeNode kDTreeNode8 = node.getChildren()[1];
            if (kDTreeNode8 != null) {
                kDTreeNode8.setParent(node);
            }
            KDTreeNode kDTreeNode9 = node.getChildren()[1];
            if (kDTreeNode9 == null) {
                throw new IllegalStateException("child is null");
            }
            return kDTreeNode9;
        }
    }

    private static final <T> KDTreeNode<T> remove(KDTreeNode<T> toRemove, Function2<? super T, ? super Integer, Double> mapper) {
        if (toRemove.isLeaf$orx_kdtree()) {
            KDTreeNode<T> p = toRemove.getParent();
            if (p != null) {
                if (p.getChildren()[0] == toRemove) {
                    p.getChildren()[0] = null;
                } else if (p.getChildren()[1] == toRemove) {
                    p.getChildren()[1] = null;
                }
            } else {
                toRemove.setItem(null);
            }
        } else {
            List stack = new ArrayList();
            boolean branch = false;
            if (toRemove.getChildren()[0] != null) {
                KDTreeNode<T> kDTreeNode = toRemove.getChildren()[0];
                Intrinsics.checkNotNull(kDTreeNode);
                stack.add(kDTreeNode);
                branch = false;
            } else {
                KDTreeNode<T> kDTreeNode = toRemove.getChildren()[1];
                Intrinsics.checkNotNull(kDTreeNode);
                stack.add(kDTreeNode);
                branch = true;
            }
            double minValue = Double.POSITIVE_INFINITY;
            double maxValue = Double.NEGATIVE_INFINITY;
            KDTreeNode minArg = null;
            KDTreeNode maxArg = null;
            while (!stack.isEmpty()) {
                KDTreeNode node = (KDTreeNode)CollectionsKt.removeLast(stack);
                Object t = node.getItem();
                if (t == null) {
                    throw new IllegalStateException("item is null".toString());
                }
                double value = ((Number)mapper.invoke(t, toRemove.getDimension())).doubleValue();
                if (value < minValue) {
                    minValue = value;
                    minArg = node;
                }
                if (value > maxValue) {
                    maxValue = value;
                    maxArg = node;
                }
                if (node.getDimension() != toRemove.getDimension()) {
                    if (node.getChildren()[0] != null) {
                        KDTreeNode kDTreeNode = node.getChildren()[0];
                        Intrinsics.checkNotNull(kDTreeNode);
                        stack.add(kDTreeNode);
                    }
                    if (node.getChildren()[1] == null) continue;
                    KDTreeNode kDTreeNode = node.getChildren()[1];
                    Intrinsics.checkNotNull(kDTreeNode);
                    stack.add(kDTreeNode);
                    continue;
                }
                if (branch) {
                    if (node.getChildren()[0] != null) {
                        KDTreeNode kDTreeNode = node.getChildren()[0];
                        Intrinsics.checkNotNull(kDTreeNode);
                        stack.add(kDTreeNode);
                    } else if (node.getChildren()[1] != null) {
                        KDTreeNode kDTreeNode = node.getChildren()[1];
                        Intrinsics.checkNotNull(kDTreeNode);
                        stack.add(kDTreeNode);
                    }
                }
                if (branch) continue;
                if (node.getChildren()[1] != null) {
                    KDTreeNode kDTreeNode = node.getChildren()[1];
                    Intrinsics.checkNotNull(kDTreeNode);
                    stack.add(kDTreeNode);
                    continue;
                }
                if (node.getChildren()[0] == null) continue;
                KDTreeNode kDTreeNode = node.getChildren()[0];
                Intrinsics.checkNotNull(kDTreeNode);
                stack.add(kDTreeNode);
            }
            if (branch) {
                KDTreeNode kDTreeNode = minArg;
                toRemove.setItem(kDTreeNode != null ? kDTreeNode.getItem() : null);
                KDTreeNode kDTreeNode2 = minArg;
                if (kDTreeNode2 == null || (kDTreeNode2 = kDTreeNode2.getItem()) == null) {
                    throw new IllegalStateException("minArg is null");
                }
                toRemove.setMedian(((Number)mapper.invoke(kDTreeNode2, toRemove.getDimension())).doubleValue());
                KDTreeKt.remove(minArg, mapper);
            }
            if (!branch) {
                KDTreeNode kDTreeNode = maxArg;
                toRemove.setItem(kDTreeNode != null ? kDTreeNode.getItem() : null);
                KDTreeNode kDTreeNode3 = maxArg;
                if (kDTreeNode3 == null || (kDTreeNode3 = kDTreeNode3.getItem()) == null) {
                    throw new IllegalStateException("maxArg is null");
                }
                toRemove.setMedian(((Number)mapper.invoke(kDTreeNode3, toRemove.getDimension())).doubleValue());
                KDTreeKt.remove(maxArg, mapper);
            }
        }
        return null;
    }

    private static final int findKNearest$lambda$0(Pair nodeA, Pair nodeB) {
        return ComparisonsKt.compareValues((Comparable)nodeB.getSecond(), (Comparable)nodeA.getSecond());
    }

    private static final <T> void findKNearest$nearest(T $query, boolean $includeQuery, PriorityQueue<Pair<KDTreeNode<T>, Double>> queue, int $k, KDTreeNode<T> node) {
        if (node != null) {
            int n;
            double dimensionValue = ((Number)node.getMapper().invoke($query, node.getDimension())).doubleValue();
            if (dimensionValue < node.getMedian()) {
                KDTreeKt.findKNearest$nearest($query, $includeQuery, queue, $k, node.getChildren()[0]);
                n = 0;
            } else {
                KDTreeKt.findKNearest$nearest($query, $includeQuery, queue, $k, node.getChildren()[1]);
                n = 1;
            }
            int route = n;
            T t = node.getItem();
            if (t == null) {
                throw new IllegalStateException("item is null".toString());
            }
            double distance = KDTreeKt.sqrDistance($query, t, node.getDimensions(), node.getMapper());
            if (($includeQuery || node.getItem() != $query) && (queue.size() < $k || distance < ((Number)queue.peek().getSecond()).doubleValue())) {
                queue.add(new Pair<KDTreeNode<T>, Double>(node, distance));
                if (queue.size() > $k) {
                    queue.poll();
                }
            }
            double d = Math.abs(node.getMedian() - dimensionValue);
            if (queue.size() < $k || d * d < ((Number)queue.peek().getSecond()).doubleValue()) {
                KDTreeKt.findKNearest$nearest($query, $includeQuery, queue, $k, node.getChildren()[1 - route]);
            }
        }
    }

    private static final Pair findKNearest$lambda$1(PriorityQueue $queue) {
        return (Pair)$queue.poll();
    }

    private static final Object findKNearest$lambda$2(Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ((KDTreeNode)it.getFirst()).getItem();
    }

    private static final <T> void findNearest$nearest$3(KDTreeNode<T> $root, T $query, Ref.DoubleRef nearest, boolean $includeQuery, Ref.ObjectRef<KDTreeNode<T>> nearestArg, KDTreeNode<T> node) {
        if (node != null) {
            double d;
            int n;
            if (((Number)$root.getMapper().invoke($query, node.getDimension())).doubleValue() < node.getMedian()) {
                KDTreeKt.findNearest$nearest$3($root, $query, nearest, $includeQuery, nearestArg, node.getChildren()[0]);
                n = 0;
            } else {
                KDTreeKt.findNearest$nearest$3($root, $query, nearest, $includeQuery, nearestArg, node.getChildren()[1]);
                n = 1;
            }
            int route = n;
            T t = node.getItem();
            if (t == null) {
                throw new IllegalStateException("item is null".toString());
            }
            double distance = KDTreeKt.sqrDistance($query, t, $root.getDimensions(), $root.getMapper());
            if (distance < nearest.element && ($includeQuery || node.getItem() != $query)) {
                nearest.element = distance;
                nearestArg.element = node;
            }
            if ((d = Math.abs(node.getMedian() - ((Number)$root.getMapper().invoke($query, node.getDimension())).doubleValue())) * d < nearest.element) {
                KDTreeKt.findNearest$nearest$3($root, $query, nearest, $includeQuery, nearestArg, node.getChildren()[1 - route]);
            }
        }
    }

    public static final /* synthetic */ KDTreeNode access$insert(KDTreeNode root, Object item, int dimensions, Function2 mapper) {
        return KDTreeKt.insert(root, item, dimensions, mapper);
    }

    public static final /* synthetic */ KDTreeNode access$remove(KDTreeNode toRemove, Function2 mapper) {
        return KDTreeKt.remove(toRemove, mapper);
    }

    public static final /* synthetic */ Object access$findNearest(KDTreeNode root, Object query, boolean includeQuery) {
        return KDTreeKt.findNearest(root, query, includeQuery);
    }

    public static final /* synthetic */ List access$findKNearest(KDTreeNode root, Object query, int k, boolean includeQuery) {
        return KDTreeKt.findKNearest(root, query, k, includeQuery);
    }

    public static final /* synthetic */ List access$findAllInRadius(KDTreeNode root, Object query, double radius, boolean includeQuery) {
        return KDTreeKt.findAllInRadius(root, query, radius, includeQuery);
    }
}

