/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.mesh;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferKt;
import org.openrndr.draw.VertexElementType;
import org.openrndr.draw.VertexFormat;
import org.openrndr.draw.VertexFormatKt;
import org.openrndr.extra.mesh.IIndexedPolygon;
import org.openrndr.extra.mesh.IMeshData;
import org.openrndr.extra.mesh.IPolygon;
import org.openrndr.extra.mesh.IndexedPolygon;
import org.openrndr.extra.mesh.IndexedPolygonExtensionsKt;
import org.openrndr.extra.mesh.MeshData;
import org.openrndr.extra.mesh.VertexData;
import org.openrndr.math.IntVector2;
import org.openrndr.math.IntVector3;
import org.openrndr.math.IntVector4;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.shape.Box;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u001a \u0010\t\u001a\u00020\n*\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\n\u001aD\u0010\u000e\u001a\u00020\u000f*\u00020\b2\u0006\u0010\u0010\u001a\u00020\f2\b\b\u0002\u0010\u0011\u001a\u00020\f2\b\b\u0002\u0010\u0012\u001a\u00020\f2\b\b\u0002\u0010\u0013\u001a\u00020\f2\b\b\u0002\u0010\u0014\u001a\u00020\f2\b\b\u0002\u0010\u0015\u001a\u00020\f\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0015\u0010\u0016\u001a\u00020\u0017*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"objVertexFormat", "Lorg/openrndr/draw/VertexFormat;", "getObjVertexFormat", "()Lorg/openrndr/draw/VertexFormat;", "objVertexFormatTangents", "getObjVertexFormatTangents", "isTriangular", "", "Lorg/openrndr/extra/mesh/IMeshData;", "toVertexBuffer", "Lorg/openrndr/draw/VertexBuffer;", "elementOffset", "", "vertexBuffer", "weld", "Lorg/openrndr/extra/mesh/MeshData;", "positionFractBits", "textureCoordFractBits", "colorFractBits", "normalFractBits", "tangentFractBits", "bitangentFractBits", "bounds", "Lorg/openrndr/shape/Box;", "getBounds", "(Lorg/openrndr/extra/mesh/IMeshData;)Lorg/openrndr/shape/Box;", "orx-mesh"})
@SourceDebugExtension(value={"SMAP\nMeshDataExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MeshDataExtensions.kt\norg/openrndr/extra/mesh/MeshDataExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,287:1\n1734#2,3:288\n1557#2:291\n1628#2,3:292\n1557#2:295\n1628#2,3:296\n1557#2:299\n1628#2,3:300\n1557#2:303\n1628#2,3:304\n1557#2:307\n1628#2,3:308\n1557#2:311\n1628#2,3:312\n1202#2,2:315\n1230#2,4:317\n1202#2,2:321\n1230#2,4:323\n1202#2,2:327\n1230#2,4:329\n1202#2,2:333\n1230#2,4:335\n1202#2,2:339\n1230#2,4:341\n1202#2,2:345\n1230#2,4:347\n1557#2:351\n1628#2,3:352\n1557#2:355\n1628#2,3:356\n1557#2:359\n1628#2,3:360\n1557#2:363\n1628#2,3:364\n1557#2:367\n1628#2,3:368\n1557#2:371\n1628#2,3:372\n1863#2,2:375\n381#3,7:377\n381#3,7:384\n381#3,7:391\n*S KotlinDebug\n*F\n+ 1 MeshDataExtensions.kt\norg/openrndr/extra/mesh/MeshDataExtensionsKt\n*L\n59#1:288,3\n194#1:291\n194#1:292,3\n201#1:295\n201#1:296,3\n207#1:299\n207#1:300,3\n213#1:303\n213#1:304,3\n219#1:307\n219#1:308,3\n225#1:311\n225#1:312,3\n233#1:315,2\n233#1:317,4\n235#1:321,2\n235#1:323,4\n236#1:327,2\n236#1:329,4\n237#1:333,2\n237#1:335,4\n238#1:339,2\n238#1:341,4\n239#1:345,2\n239#1:347,4\n243#1:351\n243#1:352,3\n248#1:355\n248#1:356,3\n253#1:359\n253#1:360,3\n258#1:363\n258#1:364,3\n263#1:367\n263#1:368,3\n268#1:371\n268#1:372,3\n85#1:375,2\n139#1:377,7\n142#1:384,7\n145#1:391,7\n*E\n"})
public final class MeshDataExtensionsKt {
    @NotNull
    private static final VertexFormat objVertexFormat = VertexFormatKt.vertexFormat$default(null, MeshDataExtensionsKt::objVertexFormat$lambda$0, 1, null);
    @NotNull
    private static final VertexFormat objVertexFormatTangents = VertexFormatKt.vertexFormat$default(null, MeshDataExtensionsKt::objVertexFormatTangents$lambda$1, 1, null);

    @NotNull
    public static final VertexFormat getObjVertexFormat() {
        return objVertexFormat;
    }

    @NotNull
    public static final VertexFormat getObjVertexFormatTangents() {
        return objVertexFormatTangents;
    }

    public static final boolean isTriangular(@NotNull IMeshData $this$isTriangular) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$isTriangular, "<this>");
            Iterable $this$all$iv = $this$isTriangular.getPolygons();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    IIndexedPolygon it = (IIndexedPolygon)element$iv;
                    boolean bl2 = false;
                    if (it.getPositions().size() == 3) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public static final VertexBuffer toVertexBuffer(@NotNull IMeshData $this$toVertexBuffer, int elementOffset, @Nullable VertexBuffer vertexBuffer) {
        VertexFormat format;
        Intrinsics.checkNotNullParameter($this$toVertexBuffer, "<this>");
        List<IPolygon> objects = $this$toVertexBuffer.triangulate().toPolygons();
        int triangleCount = objects.size();
        VertexFormat vertexFormat = format = !((Collection)$this$toVertexBuffer.getVertexData().getTangents()).isEmpty() && !((Collection)$this$toVertexBuffer.getVertexData().getBitangents()).isEmpty() ? objVertexFormatTangents : objVertexFormat;
        VertexBuffer vertexBuffer2 = vertexBuffer;
        if (vertexBuffer2 == null) {
            vertexBuffer2 = VertexBufferKt.vertexBuffer$default(format, triangleCount * 3, null, 4, null);
        }
        VertexBuffer vertexBuffer3 = vertexBuffer2;
        vertexBuffer3.put(elementOffset, arg_0 -> MeshDataExtensionsKt.toVertexBuffer$lambda$4(objects, format, arg_0));
        vertexBuffer3.getShadow().destroy();
        return vertexBuffer3;
    }

    public static /* synthetic */ VertexBuffer toVertexBuffer$default(IMeshData iMeshData, int n, VertexBuffer vertexBuffer, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            vertexBuffer = null;
        }
        return MeshDataExtensionsKt.toVertexBuffer(iMeshData, n, vertexBuffer);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MeshData weld(@NotNull IMeshData $this$weld, int positionFractBits, int textureCoordFractBits, int colorFractBits, int normalFractBits, int tangentFractBits, int bitangentFractBits) {
        Collection<Vector3> collection;
        List list;
        Collection<Vector3> collection2;
        Collection collection3;
        Collection<Vector3> collection4;
        Collection collection5;
        Collection<ColorRGBa> collection6;
        Collection collection7;
        Collection<Vector2> collection8;
        Collection collection9;
        Collection<Vector3> collection10;
        Iterator iterator2;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        boolean $i$f$map;
        Iterable $this$associateByTo$iv$iv;
        void $this$associateByTo$iv$iv2;
        void $this$associateByTo$iv$iv3;
        void $this$associateByTo$iv$iv4;
        void $this$associateByTo$iv$iv5;
        void $this$associateByTo$iv$iv6;
        List colors;
        Object object;
        Intrinsics.checkNotNullParameter($this$weld, "<this>");
        Map positionMap = new LinkedHashMap();
        Map textureCoordMap = new LinkedHashMap();
        Map colorMap = new LinkedHashMap();
        Map normalMap = new LinkedHashMap();
        Map tangentMap = new LinkedHashMap();
        Map bitangentMap = new LinkedHashMap();
        if (positionFractBits >= 0) {
            for (Vector3 vector3 : $this$weld.getVertexData().getPositions()) {
                MeshDataExtensionsKt.weld$quantize(positionMap, vector3, positionFractBits);
            }
        }
        if (textureCoordFractBits >= 0) {
            for (Vector2 vector2 : $this$weld.getVertexData().getTextureCoords()) {
                MeshDataExtensionsKt.weld$quantize$7(textureCoordMap, vector2, textureCoordFractBits);
            }
        }
        if (colorFractBits >= 0) {
            for (ColorRGBa colorRGBa : $this$weld.getVertexData().getColors()) {
                MeshDataExtensionsKt.weld$quantize$9(colorMap, colorRGBa.toVector4(), colorFractBits);
            }
        }
        if (normalFractBits >= 0) {
            for (Vector3 vector3 : $this$weld.getVertexData().getNormals()) {
                MeshDataExtensionsKt.weld$quantize(normalMap, vector3, normalFractBits);
            }
        }
        if (tangentFractBits >= 0) {
            for (Vector3 vector3 : $this$weld.getVertexData().getTangents()) {
                MeshDataExtensionsKt.weld$quantize(tangentMap, vector3, tangentFractBits);
            }
        }
        if (bitangentFractBits >= 0) {
            for (Vector3 vector3 : $this$weld.getVertexData().getBitangents()) {
                MeshDataExtensionsKt.weld$quantize(bitangentMap, vector3, bitangentFractBits);
            }
        }
        List reindexedPolygons = new ArrayList();
        for (IIndexedPolygon polygon : $this$weld.getPolygons()) {
            List list2;
            List tangents;
            List normals;
            List textureCoords;
            List positions;
            Collection destination$iv$iv2;
            if (positionFractBits >= 0) {
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv = CollectionsKt.slice($this$weld.getVertexData().getPositions(), (Iterable<Integer>)polygon.getPositions());
                boolean $i$f$map2 = false;
                Iterable iterable = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    Vector3 vector3 = (Vector3)item$iv$iv;
                    object = destination$iv$iv2;
                    boolean bl = false;
                    object.add(MeshDataExtensionsKt.weld$quantize(positionMap, (Vector3)it, positionFractBits));
                }
                v0 = (List)destination$iv$iv2;
            } else {
                v0 = positions = polygon.getPositions();
            }
            if (textureCoordFractBits >= 0) {
                void $this$mapTo$iv$iv3;
                void $this$map$iv;
                Object item$iv$iv;
                Iterable $i$f$map2 = CollectionsKt.slice($this$weld.getVertexData().getTextureCoords(), (Iterable<Integer>)polygon.getTextureCoords());
                boolean $i$f$map3 = false;
                destination$iv$iv2 = $this$map$iv;
                Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo3 = false;
                item$iv$iv = $this$mapTo$iv$iv3.iterator();
                while (item$iv$iv.hasNext()) {
                    void it;
                    Iterator<Object> item$iv$iv2 = item$iv$iv.next();
                    Vector2 bl = (Vector2)((Object)item$iv$iv2);
                    object = destination$iv$iv22;
                    boolean bl2 = false;
                    object.add(MeshDataExtensionsKt.weld$quantize$7(textureCoordMap, (Vector2)it, textureCoordFractBits));
                }
                v1 = (List)destination$iv$iv22;
            } else {
                v1 = textureCoords = polygon.getTextureCoords();
            }
            if (colorFractBits >= 0) {
                void $this$mapTo$iv$iv4;
                Iterable $this$map$iv = CollectionsKt.slice($this$weld.getVertexData().getColors(), (Iterable<Integer>)polygon.getColors());
                boolean $i$f$map4 = false;
                Iterable destination$iv$iv22 = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo4 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv4) {
                    void it;
                    ColorRGBa bl2 = (ColorRGBa)item$iv$iv;
                    object = destination$iv$iv3;
                    boolean bl = false;
                    object.add(MeshDataExtensionsKt.weld$quantize$9(colorMap, it.toVector4(), colorFractBits));
                }
                v2 = (List)destination$iv$iv3;
            } else {
                v2 = colors = polygon.getColors();
            }
            if (normalFractBits >= 0) {
                void $this$mapTo$iv$iv5;
                Iterable $this$map$iv = CollectionsKt.slice($this$weld.getVertexData().getNormals(), (Iterable<Integer>)polygon.getNormals());
                boolean $i$f$map5 = false;
                Iterable destination$iv$iv3 = $this$map$iv;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo5 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv5) {
                    void it;
                    Vector3 bl = (Vector3)item$iv$iv;
                    object = destination$iv$iv4;
                    boolean bl3 = false;
                    object.add(MeshDataExtensionsKt.weld$quantize(normalMap, (Vector3)it, normalFractBits));
                }
                v3 = (List)destination$iv$iv4;
            } else {
                v3 = normals = polygon.getNormals();
            }
            if (tangentFractBits >= 0) {
                void $this$mapTo$iv$iv6;
                Iterable $this$map$iv = CollectionsKt.slice($this$weld.getVertexData().getTangents(), (Iterable<Integer>)polygon.getTangents());
                boolean $i$f$map6 = false;
                Iterable destination$iv$iv4 = $this$map$iv;
                Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo6 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv6) {
                    void it;
                    Vector3 bl3 = (Vector3)item$iv$iv;
                    object = destination$iv$iv5;
                    boolean bl = false;
                    object.add(MeshDataExtensionsKt.weld$quantize(tangentMap, (Vector3)it, tangentFractBits));
                }
                v4 = (List)destination$iv$iv5;
            } else {
                v4 = tangents = polygon.getTangents();
            }
            if (bitangentFractBits >= 0) {
                void $this$mapTo$iv$iv7;
                Iterable $this$map$iv = CollectionsKt.slice($this$weld.getVertexData().getBitangents(), (Iterable<Integer>)polygon.getBitangents());
                boolean $i$f$map7 = false;
                Iterable destination$iv$iv5 = $this$map$iv;
                Collection destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo7 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv7) {
                    void it;
                    Vector3 bl = (Vector3)item$iv$iv;
                    object = destination$iv$iv6;
                    boolean bl4 = false;
                    object.add(MeshDataExtensionsKt.weld$quantize(bitangentMap, (Vector3)it, bitangentFractBits));
                }
                list2 = (List)destination$iv$iv6;
            } else {
                list2 = polygon.getBitangents();
            }
            List bitangents = list2;
            reindexedPolygons.add(new IndexedPolygon(positions, textureCoords, colors, normals, tangents, bitangents));
        }
        List $this$associateBy$iv = $this$weld.getVertexData().getPositions();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        colors = $this$associateBy$iv;
        Object destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv6) {
            void it;
            Vector3 $i$f$map7 = (Vector3)element$iv$iv;
            object = destination$iv$iv3;
            boolean bl = false;
            object.put(MeshDataExtensionsKt.weld$quantize(positionMap, (Vector3)it, positionFractBits), element$iv$iv);
        }
        Map map2 = destination$iv$iv3;
        Iterable $this$associateBy$iv2 = $this$weld.getVertexData().getTextureCoords();
        boolean $i$f$associateBy2 = false;
        int capacity$iv2 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv2, 10)), 16);
        destination$iv$iv3 = $this$associateBy$iv2;
        Object destination$iv$iv7 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv5) {
            void it;
            Vector2 bl = (Vector2)element$iv$iv;
            object = destination$iv$iv7;
            boolean bl5 = false;
            object.put(MeshDataExtensionsKt.weld$quantize$7(textureCoordMap, (Vector2)it, textureCoordFractBits), element$iv$iv);
        }
        Map textureCoordByIndex = destination$iv$iv7;
        Iterable $this$associateBy$iv3 = $this$weld.getVertexData().getColors();
        boolean $i$f$associateBy3 = false;
        int capacity$iv3 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv3, 10)), 16);
        destination$iv$iv7 = $this$associateBy$iv3;
        Object destination$iv$iv8 = new LinkedHashMap(capacity$iv3);
        boolean $i$f$associateByTo3 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv4) {
            void it;
            ColorRGBa bl5 = (ColorRGBa)element$iv$iv;
            object = destination$iv$iv8;
            boolean bl = false;
            object.put(MeshDataExtensionsKt.weld$quantize$9(colorMap, it.toVector4(), colorFractBits), element$iv$iv);
        }
        Map colorByIndex = destination$iv$iv8;
        Iterable $this$associateBy$iv4 = $this$weld.getVertexData().getNormals();
        boolean $i$f$associateBy4 = false;
        int capacity$iv4 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv4, 10)), 16);
        destination$iv$iv8 = $this$associateBy$iv4;
        Object destination$iv$iv9 = new LinkedHashMap(capacity$iv4);
        boolean $i$f$associateByTo4 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv3) {
            void it;
            Vector3 bl = (Vector3)element$iv$iv;
            object = destination$iv$iv9;
            boolean bl6 = false;
            object.put(MeshDataExtensionsKt.weld$quantize(normalMap, (Vector3)it, normalFractBits), element$iv$iv);
        }
        Map normalByIndex = destination$iv$iv9;
        Iterable $this$associateBy$iv5 = $this$weld.getVertexData().getTangents();
        boolean $i$f$associateBy5 = false;
        int capacity$iv5 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv5, 10)), 16);
        destination$iv$iv9 = $this$associateBy$iv5;
        Object destination$iv$iv10 = new LinkedHashMap(capacity$iv5);
        boolean $i$f$associateByTo5 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
            void it;
            Vector3 bl6 = (Vector3)element$iv$iv;
            object = destination$iv$iv10;
            boolean bl = false;
            object.put(MeshDataExtensionsKt.weld$quantize(tangentMap, (Vector3)it, tangentFractBits), element$iv$iv);
        }
        Map tangentByIndex = destination$iv$iv10;
        Iterable $this$associateBy$iv6 = $this$weld.getVertexData().getBitangents();
        boolean $i$f$associateBy6 = false;
        int capacity$iv6 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv6, 10)), 16);
        destination$iv$iv10 = $this$associateBy$iv6;
        Map destination$iv$iv11 = new LinkedHashMap(capacity$iv6);
        boolean $i$f$associateByTo6 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Vector3 bl = (Vector3)element$iv$iv;
            object = destination$iv$iv11;
            boolean bl7 = false;
            object.put(MeshDataExtensionsKt.weld$quantize(bitangentMap, (Vector3)it, bitangentFractBits), element$iv$iv);
        }
        Map bitangentByIndex = destination$iv$iv11;
        if (positionFractBits >= 0) {
            Iterable $this$map$iv = RangesKt.until(0, map2.size());
            $i$f$map = false;
            $this$associateByTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                int item$iv$iv;
                int it = item$iv$iv = ((IntIterator)iterator2).nextInt();
                collection10 = destination$iv$iv;
                boolean bl = false;
                collection10.add((Vector3)MapsKt.getValue(map2, it));
            }
            collection9 = (List)destination$iv$iv;
        } else {
            collection9 = $this$weld.getVertexData().getPositions();
        }
        if (textureCoordFractBits >= 0) {
            Iterable $this$map$iv = RangesKt.until(0, textureCoordByIndex.size());
            collection10 = collection9;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                int item$iv$iv;
                int it = item$iv$iv = ((IntIterator)iterator2).nextInt();
                collection8 = destination$iv$iv;
                boolean bl = false;
                collection8.add((Vector2)MapsKt.getValue(textureCoordByIndex, it));
            }
            collection7 = (List)destination$iv$iv;
            collection9 = collection10;
        } else {
            collection7 = $this$weld.getVertexData().getTextureCoords();
        }
        if (colorFractBits >= 0) {
            Iterable $this$map$iv = RangesKt.until(0, colorByIndex.size());
            collection8 = collection7;
            collection10 = collection9;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                int item$iv$iv;
                int it = item$iv$iv = ((IntIterator)iterator2).nextInt();
                collection6 = destination$iv$iv;
                boolean bl = false;
                collection6.add((ColorRGBa)MapsKt.getValue(colorByIndex, it));
            }
            collection6 = (List)destination$iv$iv;
            collection9 = collection10;
            collection7 = collection8;
            collection5 = collection6;
        } else {
            collection5 = $this$weld.getVertexData().getColors();
        }
        if (normalFractBits >= 0) {
            Iterable $this$map$iv = RangesKt.until(0, normalByIndex.size());
            collection6 = collection5;
            collection8 = collection7;
            collection10 = collection9;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                int item$iv$iv;
                int it = item$iv$iv = ((IntIterator)iterator2).nextInt();
                collection4 = destination$iv$iv;
                boolean bl = false;
                collection4.add((Vector3)MapsKt.getValue(normalByIndex, it));
            }
            collection4 = (List)destination$iv$iv;
            collection9 = collection10;
            collection7 = collection8;
            collection5 = collection6;
            collection3 = collection4;
        } else {
            collection3 = $this$weld.getVertexData().getNormals();
        }
        if (tangentFractBits >= 0) {
            Iterable $this$map$iv = RangesKt.until(0, tangentByIndex.size());
            collection4 = collection3;
            collection6 = collection5;
            collection8 = collection7;
            collection10 = collection9;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                int item$iv$iv;
                int it = item$iv$iv = ((IntIterator)iterator2).nextInt();
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add((Vector3)MapsKt.getValue(tangentByIndex, it));
            }
            collection2 = (List)destination$iv$iv;
            collection9 = collection10;
            collection7 = collection8;
            collection5 = collection6;
            collection3 = collection4;
            list = collection2;
        } else {
            list = $this$weld.getVertexData().getTangents();
        }
        if (bitangentFractBits >= 0) {
            Collection<Vector3> collection11;
            Iterable $this$map$iv = RangesKt.until(0, bitangentByIndex.size());
            collection2 = list;
            collection4 = collection3;
            collection6 = collection5;
            collection8 = collection7;
            collection10 = collection9;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                int item$iv$iv;
                int it = item$iv$iv = ((IntIterator)iterator2).nextInt();
                collection11 = destination$iv$iv;
                boolean bl = false;
                collection11.add((Vector3)MapsKt.getValue(bitangentByIndex, it));
            }
            collection11 = (List)destination$iv$iv;
            collection9 = collection10;
            collection7 = collection8;
            collection5 = collection6;
            collection3 = collection4;
            list = collection2;
            collection = collection11;
        } else {
            collection = $this$weld.getVertexData().getBitangents();
        }
        Collection<Vector3> collection12 = collection;
        List list3 = list;
        List list4 = collection3;
        List list5 = collection5;
        List list6 = collection7;
        List list7 = collection9;
        VertexData reindexedVertexData = new VertexData(list7, list6, list5, list4, list3, (List<Vector3>)collection12);
        return new MeshData(reindexedVertexData, reindexedPolygons);
    }

    public static /* synthetic */ MeshData weld$default(IMeshData iMeshData, int n, int n2, int n3, int n4, int n5, int n6, int n7, Object object) {
        if ((n7 & 2) != 0) {
            n2 = -1;
        }
        if ((n7 & 4) != 0) {
            n3 = -1;
        }
        if ((n7 & 8) != 0) {
            n4 = -1;
        }
        if ((n7 & 0x10) != 0) {
            n5 = -1;
        }
        if ((n7 & 0x20) != 0) {
            n6 = -1;
        }
        return MeshDataExtensionsKt.weld(iMeshData, n, n2, n3, n4, n5, n6);
    }

    @NotNull
    public static final Box getBounds(@NotNull IMeshData $this$bounds) {
        Intrinsics.checkNotNullParameter($this$bounds, "<this>");
        return IndexedPolygonExtensionsKt.bounds($this$bounds.getPolygons(), $this$bounds.getVertexData());
    }

    private static final Unit objVertexFormat$lambda$0(VertexFormat $this$vertexFormat) {
        Intrinsics.checkNotNullParameter($this$vertexFormat, "$this$vertexFormat");
        $this$vertexFormat.position(3);
        $this$vertexFormat.normal(3);
        VertexFormat.textureCoordinate$default($this$vertexFormat, 2, 0, 2, null);
        $this$vertexFormat.color(4);
        return Unit.INSTANCE;
    }

    private static final Unit objVertexFormatTangents$lambda$1(VertexFormat $this$vertexFormat) {
        Intrinsics.checkNotNullParameter($this$vertexFormat, "$this$vertexFormat");
        $this$vertexFormat.position(3);
        $this$vertexFormat.normal(3);
        VertexFormat.textureCoordinate$default($this$vertexFormat, 2, 0, 2, null);
        $this$vertexFormat.color(4);
        VertexFormat.attribute$default($this$vertexFormat, "tangent", VertexElementType.VECTOR3_FLOAT32, 0, 4, null);
        VertexFormat.attribute$default($this$vertexFormat, "bitangent", VertexElementType.VECTOR3_FLOAT32, 0, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit toVertexBuffer$lambda$4(List $objects, VertexFormat $format, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        Iterable $this$forEach$iv = $objects;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IPolygon it = (IPolygon)element$iv;
            boolean bl = false;
            int n = ((Collection)it.getPositions()).size();
            for (int i = 0; i < n; ++i) {
                $this$put.write(it.getPositions().get(i));
                if (!((Collection)it.getNormals()).isEmpty()) {
                    $this$put.write(it.getNormals().get(i));
                } else {
                    Vector3 d0 = it.getPositions().get(2).minus(it.getPositions().get(0));
                    Vector3 d1 = it.getPositions().get(1).minus(it.getPositions().get(0));
                    $this$put.write((Vector3)((Vector3)d0.getNormalized()).cross((Vector3)d1.getNormalized()).getNormalized());
                }
                if (!((Collection)it.getTextureCoords()).isEmpty()) {
                    $this$put.write(it.getTextureCoords().get(i));
                } else {
                    $this$put.write(Vector2.Companion.getZERO());
                }
                if (!((Collection)it.getColors()).isEmpty()) {
                    $this$put.write(it.getColors().get(i));
                } else {
                    $this$put.write(ColorRGBa.Companion.getWHITE());
                }
                if (!Intrinsics.areEqual($format, objVertexFormatTangents)) continue;
                $this$put.write(it.getTangents().get(i));
                $this$put.write(it.getBitangents().get(i));
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final int weld$quantize(Map<IntVector3, Integer> $this$weld_u24quantize, Vector3 v, int bits) {
        Object object;
        void $this$getOrPut$iv;
        Map<IntVector3, Integer> map2 = $this$weld_u24quantize;
        IntVector3 key$iv = v.times(1 << bits).toInt();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Integer answer$iv = $this$weld_u24quantize.size();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((Number)object).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private static final int weld$quantize$7(Map<IntVector2, Integer> $this$weld_u24quantize_u247, Vector2 v, int bits) {
        Object object;
        void $this$getOrPut$iv;
        Map<IntVector2, Integer> map2 = $this$weld_u24quantize_u247;
        IntVector2 key$iv = v.times(1 << bits).toInt();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Integer answer$iv = $this$weld_u24quantize_u247.size();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((Number)object).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private static final int weld$quantize$9(Map<IntVector4, Integer> $this$weld_u24quantize_u249, Vector4 v, int bits) {
        Object object;
        void $this$getOrPut$iv;
        Map<IntVector4, Integer> map2 = $this$weld_u24quantize_u249;
        IntVector4 key$iv = v.times(1 << bits).toInt();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Integer answer$iv = $this$weld_u24quantize_u249.size();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((Number)object).intValue();
    }
}

