/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.svg;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openrndr.extra.composition.CompositionStyleSheetKt;
import org.openrndr.extra.svg.Prop;
import org.openrndr.extra.svg.SVGElement;
import org.openrndr.extra.svg.SVGImage;
import org.openrndr.extra.svg.SVGParse;
import org.openrndr.extra.svg.SVGPath;
import org.openrndr.extra.svg.Tag;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/openrndr/extra/svg/SVGGroup;", "Lorg/openrndr/extra/svg/SVGElement;", "element", "Lorg/jsoup/nodes/Element;", "elements", "", "<init>", "(Lorg/jsoup/nodes/Element;Ljava/util/List;)V", "getElement", "()Lorg/jsoup/nodes/Element;", "getElements", "()Ljava/util/List;", "handleChildren", "", "handleAttribute", "attribute", "Lorg/jsoup/nodes/Attribute;", "orx-svg"})
@SourceDebugExtension(value={"SMAP\nSVGElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SVGElement.kt\norg/openrndr/extra/svg/SVGGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,482:1\n1863#2,2:483\n1863#2,2:485\n*S KotlinDebug\n*F\n+ 1 SVGElement.kt\norg/openrndr/extra/svg/SVGGroup\n*L\n65#1:483,2\n77#1:485,2\n*E\n"})
public class SVGGroup
extends SVGElement {
    @NotNull
    private final Element element;
    @NotNull
    private final List<SVGElement> elements;

    public SVGGroup(@NotNull Element element, @NotNull List<SVGElement> elements) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(elements, "elements");
        super(element, null);
        this.element = element;
        this.elements = elements;
        Attributes attributes = this.element.attributes();
        Intrinsics.checkNotNullExpressionValue(attributes, "attributes(...)");
        Iterable $this$forEach$iv = attributes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Attribute it = (Attribute)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it.getKey(), "style")) {
                Intrinsics.checkNotNull(it);
                this.inlineStyles(it);
                continue;
            }
            Intrinsics.checkNotNull(it);
            this.handleAttribute(it);
        }
        this.handleChildren();
    }

    public /* synthetic */ SVGGroup(Element element, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = new ArrayList();
        }
        this(element, list);
    }

    @NotNull
    public final Element getElement() {
        return this.element;
    }

    @NotNull
    public final List<SVGElement> getElements() {
        return this.elements;
    }

    private final void handleChildren() {
        Elements elements = this.element.children();
        Intrinsics.checkNotNullExpressionValue(elements, "children(...)");
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            Element child = (Element)element$iv;
            boolean bl2 = false;
            String string = child.tagName();
            if (Intrinsics.areEqual(string, "image")) {
                bl = this.elements.add(new SVGImage(child));
                continue;
            }
            if (Tag.INSTANCE.getGraphicsList().contains(string)) {
                bl = this.elements.add(new SVGPath(child));
                continue;
            }
            Intrinsics.checkNotNull(child);
            bl = this.elements.add(new SVGGroup(child, null, 2, null));
        }
    }

    @Override
    public void handleAttribute(@NotNull Attribute attribute) {
        Intrinsics.checkNotNullParameter(attribute, "attribute");
        String string = attribute.getKey();
        if (Prop.INSTANCE.getList().contains(string)) {
            String string2 = attribute.getKey();
            Intrinsics.checkNotNullExpressionValue(string2, "<get-key>(...)");
            String string3 = attribute.getValue();
            Intrinsics.checkNotNullExpressionValue(string3, "<get-value>(...)");
            this.styleProperty(string2, string3);
        } else if (Intrinsics.areEqual(string, "transform")) {
            CompositionStyleSheetKt.setTransform(this.getStyle(), SVGParse.INSTANCE.transform(this.element));
        }
    }
}

