/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.svg;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.composition.Composition;
import org.openrndr.extra.svg.SVGDocument;
import org.openrndr.extra.svg.SVGLoader;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0003\u00a8\u0006\b"}, d2={"loadSVG", "Lorg/openrndr/extra/composition/Composition;", "fileOrUrlOrSvg", "", "file", "Ljava/io/File;", "parseSVG", "svgString", "orx-svg"})
public final class SVGLoaderKt {
    @NotNull
    public static final Composition loadSVG(@NotNull String fileOrUrlOrSvg) {
        Composition composition;
        Intrinsics.checkNotNullParameter(fileOrUrlOrSvg, "fileOrUrlOrSvg");
        if (StringsKt.endsWith$default(fileOrUrlOrSvg, ".svg", false, 2, null)) {
            Composition composition2;
            try {
                URL url;
                URL uRL = url = new URL(fileOrUrlOrSvg);
                Charset charset = Charsets.UTF_8;
                byte[] byArray = TextStreamsKt.readBytes(uRL);
                composition2 = SVGLoaderKt.parseSVG(new String(byArray, charset));
            }
            catch (MalformedURLException e) {
                composition2 = SVGLoaderKt.parseSVG(FilesKt.readText$default(new File(fileOrUrlOrSvg), null, 1, null));
            }
            composition = composition2;
        } else {
            composition = SVGLoaderKt.parseSVG(fileOrUrlOrSvg);
        }
        return composition;
    }

    @NotNull
    public static final Composition loadSVG(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return SVGLoaderKt.parseSVG(FilesKt.readText$default(file, null, 1, null));
    }

    @NotNull
    public static final Composition parseSVG(@NotNull String svgString) {
        Intrinsics.checkNotNullParameter(svgString, "svgString");
        SVGDocument document = new SVGLoader().loadSVG(svgString);
        return document.composition();
    }
}

