/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ChannelMask;
import org.openrndr.draw.CullTestPass;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.DrawerConfiguration;
import org.openrndr.draw.Session;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.StencilOperation;
import org.openrndr.draw.StencilStyle;
import org.openrndr.draw.StencilTest;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferKt;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexElementType;
import org.openrndr.draw.VertexFormat;
import org.openrndr.draw.VertexFormatKt;
import org.openrndr.internal.Command;
import org.openrndr.internal.Driver;
import org.openrndr.internal.Expansion;
import org.openrndr.internal.ExpansionType;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.math.Vector4;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J.\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000f2\u0006\u0010\u001f\u001a\u00020\u001dH\u0002J.\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000f2\u0006\u0010\u001f\u001a\u00020\u001dH\u0002J.\u0010!\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J$\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000f2\u0006\u0010#\u001a\u00020\u000b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020%0\u000fH\u0002J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020'H\u0002J&\u0010-\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020\u001dJ,\u0010.\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010)\u001a\b\u0012\u0004\u0012\u00020%0\u000f2\u0006\u0010\u001f\u001a\u00020\u001dJ4\u0010/\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010)\u001a\b\u0012\u0004\u0012\u00020%0\u000f2\u0006\u00100\u001a\u0002012\u0006\u0010\u001f\u001a\u00020\u001dJ,\u00102\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010)\u001a\b\u0012\u0004\u0012\u00020%0\u000f2\u0006\u0010\u001f\u001a\u00020\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010*\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/openrndr/internal/ExpansionDrawer;", "", "<init>", "()V", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "vertexFormat", "Lorg/openrndr/draw/VertexFormat;", "getVertexFormat", "()Lorg/openrndr/draw/VertexFormat;", "manyVertices", "Lorg/openrndr/draw/VertexBuffer;", "getManyVertices", "()Lorg/openrndr/draw/VertexBuffer;", "fewVertices", "", "getFewVertices", "()Ljava/util/List;", "quads", "getQuads", "renderStrokeCommands", "", "drawContext", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "commands", "Lorg/openrndr/internal/Command;", "fringeWidth", "", "renderStrokeCommandsInterleaved", "fringeScale", "renderConvexFillCommands", "renderFillCommands", "toCommand", "vertices", "expansion", "Lorg/openrndr/internal/Expansion;", "vertexOffset", "", "toCommands", "expansions", "counter", "quadCounter", "count", "renderStroke", "renderStrokes", "renderFill", "convex", "", "renderFills", "openrndr-draw"})
@SourceDebugExtension(value={"SMAP\nExpansionDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpansionDrawer.kt\norg/openrndr/internal/ExpansionDrawer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,354:1\n1#2:355\n1863#3,2:356\n1863#3,2:358\n1863#3,2:360\n2341#3,14:362\n2341#3,14:376\n1971#3,14:390\n1971#3,14:404\n1863#3,2:418\n*S KotlinDebug\n*F\n+ 1 ExpansionDrawer.kt\norg/openrndr/internal/ExpansionDrawer\n*L\n51#1:356,2\n137#1:358,2\n142#1:360,2\n169#1:362,14\n170#1:376,14\n171#1:390,14\n172#1:404,14\n279#1:418,2\n*E\n"})
public final class ExpansionDrawer {
    @NotNull
    private final ShadeStyleManager shaderManager = ShadeStyleManager.Companion.fromGenerators$default(ShadeStyleManager.Companion, "expansion", new Function1<ShadeStructure, String>((Object)Driver.Companion.getInstance().getShaderGenerators()){

        public final String invoke(ShadeStructure p0) {
            Intrinsics.checkNotNullParameter(p0, "p0");
            return ((ShaderGenerators)this.receiver).expansionVertexShader(p0);
        }
    }, null, null, null, new Function1<ShadeStructure, String>((Object)Driver.Companion.getInstance().getShaderGenerators()){

        public final String invoke(ShadeStructure p0) {
            Intrinsics.checkNotNullParameter(p0, "p0");
            return ((ShaderGenerators)this.receiver).expansionFragmentShader(p0);
        }
    }, 28, null);
    @NotNull
    private final VertexFormat vertexFormat = VertexFormatKt.vertexFormat$default(null, ExpansionDrawer::vertexFormat$lambda$0, 1, null);
    @NotNull
    private final VertexBuffer manyVertices = VertexBuffer.Companion.createDynamic(this.vertexFormat, 0x400000, Session.Companion.getRoot());
    @NotNull
    private final List<VertexBuffer> fewVertices;
    @NotNull
    private final List<VertexBuffer> quads;
    private int counter;
    private int quadCounter;

    public ExpansionDrawer() {
        ArrayList<VertexBuffer> arrayList;
        int n;
        int n2 = DrawerConfiguration.INSTANCE.getVertexBufferMultiBufferCount();
        ExpansionDrawer expansionDrawer = this;
        ArrayList<VertexBuffer> arrayList2 = new ArrayList<VertexBuffer>(n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n = n3++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(VertexBufferKt.vertexBuffer(this.vertexFormat, 512, Session.Companion.getRoot()));
        }
        expansionDrawer.fewVertices = arrayList2;
        n2 = DrawerConfiguration.INSTANCE.getVertexBufferMultiBufferCount();
        expansionDrawer = this;
        arrayList2 = new ArrayList(n2);
        n3 = 0;
        while (n3 < n2) {
            int it = n = n3++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(VertexBuffer.Companion.createDynamic(this.vertexFormat, 6, Session.Companion.getRoot()));
        }
        expansionDrawer.quads = arrayList2;
    }

    @NotNull
    public final VertexFormat getVertexFormat() {
        return this.vertexFormat;
    }

    @NotNull
    public final VertexBuffer getManyVertices() {
        return this.manyVertices;
    }

    @NotNull
    public final List<VertexBuffer> getFewVertices() {
        return this.fewVertices;
    }

    @NotNull
    public final List<VertexBuffer> getQuads() {
        return this.quads;
    }

    private final void renderStrokeCommands(DrawContext drawContext, DrawStyle drawStyle, List<Command> commands, double fringeWidth) {
        Shader shader = this.shaderManager.shader(drawStyle.getShadeStyle(), CollectionsKt.listOf(this.vertexFormat), CollectionsKt.emptyList());
        shader.begin();
        drawContext.applyToShader(shader);
        drawStyle.applyToShader(shader);
        Driver.Companion.getInstance().setState(drawStyle);
        DrawStyle localStyle = DrawStyle.copy$default(drawStyle, null, null, null, null, null, 0.0, false, 0.0, null, null, false, null, null, null, false, null, null, null, null, null, null, null, null, 0x7FFFFF, null);
        double fs = fringeWidth;
        shader.uniform("strokeMult", (drawStyle.getStrokeWeight() * 0.5 + fs * 0.5) / fs);
        shader.uniform("strokeFillFactor", 0.0);
        Iterable $this$forEach$iv = commands;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Command command2 = (Command)element$iv;
            boolean bl = false;
            localStyle.setChannelWriteMask(new ChannelMask(true, true, true, true));
            shader.uniform("strokeThr", 0.9980392f);
            localStyle.getStencil().stencilFunc(StencilTest.EQUAL, 0, 255);
            localStyle.getStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.INCREASE);
            Driver.Companion.getInstance().setState(localStyle);
            Driver.Companion.getInstance().drawVertexBuffer(shader, CollectionsKt.listOf(command2.getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, command2.getVertexOffset(), command2.getVertexCount(), 0);
            shader.uniform("strokeThr", -1.0f);
            localStyle.getStencil().stencilFunc(StencilTest.EQUAL, 0, 255);
            localStyle.getStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.KEEP);
            Driver.Companion.getInstance().setState(localStyle);
            Driver.Companion.getInstance().drawVertexBuffer(shader, CollectionsKt.listOf(command2.getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, command2.getVertexOffset(), command2.getVertexCount(), 0);
            localStyle.setChannelWriteMask(new ChannelMask(false, false, false, false));
            localStyle.getStencil().stencilFunc(StencilTest.ALWAYS, 0, 255);
            localStyle.getStencil().stencilOp(StencilOperation.ZERO, StencilOperation.ZERO, StencilOperation.ZERO);
            Driver.Companion.getInstance().setState(localStyle);
            Driver.Companion.getInstance().drawVertexBuffer(shader, CollectionsKt.listOf(command2.getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, command2.getVertexOffset(), command2.getVertexCount(), 0);
            localStyle.getStencil().setStencilTest(StencilTest.DISABLED);
            localStyle.setChannelWriteMask(new ChannelMask(true, true, true, true));
            Driver.Companion.getInstance().setState(localStyle);
        }
        shader.end();
    }

    private final void renderStrokeCommandsInterleaved(DrawContext drawContext, DrawStyle drawStyle, List<Command> commands, double fringeScale) {
        if (!((Collection)commands).isEmpty()) {
            Shader shader = ShadeStyleManager.shader$default(this.shaderManager, drawStyle.getShadeStyle(), CollectionsKt.listOf(this.vertexFormat), null, 4, null);
            shader.begin();
            drawContext.applyToShader(shader);
            drawStyle.applyToShader(shader);
            Driver.Companion.getInstance().setState(drawStyle);
            DrawStyle localStyle = drawStyle;
            Command it = CollectionsKt.last(commands);
            boolean bl = false;
            int vertexCount = it.getVertexOffset() + it.getVertexCount();
            double fs = fringeScale;
            shader.uniform("strokeMult", (drawStyle.getStrokeWeight() * 0.5 + fs * 0.5) / fs);
            shader.uniform("strokeFillFactor", 0.0);
            shader.uniform("bounds", new Vector4(-1000.0, -1000.0, 2000.0, 2000.0));
            localStyle.setChannelWriteMask(new ChannelMask(true, true, true, true));
            shader.uniform("strokeThr", 0.9980392f);
            localStyle.getStencil().stencilFunc(StencilTest.EQUAL, 0, 255);
            localStyle.getStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.INCREASE);
            Driver.Companion.getInstance().setState(localStyle);
            Driver.Companion.getInstance().drawVertexBuffer(shader, CollectionsKt.listOf(commands.get(0).getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, commands.get(0).getVertexOffset(), vertexCount, 0);
            shader.uniform("strokeThr", 0.0f);
            localStyle.getStencil().stencilFunc(StencilTest.EQUAL, 0, 255);
            localStyle.getStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.KEEP);
            Driver.Companion.getInstance().setState(localStyle);
            Driver.Companion.getInstance().drawVertexBuffer(shader, CollectionsKt.listOf(commands.get(0).getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, commands.get(0).getVertexOffset(), vertexCount, 0);
            localStyle.setChannelWriteMask(new ChannelMask(false, false, false, false));
            localStyle.getStencil().stencilFunc(StencilTest.ALWAYS, 0, 255);
            localStyle.getStencil().stencilOp(StencilOperation.ZERO, StencilOperation.ZERO, StencilOperation.ZERO);
            Driver.Companion.getInstance().setState(localStyle);
            Driver.Companion.getInstance().drawVertexBuffer(shader, CollectionsKt.listOf(commands.get(0).getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, commands.get(0).getVertexOffset(), vertexCount, 0);
            localStyle.getStencil().setStencilTest(StencilTest.DISABLED);
            localStyle.setChannelWriteMask(new ChannelMask(true, true, true, true));
            Driver.Companion.getInstance().setState(localStyle);
        }
    }

    private final void renderConvexFillCommands(DrawContext drawContext, DrawStyle drawStyle, List<Command> commands, double fringeScale) {
        Command command2;
        Shader shader = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertexFormat);
        shader.begin();
        drawContext.applyToShader(shader);
        drawStyle.applyToShader(shader);
        Driver.Companion.getInstance().setState(drawStyle);
        shader.uniform("strokeThr", -1.0f);
        shader.uniform("strokeMult", 1.0);
        shader.uniform("strokeFillFactor", 1.0);
        Iterable $this$forEach$iv = commands;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            command2 = (Command)element$iv;
            boolean bl = false;
            if (command2.getType() != ExpansionType.FILL) continue;
            Driver.Companion.getInstance().drawVertexBuffer(shader, CollectionsKt.listOf(command2.getVertexBuffer()), DrawPrimitive.TRIANGLE_FAN, command2.getVertexOffset(), command2.getVertexCount(), 0);
        }
        $this$forEach$iv = commands;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            command2 = (Command)element$iv;
            boolean bl = false;
            if (command2.getType() != ExpansionType.FRINGE) continue;
            Driver.Companion.getInstance().drawVertexBuffer(shader, CollectionsKt.listOf(command2.getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, command2.getVertexOffset(), command2.getVertexCount(), 0);
        }
    }

    private final void renderFillCommands(DrawContext drawContext, DrawStyle drawStyle, List<Command> commands, double fringeWidth) {
        BufferWriter bufferWriter;
        Object v6;
        Object v4;
        Object v2;
        Object v0;
        if (commands.isEmpty()) {
            return;
        }
        Shader shader = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertexFormat);
        shader.begin();
        drawContext.applyToShader(shader);
        drawStyle.applyToShader(shader);
        Driver.Companion.getInstance().setState(drawStyle);
        DrawStyle localStyle = drawStyle;
        shader.uniform("strokeThr", -1.0f);
        shader.uniform("strokeMult", 1.0);
        shader.uniform("strokeFillFactor", 1.0);
        Iterable $this$minByOrNull$iv = commands;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                Command it = (Command)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.getMinX();
                do {
                    Object e$iv = iterator$iv.next();
                    Command it2 = (Command)e$iv;
                    $i$a$-minByOrNull-ExpansionDrawer$renderFillCommands$minX$1 = false;
                    double v$iv = it2.getMinX();
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        Command command2 = v0;
        if (command2 == null) {
            throw new IllegalStateException("no commands".toString());
        }
        double minX = command2.getMinX();
        Iterable $this$minByOrNull$iv2 = commands;
        boolean $i$f$minByOrNull2 = false;
        Iterator iterator$iv2 = $this$minByOrNull$iv2.iterator();
        if (!iterator$iv2.hasNext()) {
            v2 = null;
        } else {
            Object minElem$iv = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                v2 = minElem$iv;
            } else {
                Command it = (Command)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.getMinY();
                do {
                    Object e$iv = iterator$iv2.next();
                    Command it3 = (Command)e$iv;
                    $i$a$-minByOrNull-ExpansionDrawer$renderFillCommands$minY$1 = false;
                    double v$iv = it3.getMinY();
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv2.hasNext());
                v2 = minElem$iv;
            }
        }
        Command command3 = v2;
        if (command3 == null) {
            throw new IllegalStateException("no commands".toString());
        }
        double minY = command3.getMinY();
        Iterable $this$maxByOrNull$iv = commands;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv3 = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv3.hasNext()) {
            v4 = null;
        } else {
            Object maxElem$iv = iterator$iv3.next();
            if (!iterator$iv3.hasNext()) {
                v4 = maxElem$iv;
            } else {
                Command it = (Command)maxElem$iv;
                boolean bl = false;
                double maxValue$iv = it.getMaxX();
                do {
                    Object e$iv = iterator$iv3.next();
                    Command it4 = (Command)e$iv;
                    $i$a$-maxByOrNull-ExpansionDrawer$renderFillCommands$maxX$1 = false;
                    double v$iv = it4.getMaxX();
                    if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv3.hasNext());
                v4 = maxElem$iv;
            }
        }
        Command command4 = v4;
        if (command4 == null) {
            throw new IllegalStateException("no commands".toString());
        }
        double maxX = command4.getMaxX();
        Iterator<Command> $this$maxByOrNull$iv2 = commands;
        boolean $i$f$maxByOrNull2 = false;
        Iterator iterator$iv222 = $this$maxByOrNull$iv2.iterator();
        if (!iterator$iv222.hasNext()) {
            v6 = null;
        } else {
            Object maxElem$iv = iterator$iv222.next();
            if (!iterator$iv222.hasNext()) {
                v6 = maxElem$iv;
            } else {
                Command it = (Command)maxElem$iv;
                boolean bl = false;
                double maxValue$iv = it.getMaxY();
                do {
                    Object e$iv = iterator$iv222.next();
                    Command it5 = (Command)e$iv;
                    $i$a$-maxByOrNull-ExpansionDrawer$renderFillCommands$maxY$1 = false;
                    double v$iv = it5.getMaxY();
                    if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv222.hasNext());
                v6 = maxElem$iv;
            }
        }
        Command command5 = v6;
        if (command5 == null) {
            throw new IllegalStateException("no commands".toString());
        }
        double maxY = command5.getMaxY();
        Command command6 = commands.get(0);
        shader.uniform("bounds", new Vector4(command6.getMinX(), command6.getMinY(), command6.getMaxX() - command6.getMinX(), command6.getMaxY() - command6.getMinY()));
        localStyle.setFrontStencil(new StencilStyle(null, null, null, 0, 0, 0, null, 127, null));
        localStyle.setBackStencil(new StencilStyle(null, null, null, 0, 0, 0, null, 127, null));
        localStyle.getFrontStencil().setStencilWriteMask(255);
        localStyle.getBackStencil().setStencilWriteMask(255);
        localStyle.getFrontStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.INCREASE_WRAP);
        localStyle.getBackStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.DECREASE_WRAP);
        localStyle.getFrontStencil().stencilFunc(StencilTest.ALWAYS, 0, 255);
        localStyle.getBackStencil().stencilFunc(StencilTest.ALWAYS, 0, 255);
        localStyle.setChannelWriteMask(ChannelMask.Companion.getNONE());
        localStyle.setCullTestPass(CullTestPass.ALWAYS);
        Driver.Companion.getInstance().setState(localStyle);
        for (Command c2 : commands) {
            if (c2.getType() != ExpansionType.FILL) continue;
            Driver.Companion.getInstance().drawVertexBuffer(shader, CollectionsKt.listOf(c2.getVertexBuffer()), DrawPrimitive.TRIANGLE_FAN, c2.getVertexOffset(), c2.getVertexCount(), 0);
        }
        localStyle.setFrontStencil(localStyle.getStencil());
        localStyle.setBackStencil(localStyle.getStencil());
        localStyle.setChannelWriteMask(ChannelMask.Companion.getALL());
        shader.uniform("strokeThr", 0.0f);
        shader.uniform("strokeMult", 1.0);
        localStyle.getStencil().stencilFunc(StencilTest.EQUAL, 0, 255);
        localStyle.getStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.KEEP);
        Driver.Companion.getInstance().setState(localStyle);
        for (Command c3 : commands) {
            if (c3.getType() != ExpansionType.FRINGE) continue;
            Driver.Companion.getInstance().drawVertexBuffer(shader, CollectionsKt.listOf(c3.getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, c3.getVertexOffset(), c3.getVertexCount(), 0);
        }
        Driver.Companion.getInstance().setState(localStyle);
        shader.uniform("strokeThr", -1.0f);
        shader.uniform("strokeMult", 1.0);
        localStyle.getStencil().stencilFunc(StencilTest.NOT_EQUAL, 0, 255);
        localStyle.getStencil().setStencilTestMask(1);
        localStyle.getStencil().stencilOp(StencilOperation.ZERO, StencilOperation.ZERO, StencilOperation.ZERO);
        localStyle.setChannelWriteMask(ChannelMask.Companion.getALL());
        localStyle.setCullTestPass(CullTestPass.ALWAYS);
        int n = this.quadCounter;
        int iterator$iv222 = this.quads.size();
        int maxElem$iv = n % iterator$iv222;
        VertexBuffer quad = this.quads.get(maxElem$iv + (iterator$iv222 & ((maxElem$iv ^ iterator$iv222) & (maxElem$iv | -maxElem$iv)) >> 31));
        BufferWriter $this$renderFillCommands_u24lambda_u2411 = bufferWriter = quad.getShadow().writer();
        boolean bl = false;
        $this$renderFillCommands_u24lambda_u2411.rewind();
        $this$renderFillCommands_u24lambda_u2411.write((float)minX, (float)minY);
        $this$renderFillCommands_u24lambda_u2411.write(0.5f, 1.0f, 0.0f);
        $this$renderFillCommands_u24lambda_u2411.write((float)minX, (float)maxY);
        $this$renderFillCommands_u24lambda_u2411.write(0.5f, 1.0f, 0.0f);
        $this$renderFillCommands_u24lambda_u2411.write((float)maxX, (float)maxY);
        $this$renderFillCommands_u24lambda_u2411.write(0.5f, 1.0f, 0.0f);
        $this$renderFillCommands_u24lambda_u2411.write((float)maxX, (float)maxY);
        $this$renderFillCommands_u24lambda_u2411.write(0.5f, 1.0f, 0.0f);
        $this$renderFillCommands_u24lambda_u2411.write((float)maxX, (float)minY);
        $this$renderFillCommands_u24lambda_u2411.write(0.5f, 1.0f, 0.0f);
        $this$renderFillCommands_u24lambda_u2411.write((float)minX, (float)minY);
        $this$renderFillCommands_u24lambda_u2411.write(0.5f, 1.0f, 0.0f);
        VertexBufferShadow.DefaultImpls.upload$default(quad.getShadow(), 0, 0, 3, null);
        int n2 = this.quadCounter;
        this.quadCounter = n2 + 1;
        Driver.Companion.getInstance().setState(localStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader, CollectionsKt.listOf(quad), DrawPrimitive.TRIANGLES, 0, 6, 0);
        localStyle.getStencil().setStencilTest(StencilTest.DISABLED);
        shader.end();
    }

    private final Command toCommand(VertexBuffer vertices, Expansion expansion, int vertexOffset) {
        if (expansion.getVertexCount() > 0) {
            BufferWriter bufferWriter;
            Command command2 = new Command(vertices, expansion.getType(), vertexOffset, expansion.getVertexCount() + 2, expansion.getMinx(), expansion.getMiny(), expansion.getMaxx(), expansion.getMaxy());
            BufferWriter $this$toCommand_u24lambda_u2412 = bufferWriter = vertices.getShadow().writer();
            boolean bl = false;
            $this$toCommand_u24lambda_u2412.setPositionElements(vertexOffset);
            BufferWriter w = bufferWriter;
            int vertexSize = (expansion.getBufferPosition() - expansion.getBufferStart()) / expansion.getVertexCount();
            w.write(expansion.getFb(), expansion.getBufferStart(), vertexSize);
            w.write(expansion.getFb(), expansion.getBufferStart(), expansion.getBufferPosition() - expansion.getBufferStart());
            w.write(expansion.getFb(), expansion.getBufferStart() + vertexSize * (expansion.getVertexCount() - 1), vertexSize);
            return command2;
        }
        return new Command(vertices, ExpansionType.SKIP, 0, 0, 0.0, 0.0, 0.0, 0.0);
    }

    private final List<Command> toCommands(VertexBuffer vertices, List<Expansion> expansions) {
        int vertexOffset = 0;
        List commands = new ArrayList();
        Iterable $this$forEach$iv = expansions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Expansion it = (Expansion)element$iv;
            boolean bl = false;
            Command command2 = this.toCommand(vertices, it, vertexOffset);
            if (command2.getType() == ExpansionType.SKIP) continue;
            commands.add(command2);
            vertexOffset += it.getVertexCount() + 2;
        }
        vertices.getShadow().uploadElements(0, vertexOffset);
        return commands;
    }

    private final VertexBuffer vertices(int count2) {
        VertexBuffer vertexBuffer;
        if (count2 < 128) {
            int n = this.counter;
            n = this.counter = n + 1;
            int n2 = this.fewVertices.size();
            int n3 = n % n2;
            vertexBuffer = this.fewVertices.get(n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31));
        } else {
            vertexBuffer = this.manyVertices;
        }
        return vertexBuffer;
    }

    public final void renderStroke(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull Expansion expansion, double fringeScale) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(expansion, "expansion");
        this.renderStrokeCommands(drawContext, drawStyle, this.toCommands(this.vertices(expansion.getVertexCount()), CollectionsKt.listOf(expansion)), fringeScale);
    }

    /*
     * WARNING - void declaration
     */
    public final void renderStrokes(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Expansion> expansions, double fringeScale) {
        int n;
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(expansions, "expansions");
        Iterable iterable = expansions;
        ExpansionDrawer expansionDrawer = this;
        ExpansionDrawer expansionDrawer2 = this;
        DrawStyle drawStyle2 = drawStyle;
        DrawContext drawContext2 = drawContext;
        ExpansionDrawer expansionDrawer3 = this;
        int n2 = 0;
        for (Object t : iterable) {
            void it;
            Expansion expansion = (Expansion)t;
            n = n2;
            boolean bl = false;
            int n3 = it.getVertexCount();
            n2 = n + n3;
        }
        n = n2;
        expansionDrawer3.renderStrokeCommandsInterleaved(drawContext2, drawStyle2, expansionDrawer2.toCommands(expansionDrawer.vertices(n), expansions), fringeScale);
    }

    /*
     * WARNING - void declaration
     */
    public final void renderFill(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Expansion> expansions, boolean convex, double fringeScale) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(expansions, "expansions");
        if (convex) {
            int n;
            Iterable iterable = expansions;
            ExpansionDrawer expansionDrawer = this;
            ExpansionDrawer expansionDrawer2 = this;
            DrawStyle drawStyle2 = drawStyle;
            DrawContext drawContext2 = drawContext;
            ExpansionDrawer expansionDrawer3 = this;
            int n2 = 0;
            for (Object t : iterable) {
                void it;
                Expansion expansion = (Expansion)t;
                n = n2;
                boolean bl = false;
                int n3 = it.getVertexCount();
                n2 = n + n3;
            }
            n = n2;
            expansionDrawer3.renderConvexFillCommands(drawContext2, drawStyle2, expansionDrawer2.toCommands(expansionDrawer.vertices(n), expansions), fringeScale);
        } else {
            int n;
            Iterable iterable = expansions;
            ExpansionDrawer expansionDrawer = this;
            ExpansionDrawer expansionDrawer4 = this;
            DrawStyle drawStyle3 = drawStyle;
            DrawContext drawContext3 = drawContext;
            ExpansionDrawer expansionDrawer5 = this;
            int n4 = 0;
            for (Object t : iterable) {
                Expansion it = (Expansion)t;
                n = n4;
                boolean bl = false;
                int n5 = it.getVertexCount();
                n4 = n + n5;
            }
            n = n4;
            expansionDrawer5.renderFillCommands(drawContext3, drawStyle3, expansionDrawer4.toCommands(expansionDrawer.vertices(n), expansions), fringeScale);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void renderFills(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Expansion> expansions, double fringeScale) {
        int n;
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(expansions, "expansions");
        Iterable iterable = expansions;
        ExpansionDrawer expansionDrawer = this;
        ExpansionDrawer expansionDrawer2 = this;
        DrawStyle drawStyle2 = drawStyle;
        DrawContext drawContext2 = drawContext;
        ExpansionDrawer expansionDrawer3 = this;
        int n2 = 0;
        for (Object t : iterable) {
            void it;
            Expansion expansion = (Expansion)t;
            n = n2;
            boolean bl = false;
            int n3 = it.getVertexCount();
            n2 = n + n3;
        }
        n = n2;
        expansionDrawer3.renderFillCommands(drawContext2, drawStyle2, expansionDrawer2.toCommands(expansionDrawer.vertices(n), expansions), fringeScale);
    }

    private static final Unit vertexFormat$lambda$0(VertexFormat $this$vertexFormat) {
        Intrinsics.checkNotNullParameter($this$vertexFormat, "$this$vertexFormat");
        $this$vertexFormat.position(2);
        VertexFormat.textureCoordinate$default($this$vertexFormat, 2, 0, 2, null);
        VertexFormat.attribute$default($this$vertexFormat, "vertexOffset", VertexElementType.FLOAT32, 0, 4, null);
        return Unit.INSTANCE;
    }
}

