/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengles.GLES32;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.DepthBuffer;
import org.openrndr.draw.DepthFormat;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetBuilder;
import org.openrndr.draw.RenderTargetKt;
import org.openrndr.draw.Session;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.DepthBufferGL3Kt;
import org.openrndr.internal.gl3.DriverGL3;
import org.openrndr.internal.gl3.DriverGL3Configuration;
import org.openrndr.internal.gl3.DriverGL3Kt;
import org.openrndr.internal.gl3.DriverTypeGL;
import org.openrndr.internal.gl3.DriverVersionGL;
import org.openrndr.internal.gl3.ErrorGL3Kt;
import org.openrndr.internal.gl3.GL3Exception;
import org.openrndr.internal.gl3.GLGLESKt;
import org.openrndr.internal.gl3.RenderTargetGL3;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 )2\u00020\u0001:\u0001)BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u0001H\u0016J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u0001H\u0016J\u001f\u0010!\u001a\u00020\u001f2\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001f0#\u00a2\u0006\u0002\b$J\b\u0010%\u001a\u00020\u001fH\u0016J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u0003H\u0016J\b\u0010(\u001a\u00020\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/openrndr/internal/gl3/DepthBufferGL3;", "Lorg/openrndr/draw/DepthBuffer;", "texture", "", "buffer", "target", "width", "height", "format", "Lorg/openrndr/draw/DepthFormat;", "multisample", "Lorg/openrndr/draw/BufferMultisample;", "session", "Lorg/openrndr/draw/Session;", "<init>", "(IIIIILorg/openrndr/draw/DepthFormat;Lorg/openrndr/draw/BufferMultisample;Lorg/openrndr/draw/Session;)V", "getTexture", "()I", "getBuffer", "getTarget", "getWidth", "getHeight", "getFormat", "()Lorg/openrndr/draw/DepthFormat;", "getMultisample", "()Lorg/openrndr/draw/BufferMultisample;", "getSession", "()Lorg/openrndr/draw/Session;", "destroyed", "", "resolveTo", "", "copyTo", "bound", "f", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "destroy", "bind", "textureUnit", "close", "Companion", "openrndr-gl3"})
@SourceDebugExtension(value={"SMAP\nDepthBufferGL3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DepthBufferGL3.kt\norg/openrndr/internal/gl3/DepthBufferGL3\n+ 2 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n+ 3 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt\n+ 4 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$debugGLErrors$1\n*L\n1#1,249:1\n91#2,3:250\n1169#2,3:253\n1154#2,3:256\n69#2,3:259\n69#2,3:262\n1154#2,3:265\n67#3,3:268\n51#3,13:271\n65#3,7:285\n67#4:284\n*S KotlinDebug\n*F\n+ 1 DepthBufferGL3.kt\norg/openrndr/internal/gl3/DepthBufferGL3\n*L\n173#1:250,3\n193#1:253,3\n205#1:256,3\n207#1:259,3\n208#1:262,3\n229#1:265,3\n196#1:268,3\n196#1:271,13\n196#1:285,7\n196#1:284\n*E\n"})
public final class DepthBufferGL3
implements DepthBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int texture;
    private final int buffer;
    private final int target;
    private final int width;
    private final int height;
    @NotNull
    private final DepthFormat format;
    @NotNull
    private final BufferMultisample multisample;
    @Nullable
    private final Session session;
    private boolean destroyed;

    public DepthBufferGL3(int texture, int buffer, int target2, int width, int height, @NotNull DepthFormat format, @NotNull BufferMultisample multisample, @Nullable Session session) {
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter(multisample, "multisample");
        this.texture = texture;
        this.buffer = buffer;
        this.target = target2;
        this.width = width;
        this.height = height;
        this.format = format;
        this.multisample = multisample;
        this.session = session;
    }

    public final int getTexture() {
        return this.texture;
    }

    public final int getBuffer() {
        return this.buffer;
    }

    public final int getTarget() {
        return this.target;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    @NotNull
    public DepthFormat getFormat() {
        return this.format;
    }

    @Override
    @NotNull
    public BufferMultisample getMultisample() {
        return this.multisample;
    }

    @Override
    @Nullable
    public Session getSession() {
        return this.session;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void resolveTo(@NotNull DepthBuffer target2) {
        Intrinsics.checkNotNullParameter(target2, "target");
        RenderTarget renderTarget = RenderTargetKt.renderTarget$default(this.getWidth(), this.getHeight(), 0.0, this.getMultisample(), null, arg_0 -> DepthBufferGL3.resolveTo$lambda$0(this, arg_0), 20, null);
        Intrinsics.checkNotNull(renderTarget, "null cannot be cast to non-null type org.openrndr.internal.gl3.RenderTargetGL3");
        RenderTargetGL3 readTarget = (RenderTargetGL3)renderTarget;
        RenderTarget renderTarget2 = RenderTargetKt.renderTarget$default(target2.getWidth(), target2.getHeight(), 0.0, target2.getMultisample(), null, arg_0 -> DepthBufferGL3.resolveTo$lambda$1(target2, arg_0), 20, null);
        Intrinsics.checkNotNull(renderTarget2, "null cannot be cast to non-null type org.openrndr.internal.gl3.RenderTargetGL3");
        RenderTargetGL3 writeTarget = (RenderTargetGL3)renderTarget2;
        writeTarget.bind();
        int n = 36008;
        int framebuffer$iv = readTarget.getFramebuffer();
        boolean $i$f$glBindFramebuffer = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                void target$iv;
                GL45C.glBindFramebuffer((int)target$iv, framebuffer$iv);
                break;
            }
            case 2: {
                void target$iv;
                GLES32.glBindFramebuffer((int)target$iv, framebuffer$iv);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        GLGLESKt.glBlitFramebuffer(0, 0, this.getWidth(), this.getHeight(), 0, 0, this.getWidth(), this.getHeight(), 256, 9728);
        writeTarget.unbind();
        writeTarget.detachColorAttachments();
        writeTarget.destroy();
        readTarget.detachColorAttachments();
        readTarget.destroy();
    }

    @Override
    public void copyTo(@NotNull DepthBuffer target2) {
        Intrinsics.checkNotNullParameter(target2, "target");
        if (!(!this.destroyed)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        RenderTarget renderTarget = RenderTargetKt.renderTarget$default(this.getWidth(), this.getHeight(), 0.0, null, null, arg_0 -> DepthBufferGL3.copyTo$lambda$2(this, arg_0), 28, null);
        Intrinsics.checkNotNull(renderTarget, "null cannot be cast to non-null type org.openrndr.internal.gl3.RenderTargetGL3");
        RenderTargetGL3 readTarget = (RenderTargetGL3)renderTarget;
        DepthBufferGL3 cfr_ignored_0 = (DepthBufferGL3)target2;
        readTarget.bind();
        int src$iv = 36064;
        boolean $i$f$glReadBuffer = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                GL45C.glReadBuffer(src$iv);
                break;
            }
            case 2: {
                GLES32.glReadBuffer(src$iv);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ((DepthBufferGL3)target2).bound(arg_0 -> DepthBufferGL3.copyTo$lambda$3(target2, arg_0));
        readTarget.unbind();
        readTarget.detachDepthBuffer();
        readTarget.destroy();
    }

    public final void bound(@NotNull Function1<? super DepthBufferGL3, Unit> f) {
        int n;
        block14: {
            block15: {
                boolean $i$f$glGetInteger;
                int pname$iv;
                BufferMultisample bufferMultisample;
                block13: {
                    Intrinsics.checkNotNullParameter(f, "f");
                    if (!(!this.destroyed)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    int texture$iv = 33984;
                    boolean $i$f$glActiveTexture = false;
                    switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                        case 1: {
                            GL45C.glActiveTexture(texture$iv);
                            break;
                        }
                        case 2: {
                            GLES32.glActiveTexture(texture$iv);
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    bufferMultisample = this.getMultisample();
                    if (!Intrinsics.areEqual(bufferMultisample, BufferMultisample.Disabled.INSTANCE)) break block13;
                    pname$iv = 32873;
                    $i$f$glGetInteger = false;
                    switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                        case 1: {
                            n = GL45C.glGetInteger(pname$iv);
                            break block14;
                        }
                        case 2: {
                            n = GLES32.glGetInteger(pname$iv);
                            break block14;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                if (!(bufferMultisample instanceof BufferMultisample.SampleCount)) break block15;
                pname$iv = 37124;
                $i$f$glGetInteger = false;
                switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                    case 1: {
                        n = GL45C.glGetInteger(pname$iv);
                        break block14;
                    }
                    case 2: {
                        n = GLES32.glGetInteger(pname$iv);
                        break block14;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        int current = n;
        GLGLESKt.glBindTexture(this.target, this.texture);
        f.invoke(this);
        GLGLESKt.glBindTexture(this.target, current);
    }

    @Override
    public void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.texture != -1) {
                GLGLESKt.glDeleteTextures(this.texture);
            }
            if (this.buffer != -1) {
                GLGLESKt.glDeleteRenderbuffers(this.buffer);
            }
        }
    }

    @Override
    public void bind(int textureUnit) {
        if (!(!this.destroyed)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int texture$iv = 33984 + textureUnit;
        boolean $i$f$glActiveTexture = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                GL45C.glActiveTexture(texture$iv);
                break;
            }
            case 2: {
                GLES32.glActiveTexture(texture$iv);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        GLGLESKt.glBindTexture(this.target, this.texture);
    }

    @Override
    public void close() {
        this.destroy();
    }

    @Override
    public boolean getHasDepth() {
        return DepthBuffer.DefaultImpls.getHasDepth(this);
    }

    @Override
    public boolean getHasStencil() {
        return DepthBuffer.DefaultImpls.getHasStencil(this);
    }

    private static final Unit resolveTo$lambda$0(DepthBufferGL3 this$0, RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        $this$renderTarget.depthBuffer(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit resolveTo$lambda$1(DepthBuffer $target, RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        $this$renderTarget.depthBuffer($target);
        return Unit.INSTANCE;
    }

    private static final Unit copyTo$lambda$2(DepthBufferGL3 this$0, RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        $this$renderTarget.depthBuffer(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit copyTo$lambda$3(DepthBuffer $target, DepthBufferGL3 $this$bound) {
        Intrinsics.checkNotNullParameter($this$bound, "$this$bound");
        GLGLESKt.glCopyTexSubImage2D(((DepthBufferGL3)$target).target, 0, 0, 0, 0, 0, ((DepthBufferGL3)$target).getWidth(), ((DepthBufferGL3)$target).getHeight());
        boolean $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var11_10 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var11_10;
                throw new GL3Exception(string);
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/openrndr/internal/gl3/DepthBufferGL3$Companion;", "", "<init>", "()V", "create", "Lorg/openrndr/internal/gl3/DepthBufferGL3;", "width", "", "height", "format", "Lorg/openrndr/draw/DepthFormat;", "multisample", "Lorg/openrndr/draw/BufferMultisample;", "session", "Lorg/openrndr/draw/Session;", "openrndr-gl3"})
    @SourceDebugExtension(value={"SMAP\nDepthBufferGL3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DepthBufferGL3.kt\norg/openrndr/internal/gl3/DepthBufferGL3$Companion\n+ 2 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt\n+ 3 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$checkGLErrors$1\n+ 4 DriverGL3.kt\norg/openrndr/internal/gl3/DriverGL3Kt\n+ 5 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n*L\n1#1,249:1\n51#2,15:250\n50#2,14:265\n65#2:280\n51#2,15:285\n51#2,15:300\n51#2,15:319\n51#2,15:337\n50#3:279\n71#4,4:281\n71#4,4:315\n69#5,3:334\n*S KotlinDebug\n*F\n+ 1 DepthBufferGL3.kt\norg/openrndr/internal/gl3/DepthBufferGL3$Companion\n*L\n32#1:250,15\n41#1:265,14\n41#1:280\n70#1:285,15\n94#1:300,15\n127#1:319,15\n149#1:337,15\n41#1:279\n50#1:281,4\n113#1:315,4\n143#1:334,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DepthBufferGL3 create(int width, int height, @NotNull DepthFormat format, @NotNull BufferMultisample multisample, @Nullable Session session) {
            int n;
            Intrinsics.checkNotNullParameter((Object)format, "format");
            Intrinsics.checkNotNullParameter(multisample, "multisample");
            boolean $i$f$checkGLErrors = false;
            int error$iv = GLGLESKt.glGetError();
            if (error$iv != 0) {
                Object message$iv = switch (error$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv + ">";
                };
                int n2 = error$iv;
                Object object = message$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                String string = "pre-existing error";
                String string2 = "[context=" + l + "] GL ERROR: " + (String)object + " " + string;
                throw new GL3Exception(string2);
            }
            int glTexture = GLGLESKt.glGenTextures();
            BufferMultisample message$iv = multisample;
            if (Intrinsics.areEqual(message$iv, BufferMultisample.Disabled.INSTANCE)) {
                n = 3553;
            } else if (message$iv instanceof BufferMultisample.SampleCount) {
                n = 37120;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            int target2 = n;
            GLGLESKt.glBindTexture(target2, glTexture);
            boolean $i$f$checkGLErrors2 = false;
            int error$iv2 = GLGLESKt.glGetError();
            if (error$iv2 != 0) {
                Object message$iv2 = switch (error$iv2) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv2 + ">";
                };
                int n3 = error$iv2;
                Object object = message$iv2;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n3;
                Object var23_27 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var23_27;
                throw new GL3Exception(string);
            }
            ByteBuffer nullBuffer = null;
            return switch (WhenMappings.$EnumSwitchMapping$1[DriverGL3Kt.getGlType(Driver.Companion).ordinal()]) {
                case 1 -> {
                    int error$iv;
                    int v3 = switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                        case 1, 2, 3 -> 6402;
                        case 4, 5, 6 -> 34041;
                        case 7 -> {
                            void $this$require$iv;
                            Driver v4 = Driver.Companion.getInstance();
                            Intrinsics.checkNotNull(v4, "null cannot be cast to non-null type org.openrndr.internal.gl3.DriverGL3");
                            DriverVersionGL var14_45 = ((DriverGL3)v4).getVersion();
                            DriverVersionGL minimum$iv = DriverVersionGL.GL_VERSION_4_4;
                            boolean $i$f$require = false;
                            if (!($this$require$iv.ordinal() >= minimum$iv.ordinal())) {
                                boolean $i$a$-require-DriverGL3Kt$require$1$iv2 = false;
                                String $i$a$-require-DriverGL3Kt$require$1$iv2 = "Feature is not supported on current OpenGL configuration (configuration: " + $this$require$iv.getVersionString() + ", required: " + minimum$iv.getVersionString() + ")";
                                throw new IllegalArgumentException($i$a$-require-DriverGL3Kt$require$1$iv2.toString());
                            }
                            yield 6401;
                        }
                        default -> throw new NoWhenBranchMatchedException();
                    };
                    int glFormat = v3;
                    int v5 = switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                        case 3 -> 36012;
                        case 2 -> 33190;
                        case 6 -> 36013;
                        case 4, 5 -> 35056;
                        default -> throw new IllegalStateException(("format " + format + " not supported").toString());
                    };
                    int type = v5;
                    BufferMultisample bl = multisample;
                    if (Intrinsics.areEqual(bl, BufferMultisample.Disabled.INSTANCE)) {
                        int buffer = GLGLESKt.glGenRenderbuffers();
                        GLGLESKt.glBindRenderbuffer(36161, buffer);
                        GLGLESKt.glRenderbufferStorage(36161, type, width, height);
                        boolean $i$f$checkGLErrors = false;
                        error$iv = GLGLESKt.glGetError();
                        if (error$iv != 0) {
                            void it;
                            Object v6 = switch (error$iv) {
                                case 1282 -> "GL_INVALID_OPERATION";
                                case 1281 -> "GL_INVALID_VALUE";
                                case 1280 -> "GL_INVALID_ENUM";
                                case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                                case 1285 -> "GL_OUT_OF_MEMORY";
                                case 1284 -> "GL_STACK_UNDERFLOW";
                                case 1283 -> "GL_STACK_OVERFLOW";
                                default -> "<untranslated: " + error$iv + ">";
                            };
                            Object message$iv = v6;
                            int var18_64 = error$iv;
                            Object var22_14 = message$iv;
                            long var20_20 = Driver.Companion.getInstance().getContextID();
                            boolean $i$a$-checkGLErrors-DepthBufferGL3$Companion$create$2 = false;
                            DepthBufferGL3Kt.access$getLogger$p().error((Function0<? extends Object>)new Function0<Object>(width, height, format, multisample){
                                final /* synthetic */ int $width;
                                final /* synthetic */ int $height;
                                final /* synthetic */ DepthFormat $format;
                                final /* synthetic */ BufferMultisample $multisample;
                                {
                                    this.$width = $width;
                                    this.$height = $height;
                                    this.$format = $format;
                                    this.$multisample = $multisample;
                                }

                                public final Object invoke() {
                                    return "failed to create depth buffer. width: " + this.$width + ", height: " + this.$height + ", format: " + this.$format + ", multisample: " + this.$multisample;
                                }
                            });
                            String var23_28 = it == 1280 ? format + " not supported?" : null;
                            String var26_70 = "[context=" + var20_20 + "] GL ERROR: " + (String)var22_14 + " " + var23_28;
                            throw new GL3Exception(var26_70);
                        }
                        GLGLESKt.glBindRenderbuffer(36161, 0);
                        yield new DepthBufferGL3(-1, buffer, target2, width, height, format, multisample, session);
                    }
                    if (bl instanceof BufferMultisample.SampleCount) {
                        int buffer = GLGLESKt.glGenRenderbuffers();
                        GLGLESKt.glBindRenderbuffer(36161, buffer);
                        GLGLESKt.glRenderbufferStorageMultisample(36161, ((BufferMultisample.SampleCount)multisample).getSampleCount(), 36013, width, height);
                        boolean $i$f$checkGLErrors = false;
                        error$iv = GLGLESKt.glGetError();
                        if (error$iv != 0) {
                            Object v8 = switch (error$iv) {
                                case 1282 -> "GL_INVALID_OPERATION";
                                case 1281 -> "GL_INVALID_VALUE";
                                case 1280 -> "GL_INVALID_ENUM";
                                case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                                case 1285 -> "GL_OUT_OF_MEMORY";
                                case 1284 -> "GL_STACK_UNDERFLOW";
                                case 1283 -> "GL_STACK_OVERFLOW";
                                default -> "<untranslated: " + error$iv + ">";
                            };
                            Object message$iv = v8;
                            int it = error$iv;
                            Object var22_15 = message$iv;
                            long var20_21 = Driver.Companion.getInstance().getContextID();
                            boolean $i$a$-checkGLErrors-DepthBufferGL3$Companion$create$3 = false;
                            DepthBufferGL3Kt.access$getLogger$p().error((Function0<? extends Object>)new Function0<Object>(width, height, format, multisample){
                                final /* synthetic */ int $width;
                                final /* synthetic */ int $height;
                                final /* synthetic */ DepthFormat $format;
                                final /* synthetic */ BufferMultisample $multisample;
                                {
                                    this.$width = $width;
                                    this.$height = $height;
                                    this.$format = $format;
                                    this.$multisample = $multisample;
                                }

                                public final Object invoke() {
                                    return "failed to create depth buffer. width: " + this.$width + ", height: " + this.$height + ", format: " + this.$format + ", multisample: " + this.$multisample;
                                }
                            });
                            Object var23_29 = null;
                            String var27_71 = "[context=" + var20_21 + "] GL ERROR: " + (String)var22_15 + " " + var23_29;
                            throw new GL3Exception(var27_71);
                        }
                        GLGLESKt.glBindRenderbuffer(36161, 0);
                        yield new DepthBufferGL3(-1, buffer, target2, width, height, format, multisample, session);
                    }
                    throw new NoWhenBranchMatchedException();
                }
                case 2 -> {
                    BufferMultisample var11_35 = multisample;
                    if (Intrinsics.areEqual(var11_35, BufferMultisample.Disabled.INSTANCE)) {
                        int v9 = switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                            case 1, 2, 3 -> 6402;
                            case 4, 5, 6 -> 6402;
                            case 7 -> {
                                void $this$require$iv;
                                Driver v10 = Driver.Companion.getInstance();
                                Intrinsics.checkNotNull(v10, "null cannot be cast to non-null type org.openrndr.internal.gl3.DriverGL3");
                                DriverVersionGL $i$f$checkGLErrors = ((DriverGL3)v10).getVersion();
                                DriverVersionGL minimum$iv = DriverVersionGL.GL_VERSION_4_4;
                                boolean $i$f$require = false;
                                if (!($this$require$iv.ordinal() >= minimum$iv.ordinal())) {
                                    boolean $i$a$-require-DriverGL3Kt$require$1$iv = false;
                                    String var18_67 = "Feature is not supported on current OpenGL configuration (configuration: " + $this$require$iv.getVersionString() + ", required: " + minimum$iv.getVersionString() + ")";
                                    throw new IllegalArgumentException(var18_67.toString());
                                }
                                yield 6401;
                            }
                            default -> throw new NoWhenBranchMatchedException();
                        };
                        int glFormat = v9;
                        GLGLESKt.glTexImage2D(3553, 0, DepthBufferGL3Kt.access$toGLFormat(format), width, height, 0, glFormat, 5121, nullBuffer);
                        boolean $i$f$checkGLErrors = false;
                        int error$iv = GLGLESKt.glGetError();
                        if (error$iv != 0) {
                            Object v11 = switch (error$iv) {
                                case 1282 -> "GL_INVALID_OPERATION";
                                case 1281 -> "GL_INVALID_VALUE";
                                case 1280 -> "GL_INVALID_ENUM";
                                case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                                case 1285 -> "GL_OUT_OF_MEMORY";
                                case 1284 -> "GL_STACK_UNDERFLOW";
                                case 1283 -> "GL_STACK_OVERFLOW";
                                default -> "<untranslated: " + error$iv + ">";
                            };
                            Object message$iv = v11;
                            int minimum$iv = error$iv;
                            Object var22_16 = message$iv;
                            long var20_22 = Driver.Companion.getInstance().getContextID();
                            boolean $i$a$-checkGLErrors-DepthBufferGL3$Companion$create$4 = false;
                            DepthBufferGL3Kt.access$getLogger$p().error((Function0<? extends Object>)new Function0<Object>(format, multisample, glFormat){
                                final /* synthetic */ DepthFormat $format;
                                final /* synthetic */ BufferMultisample $multisample;
                                final /* synthetic */ int $glFormat;
                                {
                                    this.$format = $format;
                                    this.$multisample = $multisample;
                                    this.$glFormat = $glFormat;
                                }

                                public final Object invoke() {
                                    return StringsKt.trimMargin$default("glTexImage2D failed. format: " + this.$format + ", multisample: " + this.$multisample + "\n                                    |internalformat=" + ErrorGL3Kt.glEnumName(DepthBufferGL3Kt.access$toGLFormat(this.$format)) + ", format=" + ErrorGL3Kt.glEnumName(this.$glFormat) + "\n                                ", null, 1, null);
                                }
                            });
                            Object var23_30 = null;
                            String var28_72 = "[context=" + var20_22 + "] GL ERROR: " + (String)var22_16 + " " + var23_30;
                            throw new GL3Exception(var28_72);
                        }
                        GLGLESKt.glTexParameteri(3553, 10241, 9728);
                        GLGLESKt.glTexParameteri(3553, 10240, 9728);
                        GLGLESKt.glTexParameteri(3553, 10242, 33071);
                        GLGLESKt.glTexParameteri(3553, 10243, 33071);
                        yield new DepthBufferGL3(glTexture, -1, target2, width, height, format, multisample, session);
                    }
                    if (var11_35 instanceof BufferMultisample.SampleCount) {
                        int v12 = ((BufferMultisample.SampleCount)multisample).getSampleCount();
                        int pname$iv = 37135;
                        boolean $i$f$glGetInteger = false;
                        int v13 = switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                            case 1 -> GL45C.glGetInteger(pname$iv);
                            case 2 -> GLES32.glGetInteger(pname$iv);
                            default -> throw new NoWhenBranchMatchedException();
                        };
                        GLGLESKt.glTexImage2DMultisample(target2, RangesKt.coerceAtMost(v12, v13), DepthBufferGL3Kt.access$toGLFormat(format), width, height, true);
                        boolean $i$f$checkGLErrors = false;
                        int error$iv = GLGLESKt.glGetError();
                        if (error$iv != 0) {
                            Object v14 = switch (error$iv) {
                                case 1282 -> "GL_INVALID_OPERATION";
                                case 1281 -> "GL_INVALID_VALUE";
                                case 1280 -> "GL_INVALID_ENUM";
                                case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                                case 1285 -> "GL_OUT_OF_MEMORY";
                                case 1284 -> "GL_STACK_UNDERFLOW";
                                case 1283 -> "GL_STACK_OVERFLOW";
                                default -> "<untranslated: " + error$iv + ">";
                            };
                            Object message$iv = v14;
                            int message$iv = error$iv;
                            Object var22_17 = message$iv;
                            long var20_23 = Driver.Companion.getInstance().getContextID();
                            boolean $i$a$-checkGLErrors-DepthBufferGL3$Companion$create$5 = false;
                            DepthBufferGL3Kt.access$getLogger$p().error((Function0<? extends Object>)new Function0<Object>(format, multisample){
                                final /* synthetic */ DepthFormat $format;
                                final /* synthetic */ BufferMultisample $multisample;
                                {
                                    this.$format = $format;
                                    this.$multisample = $multisample;
                                }

                                public final Object invoke() {
                                    return StringsKt.trimMargin$default("glTexImage2D failed. format: " + this.$format + ", multisample: " + this.$multisample + "\n                                    |internalformat=" + ErrorGL3Kt.glEnumName(DepthBufferGL3Kt.access$toGLFormat(this.$format)) + "}\n                                ", null, 1, null);
                                }
                            });
                            Object var23_31 = null;
                            String var29_73 = "[context=" + var20_23 + "] GL ERROR: " + (String)var22_17 + " " + var23_31;
                            throw new GL3Exception(var29_73);
                        }
                        yield new DepthBufferGL3(glTexture, -1, target2, width, height, format, multisample, session);
                    }
                    throw new NoWhenBranchMatchedException();
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[DepthFormat.values().length];
                try {
                    nArray[DepthFormat.DEPTH16.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DepthFormat.DEPTH24.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DepthFormat.DEPTH32F.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DepthFormat.DEPTH_STENCIL.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DepthFormat.DEPTH24_STENCIL8.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DepthFormat.DEPTH32F_STENCIL8.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DepthFormat.STENCIL8.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[DriverTypeGL.values().length];
                try {
                    nArray[DriverTypeGL.GLES.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DriverTypeGL.GL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

