/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengles.GLDebugMessageCallback;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLES32;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIUtil;
import org.openrndr.internal.gl3.GLESUtilKt;
import org.openrndr.internal.gl3.GLGLESKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J$\u0010\u0006\u001a\u00020\u00052\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/openrndr/internal/gl3/GLESUtil;", "", "<init>", "()V", "setupDebugMessageCallback", "", "printDetail", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "type", "", "message", "getDebugSource", "source", "", "getDebugType", "getDebugSeverity", "severity", "openrndr-gl3"})
@SourceDebugExtension(value={"SMAP\nGLESUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GLESUtil.kt\norg/openrndr/internal/gl3/GLESUtil\n+ 2 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n*L\n1#1,106:1\n18#2,3:107\n*S KotlinDebug\n*F\n+ 1 GLESUtil.kt\norg/openrndr/internal/gl3/GLESUtil\n*L\n55#1:107,3\n*E\n"})
public final class GLESUtil {
    @NotNull
    public static final GLESUtil INSTANCE = new GLESUtil();

    private GLESUtil() {
    }

    public final void setupDebugMessageCallback() {
        block5: {
            block4: {
                GLESCapabilities gLESCapabilities = GLES.getCapabilities();
                Intrinsics.checkNotNullExpressionValue(gLESCapabilities, "getCapabilities(...)");
                GLESCapabilities caps = gLESCapabilities;
                if (!caps.GLES32) break block4;
                GLESUtilKt.access$getLogger$p().info(GLESUtil::setupDebugMessageCallback$lambda$0);
                GLDebugMessageCallback gLDebugMessageCallback = GLDebugMessageCallback.create(GLESUtil::setupDebugMessageCallback$lambda$2);
                Intrinsics.checkNotNullExpressionValue(gLDebugMessageCallback, "create(...)");
                GLDebugMessageCallback proc = gLDebugMessageCallback;
                GLES32.glDebugMessageCallback(proc, 0L);
                GLESUtilKt.access$getLogger$p().warn(GLESUtil::setupDebugMessageCallback$lambda$3);
                int target$iv = 37600;
                boolean $i$f$glEnable = false;
                switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                    case 1: {
                        GL45C.glEnable(target$iv);
                        break block5;
                    }
                    case 2: {
                        GLES32.glEnable(target$iv);
                        break block5;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            GLESUtilKt.access$getLogger$p().warn(GLESUtil::setupDebugMessageCallback$lambda$4);
        }
    }

    private final void printDetail(StringBuilder sb, String type, String message) {
        sb.append("\t").append(type).append(": ").append(message).append("\n");
    }

    private final String getDebugSource(int source) {
        String string;
        switch (source) {
            case 33350: {
                string = "API";
                break;
            }
            case 33351: {
                string = "WINDOW SYSTEM";
                break;
            }
            case 33352: {
                string = "SHADER COMPILER";
                break;
            }
            case 33353: {
                string = "THIRD PARTY";
                break;
            }
            case 33354: {
                string = "APPLICATION";
                break;
            }
            case 33355: {
                string = "OTHER";
                break;
            }
            default: {
                String string2 = APIUtil.apiUnknownToken(source);
                string = string2;
                Intrinsics.checkNotNullExpressionValue(string2, "apiUnknownToken(...)");
            }
        }
        return string;
    }

    private final String getDebugType(int type) {
        String string;
        switch (type) {
            case 33356: {
                string = "ERROR";
                break;
            }
            case 33357: {
                string = "DEPRECATED BEHAVIOR";
                break;
            }
            case 33358: {
                string = "UNDEFINED BEHAVIOR";
                break;
            }
            case 33359: {
                string = "PORTABILITY";
                break;
            }
            case 33360: {
                string = "PERFORMANCE";
                break;
            }
            case 33361: {
                string = "OTHER";
                break;
            }
            case 33384: {
                string = "MARKER";
                break;
            }
            default: {
                String string2 = APIUtil.apiUnknownToken(type);
                string = string2;
                Intrinsics.checkNotNullExpressionValue(string2, "apiUnknownToken(...)");
            }
        }
        return string;
    }

    private final String getDebugSeverity(int severity) {
        String string;
        switch (severity) {
            case 37190: {
                string = "HIGH";
                break;
            }
            case 37191: {
                string = "MEDIUM";
                break;
            }
            case 37192: {
                string = "LOW";
                break;
            }
            case 33387: {
                string = "NOTIFICATION";
                break;
            }
            default: {
                String string2 = APIUtil.apiUnknownToken(severity);
                string = string2;
                Intrinsics.checkNotNullExpressionValue(string2, "apiUnknownToken(...)");
            }
        }
        return string;
    }

    private static final Object setupDebugMessageCallback$lambda$0() {
        return "Using GLES 3.2 for error logging.";
    }

    private static final Object setupDebugMessageCallback$lambda$2$lambda$1(StringBuilder $sb) {
        return $sb.toString();
    }

    private static final void setupDebugMessageCallback$lambda$2(int source, int type, int id, int severity, int length, long message, long userParam) {
        StringBuilder sb = new StringBuilder(300);
        sb.append("[LWJGL] OpenGL debug message\n");
        String string = Integer.toHexString(id);
        Intrinsics.checkNotNullExpressionValue(string, "toHexString(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue(string3, "toUpperCase(...)");
        INSTANCE.printDetail(sb, "ID", "0x" + string3);
        INSTANCE.printDetail(sb, "Source", INSTANCE.getDebugSource(source));
        INSTANCE.printDetail(sb, "Type", INSTANCE.getDebugType(type));
        INSTANCE.printDetail(sb, "Severity", INSTANCE.getDebugSeverity(severity));
        String string4 = GLDebugMessageCallback.getMessage(length, message);
        Intrinsics.checkNotNullExpressionValue(string4, "getMessage(...)");
        INSTANCE.printDetail(sb, "Message", string4);
        GLESUtilKt.access$getLogger$p().info(() -> GLESUtil.setupDebugMessageCallback$lambda$2$lambda$1(sb));
    }

    private static final Object setupDebugMessageCallback$lambda$3() {
        return "Warning: A non-debug context may not produce any debug output.";
    }

    private static final Object setupDebugMessageCallback$lambda$4() {
        return "GLES debug not supported";
    }
}

