/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengles.GLES32;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.AtomicCounterBuffer;
import org.openrndr.draw.ImageBinding;
import org.openrndr.draw.Session;
import org.openrndr.draw.Shader;
import org.openrndr.draw.ShaderStorageBuffer;
import org.openrndr.draw.ShaderType;
import org.openrndr.draw.UniformBlock;
import org.openrndr.draw.UniformBlockLayout;
import org.openrndr.draw.UniformDescription;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.DriverGL3;
import org.openrndr.internal.gl3.DriverGL3Configuration;
import org.openrndr.internal.gl3.DriverGL3Kt;
import org.openrndr.internal.gl3.FragmentShaderGL3;
import org.openrndr.internal.gl3.GL3Exception;
import org.openrndr.internal.gl3.GLGLESKt;
import org.openrndr.internal.gl3.GeometryShaderGL3;
import org.openrndr.internal.gl3.ShaderBufferBindingsGL3;
import org.openrndr.internal.gl3.ShaderGL3Kt;
import org.openrndr.internal.gl3.ShaderImageBindingsGL43;
import org.openrndr.internal.gl3.ShaderUniformsGL3;
import org.openrndr.internal.gl3.TessellationControlShaderGL3;
import org.openrndr.internal.gl3.TessellationEvaluationShaderGL3;
import org.openrndr.internal.gl3.UniformBlockGL3;
import org.openrndr.internal.gl3.VertexShaderGL3;
import org.openrndr.math.BooleanVector2;
import org.openrndr.math.BooleanVector3;
import org.openrndr.math.BooleanVector4;
import org.openrndr.math.IntVector2;
import org.openrndr.math.IntVector3;
import org.openrndr.math.IntVector4;
import org.openrndr.math.Matrix33;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 D2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001DBO\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u00107\u001a\u00020$2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00020\bH\u0016J\u0012\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010:\u001a\u00020\bH\u0016J\u0018\u0010=\u001a\u00020>2\u0006\u0010:\u001a\u00020\b2\u0006\u0010=\u001a\u000209H\u0016J\u0010\u0010?\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\bH\u0002J\b\u0010@\u001a\u00020>H\u0016J\b\u0010A\u001a\u00020>H\u0016J\u000e\u0010B\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010C\u001a\u00020>H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R \u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060 X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\"\"\u0004\b0\u00101R\u001a\u00102\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u00103\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000604j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0006`5X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00106\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/openrndr/internal/gl3/ShaderGL3;", "Lorg/openrndr/draw/Shader;", "Lorg/openrndr/internal/gl3/ShaderUniformsGL3;", "Lorg/openrndr/internal/gl3/ShaderBufferBindingsGL3;", "Lorg/openrndr/internal/gl3/ShaderImageBindingsGL43;", "programObject", "", "name", "", "vertexShader", "Lorg/openrndr/internal/gl3/VertexShaderGL3;", "tessellationControlShader", "Lorg/openrndr/internal/gl3/TessellationControlShaderGL3;", "tessellationEvaluationShader", "Lorg/openrndr/internal/gl3/TessellationEvaluationShaderGL3;", "geometryShader", "Lorg/openrndr/internal/gl3/GeometryShaderGL3;", "fragmentShader", "Lorg/openrndr/internal/gl3/FragmentShaderGL3;", "session", "Lorg/openrndr/draw/Session;", "<init>", "(ILjava/lang/String;Lorg/openrndr/internal/gl3/VertexShaderGL3;Lorg/openrndr/internal/gl3/TessellationControlShaderGL3;Lorg/openrndr/internal/gl3/TessellationEvaluationShaderGL3;Lorg/openrndr/internal/gl3/GeometryShaderGL3;Lorg/openrndr/internal/gl3/FragmentShaderGL3;Lorg/openrndr/draw/Session;)V", "getProgramObject", "()I", "getName", "()Ljava/lang/String;", "getSession", "()Lorg/openrndr/draw/Session;", "ssbo", "getSsbo", "ssboResourceIndices", "", "getSsboResourceIndices", "()Ljava/util/Map;", "useProgramUniform", "", "getUseProgramUniform", "()Z", "types", "", "Lorg/openrndr/draw/ShaderType;", "getTypes", "()Ljava/util/Set;", "destroyed", "running", "uniforms", "getUniforms", "setUniforms", "(Ljava/util/Map;)V", "attributes", "blockBindings", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "blocks", "hasUniform", "createBlock", "Lorg/openrndr/draw/UniformBlock;", "blockName", "blockLayout", "Lorg/openrndr/draw/UniformBlockLayout;", "block", "", "blockIndex", "begin", "end", "attributeIndex", "destroy", "Companion", "openrndr-gl3"})
@SourceDebugExtension(value={"SMAP\nShaderGL3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShaderGL3.kt\norg/openrndr/internal/gl3/ShaderGL3\n+ 2 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt\n+ 3 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n+ 4 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$checkGLErrors$1\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$debugGLErrors$1\n+ 8 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,405:1\n51#2,13:406\n65#2:422\n50#2,14:423\n65#2:438\n50#2,14:439\n65#2:454\n50#2,14:455\n65#2:470\n50#2,14:471\n65#2:486\n50#2,14:487\n65#2:502\n50#2,14:503\n65#2:518\n50#2,14:522\n65#2:537\n67#2,3:552\n51#2,13:555\n65#2,7:569\n50#2,14:582\n65#2:597\n68#2,2:608\n51#2,21:610\n67#2,3:634\n51#2,13:637\n65#2,7:651\n67#2,3:664\n51#2,13:667\n65#2,7:681\n69#3,3:419\n364#3,3:549\n334#3,3:579\n48#3,3:602\n324#3,3:605\n324#3,3:631\n344#3,3:661\n352#3,3:692\n50#4:437\n50#4:453\n50#4:469\n50#4:485\n50#4:501\n50#4:517\n50#4:536\n50#4:596\n11188#5:519\n11523#5,2:520\n11525#5:538\n1557#6:539\n1628#6,3:540\n1202#6,2:543\n1230#6,4:545\n67#7:568\n67#7:650\n67#7:680\n381#8,3:576\n384#8,4:598\n381#8,3:658\n384#8,4:688\n*S KotlinDebug\n*F\n+ 1 ShaderGL3.kt\norg/openrndr/internal/gl3/ShaderGL3\n*L\n209#1:406,13\n209#1:422\n231#1:423,14\n231#1:438\n243#1:439,14\n243#1:454\n255#1:455,14\n255#1:470\n264#1:471,14\n264#1:486\n274#1:487,14\n274#1:502\n284#1:503,14\n284#1:518\n293#1:522,14\n293#1:537\n329#1:552,3\n329#1:555,13\n329#1:569,7\n338#1:582,14\n338#1:597\n352#1:608,2\n352#1:610,21\n366#1:634,3\n366#1:637,13\n366#1:651,7\n373#1:664,3\n373#1:667,13\n373#1:681,7\n212#1:419,3\n328#1:549,3\n337#1:579,3\n345#1:602,3\n350#1:605,3\n364#1:631,3\n372#1:661,3\n380#1:692,3\n231#1:437\n243#1:453\n255#1:469\n264#1:485\n274#1:501\n284#1:517\n293#1:536\n338#1:596\n291#1:519\n291#1:520,2\n291#1:538\n298#1:539\n298#1:540,3\n307#1:543,2\n307#1:545,4\n329#1:568\n366#1:650\n373#1:680\n336#1:576,3\n336#1:598,4\n371#1:658,3\n371#1:688,4\n*E\n"})
public final class ShaderGL3
implements Shader,
ShaderUniformsGL3,
ShaderBufferBindingsGL3,
ShaderImageBindingsGL43 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int programObject;
    @NotNull
    private final String name;
    @Nullable
    private final Session session;
    private final int ssbo;
    @NotNull
    private final Map<String, Integer> ssboResourceIndices;
    private final boolean useProgramUniform;
    @NotNull
    private final Set<ShaderType> types;
    private boolean destroyed;
    private boolean running;
    @NotNull
    private Map<String, Integer> uniforms;
    @NotNull
    private Map<String, Integer> attributes;
    @NotNull
    private HashMap<String, Integer> blockBindings;
    @NotNull
    private final Map<String, Integer> blocks;

    public ShaderGL3(int programObject, @NotNull String name, @NotNull VertexShaderGL3 vertexShader, @Nullable TessellationControlShaderGL3 tessellationControlShader, @Nullable TessellationEvaluationShaderGL3 tessellationEvaluationShader, @Nullable GeometryShaderGL3 geometryShader, @NotNull FragmentShaderGL3 fragmentShader, @Nullable Session session) {
        Set<ShaderType> set;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(vertexShader, "vertexShader");
        Intrinsics.checkNotNullParameter(fragmentShader, "fragmentShader");
        this.programObject = programObject;
        this.name = name;
        this.session = session;
        this.ssbo = this.createSSBO();
        this.ssboResourceIndices = new LinkedHashMap();
        this.useProgramUniform = DriverGL3Kt.getCapabilities(Driver.Companion).getProgramUniform();
        if (geometryShader != null) {
            ShaderType[] shaderTypeArray = new ShaderType[]{ShaderType.VERTEX, ShaderType.GEOMETRY, ShaderType.FRAGMENT};
            set = SetsKt.setOf(shaderTypeArray);
        } else {
            ShaderType[] shaderTypeArray = new ShaderType[]{ShaderType.VERTEX, ShaderType.FRAGMENT};
            set = SetsKt.setOf(shaderTypeArray);
        }
        this.types = set;
        this.uniforms = new HashMap();
        this.attributes = new HashMap();
        this.blockBindings = new HashMap();
        this.blocks = new HashMap();
    }

    @Override
    public int getProgramObject() {
        return this.programObject;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Session getSession() {
        return this.session;
    }

    @Override
    public int getSsbo() {
        return this.ssbo;
    }

    @Override
    @NotNull
    public Map<String, Integer> getSsboResourceIndices() {
        return this.ssboResourceIndices;
    }

    @Override
    public boolean getUseProgramUniform() {
        return this.useProgramUniform;
    }

    @Override
    @NotNull
    public Set<ShaderType> getTypes() {
        return this.types;
    }

    @Override
    @NotNull
    public Map<String, Integer> getUniforms() {
        return this.uniforms;
    }

    public void setUniforms(@NotNull Map<String, Integer> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        this.uniforms = map2;
    }

    @Override
    public boolean hasUniform(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.uniformIndex(name, true) != -1;
    }

    @Override
    @Nullable
    public UniformBlock createBlock(@NotNull String blockName) {
        Intrinsics.checkNotNullParameter(blockName, "blockName");
        UniformBlockLayout layout = this.blockLayout(blockName);
        return layout != null ? (UniformBlock)UniformBlockGL3.Companion.create(layout) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public UniformBlockLayout blockLayout(@NotNull String blockName) {
        Intrinsics.checkNotNullParameter(blockName, "blockName");
        int blockIndex = this.blockIndex(blockName);
        if (blockIndex == -1) {
            return null;
        }
        ShaderGL3 $this$blockLayout_u24lambda_u241 = this;
        boolean bl = false;
        IntBuffer intBuffer = BufferUtils.createIntBuffer(1);
        Intrinsics.checkNotNullExpressionValue(intBuffer, "createIntBuffer(...)");
        IntBuffer blockSizeBuffer = intBuffer;
        GLGLESKt.glGetActiveUniformBlockiv($this$blockLayout_u24lambda_u241.getProgramObject(), blockIndex, 35392, blockSizeBuffer);
        boolean $i$f$checkGLErrors = false;
        int error$iv = GLGLESKt.glGetError();
        if (error$iv != 0) {
            String string;
            void it;
            Object message$iv = switch (error$iv) {
                case 1282 -> "GL_INVALID_OPERATION";
                case 1281 -> "GL_INVALID_VALUE";
                case 1280 -> "GL_INVALID_ENUM";
                case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                case 1285 -> "GL_OUT_OF_MEMORY";
                case 1284 -> "GL_STACK_UNDERFLOW";
                case 1283 -> "GL_STACK_OVERFLOW";
                default -> "<untranslated: " + error$iv + ">";
            };
            int n = error$iv;
            Object object = message$iv;
            long l = Driver.Companion.getInstance().getContextID();
            boolean bl2 = false;
            if (it == 1281) {
                int n2 = 35382;
                boolean $i$f$glGetInteger = false;
                string = "uniformBlockIndex (" + blockIndex + ") is greater than or equal to the value of GL_ACTIVE_UNIFORM_BLOCKS (" + (switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                    case 1 -> {
                        void pname$iv;
                        yield GL45C.glGetInteger((int)pname$iv);
                    }
                    case 2 -> {
                        void pname$iv;
                        yield GLES32.glGetInteger((int)pname$iv);
                    }
                    default -> throw new NoWhenBranchMatchedException();
                }) + ") or is not the index of an active uniform block in program.\n";
            } else {
                string = null;
            }
            String string2 = string;
            String string3 = "[context=" + l + "] GL ERROR: " + (String)object + " " + string2;
            throw new GL3Exception(string3);
        }
        int blockSize = blockSizeBuffer.get(0);
        if (blockSize != 0) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Object object;
            Object object2;
            Object $this$mapTo$iv$iv;
            ShaderGL3 $this$blockLayout_u24lambda_u242 = this;
            boolean bl3 = false;
            IntBuffer intBuffer2 = BufferUtils.createIntBuffer(1);
            Intrinsics.checkNotNullExpressionValue(intBuffer2, "createIntBuffer(...)");
            IntBuffer uniformCountBuffer = intBuffer2;
            GLGLESKt.glGetActiveUniformBlockiv($this$blockLayout_u24lambda_u242.getProgramObject(), blockIndex, 35394, uniformCountBuffer);
            boolean $i$f$checkGLErrors2 = false;
            int error$iv2 = GLGLESKt.glGetError();
            if (error$iv2 != 0) {
                Object message$iv = switch (error$iv2) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv2 + ">";
                };
                int n = error$iv2;
                Object object3 = message$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean $i$a$-checkGLErrors-ErrorGL3Kt$checkGLErrors$3 = false;
                int it = n;
                Object $i$f$glGetInteger = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object3 + " " + $i$f$glGetInteger;
                throw new GL3Exception(string);
            }
            int uniformCount = uniformCountBuffer.get(0);
            IntBuffer intBuffer3 = BufferUtils.createIntBuffer(uniformCount);
            Intrinsics.checkNotNullExpressionValue(intBuffer3, "createIntBuffer(...)");
            IntBuffer uniformIndicesBuffer = intBuffer3;
            ShaderGL3 $this$blockLayout_u24lambda_u243 = this;
            boolean bl4 = false;
            GLGLESKt.glGetActiveUniformBlockiv($this$blockLayout_u24lambda_u243.getProgramObject(), blockIndex, 35395, uniformIndicesBuffer);
            boolean $i$f$checkGLErrors3 = false;
            int error$iv3 = GLGLESKt.glGetError();
            if (error$iv3 != 0) {
                Object message$iv = switch (error$iv3) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv3 + ">";
                };
                int n = error$iv3;
                Object object4 = message$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean $i$a$-checkGLErrors-ErrorGL3Kt$checkGLErrors$5 = false;
                int it = n;
                Object var20_59 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object4 + " " + var20_59;
                throw new GL3Exception(string);
            }
            ((Buffer)uniformIndicesBuffer).rewind();
            int[] array = new int[uniformCount];
            uniformIndicesBuffer.get(array);
            int[] uniformIndices = array;
            ((Buffer)uniformIndicesBuffer).rewind();
            ShaderGL3 $this$blockLayout_u24lambda_u244 = this;
            boolean bl5 = false;
            IntBuffer intBuffer4 = BufferUtils.createIntBuffer(uniformCount);
            Intrinsics.checkNotNullExpressionValue(intBuffer4, "createIntBuffer(...)");
            IntBuffer buffer = intBuffer4;
            GLGLESKt.glGetActiveUniformsiv($this$blockLayout_u24lambda_u244.getProgramObject(), uniformIndicesBuffer, 35383, buffer);
            boolean $i$f$checkGLErrors4 = false;
            int error$iv4 = GLGLESKt.glGetError();
            if (error$iv4 != 0) {
                Object message$iv = switch (error$iv4) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv4 + ">";
                };
                int n = error$iv4;
                Object object5 = message$iv;
                long bl2 = Driver.Companion.getInstance().getContextID();
                boolean bl6 = false;
                int it = n;
                Object var22_88 = null;
                String string = "[context=" + bl2 + "] GL ERROR: " + (String)object5 + " " + var22_88;
                throw new GL3Exception(string);
            }
            Intrinsics.checkNotNull(buffer, "null cannot be cast to non-null type java.nio.Buffer");
            ((Buffer)buffer).rewind();
            int[] array2 = new int[uniformCount];
            buffer.get(array2);
            int[] uniformTypes = array2;
            ShaderGL3 $this$blockLayout_u24lambda_u245 = this;
            boolean bl7 = false;
            IntBuffer intBuffer5 = BufferUtils.createIntBuffer(uniformCount);
            Intrinsics.checkNotNullExpressionValue(intBuffer5, "createIntBuffer(...)");
            IntBuffer buffer2 = intBuffer5;
            GLGLESKt.glGetActiveUniformsiv($this$blockLayout_u24lambda_u245.getProgramObject(), uniformIndicesBuffer, 35384, buffer2);
            boolean $i$f$checkGLErrors5 = false;
            int error$iv5 = GLGLESKt.glGetError();
            if (error$iv5 != 0) {
                Object message$iv = switch (error$iv5) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv5 + ">";
                };
                int n = error$iv5;
                Object bl2 = message$iv;
                long $i$a$-checkGLErrors-ErrorGL3Kt$checkGLErrors$3 = Driver.Companion.getInstance().getContextID();
                boolean $i$a$-checkGLErrors-ErrorGL3Kt$checkGLErrors$2 = false;
                int it = n;
                array2 = null;
                String string = "[context=" + $i$a$-checkGLErrors-ErrorGL3Kt$checkGLErrors$3 + "] GL ERROR: " + (String)bl2 + " " + array2;
                throw new GL3Exception(string);
            }
            Intrinsics.checkNotNull(buffer2, "null cannot be cast to non-null type java.nio.Buffer");
            ((Buffer)buffer2).rewind();
            int[] array3 = new int[uniformCount];
            buffer2.get(array3);
            int[] uniformSizes = array3;
            ShaderGL3 $this$blockLayout_u24lambda_u246 = this;
            boolean bl8 = false;
            IntBuffer intBuffer6 = BufferUtils.createIntBuffer(uniformCount);
            Intrinsics.checkNotNullExpressionValue(intBuffer6, "createIntBuffer(...)");
            IntBuffer buffer3 = intBuffer6;
            GLGLESKt.glGetActiveUniformsiv($this$blockLayout_u24lambda_u246.getProgramObject(), uniformIndicesBuffer, 35387, buffer3);
            boolean $i$f$checkGLErrors6 = false;
            int error$iv6 = GLGLESKt.glGetError();
            if (error$iv6 != 0) {
                Object message$iv = switch (error$iv6) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv6 + ">";
                };
                int bl2 = error$iv6;
                Object $i$a$-checkGLErrors-ErrorGL3Kt$checkGLErrors$3 = message$iv;
                long $i$a$-checkGLErrors-ErrorGL3Kt$checkGLErrors$5 = Driver.Companion.getInstance().getContextID();
                boolean $i$a$-checkGLErrors-ErrorGL3Kt$checkGLErrors$4 = false;
                int it = bl2;
                array3 = null;
                String string = "[context=" + $i$a$-checkGLErrors-ErrorGL3Kt$checkGLErrors$5 + "] GL ERROR: " + (String)$i$a$-checkGLErrors-ErrorGL3Kt$checkGLErrors$3 + " " + array3;
                throw new GL3Exception(string);
            }
            Intrinsics.checkNotNull(buffer3, "null cannot be cast to non-null type java.nio.Buffer");
            ((Buffer)buffer3).rewind();
            int[] array4 = new int[uniformCount];
            buffer3.get(array4);
            int[] uniformOffsets = array4;
            ShaderGL3 $this$blockLayout_u24lambda_u247 = this;
            boolean bl9 = false;
            IntBuffer intBuffer7 = BufferUtils.createIntBuffer(uniformCount);
            Intrinsics.checkNotNullExpressionValue(intBuffer7, "createIntBuffer(...)");
            Object buffer4 = intBuffer7;
            GLGLESKt.glGetActiveUniformsiv($this$blockLayout_u24lambda_u247.getProgramObject(), uniformIndicesBuffer, 35388, (IntBuffer)buffer4);
            boolean $i$f$checkGLErrors7 = false;
            int error$iv7 = GLGLESKt.glGetError();
            if (error$iv7 != 0) {
                Object message$iv = switch (error$iv7) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv7 + ">";
                };
                int $i$a$-checkGLErrors-ErrorGL3Kt$checkGLErrors$3 = error$iv7;
                Object $i$a$-checkGLErrors-ErrorGL3Kt$checkGLErrors$5 = message$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl10 = false;
                int it = $i$a$-checkGLErrors-ErrorGL3Kt$checkGLErrors$3;
                array4 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)$i$a$-checkGLErrors-ErrorGL3Kt$checkGLErrors$5 + " " + array4;
                throw new GL3Exception(string);
            }
            Intrinsics.checkNotNull(buffer4, "null cannot be cast to non-null type java.nio.Buffer");
            ((Buffer)buffer4).rewind();
            int[] array5 = new int[uniformCount];
            ((IntBuffer)buffer4).get(array5);
            int[] uniformStrides = array5;
            Object $this$map$iv = uniformIndices;
            boolean $i$f$map = false;
            buffer4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((int[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (int item$iv$iv2 : $this$mapTo$iv$iv) {
                void it;
                void var20_61 = item$iv$iv2;
                Collection collection = destination$iv$iv;
                boolean bl11 = false;
                object2 = GLGLESKt.glGetActiveUniformName(this.getProgramObject(), (int)it, 128);
                String it2 = object2;
                boolean bl12 = false;
                boolean $i$f$checkGLErrors8 = false;
                int error$iv8 = GLGLESKt.glGetError();
                if (error$iv8 != 0) {
                    Object message$iv = switch (error$iv8) {
                        case 1282 -> "GL_INVALID_OPERATION";
                        case 1281 -> "GL_INVALID_VALUE";
                        case 1280 -> "GL_INVALID_ENUM";
                        case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                        case 1285 -> "GL_OUT_OF_MEMORY";
                        case 1284 -> "GL_STACK_UNDERFLOW";
                        case 1283 -> "GL_STACK_OVERFLOW";
                        default -> "<untranslated: " + error$iv8 + ">";
                    };
                    int n = error$iv8;
                    Object object6 = message$iv;
                    long l = Driver.Companion.getInstance().getContextID();
                    boolean bl13 = false;
                    int it3 = n;
                    Object var33_110 = null;
                    String string = "[context=" + l + "] GL ERROR: " + (String)object6 + " " + var33_110;
                    throw new GL3Exception(string);
                }
                collection.add(object2);
            }
            List uniformNames = (List)destination$iv$iv;
            $this$map$iv = RangesKt.until(0, uniformCount);
            int n = blockSize;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            Iterator message$iv = $this$mapTo$iv$iv.iterator();
            while (message$iv.hasNext()) {
                void it;
                int item$iv$iv;
                int item$iv$iv2;
                item$iv$iv2 = item$iv$iv = ((IntIterator)message$iv).nextInt();
                object = destination$iv$iv;
                boolean bl14 = false;
                CharSequence bl11 = (CharSequence)uniformNames.get((int)it);
                object2 = new Regex("\\[.*\\]");
                String string = "";
                object.add(new UniformDescription(((Regex)object2).replace(bl11, string), ShaderGL3Kt.access$toUniformType(uniformTypes[it]), uniformSizes[it], uniformOffsets[it], uniformStrides[it]));
            }
            object = (List)destination$iv$iv;
            $this$map$iv = (Iterable)object;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
            destination$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                UniformDescription bl14 = (UniformDescription)element$iv$iv;
                object = destination$iv$iv2;
                boolean bl15 = false;
                object.put(it.getName(), element$iv$iv);
            }
            Object object7 = object = destination$iv$iv2;
            int n3 = n;
            return new UniformBlockLayout(n3, (Map<String, UniformDescription>)object7);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void block(@NotNull String blockName, @NotNull UniformBlock block) {
        Intrinsics.checkNotNullParameter(blockName, "blockName");
        Intrinsics.checkNotNullParameter(block, "block");
        if (!Intrinsics.areEqual(Thread.currentThread(), ((UniformBlockGL3)block).getThread$openrndr_gl3())) {
            throw new IllegalStateException("block is created on " + ((UniformBlockGL3)block).getThread$openrndr_gl3() + " and is now used on " + Thread.currentThread());
        }
        if (!this.running) {
            throw new IllegalStateException("use begin() before setting blocks");
        }
        int blockIndex = this.blockIndex(blockName);
        if (blockIndex != -1) {
            Integer n = this.blockBindings.get(blockName);
            int n2 = ((UniformBlockGL3)block).getBlockBinding();
            if (n == null || n != n2) {
                n2 = this.getProgramObject();
                int uniformBlockBinding$iv = ((UniformBlockGL3)block).getBlockBinding();
                boolean $i$f$glUniformBlockBinding = false;
                switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                    case 1: {
                        void program$iv;
                        GL45C.glUniformBlockBinding((int)program$iv, blockIndex, uniformBlockBinding$iv);
                        break;
                    }
                    case 2: {
                        void program$iv;
                        GLES32.glUniformBlockBinding((int)program$iv, blockIndex, uniformBlockBinding$iv);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                boolean $i$f$debugGLErrors = false;
                if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                    boolean $i$f$checkGLErrors = false;
                    int error$iv$iv = GLGLESKt.glGetError();
                    if (error$iv$iv != 0) {
                        Object message$iv$iv = switch (error$iv$iv) {
                            case 1282 -> "GL_INVALID_OPERATION";
                            case 1281 -> "GL_INVALID_VALUE";
                            case 1280 -> "GL_INVALID_ENUM";
                            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                            case 1285 -> "GL_OUT_OF_MEMORY";
                            case 1284 -> "GL_STACK_UNDERFLOW";
                            case 1283 -> "GL_STACK_OVERFLOW";
                            default -> "<untranslated: " + error$iv$iv + ">";
                        };
                        int n3 = error$iv$iv;
                        Object object = message$iv$iv;
                        long l = Driver.Companion.getInstance().getContextID();
                        boolean bl = false;
                        int it = n3;
                        Object var14_13 = null;
                        String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var14_13;
                        throw new GL3Exception(string);
                    }
                }
                ((Map)this.blockBindings).put(blockName, ((UniformBlockGL3)block).getBlockBinding());
            }
        }
    }

    private final int blockIndex(String block) {
        Integer n;
        Map<String, Integer> $this$getOrPut$iv = this.blocks;
        boolean $i$f$getOrPut = false;
        Integer value$iv = $this$getOrPut$iv.get(block);
        if (value$iv == null) {
            int n2;
            boolean bl = false;
            int program$iv = this.getProgramObject();
            boolean $i$f$glGetUniformBlockIndex = false;
            int it = n2 = (switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1 -> GL45C.glGetUniformBlockIndex(program$iv, block);
                case 2 -> GLES32.glGetUniformBlockIndex(program$iv, block);
                default -> throw new NoWhenBranchMatchedException();
            });
            boolean bl2 = false;
            boolean $i$f$checkGLErrors = false;
            int error$iv = GLGLESKt.glGetError();
            if (error$iv != 0) {
                Object message$iv = switch (error$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv + ">";
                };
                int n3 = error$iv;
                Object object = message$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl3 = false;
                int it2 = n3;
                Object var17_16 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var17_16;
                throw new GL3Exception(string);
            }
            Integer answer$iv = n2;
            $this$getOrPut$iv.put(block, answer$iv);
            n = answer$iv;
        } else {
            n = value$iv;
        }
        return ((Number)n).intValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void begin() {
        if (this.getSsbo() != -1) {
            int n = 37074;
            int buffer$iv = this.getSsbo();
            boolean $i$f$glBindBuffer = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    void target$iv;
                    GL45C.glBindBuffer((int)target$iv, buffer$iv);
                    break;
                }
                case 2: {
                    void target$iv;
                    GLES32.glBindBuffer((int)target$iv, buffer$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        ShaderGL3Kt.access$getLogger$p().trace(() -> ShaderGL3.begin$lambda$14(this));
        this.running = true;
        int program$iv = this.getProgramObject();
        boolean $i$f$glUseProgram = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                GL45C.glUseProgram(program$iv);
                break;
            }
            case 2: {
                GLES32.glUseProgram(program$iv);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object object;
                void it;
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n = error$iv$iv;
                Object object2 = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                switch (it) {
                    case 1281: {
                        object = "program is neither 0 nor a value generated by OpenGL";
                        break;
                    }
                    case 1282: {
                        object = "program (" + this.getProgramObject() + ") is not a program object / program could not be made part of current state / transform feedback mode is active.";
                        break;
                    }
                    default: {
                        object = null;
                    }
                }
                Object object3 = object;
                String string = "[context=" + l + "] GL ERROR: " + (String)object2 + " " + object3;
                throw new GL3Exception(string);
            }
        }
    }

    @Override
    public void end() {
        ShaderGL3Kt.access$getLogger$p().trace(() -> ShaderGL3.end$lambda$16(this));
        int program$iv = 0;
        boolean $i$f$glUseProgram = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                GL45C.glUseProgram(program$iv);
                break;
            }
            case 2: {
                GLES32.glUseProgram(program$iv);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var11_10 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var11_10;
                throw new GL3Exception(string);
            }
        }
        this.running = false;
    }

    public final int attributeIndex(@NotNull String name) {
        Integer n;
        Intrinsics.checkNotNullParameter(name, "name");
        Map<String, Integer> $this$getOrPut$iv = this.attributes;
        boolean $i$f$getOrPut = false;
        Integer value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl = false;
            int program$iv = this.getProgramObject();
            boolean $i$f$glGetAttribLocation = false;
            int location = switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1 -> GL45C.glGetAttribLocation(program$iv, name);
                case 2 -> GLES32.glGetAttribLocation(program$iv, name);
                default -> throw new NoWhenBranchMatchedException();
            };
            boolean $i$f$debugGLErrors = false;
            if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                boolean $i$f$checkGLErrors = false;
                int error$iv$iv = GLGLESKt.glGetError();
                if (error$iv$iv != 0) {
                    Object message$iv$iv = switch (error$iv$iv) {
                        case 1282 -> "GL_INVALID_OPERATION";
                        case 1281 -> "GL_INVALID_VALUE";
                        case 1280 -> "GL_INVALID_ENUM";
                        case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                        case 1285 -> "GL_OUT_OF_MEMORY";
                        case 1284 -> "GL_STACK_UNDERFLOW";
                        case 1283 -> "GL_STACK_OVERFLOW";
                        default -> "<untranslated: " + error$iv$iv + ">";
                    };
                    int n2 = error$iv$iv;
                    Object object = message$iv$iv;
                    long l = Driver.Companion.getInstance().getContextID();
                    boolean bl2 = false;
                    int it = n2;
                    Object var17_16 = null;
                    String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var17_16;
                    throw new GL3Exception(string);
                }
            }
            Integer answer$iv = location;
            $this$getOrPut$iv.put(name, answer$iv);
            n = answer$iv;
        } else {
            n = value$iv;
        }
        return ((Number)n).intValue();
    }

    @Override
    public void destroy() {
        if (!this.destroyed) {
            Session session = this.getSession();
            if (session != null) {
                session.untrack(this);
            }
            int program$iv = this.getProgramObject();
            boolean $i$f$glDeleteProgram = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glDeleteProgram(program$iv);
                    break;
                }
                case 2: {
                    GLES32.glDeleteProgram(program$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.destroyed = true;
            Driver driver = Driver.Companion.getInstance();
            Intrinsics.checkNotNull(driver, "null cannot be cast to non-null type org.openrndr.internal.gl3.DriverGL3");
            ((DriverGL3)driver).destroyVAOsForShader(this);
            Session.Companion.getActive().untrack(this);
        }
    }

    @Override
    public void image(@NotNull String name, int image, @NotNull ImageBinding imageBinding) {
        ShaderImageBindingsGL43.DefaultImpls.image((ShaderImageBindingsGL43)this, name, image, imageBinding);
    }

    @Override
    public void image(@NotNull String name, int image, @NotNull ImageBinding[] imageBinding) {
        ShaderImageBindingsGL43.DefaultImpls.image((ShaderImageBindingsGL43)this, name, image, imageBinding);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Matrix33 value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Matrix44 value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull ColorRGBa value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Vector4 value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Vector3 value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Vector2 value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull IntVector2 value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull IntVector3 value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull IntVector4 value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull BooleanVector2 value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull BooleanVector3 value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull BooleanVector4 value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, float x, float y, float z, float w) {
        ShaderUniformsGL3.DefaultImpls.uniform(this, name, x, y, z, w);
    }

    @Override
    public void uniform(@NotNull String name, float x, float y, float z) {
        ShaderUniformsGL3.DefaultImpls.uniform(this, name, x, y, z);
    }

    @Override
    public void uniform(@NotNull String name, float x, float y) {
        ShaderUniformsGL3.DefaultImpls.uniform(this, name, x, y);
    }

    @Override
    public void uniform(@NotNull String name, double value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, float value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, int value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, boolean value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull IntVector4[] value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull IntVector3[] value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull IntVector2[] value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Vector4[] value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Vector3[] value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Vector2[] value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull float[] value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull int[] value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull ColorRGBa[] value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Double[] value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Matrix33[] value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void uniform(@NotNull String name, @NotNull Matrix44[] value) {
        ShaderUniformsGL3.DefaultImpls.uniform((ShaderUniformsGL3)this, name, value);
    }

    @Override
    public void buffer(@NotNull String name, @NotNull VertexBuffer vertexBuffer) {
        ShaderBufferBindingsGL3.DefaultImpls.buffer((ShaderBufferBindingsGL3)this, name, vertexBuffer);
    }

    @Override
    public void buffer(@NotNull String name, @NotNull ShaderStorageBuffer shaderStorageBuffer) {
        ShaderBufferBindingsGL3.DefaultImpls.buffer((ShaderBufferBindingsGL3)this, name, shaderStorageBuffer);
    }

    @Override
    public void buffer(@NotNull String name, @NotNull AtomicCounterBuffer counterBuffer) {
        ShaderBufferBindingsGL3.DefaultImpls.buffer((ShaderBufferBindingsGL3)this, name, counterBuffer);
    }

    @Override
    public void bound(@NotNull Function0<Unit> f) {
        ShaderUniformsGL3.DefaultImpls.bound(this, f);
    }

    @Override
    public int uniformIndex(@NotNull String uniform, boolean query) {
        return ShaderUniformsGL3.DefaultImpls.uniformIndex(this, uniform, query);
    }

    @Override
    public int resourceIndex(@NotNull String name) {
        return ShaderBufferBindingsGL3.DefaultImpls.resourceIndex(this, name);
    }

    @Override
    public int createSSBO() {
        return ShaderBufferBindingsGL3.DefaultImpls.createSSBO(this);
    }

    private static final Object begin$lambda$14(ShaderGL3 this$0) {
        return "shader begin " + this$0.getName();
    }

    private static final Object end$lambda$16(ShaderGL3 this$0) {
        return "shader end " + this$0.getName();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/openrndr/internal/gl3/ShaderGL3$Companion;", "", "<init>", "()V", "create", "Lorg/openrndr/internal/gl3/ShaderGL3;", "vertexShader", "Lorg/openrndr/internal/gl3/VertexShaderGL3;", "tessellationControlShader", "Lorg/openrndr/internal/gl3/TessellationControlShaderGL3;", "tessellationEvaluationShader", "Lorg/openrndr/internal/gl3/TessellationEvaluationShaderGL3;", "geometryShader", "Lorg/openrndr/internal/gl3/GeometryShaderGL3;", "fragmentShader", "Lorg/openrndr/internal/gl3/FragmentShaderGL3;", "name", "", "session", "Lorg/openrndr/draw/Session;", "openrndr-gl3"})
    @SourceDebugExtension(value={"SMAP\nShaderGL3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShaderGL3.kt\norg/openrndr/internal/gl3/ShaderGL3$Companion\n+ 2 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt\n+ 3 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$debugGLErrors$1\n+ 4 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n*L\n1#1,405:1\n67#2,3:406\n51#2,13:409\n65#2,7:423\n67#2,3:430\n51#2,13:433\n65#2,7:447\n67#2,3:454\n51#2,13:457\n65#2,7:471\n67#2,3:478\n51#2,13:481\n65#2,7:495\n67#2,3:502\n51#2,13:505\n65#2,7:519\n67#2,3:526\n51#2,13:529\n65#2,7:543\n67#2,3:550\n51#2,13:553\n65#2,7:567\n67#2,3:574\n51#2,13:577\n65#2,7:591\n67#2,3:598\n51#2,13:601\n65#2,7:615\n67#3:422\n67#3:446\n67#3:470\n67#3:494\n67#3:518\n67#3:542\n67#3:566\n67#3:590\n67#3:614\n316#4,3:622\n*S KotlinDebug\n*F\n+ 1 ShaderGL3.kt\norg/openrndr/internal/gl3/ShaderGL3$Companion\n*L\n131#1:406,3\n131#1:409,13\n131#1:423,7\n134#1:430,3\n134#1:433,13\n134#1:447,7\n137#1:454,3\n137#1:457,13\n137#1:471,7\n141#1:478,3\n141#1:481,13\n141#1:495,7\n146#1:502,3\n146#1:505,13\n146#1:519,7\n151#1:526,3\n151#1:529,13\n151#1:543,7\n155#1:550,3\n155#1:553,13\n155#1:567,7\n158#1:574,3\n158#1:577,13\n158#1:591,7\n162#1:598,3\n162#1:601,13\n162#1:615,7\n131#1:422\n134#1:446\n137#1:470\n141#1:494\n146#1:518\n151#1:542\n155#1:566\n158#1:590\n162#1:614\n167#1:622,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final ShaderGL3 create(@NotNull VertexShaderGL3 vertexShader, @Nullable TessellationControlShaderGL3 tessellationControlShader, @Nullable TessellationEvaluationShaderGL3 tessellationEvaluationShader, @Nullable GeometryShaderGL3 geometryShader, @NotNull FragmentShaderGL3 fragmentShader, @NotNull String name, @Nullable Session session) {
            Intrinsics.checkNotNullParameter(vertexShader, "vertexShader");
            Intrinsics.checkNotNullParameter(fragmentShader, "fragmentShader");
            Intrinsics.checkNotNullParameter(name, "name");
            Driver driver = Driver.Companion.getInstance();
            synchronized (driver) {
                int it;
                int error$iv$iv;
                boolean $i$f$checkGLErrors;
                boolean $i$f$debugGLErrors;
                int error$iv$iv2;
                boolean $i$f$checkGLErrors2;
                boolean bl = false;
                boolean $i$f$debugGLErrors2 = false;
                if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                    boolean $i$f$checkGLErrors3 = false;
                    int error$iv$iv3 = GLGLESKt.glGetError();
                    if (error$iv$iv3 != 0) {
                        Object message$iv$iv = switch (error$iv$iv3) {
                            case 1282 -> "GL_INVALID_OPERATION";
                            case 1281 -> "GL_INVALID_VALUE";
                            case 1280 -> "GL_INVALID_ENUM";
                            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                            case 1285 -> "GL_OUT_OF_MEMORY";
                            case 1284 -> "GL_STACK_UNDERFLOW";
                            case 1283 -> "GL_STACK_OVERFLOW";
                            default -> "<untranslated: " + error$iv$iv3 + ">";
                        };
                        int n = error$iv$iv3;
                        Object object = message$iv$iv;
                        long l = Driver.Companion.getInstance().getContextID();
                        boolean bl2 = false;
                        int it2 = n;
                        Object var19_44 = null;
                        String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var19_44;
                        throw new GL3Exception(string);
                    }
                }
                int program2 = GLGLESKt.glCreateProgram();
                boolean $i$f$debugGLErrors3 = false;
                if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                    $i$f$checkGLErrors2 = false;
                    error$iv$iv2 = GLGLESKt.glGetError();
                    if (error$iv$iv2 != 0) {
                        Object message$iv$iv = switch (error$iv$iv2) {
                            case 1282 -> "GL_INVALID_OPERATION";
                            case 1281 -> "GL_INVALID_VALUE";
                            case 1280 -> "GL_INVALID_ENUM";
                            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                            case 1285 -> "GL_OUT_OF_MEMORY";
                            case 1284 -> "GL_STACK_UNDERFLOW";
                            case 1283 -> "GL_STACK_OVERFLOW";
                            default -> "<untranslated: " + error$iv$iv2 + ">";
                        };
                        int bl2 = error$iv$iv2;
                        Object object = message$iv$iv;
                        long l = Driver.Companion.getInstance().getContextID();
                        boolean $i$a$-debugGLErrors-ErrorGL3Kt$debugGLErrors$2 = false;
                        int it3 = bl2;
                        Object var19_45 = null;
                        String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var19_45;
                        throw new GL3Exception(string);
                    }
                }
                GLGLESKt.glAttachShader(program2, vertexShader.getShaderObject());
                $i$f$debugGLErrors3 = false;
                if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                    $i$f$checkGLErrors2 = false;
                    error$iv$iv2 = GLGLESKt.glGetError();
                    if (error$iv$iv2 != 0) {
                        Object message$iv$iv = switch (error$iv$iv2) {
                            case 1282 -> "GL_INVALID_OPERATION";
                            case 1281 -> "GL_INVALID_VALUE";
                            case 1280 -> "GL_INVALID_ENUM";
                            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                            case 1285 -> "GL_OUT_OF_MEMORY";
                            case 1284 -> "GL_STACK_UNDERFLOW";
                            case 1283 -> "GL_STACK_OVERFLOW";
                            default -> "<untranslated: " + error$iv$iv2 + ">";
                        };
                        int it3 = error$iv$iv2;
                        Object object = message$iv$iv;
                        long l = Driver.Companion.getInstance().getContextID();
                        boolean $i$a$-debugGLErrors-ErrorGL3Kt$debugGLErrors$3 = false;
                        Object var19_46 = null;
                        String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var19_46;
                        throw new GL3Exception(string);
                    }
                }
                TessellationControlShaderGL3 tessellationControlShaderGL3 = tessellationControlShader;
                if (tessellationControlShaderGL3 != null) {
                    TessellationControlShaderGL3 it4 = tessellationControlShaderGL3;
                    boolean bl3 = false;
                    GLGLESKt.glAttachShader(program2, it4.getShaderObject());
                    $i$f$debugGLErrors = false;
                    if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                        $i$f$checkGLErrors = false;
                        error$iv$iv = GLGLESKt.glGetError();
                        if (error$iv$iv != 0) {
                            Object message$iv$iv = switch (error$iv$iv) {
                                case 1282 -> "GL_INVALID_OPERATION";
                                case 1281 -> "GL_INVALID_VALUE";
                                case 1280 -> "GL_INVALID_ENUM";
                                case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                                case 1285 -> "GL_OUT_OF_MEMORY";
                                case 1284 -> "GL_STACK_UNDERFLOW";
                                case 1283 -> "GL_STACK_OVERFLOW";
                                default -> "<untranslated: " + error$iv$iv + ">";
                            };
                            int n = error$iv$iv;
                            Object object = message$iv$iv;
                            long l = Driver.Companion.getInstance().getContextID();
                            boolean bl4 = false;
                            int it5 = n;
                            Object var27_75 = null;
                            String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var27_75;
                            throw new GL3Exception(string);
                        }
                    }
                }
                TessellationEvaluationShaderGL3 tessellationEvaluationShaderGL3 = tessellationEvaluationShader;
                if (tessellationEvaluationShaderGL3 != null) {
                    TessellationEvaluationShaderGL3 it6 = tessellationEvaluationShaderGL3;
                    boolean bl5 = false;
                    GLGLESKt.glAttachShader(program2, it6.getShaderObject());
                    $i$f$debugGLErrors = false;
                    if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                        $i$f$checkGLErrors = false;
                        error$iv$iv = GLGLESKt.glGetError();
                        if (error$iv$iv != 0) {
                            Object message$iv$iv = switch (error$iv$iv) {
                                case 1282 -> "GL_INVALID_OPERATION";
                                case 1281 -> "GL_INVALID_VALUE";
                                case 1280 -> "GL_INVALID_ENUM";
                                case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                                case 1285 -> "GL_OUT_OF_MEMORY";
                                case 1284 -> "GL_STACK_UNDERFLOW";
                                case 1283 -> "GL_STACK_OVERFLOW";
                                default -> "<untranslated: " + error$iv$iv + ">";
                            };
                            int it5 = error$iv$iv;
                            Object object = message$iv$iv;
                            long l = Driver.Companion.getInstance().getContextID();
                            boolean bl6 = false;
                            Object var27_76 = null;
                            String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var27_76;
                            throw new GL3Exception(string);
                        }
                    }
                }
                GeometryShaderGL3 geometryShaderGL3 = geometryShader;
                if (geometryShaderGL3 != null) {
                    GeometryShaderGL3 it7 = geometryShaderGL3;
                    boolean bl7 = false;
                    GLGLESKt.glAttachShader(program2, it7.getShaderObject());
                    $i$f$debugGLErrors = false;
                    if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                        $i$f$checkGLErrors = false;
                        error$iv$iv = GLGLESKt.glGetError();
                        if (error$iv$iv != 0) {
                            Object message$iv$iv = switch (error$iv$iv) {
                                case 1282 -> "GL_INVALID_OPERATION";
                                case 1281 -> "GL_INVALID_VALUE";
                                case 1280 -> "GL_INVALID_ENUM";
                                case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                                case 1285 -> "GL_OUT_OF_MEMORY";
                                case 1284 -> "GL_STACK_UNDERFLOW";
                                case 1283 -> "GL_STACK_OVERFLOW";
                                default -> "<untranslated: " + error$iv$iv + ">";
                            };
                            int it8 = error$iv$iv;
                            Object object = message$iv$iv;
                            long l = Driver.Companion.getInstance().getContextID();
                            boolean bl8 = false;
                            Object var27_77 = null;
                            String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var27_77;
                            throw new GL3Exception(string);
                        }
                    }
                }
                GLGLESKt.glAttachShader(program2, fragmentShader.getShaderObject());
                $i$f$debugGLErrors = false;
                if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                    $i$f$checkGLErrors2 = false;
                    error$iv$iv2 = GLGLESKt.glGetError();
                    if (error$iv$iv2 != 0) {
                        Object message$iv$iv = switch (error$iv$iv2) {
                            case 1282 -> "GL_INVALID_OPERATION";
                            case 1281 -> "GL_INVALID_VALUE";
                            case 1280 -> "GL_INVALID_ENUM";
                            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                            case 1285 -> "GL_OUT_OF_MEMORY";
                            case 1284 -> "GL_STACK_UNDERFLOW";
                            case 1283 -> "GL_STACK_OVERFLOW";
                            default -> "<untranslated: " + error$iv$iv2 + ">";
                        };
                        error$iv$iv = error$iv$iv2;
                        Object object = message$iv$iv;
                        long l = Driver.Companion.getInstance().getContextID();
                        boolean bl9 = false;
                        it = error$iv$iv;
                        Object var19_47 = null;
                        String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var19_47;
                        throw new GL3Exception(string);
                    }
                }
                GLGLESKt.glLinkProgram(program2);
                $i$f$debugGLErrors = false;
                if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                    $i$f$checkGLErrors2 = false;
                    error$iv$iv2 = GLGLESKt.glGetError();
                    if (error$iv$iv2 != 0) {
                        Object message$iv$iv = switch (error$iv$iv2) {
                            case 1282 -> "GL_INVALID_OPERATION";
                            case 1281 -> "GL_INVALID_VALUE";
                            case 1280 -> "GL_INVALID_ENUM";
                            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                            case 1285 -> "GL_OUT_OF_MEMORY";
                            case 1284 -> "GL_STACK_UNDERFLOW";
                            case 1283 -> "GL_STACK_OVERFLOW";
                            default -> "<untranslated: " + error$iv$iv2 + ">";
                        };
                        it = error$iv$iv2;
                        Object object = message$iv$iv;
                        long l = Driver.Companion.getInstance().getContextID();
                        boolean bl10 = false;
                        Object var19_48 = null;
                        String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var19_48;
                        throw new GL3Exception(string);
                    }
                }
                int[] linkStatus = new int[1];
                GLGLESKt.glGetProgramiv(program2, 35714, linkStatus);
                boolean $i$f$debugGLErrors4 = false;
                if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                    boolean $i$f$checkGLErrors4 = false;
                    int error$iv$iv4 = GLGLESKt.glGetError();
                    if (error$iv$iv4 != 0) {
                        Object message$iv$iv = switch (error$iv$iv4) {
                            case 1282 -> "GL_INVALID_OPERATION";
                            case 1281 -> "GL_INVALID_VALUE";
                            case 1280 -> "GL_INVALID_ENUM";
                            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                            case 1285 -> "GL_OUT_OF_MEMORY";
                            case 1284 -> "GL_STACK_UNDERFLOW";
                            case 1283 -> "GL_STACK_OVERFLOW";
                            default -> "<untranslated: " + error$iv$iv4 + ">";
                        };
                        int bl10 = error$iv$iv4;
                        Object object = message$iv$iv;
                        long l = Driver.Companion.getInstance().getContextID();
                        boolean $i$a$-debugGLErrors-ErrorGL3Kt$debugGLErrors$4 = false;
                        int it9 = bl10;
                        Object var19_49 = null;
                        String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var19_49;
                        throw new GL3Exception(string);
                    }
                }
                if (linkStatus[0] != 1) {
                    ShaderGL3Kt.checkProgramInfoLog(program2, "noname");
                }
                boolean $i$f$glFinish = false;
                switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                    case 1: {
                        GL45C.glFinish();
                        break;
                    }
                    case 2: {
                        GLES32.glFinish();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                ShaderGL3 shaderGL3 = new ShaderGL3(program2, name, vertexShader, tessellationControlShader, tessellationEvaluationShader, geometryShader, fragmentShader, session);
                return shaderGL3;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

