/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.kartifex.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.kartifex.Bezier2;
import org.openrndr.kartifex.Box;
import org.openrndr.kartifex.Box2;
import org.openrndr.kartifex.Curve2;
import org.openrndr.kartifex.Interval;
import org.openrndr.kartifex.Line2;
import org.openrndr.kartifex.OperatorsKt;
import org.openrndr.kartifex.Vec;
import org.openrndr.kartifex.Vec2;
import org.openrndr.kartifex.utils.EquationsKt;
import org.openrndr.kartifex.utils.IntersectionsKt;
import org.openrndr.kartifex.utils.ScalarsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002DEB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0018J!\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\u001dJ!\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001f\u00a2\u0006\u0002\u0010 J\u001f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u0010#J!\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010%J\u0016\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0005J!\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010%J\u001e\u0010)\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0015J)\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u001c\u00a2\u0006\u0002\u0010.J)\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u001f\u00a2\u0006\u0002\u0010/J)\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u0015\u00a2\u0006\u0002\u00100J!\u00101\u001a\u00020+2\u0006\u00102\u001a\u00020+2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u00104J\u000e\u00105\u001a\u00020+2\u0006\u00106\u001a\u00020+J$\u00107\u001a\u0002082\u0006\u0010\u0012\u001a\u0002092\u0006\u0010\u0014\u001a\u0002092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00110;J\u0018\u0010<\u001a\u0004\u0018\u0001092\u0006\u0010=\u001a\u0002092\u0006\u0010>\u001a\u000209J!\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010%J+\u0010@\u001a\u00020A2\u0006\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0002\u0010CR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006F"}, d2={"Lorg/openrndr/kartifex/utils/Intersections;", "", "<init>", "()V", "FAT_LINE_PARAMETRIC_RESOLUTION", "", "FAT_LINE_SPATIAL_EPSILON", "PARAMETRIC_EPSILON", "SPATIAL_EPSILON", "MAX_CUBIC_CUBIC_INTERSECTIONS", "", "PARAMETRIC_BOUNDS", "Lorg/openrndr/kartifex/Box2;", "getPARAMETRIC_BOUNDS", "()Lorg/openrndr/kartifex/Box2;", "lineCurve", "", "Lorg/openrndr/kartifex/Vec2;", "a", "Lorg/openrndr/kartifex/Line2;", "b", "Lorg/openrndr/kartifex/Curve2;", "(Lorg/openrndr/kartifex/Line2;Lorg/openrndr/kartifex/Curve2;)[Lorg/openrndr/kartifex/Vec2;", "lineLine", "(Lorg/openrndr/kartifex/Line2;Lorg/openrndr/kartifex/Line2;)[Lorg/openrndr/kartifex/Vec2;", "lineQuadratic", "p", "q", "Lorg/openrndr/kartifex/Bezier2$QuadraticBezier2;", "(Lorg/openrndr/kartifex/Line2;Lorg/openrndr/kartifex/Bezier2$QuadraticBezier2;)[Lorg/openrndr/kartifex/Vec2;", "lineCubic", "Lorg/openrndr/kartifex/Bezier2$CubicBezier2;", "(Lorg/openrndr/kartifex/Line2;Lorg/openrndr/kartifex/Bezier2$CubicBezier2;)[Lorg/openrndr/kartifex/Vec2;", "normalize", "intersections", "([Lorg/openrndr/kartifex/Vec2;)[Lorg/openrndr/kartifex/Vec2;", "collinearIntersection", "(Lorg/openrndr/kartifex/Curve2;Lorg/openrndr/kartifex/Curve2;)[Lorg/openrndr/kartifex/Vec2;", "round", "n", "epsilon", "signedDistance", "fatLineWidth", "Lorg/openrndr/kartifex/Interval;", "c", "convexHull", "(Lorg/openrndr/kartifex/Vec2;Lorg/openrndr/kartifex/Vec2;Lorg/openrndr/kartifex/Bezier2$QuadraticBezier2;)[Lorg/openrndr/kartifex/Vec2;", "(Lorg/openrndr/kartifex/Vec2;Lorg/openrndr/kartifex/Vec2;Lorg/openrndr/kartifex/Bezier2$CubicBezier2;)[Lorg/openrndr/kartifex/Vec2;", "(Lorg/openrndr/kartifex/Vec2;Lorg/openrndr/kartifex/Vec2;Lorg/openrndr/kartifex/Curve2;)[Lorg/openrndr/kartifex/Vec2;", "clipHull", "fatLine", "hull", "(Lorg/openrndr/kartifex/Interval;[Lorg/openrndr/kartifex/Vec2;)Lorg/openrndr/kartifex/Interval;", "quantize", "t", "addIntersections", "", "Lorg/openrndr/kartifex/utils/Intersections$FatLine;", "acc", "", "clipFatline", "subject", "clipper", "fatLineCurveCurve", "isCollinear", "", "is", "(Lorg/openrndr/kartifex/Curve2;Lorg/openrndr/kartifex/Curve2;[Lorg/openrndr/kartifex/Vec2;)Z", "CurveInterval", "FatLine", "openrndr-kartifex"})
@SourceDebugExtension(value={"SMAP\nIntersections.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Intersections.kt\norg/openrndr/kartifex/utils/Intersections\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,912:1\n12364#2,2:913\n37#3:915\n36#3,3:916\n37#3:919\n36#3,3:920\n*S KotlinDebug\n*F\n+ 1 Intersections.kt\norg/openrndr/kartifex/utils/Intersections\n*L\n82#1:913,2\n299#1:915\n299#1:916,3\n886#1:919\n886#1:920,3\n*E\n"})
public final class Intersections {
    @NotNull
    public static final Intersections INSTANCE = new Intersections();
    public static final double FAT_LINE_PARAMETRIC_RESOLUTION = 1.0E-5;
    public static final double FAT_LINE_SPATIAL_EPSILON = 1.0E-5;
    public static final double PARAMETRIC_EPSILON = 1.0E-5;
    public static final double SPATIAL_EPSILON = 1.0E-5;
    public static final int MAX_CUBIC_CUBIC_INTERSECTIONS = 9;
    @NotNull
    private static final Box2 PARAMETRIC_BOUNDS = Box.Companion.box(new Vec2(0.0, 0.0), new Vec2(1.0, 1.0));

    private Intersections() {
    }

    @NotNull
    public final Box2 getPARAMETRIC_BOUNDS() {
        return PARAMETRIC_BOUNDS;
    }

    @NotNull
    public final Vec2[] lineCurve(@NotNull Line2 a, @NotNull Curve2 b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return b instanceof Line2 ? this.lineLine(a, (Line2)b) : (b.isFlat(1.0E-5) ? this.lineLine(a, Line2.Companion.line(b.start(), b.end())) : (b instanceof Bezier2.QuadraticBezier2 ? this.lineQuadratic(a, (Bezier2.QuadraticBezier2)b) : this.lineCubic(a, (Bezier2.CubicBezier2)b)));
    }

    @NotNull
    public final Vec2[] lineLine(@NotNull Line2 a, @NotNull Line2 b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        Vec2 av = a.end().sub(a.start());
        Vec2 bv = b.end().sub(b.start());
        double d = Vec2.Companion.cross(av, bv);
        if (Math.abs(d) < 1.0E-6) {
            boolean bl;
            Vec2[] ints;
            block4: {
                Vec2[] $this$all$iv = ints = this.collinearIntersection(a, b);
                boolean $i$f$all = false;
                int n = $this$all$iv.length;
                for (int i = 0; i < n; ++i) {
                    Vec2 element$iv;
                    Vec2 v = element$iv = $this$all$iv[i];
                    boolean bl2 = false;
                    if (Vec.Companion.equals((Vec)a.position(v.x()), (Vec)b.position(v.y()), 1.0E-5)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
            if (bl) {
                return ints;
            }
            if (Math.abs(d) == 0.0) {
                return new Vec2[0];
            }
        }
        Vec2 asb = a.start().sub(b.start());
        double s = Vec2.Companion.cross(bv, asb) / d;
        double t = Vec2.Companion.cross(av, asb) / d;
        Vec2[] vec2Array = new Vec2[]{new Vec2(s, t)};
        return vec2Array;
    }

    @NotNull
    public final Vec2[] lineQuadratic(@NotNull Line2 p, @NotNull Bezier2.QuadraticBezier2 q) {
        Vec2[] vec2Array;
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(q, "q");
        Vec2 a = q.getP0().add(q.getP1().mul(-2.0)).add(q.getP2());
        Vec2 b = q.getP0().mul(-2.0).add(q.getP1().mul(2.0));
        Vec2 c2 = q.getP0();
        Vec2 dir = p.end().sub(p.start());
        Vec2 n = new Vec2(-dir.y(), dir.x());
        double[] roots = EquationsKt.solveQuadratic(Vec.Companion.dot(n, a), Vec.Companion.dot(n, b), Vec.Companion.dot(n, c2) + Vec2.Companion.cross(p.start(), p.end()));
        if (ScalarsKt.equals(dir.x(), 0.0, 1.0E-14)) {
            double y0 = p.start().y();
            var12_10 = 0;
            var13_11 = roots.length;
            var14_12 = new Vec2[var13_11];
            while (var12_10 < var13_11) {
                var15_13 = var12_10++;
                t = roots[var15_13];
                double y1 = q.position(t).y();
                var14_12[var15_13] = new Vec2((y1 - y0) / dir.y(), t);
            }
            vec2Array = var14_12;
        } else {
            double x0 = p.start().x();
            var12_10 = 0;
            var13_11 = roots.length;
            var14_12 = new Vec2[var13_11];
            while (var12_10 < var13_11) {
                var15_13 = var12_10++;
                t = roots[var15_13];
                double x1 = q.position(t).x();
                var14_12[var15_13] = new Vec2((x1 - x0) / dir.x(), t);
            }
            vec2Array = var14_12;
        }
        Vec2[] result = vec2Array;
        return result;
    }

    @NotNull
    public final Vec2[] lineCubic(@NotNull Line2 p, @NotNull Bezier2.CubicBezier2 q) {
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(q, "q");
        Vec2 a = q.getP0().mul(-1.0).add(q.getP1().mul(3.0)).add(q.getP2().mul(-3.0)).add(q.getP3());
        Vec2 b = q.getP0().mul(3.0).add(q.getP1().mul(-6.0)).add(q.getP2().mul(3.0));
        Vec2 c2 = q.getP0().mul(-3.0).add(q.getP1().mul(3.0));
        Vec2 d = q.getP0();
        Vec2 dir = p.end().sub(p.start());
        double dLen = dir.length();
        Vec2 n = new Vec2(-dir.y(), dir.x());
        double[] roots = EquationsKt.solveCubic(Vec.Companion.dot(n, a), Vec.Companion.dot(n, b), Vec.Companion.dot(n, c2), Vec.Companion.dot(n, d) + Vec2.Companion.cross(p.start(), p.end()));
        int n2 = 0;
        int n3 = roots.length;
        Vec2[] vec2Array = new Vec2[n3];
        while (n2 < n3) {
            int n4 = n2++;
            double t = roots[n4];
            Vec2 v = q.position(t).sub(p.start());
            double vLen = v.length();
            double s = vLen / dLen * OperatorsKt.signum(Vec.Companion.dot(dir, v));
            vec2Array[n4] = new Vec2(s, t);
        }
        Vec2[] result = vec2Array;
        return result;
    }

    @NotNull
    public final Vec2[] normalize(@NotNull Vec2[] intersections) {
        Vec i;
        Intrinsics.checkNotNullParameter(intersections, "intersections");
        int limit = intersections.length;
        if (limit == 0) {
            return intersections;
        }
        int readIdx = 0;
        int writeIdx = 0;
        writeIdx = 0;
        for (readIdx = 0; readIdx < limit; ++readIdx) {
            i = intersections[readIdx].map(Intersections::normalize$lambda$1);
            if (!PARAMETRIC_BOUNDS.contains(i)) continue;
            intersections[writeIdx++] = i;
        }
        limit = writeIdx;
        if (limit > 1) {
            IntersectionsKt.kartifexHackSort2(intersections, 0, limit, Intersections::normalize$lambda$2);
            writeIdx = -1;
            for (readIdx = 0; readIdx < limit; ++readIdx) {
                i = intersections[readIdx];
                if (writeIdx >= 0 && ScalarsKt.equals(intersections[writeIdx].y(), ((Vec2)i).y(), 1.0E-14)) continue;
                intersections[++writeIdx] = i;
            }
            limit = writeIdx + 1;
        }
        if (limit > 1) {
            IntersectionsKt.kartifexHackSort2(intersections, 0, limit, Intersections::normalize$lambda$3);
            writeIdx = -1;
            for (readIdx = 0; readIdx < limit; ++readIdx) {
                i = intersections[readIdx];
                if (writeIdx >= 0 && ScalarsKt.equals(intersections[writeIdx].x(), ((Vec2)i).x(), 1.0E-14)) continue;
                intersections[++writeIdx] = i;
            }
            limit = writeIdx + 1;
        }
        int n = 0;
        int n2 = limit;
        Vec2[] vec2Array = new Vec2[n2];
        while (n < n2) {
            int n3 = n++;
            vec2Array[n3] = intersections[n3];
        }
        Vec2[] result = vec2Array;
        return result;
    }

    @NotNull
    public final Vec2[] collinearIntersection(@NotNull Curve2 a, @NotNull Curve2 b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        List result = new ArrayList();
        for (int i = 0; i < 2; ++i) {
            double s;
            double tb = b.nearestPoint(a.position(i));
            if (tb <= 0.0) {
                s = this.round(a.nearestPoint(b.start()), 1.0E-5);
                boolean bl = 0.0 <= s ? s <= 1.0 : false;
                if (!bl) continue;
                result.add(new Vec2(s, 0.0));
                continue;
            }
            if (tb >= 1.0) {
                s = this.round(a.nearestPoint(b.end()), 1.0E-5);
                boolean bl = 0.0 <= s ? s <= 1.0 : false;
                if (!bl) continue;
                result.add(new Vec2(s, 1.0));
                continue;
            }
            result.add(new Vec2(i, tb));
        }
        if (result.size() == 2 && Vec.Companion.equals((Vec)result.get(0), (Vec)result.get(1), 1.0E-5)) {
            CollectionsKt.removeLast(result);
        }
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Vec2[0]);
    }

    public final double round(double n, double epsilon) {
        return ScalarsKt.equals(n, 0.0, epsilon) ? 0.0 : (ScalarsKt.equals(n, 1.0, epsilon) ? 1.0 : n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Vec2[] intersections(@NotNull Curve2 a, @NotNull Curve2 b) {
        Vec2[] vec2Array;
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        if (!((Box2)a.bounds().expand(1.0E-5)).intersects(b.bounds())) {
            return new Vec2[0];
        }
        if (a instanceof Line2) {
            vec2Array = this.normalize(this.lineCurve((Line2)a, b));
        } else if (b instanceof Line2) {
            void var3_3;
            Vec2[] result = this.normalize(this.lineCurve((Line2)b, a));
            int n = result.length;
            for (int i = 0; i < n; ++i) {
                result[i] = result[i].swap();
            }
            vec2Array = var3_3;
        } else {
            vec2Array = this.fatLineCurveCurve(a, b);
        }
        return vec2Array;
    }

    public final double signedDistance(@NotNull Vec2 p, @NotNull Vec2 a, @NotNull Vec2 b) {
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        Vec2 d = b.sub(a);
        return (Vec2.Companion.cross(p, d) + Vec2.Companion.cross(b, a)) / d.length();
    }

    @NotNull
    public final Interval fatLineWidth(@NotNull Curve2 c2) {
        Interval interval;
        Intrinsics.checkNotNullParameter(c2, "c");
        Curve2 curve2 = c2;
        if (curve2 instanceof Line2) {
            interval = Interval.Companion.interval(0.0, 0.0);
        } else if (curve2 instanceof Bezier2.QuadraticBezier2) {
            Bezier2.QuadraticBezier2 b = (Bezier2.QuadraticBezier2)c2;
            interval = Interval.Companion.interval(0.0, this.signedDistance(b.getP1(), b.getP0(), b.getP2()) / (double)2);
        } else if (curve2 instanceof Bezier2.CubicBezier2) {
            double d2;
            Bezier2.CubicBezier2 b = (Bezier2.CubicBezier2)c2;
            double d1 = this.signedDistance(b.getP1(), b.getP0(), b.getP3());
            double k = d1 * (d2 = this.signedDistance(b.getP2(), b.getP0(), b.getP3())) < 0.0 ? 0.4444444444444444 : 0.75;
            interval = Interval.Companion.interval(ScalarsKt.min(0.0, ScalarsKt.min(d1, d2)) * k, ScalarsKt.max(0.0, ScalarsKt.max(d1, d2)) * k);
        } else {
            throw new IllegalStateException();
        }
        return interval;
    }

    @NotNull
    public final Vec2[] convexHull(@NotNull Vec2 a, @NotNull Vec2 b, @NotNull Bezier2.QuadraticBezier2 c2) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(c2, "c");
        Vec2 p0 = new Vec2(0.0, this.signedDistance(c2.getP0(), a, b));
        Vec2 p1 = new Vec2(0.5, this.signedDistance(c2.getP1(), a, b));
        Vec2 p2 = new Vec2(1.0, this.signedDistance(c2.getP2(), a, b));
        Vec2[] vec2Array = new Vec2[]{p0, p1, p2, p0};
        return vec2Array;
    }

    @NotNull
    public final Vec2[] convexHull(@NotNull Vec2 a, @NotNull Vec2 b, @NotNull Bezier2.CubicBezier2 c2) {
        Vec2[] vec2Array;
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(c2, "c");
        Vec2 p0 = new Vec2(0.0, this.signedDistance(c2.getP0(), a, b));
        Vec2 p1 = new Vec2(0.3333333333333333, this.signedDistance(c2.getP1(), a, b));
        Vec2 p2 = new Vec2(0.6666666666666666, this.signedDistance(c2.getP2(), a, b));
        Vec2 p3 = new Vec2(1.0, this.signedDistance(c2.getP3(), a, b));
        double d1 = this.signedDistance(p1, p0, p3);
        double d2 = this.signedDistance(p2, p0, p3);
        if (d1 * d2 < 0.0) {
            Vec2[] vec2Array2 = new Vec2[]{p0, p1, p3, p2, p0};
            vec2Array = vec2Array2;
        } else {
            double k = d1 / d2;
            if (k >= 2.0) {
                Vec2[] vec2Array3 = new Vec2[]{p0, p1, p3, p0};
                vec2Array = vec2Array3;
            } else if (k <= 0.5) {
                Vec2[] vec2Array4 = new Vec2[]{p0, p2, p3, p0};
                vec2Array = vec2Array4;
            } else {
                Vec2[] vec2Array5 = new Vec2[]{p0, p1, p2, p3, p0};
                vec2Array = vec2Array5;
            }
        }
        return vec2Array;
    }

    @NotNull
    public final Vec2[] convexHull(@NotNull Vec2 a, @NotNull Vec2 b, @NotNull Curve2 c2) {
        Vec2[] vec2Array;
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(c2, "c");
        Curve2 curve2 = c2;
        if (curve2 instanceof Bezier2.QuadraticBezier2) {
            vec2Array = this.convexHull(a, b, (Bezier2.QuadraticBezier2)c2);
        } else if (curve2 instanceof Bezier2.CubicBezier2) {
            vec2Array = this.convexHull(a, b, (Bezier2.CubicBezier2)c2);
        } else {
            throw new IllegalStateException();
        }
        return vec2Array;
    }

    @NotNull
    public final Interval clipHull(@NotNull Interval fatLine, @NotNull Vec2[] hull) {
        Intrinsics.checkNotNullParameter(fatLine, "fatLine");
        Intrinsics.checkNotNullParameter(hull, "hull");
        double lo = Double.POSITIVE_INFINITY;
        double hi = Double.NEGATIVE_INFINITY;
        int n = hull.length - 1;
        for (int i = 0; i < n; ++i) {
            if (!fatLine.contains(hull[i].y())) continue;
            lo = ScalarsKt.min(lo, hull[i].x());
            hi = ScalarsKt.max(hi, hull[i].x());
        }
        double[] dArray = new double[]{fatLine.getLo(), fatLine.getHi()};
        for (double y : dArray) {
            int n2 = hull.length - 1;
            for (int i = 0; i < n2; ++i) {
                Vec2 a = hull[i];
                Vec2 b = hull[i + 1];
                if (!Interval.Companion.interval(a.y(), b.y()).contains(y)) continue;
                if (a.y() == b.y()) {
                    lo = ScalarsKt.min(lo, ScalarsKt.min(a.x(), b.x()));
                    hi = ScalarsKt.max(lo, ScalarsKt.max(a.x(), b.x()));
                    continue;
                }
                double t = ScalarsKt.lerp(a.x(), b.x(), (y - a.y()) / (b.y() - a.y()));
                lo = ScalarsKt.min(lo, t);
                hi = ScalarsKt.max(hi, t);
            }
        }
        return hi < lo ? Interval.Companion.getEMPTY() : Interval.Companion.interval(lo, hi);
    }

    @NotNull
    public final Interval quantize(@NotNull Interval t) {
        Intrinsics.checkNotNullParameter(t, "t");
        double resolution = 1.0E-5;
        double lo = ScalarsKt.min(1.0 - resolution, Math.floor(t.getLo() / resolution) * resolution);
        double hi = ScalarsKt.max(lo + resolution, Math.ceil(t.getHi() / resolution) * resolution);
        return Interval.Companion.interval(lo, hi);
    }

    public final void addIntersections(@NotNull FatLine a, @NotNull FatLine b, @NotNull List<Vec2> acc) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(acc, "acc");
        Line2 la = a.line();
        Line2 lb = b.line();
        Vec2 av = la.end().sub(la.start());
        Vec2 bv = lb.end().sub(lb.start());
        Vec2 asb = la.start().sub(lb.start());
        double d = Vec2.Companion.cross(av, bv);
        Vec2 i = new Vec2(Vec2.Companion.cross(bv, asb) / d, Vec2.Companion.cross(av, asb) / d);
        if (((Box2)PARAMETRIC_BOUNDS.expand(0.1)).contains((Vec)i)) {
            acc.add((Vec2)Box.Companion.box(a.getT(), b.getT()).lerp((Vec)i));
        }
    }

    @Nullable
    public final FatLine clipFatline(@NotNull FatLine subject, @NotNull FatLine clipper) {
        Intrinsics.checkNotNullParameter(subject, "subject");
        Intrinsics.checkNotNullParameter(clipper, "clipper");
        Vec2[] hull = this.convexHull(clipper.getRange().start(), clipper.getRange().end(), subject.getRange());
        Interval expanded = clipper.get_line().expand(1.0E-5);
        Interval normalized = this.clipHull(expanded, hull);
        return normalized.isEmpty() ? null : new FatLine(subject.getCurve(), subject.getT().lerp(normalized));
    }

    @NotNull
    public final Vec2[] fatLineCurveCurve(@NotNull Curve2 a, @NotNull Curve2 b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        ArrayDeque<FatLine> queue = new ArrayDeque<FatLine>();
        FatLine[] as = FatLine.Companion.from(a);
        FatLine[] bs = FatLine.Companion.from(b);
        for (FatLine ap : as) {
            for (FatLine bp : bs) {
                ArrayDeque<FatLine> arrayDeque;
                ArrayDeque<FatLine> $this$fatLineCurveCurve_u24lambda_u244 = arrayDeque = queue;
                boolean bl = false;
                $this$fatLineCurveCurve_u24lambda_u244.addLast(ap);
                $this$fatLineCurveCurve_u24lambda_u244.addLast(bp);
            }
        }
        int iterations = 0;
        boolean collinearCheck = false;
        ArrayDeque acc = new ArrayDeque();
        block2: while (queue.size() > 0) {
            double bSize;
            double kb;
            double aSize;
            FatLine laPrime;
            double ka;
            if (iterations > 32 && !collinearCheck) {
                collinearCheck = true;
                Vec2[] is = this.collinearIntersection(a, b);
                if (this.isCollinear(a, b, is)) {
                    return is;
                }
            }
            FatLine lb = (FatLine)queue.removeLast();
            FatLine la = (FatLine)queue.removeLast();
            do {
                FatLine lbPrime;
                ++iterations;
                if (!la.intersects(lb)) continue block2;
                if (la.isFlat() && lb.isFlat()) {
                    this.addIntersections(la, lb, acc);
                    continue block2;
                }
                aSize = la.getT().size();
                bSize = lb.getT().size();
                if (this.clipFatline(lb, la) == null || this.clipFatline(la, lb = lbPrime) == null) continue block2;
            } while (!(ScalarsKt.max(ka = (la = laPrime).getT().size() / aSize, kb = lb.getT().size() / bSize) > 0.8));
            for (FatLine ap : la.split()) {
                for (FatLine bp : lb.split()) {
                    ArrayDeque<FatLine> arrayDeque;
                    ArrayDeque<FatLine> $this$fatLineCurveCurve_u24lambda_u245 = arrayDeque = queue;
                    boolean bl = false;
                    $this$fatLineCurveCurve_u24lambda_u245.addLast(ap);
                    $this$fatLineCurveCurve_u24lambda_u245.addLast(bp);
                }
            }
        }
        Collection $this$toTypedArray$iv = acc;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return this.normalize(thisCollection$iv.toArray(new Vec2[0]));
    }

    private final boolean isCollinear(Curve2 a, Curve2 b, Vec2[] is) {
        if (is.length != 2) {
            return false;
        }
        for (int i = 0; i < 10; ++i) {
            Vec2 pb;
            double t = (double)i / (double)9;
            Vec2 pa = a.position(ScalarsKt.lerp(is[0].x(), is[1].x(), t));
            if (Vec.Companion.equals((Vec)pa, (Vec)(pb = b.position(ScalarsKt.lerp(is[0].y(), is[1].y(), t))), 1.0E-5)) continue;
            return false;
        }
        return true;
    }

    private static final double normalize$lambda$1(double n) {
        return INSTANCE.round(n, 1.0E-5);
    }

    private static final double normalize$lambda$2(Vec2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return v.y();
    }

    private static final double normalize$lambda$3(Vec2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return v.x();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0000J\u0011\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00000\u001c\u00a2\u0006\u0002\u0010\u001dJ\u001c\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00002\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0!J\b\u0010\"\u001a\u00020#H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015\u00a8\u0006%"}, d2={"Lorg/openrndr/kartifex/utils/Intersections$CurveInterval;", "", "curve", "Lorg/openrndr/kartifex/Curve2;", "tLo", "", "tHi", "pLo", "Lorg/openrndr/kartifex/Vec2;", "pHi", "<init>", "(Lorg/openrndr/kartifex/Curve2;DDLorg/openrndr/kartifex/Vec2;Lorg/openrndr/kartifex/Vec2;)V", "getCurve", "()Lorg/openrndr/kartifex/Curve2;", "isFlat", "", "()Z", "getTLo", "()D", "getTHi", "getPLo", "()Lorg/openrndr/kartifex/Vec2;", "getPHi", "bounds", "Lorg/openrndr/kartifex/Box2;", "intersects", "c", "split", "", "()[Lorg/openrndr/kartifex/utils/Intersections$CurveInterval;", "intersections", "", "acc", "", "toString", "", "Companion", "openrndr-kartifex"})
    public static final class CurveInterval {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Curve2 curve;
        private final boolean isFlat;
        private final double tLo;
        private final double tHi;
        @NotNull
        private final Vec2 pLo;
        @NotNull
        private final Vec2 pHi;

        public CurveInterval(@NotNull Curve2 curve, double tLo, double tHi, @NotNull Vec2 pLo, @NotNull Vec2 pHi) {
            Intrinsics.checkNotNullParameter(curve, "curve");
            Intrinsics.checkNotNullParameter(pLo, "pLo");
            Intrinsics.checkNotNullParameter(pHi, "pHi");
            this.curve = curve;
            this.tLo = tLo;
            this.tHi = tHi;
            this.pLo = pLo;
            this.pHi = pHi;
            this.isFlat = Vec.Companion.equals((Vec)pLo, (Vec)pHi, 1.0E-5) || tHi - tLo < 1.0E-5 || curve.range(tLo, tHi).isFlat(1.0E-5);
        }

        @NotNull
        public final Curve2 getCurve() {
            return this.curve;
        }

        public final boolean isFlat() {
            return this.isFlat;
        }

        public final double getTLo() {
            return this.tLo;
        }

        public final double getTHi() {
            return this.tHi;
        }

        @NotNull
        public final Vec2 getPLo() {
            return this.pLo;
        }

        @NotNull
        public final Vec2 getPHi() {
            return this.pHi;
        }

        @NotNull
        public final Box2 bounds() {
            return Box.Companion.box(this.pLo, this.pHi);
        }

        public final boolean intersects(@NotNull CurveInterval c2) {
            Intrinsics.checkNotNullParameter(c2, "c");
            return ((Box2)this.bounds().expand(1.0E-5)).intersects(c2.bounds());
        }

        @NotNull
        public final CurveInterval[] split() {
            CurveInterval[] curveIntervalArray;
            if (this.isFlat) {
                CurveInterval[] curveIntervalArray2 = new CurveInterval[]{this};
                curveIntervalArray = curveIntervalArray2;
            } else {
                double tMid = (this.tLo + this.tHi) / (double)2;
                Vec2 pMid = this.curve.position(tMid);
                CurveInterval[] curveIntervalArray3 = new CurveInterval[]{new CurveInterval(this.curve, this.tLo, tMid, this.pLo, pMid), new CurveInterval(this.curve, tMid, this.tHi, pMid, this.pHi)};
                curveIntervalArray = curveIntervalArray3;
            }
            return curveIntervalArray;
        }

        public final void intersections(@NotNull CurveInterval c2, @NotNull List<Vec2> acc) {
            Intrinsics.checkNotNullParameter(c2, "c");
            Intrinsics.checkNotNullParameter(acc, "acc");
            for (Vec2 i : INSTANCE.lineLine(Line2.Companion.line(this.pLo, this.pHi), Line2.Companion.line(c2.pLo, c2.pHi))) {
                if (!((Box2)INSTANCE.getPARAMETRIC_BOUNDS().expand(1.0E-5)).contains((Vec)i)) continue;
                acc.add(Vec.Companion.lerp(new Vec2(this.tLo, c2.tLo), new Vec2(this.tHi, c2.tHi), i));
            }
        }

        @NotNull
        public String toString() {
            return "[" + this.tLo + ", " + this.tHi + "]";
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/openrndr/kartifex/utils/Intersections$CurveInterval$Companion;", "", "<init>", "()V", "from", "", "Lorg/openrndr/kartifex/utils/Intersections$CurveInterval;", "c", "Lorg/openrndr/kartifex/Curve2;", "(Lorg/openrndr/kartifex/Curve2;)[Lorg/openrndr/kartifex/utils/Intersections$CurveInterval;", "openrndr-kartifex"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CurveInterval[] from(@NotNull Curve2 c2) {
                CurveInterval[] curveIntervalArray;
                Intrinsics.checkNotNullParameter(c2, "c");
                double[] ts = c2.inflections();
                ArraysKt.sort(ts);
                if (ts.length == 0) {
                    CurveInterval[] curveIntervalArray2 = new CurveInterval[]{new CurveInterval(c2, 0.0, 1.0, c2.start(), c2.end())};
                    curveIntervalArray = curveIntervalArray2;
                } else {
                    void var3_4;
                    CurveInterval[] ls = new CurveInterval[ts.length + 1];
                    int n = ls.length;
                    for (int i = 0; i < n; ++i) {
                        double lo = i == 0 ? 0.0 : ts[i - 1];
                        double hi = i == ls.length - 1 ? 1.0 : ts[i];
                        ls[i] = new CurveInterval(c2, lo, hi, c2.position(lo), c2.position(hi));
                    }
                    curveIntervalArray = var3_4;
                }
                return curveIntervalArray;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0000J\u0011\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00000\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\u00a8\u0006!"}, d2={"Lorg/openrndr/kartifex/utils/Intersections$FatLine;", "", "curve", "Lorg/openrndr/kartifex/Curve2;", "t", "Lorg/openrndr/kartifex/Interval;", "<init>", "(Lorg/openrndr/kartifex/Curve2;Lorg/openrndr/kartifex/Interval;)V", "getCurve", "()Lorg/openrndr/kartifex/Curve2;", "range", "getRange", "getT", "()Lorg/openrndr/kartifex/Interval;", "_line", "get_line", "mid", "", "isFlat", "", "()Z", "bounds", "Lorg/openrndr/kartifex/Box2;", "intersects", "l", "split", "", "()[Lorg/openrndr/kartifex/utils/Intersections$FatLine;", "line", "Lorg/openrndr/kartifex/Line2;", "toString", "", "Companion", "openrndr-kartifex"})
    public static final class FatLine {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Curve2 curve;
        @NotNull
        private final Curve2 range;
        @NotNull
        private final Interval t;
        @NotNull
        private final Interval _line;

        public FatLine(@NotNull Curve2 curve, @NotNull Interval t) {
            Intrinsics.checkNotNullParameter(curve, "curve");
            Intrinsics.checkNotNullParameter(t, "t");
            this.curve = curve;
            this.t = INSTANCE.quantize(t);
            this.range = curve.range(this.t);
            this._line = INSTANCE.fatLineWidth(this.range);
        }

        @NotNull
        public final Curve2 getCurve() {
            return this.curve;
        }

        @NotNull
        public final Curve2 getRange() {
            return this.range;
        }

        @NotNull
        public final Interval getT() {
            return this.t;
        }

        @NotNull
        public final Interval get_line() {
            return this._line;
        }

        public final double mid() {
            return this.t.lerp(0.5);
        }

        public final boolean isFlat() {
            return this.t.size() < 1.0E-5 || this._line.size() <= 1.0E-5;
        }

        @NotNull
        public final Box2 bounds() {
            return Box.Companion.box(this.range.start(), this.range.end());
        }

        public final boolean intersects(@NotNull FatLine l) {
            Intrinsics.checkNotNullParameter(l, "l");
            return ((Box2)this.bounds().expand(1.0E-4)).intersects(l.bounds());
        }

        @NotNull
        public final FatLine[] split() {
            FatLine[] fatLineArray;
            if (this.isFlat()) {
                FatLine[] fatLineArray2 = new FatLine[]{this};
                fatLineArray = fatLineArray2;
            } else {
                FatLine[] fatLineArray3 = new FatLine[]{new FatLine(this.curve, Interval.Companion.interval(this.t.getLo(), this.mid())), new FatLine(this.curve, Interval.Companion.interval(this.mid(), this.t.getHi()))};
                fatLineArray = fatLineArray3;
            }
            return fatLineArray;
        }

        @NotNull
        public final Line2 line() {
            return Line2.Companion.line(this.range.start(), this.range.end());
        }

        @NotNull
        public String toString() {
            return "FatLine(curve=" + this.curve + ", range=" + this.range + ", t=" + this.t + ", _line=" + this._line + ", isFlat=" + this.isFlat() + ")";
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/openrndr/kartifex/utils/Intersections$FatLine$Companion;", "", "<init>", "()V", "from", "", "Lorg/openrndr/kartifex/utils/Intersections$FatLine;", "c", "Lorg/openrndr/kartifex/Curve2;", "(Lorg/openrndr/kartifex/Curve2;)[Lorg/openrndr/kartifex/utils/Intersections$FatLine;", "openrndr-kartifex"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final FatLine[] from(@NotNull Curve2 c2) {
                FatLine[] fatLineArray;
                Intrinsics.checkNotNullParameter(c2, "c");
                double[] ts = c2.inflections();
                ArraysKt.sort(ts);
                if (ts.length == 0) {
                    FatLine[] fatLineArray2 = new FatLine[]{new FatLine(c2, Interval.Companion.interval(0.0, 1.0))};
                    fatLineArray = fatLineArray2;
                } else {
                    void var3_4;
                    FatLine[] result = new FatLine[ts.length + 1];
                    int n = result.length;
                    for (int i = 0; i < n; ++i) {
                        double lo = i == 0 ? 0.0 : ts[i - 1];
                        double hi = i == result.length - 1 ? 1.0 : ts[i];
                        result[i] = new FatLine(c2, Interval.Companion.interval(lo, hi));
                    }
                    fatLineArray = var3_4;
                }
                return fatLineArray;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

