/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.ktessellation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.ktessellation.ActiveRegion;
import org.openrndr.ktessellation.ArrayUtilsKt;
import org.openrndr.ktessellation.Dict;
import org.openrndr.ktessellation.DictNode;
import org.openrndr.ktessellation.GLUface;
import org.openrndr.ktessellation.GLUhalfEdge;
import org.openrndr.ktessellation.GLUmesh;
import org.openrndr.ktessellation.GLUtessellatorImpl;
import org.openrndr.ktessellation.GLUvertex;
import org.openrndr.ktessellation.Geom;
import org.openrndr.ktessellation.Mesh;
import org.openrndr.ktessellation.PriorityQ;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0019\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rJ\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\rJ\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rJ$\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\nJ\u0016\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\rJ\u0016\u0010!\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\rJ \u0010\"\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\r2\b\u0010$\u001a\u0004\u0018\u00010\rJ:\u0010%\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010\r2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\n2\b\u0010)\u001a\u0004\u0018\u00010\n2\u0006\u0010*\u001a\u00020\u0011J?\u0010+\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-2\u0010\u0010.\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u00020\u0011\u00a2\u0006\u0002\u00103J\u001e\u00104\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\nJ&\u00107\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-2\u0006\u00108\u001a\u00020-2\u0006\u00109\u001a\u00020-2\u0006\u00100\u001a\u000201J6\u0010:\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-2\u0006\u0010;\u001a\u00020-2\u0006\u0010<\u001a\u00020-2\u0006\u0010=\u001a\u00020-2\u0006\u0010>\u001a\u00020-J\u0016\u0010?\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\rJ\u001a\u0010@\u001a\u00020\u00112\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010&\u001a\u0004\u0018\u00010\rJ\u0016\u0010A\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\rJ\u0016\u0010B\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\rJ\u001e\u0010C\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\r2\u0006\u0010D\u001a\u00020\nJ\u001e\u0010F\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\r2\u0006\u0010G\u001a\u00020-J\u0016\u0010H\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010G\u001a\u00020-J\u0016\u0010I\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010G\u001a\u00020-J\u0016\u0010L\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010M\u001a\u00020KJ\u000e\u0010N\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010O\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010P\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010Q\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010R\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010S\u001a\u00020\u00112\u0006\u0010T\u001a\u00020UJ\u000e\u0010V\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010E\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020KX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lorg/openrndr/ktessellation/Sweep;", "", "<init>", "()V", "DebugEvent", "", "tess", "Lorg/openrndr/ktessellation/GLUtessellatorImpl;", "AddWinding", "eDst", "Lorg/openrndr/ktessellation/GLUhalfEdge;", "eSrc", "RegionBelow", "Lorg/openrndr/ktessellation/ActiveRegion;", "r", "RegionAbove", "EdgeLeq", "", "reg1", "reg2", "DeleteRegion", "reg", "FixUpperEdge", "newEdge", "TopLeftRegion", "TopRightRegion", "AddRegionBelow", "regAbove", "eNewUp", "IsWindingInside", "n", "", "ComputeWinding", "FinishRegion", "FinishLeftRegions", "regFirst", "regLast", "AddRightEdges", "regUp", "eFirst", "eLast", "eTopLeft", "cleanUp", "CallCombine", "isect", "Lorg/openrndr/ktessellation/GLUvertex;", "data", "", "weights", "", "needed", "(Lorg/openrndr/ktessellation/GLUtessellatorImpl;Lorg/openrndr/ktessellation/GLUvertex;[Ljava/lang/Object;[FZ)V", "SpliceMergeVertices", "e1", "e2", "VertexWeights", "org", "dst", "GetIntersectData", "orgUp", "dstUp", "orgLo", "dstLo", "CheckForRightSplice", "CheckForLeftSplice", "CheckForIntersect", "WalkDirtyRegions", "ConnectRightVertex", "eBottomLeft", "TOLERANCE_NONZERO", "ConnectLeftDegenerate", "vEvent", "ConnectLeftVertex", "SweepEvent", "SENTINEL_COORD", "", "AddSentinel", "t", "InitEdgeDict", "DoneEdgeDict", "RemoveDegenerateEdges", "InitPriorityQ", "DonePriorityQ", "RemoveDegenerateFaces", "mesh", "Lorg/openrndr/ktessellation/GLUmesh;", "__gl_computeInterior", "openrndr-ktessellation"})
@SourceDebugExtension(value={"SMAP\nSweep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sweep.kt\norg/openrndr/ktessellation/Sweep\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1308:1\n1#2:1309\n*E\n"})
public final class Sweep {
    @NotNull
    public static final Sweep INSTANCE = new Sweep();
    private static final boolean TOLERANCE_NONZERO = false;
    private static final double SENTINEL_COORD = 4.0E150;

    private Sweep() {
    }

    private final void DebugEvent(GLUtessellatorImpl tess) {
    }

    private final void AddWinding(GLUhalfEdge eDst, GLUhalfEdge eSrc) {
        eDst.setWinding(eDst.getWinding() + eSrc.getWinding());
        GLUhalfEdge gLUhalfEdge = eDst.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge);
        GLUhalfEdge gLUhalfEdge2 = gLUhalfEdge;
        int n = gLUhalfEdge2.getWinding();
        GLUhalfEdge gLUhalfEdge3 = eSrc.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge3);
        gLUhalfEdge2.setWinding(n + gLUhalfEdge3.getWinding());
    }

    private final ActiveRegion RegionBelow(ActiveRegion r) {
        DictNode dictNode = r.getNodeUp();
        Intrinsics.checkNotNull(dictNode);
        DictNode dictNode2 = Dict.Companion.dictPred(dictNode);
        Intrinsics.checkNotNull(dictNode2);
        return (ActiveRegion)Dict.Companion.dictKey(dictNode2);
    }

    private final ActiveRegion RegionAbove(ActiveRegion r) {
        DictNode dictNode = r.getNodeUp();
        Intrinsics.checkNotNull(dictNode);
        DictNode dictNode2 = Dict.Companion.dictSucc(dictNode);
        Intrinsics.checkNotNull(dictNode2);
        return (ActiveRegion)Dict.Companion.dictKey(dictNode2);
    }

    public final boolean EdgeLeq(@NotNull GLUtessellatorImpl tess, @NotNull ActiveRegion reg1, @NotNull ActiveRegion reg2) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        Intrinsics.checkNotNullParameter(reg1, "reg1");
        Intrinsics.checkNotNullParameter(reg2, "reg2");
        GLUvertex gLUvertex = tess.getEvent$openrndr_ktessellation();
        Intrinsics.checkNotNull(gLUvertex);
        GLUvertex event = gLUvertex;
        double t1 = 0.0;
        double t2 = 0.0;
        GLUhalfEdge gLUhalfEdge = reg1.getEUp();
        Intrinsics.checkNotNull(gLUhalfEdge);
        GLUhalfEdge e1 = gLUhalfEdge;
        GLUhalfEdge gLUhalfEdge2 = reg2.getEUp();
        Intrinsics.checkNotNull(gLUhalfEdge2);
        GLUhalfEdge e2 = gLUhalfEdge2;
        GLUhalfEdge gLUhalfEdge3 = e1.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge3);
        if (gLUhalfEdge3.getOrg() == event) {
            boolean bl;
            GLUhalfEdge gLUhalfEdge4 = e2.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge4);
            if (gLUhalfEdge4.getOrg() == event) {
                GLUvertex gLUvertex2 = e1.getOrg();
                Intrinsics.checkNotNull(gLUvertex2);
                GLUvertex gLUvertex3 = e2.getOrg();
                Intrinsics.checkNotNull(gLUvertex3);
                if (Geom.INSTANCE.VertLeq(gLUvertex2, gLUvertex3)) {
                    GLUhalfEdge gLUhalfEdge5 = e2.getSym();
                    Intrinsics.checkNotNull(gLUhalfEdge5);
                    GLUvertex gLUvertex4 = gLUhalfEdge5.getOrg();
                    Intrinsics.checkNotNull(gLUvertex4);
                    GLUvertex gLUvertex5 = e1.getOrg();
                    Intrinsics.checkNotNull(gLUvertex5);
                    GLUvertex gLUvertex6 = e2.getOrg();
                    Intrinsics.checkNotNull(gLUvertex6);
                    bl = Geom.INSTANCE.EdgeSign(gLUvertex4, gLUvertex5, gLUvertex6) <= 0.0;
                } else {
                    GLUhalfEdge gLUhalfEdge6 = e1.getSym();
                    Intrinsics.checkNotNull(gLUhalfEdge6);
                    GLUvertex gLUvertex7 = gLUhalfEdge6.getOrg();
                    Intrinsics.checkNotNull(gLUvertex7);
                    GLUvertex gLUvertex8 = e2.getOrg();
                    Intrinsics.checkNotNull(gLUvertex8);
                    GLUvertex gLUvertex9 = e1.getOrg();
                    Intrinsics.checkNotNull(gLUvertex9);
                    bl = Geom.INSTANCE.EdgeSign(gLUvertex7, gLUvertex8, gLUvertex9) >= 0.0;
                }
            } else {
                GLUhalfEdge gLUhalfEdge7 = e2.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge7);
                GLUvertex gLUvertex10 = gLUhalfEdge7.getOrg();
                Intrinsics.checkNotNull(gLUvertex10);
                GLUvertex gLUvertex11 = e2.getOrg();
                Intrinsics.checkNotNull(gLUvertex11);
                bl = Geom.INSTANCE.EdgeSign(gLUvertex10, event, gLUvertex11) <= 0.0;
            }
            return bl;
        }
        GLUhalfEdge gLUhalfEdge8 = e2.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge8);
        if (gLUhalfEdge8.getOrg() == event) {
            GLUhalfEdge gLUhalfEdge9 = e1.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge9);
            GLUvertex gLUvertex12 = gLUhalfEdge9.getOrg();
            Intrinsics.checkNotNull(gLUvertex12);
            GLUvertex gLUvertex13 = e1.getOrg();
            Intrinsics.checkNotNull(gLUvertex13);
            return Geom.INSTANCE.EdgeSign(gLUvertex12, event, gLUvertex13) >= 0.0;
        }
        GLUhalfEdge gLUhalfEdge10 = e1.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge10);
        GLUvertex gLUvertex14 = gLUhalfEdge10.getOrg();
        Intrinsics.checkNotNull(gLUvertex14);
        GLUvertex gLUvertex15 = e1.getOrg();
        Intrinsics.checkNotNull(gLUvertex15);
        t1 = Geom.INSTANCE.EdgeEval(gLUvertex14, event, gLUvertex15);
        GLUhalfEdge gLUhalfEdge11 = e2.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge11);
        GLUvertex gLUvertex16 = gLUhalfEdge11.getOrg();
        Intrinsics.checkNotNull(gLUvertex16);
        GLUvertex gLUvertex17 = e2.getOrg();
        Intrinsics.checkNotNull(gLUvertex17);
        t2 = Geom.INSTANCE.EdgeEval(gLUvertex16, event, gLUvertex17);
        return t1 >= t2;
    }

    public final void DeleteRegion(@NotNull GLUtessellatorImpl tess, @Nullable ActiveRegion reg) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        ActiveRegion activeRegion = reg;
        Intrinsics.checkNotNull(activeRegion);
        if (activeRegion.getFixUpperEdge()) {
            GLUhalfEdge gLUhalfEdge = reg.getEUp();
            Intrinsics.checkNotNull(gLUhalfEdge);
            if (!(gLUhalfEdge.getWinding() == 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }
        GLUhalfEdge gLUhalfEdge = reg.getEUp();
        Intrinsics.checkNotNull(gLUhalfEdge);
        gLUhalfEdge.setActiveRegion(null);
        Dict dict = tess.getDict$openrndr_ktessellation();
        DictNode dictNode = reg.getNodeUp();
        Intrinsics.checkNotNull(dictNode);
        Dict.Companion.dictDelete(dict, dictNode);
    }

    public final boolean FixUpperEdge(@NotNull ActiveRegion reg, @Nullable GLUhalfEdge newEdge) {
        Intrinsics.checkNotNullParameter(reg, "reg");
        if (!reg.getFixUpperEdge()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        GLUhalfEdge gLUhalfEdge = reg.getEUp();
        Intrinsics.checkNotNull(gLUhalfEdge);
        if (!Mesh.INSTANCE.__gl_meshDelete(gLUhalfEdge)) {
            return false;
        }
        reg.setFixUpperEdge(false);
        reg.setEUp(newEdge);
        GLUhalfEdge gLUhalfEdge2 = newEdge;
        Intrinsics.checkNotNull(gLUhalfEdge2);
        gLUhalfEdge2.setActiveRegion(reg);
        return true;
    }

    @Nullable
    public final ActiveRegion TopLeftRegion(@NotNull ActiveRegion reg) {
        GLUhalfEdge gLUhalfEdge;
        Intrinsics.checkNotNullParameter(reg, "reg");
        ActiveRegion reg2 = reg;
        GLUhalfEdge gLUhalfEdge2 = reg2.getEUp();
        Intrinsics.checkNotNull(gLUhalfEdge2);
        GLUvertex gLUvertex = gLUhalfEdge2.getOrg();
        Intrinsics.checkNotNull(gLUvertex);
        GLUvertex org = gLUvertex;
        GLUhalfEdge e = null;
        do {
            Intrinsics.checkNotNull(this.RegionAbove(reg2));
            gLUhalfEdge = reg2.getEUp();
            Intrinsics.checkNotNull(gLUhalfEdge);
        } while (gLUhalfEdge.getOrg() == org);
        if (reg2.getFixUpperEdge()) {
            ActiveRegion activeRegion = this.RegionBelow(reg2);
            Intrinsics.checkNotNull(activeRegion);
            GLUhalfEdge gLUhalfEdge3 = activeRegion.getEUp();
            Intrinsics.checkNotNull(gLUhalfEdge3);
            GLUhalfEdge gLUhalfEdge4 = gLUhalfEdge3.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge4);
            GLUhalfEdge gLUhalfEdge5 = reg2.getEUp();
            Intrinsics.checkNotNull(gLUhalfEdge5);
            GLUhalfEdge gLUhalfEdge6 = gLUhalfEdge5.getLnext();
            Intrinsics.checkNotNull(gLUhalfEdge6);
            e = Mesh.INSTANCE.__gl_meshConnect(gLUhalfEdge4, gLUhalfEdge6);
            if (e == null) {
                return null;
            }
            if (!this.FixUpperEdge(reg2, e)) {
                return null;
            }
            ActiveRegion activeRegion2 = this.RegionAbove(reg2);
            Intrinsics.checkNotNull(activeRegion2);
            reg2 = activeRegion2;
        }
        return reg2;
    }

    @NotNull
    public final ActiveRegion TopRightRegion(@NotNull ActiveRegion reg) {
        GLUvertex gLUvertex;
        Intrinsics.checkNotNullParameter(reg, "reg");
        ActiveRegion reg2 = reg;
        GLUhalfEdge gLUhalfEdge = reg2.getEUp();
        Intrinsics.checkNotNull(gLUhalfEdge);
        GLUhalfEdge gLUhalfEdge2 = gLUhalfEdge.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge2);
        GLUvertex gLUvertex2 = gLUhalfEdge2.getOrg();
        Intrinsics.checkNotNull(gLUvertex2);
        GLUvertex dst = gLUvertex2;
        do {
            Intrinsics.checkNotNull(this.RegionAbove(reg2));
            GLUhalfEdge gLUhalfEdge3 = reg2.getEUp();
            Intrinsics.checkNotNull(gLUhalfEdge3);
            GLUhalfEdge gLUhalfEdge4 = gLUhalfEdge3.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge4);
            gLUvertex = gLUhalfEdge4.getOrg();
            Intrinsics.checkNotNull(gLUvertex);
        } while (gLUvertex == dst);
        return reg2;
    }

    @Nullable
    public final ActiveRegion AddRegionBelow(@NotNull GLUtessellatorImpl tess, @Nullable ActiveRegion regAbove, @Nullable GLUhalfEdge eNewUp) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        ActiveRegion regNew = new ActiveRegion();
        regNew.setEUp(eNewUp);
        Dict dict = tess.getDict$openrndr_ktessellation();
        Intrinsics.checkNotNull(dict);
        ActiveRegion activeRegion = regAbove;
        Intrinsics.checkNotNull(activeRegion);
        DictNode dictNode = activeRegion.getNodeUp();
        Intrinsics.checkNotNull(dictNode);
        regNew.setNodeUp(Dict.Companion.dictInsertBefore(dict, dictNode, regNew));
        if (regNew.getNodeUp() == null) {
            throw new RuntimeException();
        }
        regNew.setFixUpperEdge(false);
        regNew.setSentinel(false);
        regNew.setDirty(false);
        GLUhalfEdge gLUhalfEdge = eNewUp;
        Intrinsics.checkNotNull(gLUhalfEdge);
        gLUhalfEdge.setActiveRegion(regNew);
        return regNew;
    }

    public final boolean IsWindingInside(@NotNull GLUtessellatorImpl tess, int n) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        return switch (tess.getWindingRule()) {
            case 100130 -> {
                if ((n & 1) != 0) {
                    yield true;
                }
                yield false;
            }
            case 100131 -> {
                if (n != 0) {
                    yield true;
                }
                yield false;
            }
            case 100132 -> {
                if (n > 0) {
                    yield true;
                }
                yield false;
            }
            case 100133 -> {
                if (n < 0) {
                    yield true;
                }
                yield false;
            }
            case 100134 -> {
                if (n >= 2 || n <= -2) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalStateException("no such winding rule".toString());
        };
    }

    public final void ComputeWinding(@NotNull GLUtessellatorImpl tess, @NotNull ActiveRegion reg) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        Intrinsics.checkNotNullParameter(reg, "reg");
        ActiveRegion activeRegion = this.RegionAbove(reg);
        Intrinsics.checkNotNull(activeRegion);
        int n = activeRegion.getWindingNumber();
        GLUhalfEdge gLUhalfEdge = reg.getEUp();
        Intrinsics.checkNotNull(gLUhalfEdge);
        reg.setWindingNumber(n + gLUhalfEdge.getWinding());
        reg.setInside(this.IsWindingInside(tess, reg.getWindingNumber()));
    }

    public final void FinishRegion(@NotNull GLUtessellatorImpl tess, @NotNull ActiveRegion reg) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        Intrinsics.checkNotNullParameter(reg, "reg");
        GLUhalfEdge gLUhalfEdge = reg.getEUp();
        Intrinsics.checkNotNull(gLUhalfEdge);
        GLUhalfEdge e = gLUhalfEdge;
        GLUface gLUface = e.getLface();
        Intrinsics.checkNotNull(gLUface);
        GLUface f = gLUface;
        f.setInside(reg.getInside());
        f.setAnEdge(e);
        this.DeleteRegion(tess, reg);
    }

    @NotNull
    public final GLUhalfEdge FinishLeftRegions(@NotNull GLUtessellatorImpl tess, @NotNull ActiveRegion regFirst, @Nullable ActiveRegion regLast) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        Intrinsics.checkNotNullParameter(regFirst, "regFirst");
        ActiveRegion reg = null;
        ActiveRegion regPrev = null;
        GLUhalfEdge e = null;
        GLUhalfEdge ePrev = null;
        regPrev = regFirst;
        GLUhalfEdge gLUhalfEdge = regFirst.getEUp();
        Intrinsics.checkNotNull(gLUhalfEdge);
        ePrev = gLUhalfEdge;
        while (regPrev != regLast) {
            ActiveRegion activeRegion = regPrev;
            Intrinsics.checkNotNull(activeRegion);
            activeRegion.setFixUpperEdge(false);
            Intrinsics.checkNotNull(this.RegionBelow(regPrev));
            Intrinsics.checkNotNull(reg.getEUp());
            if (e.getOrg() != ePrev.getOrg()) {
                if (!reg.getFixUpperEdge()) {
                    this.FinishRegion(tess, regPrev);
                    break;
                }
                GLUhalfEdge gLUhalfEdge2 = ePrev.getOnext();
                Intrinsics.checkNotNull(gLUhalfEdge2);
                GLUhalfEdge gLUhalfEdge3 = gLUhalfEdge2.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge3);
                GLUhalfEdge gLUhalfEdge4 = e.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge4);
                e = Mesh.INSTANCE.__gl_meshConnect(gLUhalfEdge3, gLUhalfEdge4);
                if (e == null) {
                    throw new RuntimeException();
                }
                if (!this.FixUpperEdge(reg, e)) {
                    throw new RuntimeException();
                }
            }
            if (ePrev.getOnext() != e) {
                GLUhalfEdge gLUhalfEdge5 = e.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge5);
                GLUhalfEdge gLUhalfEdge6 = gLUhalfEdge5.getLnext();
                Intrinsics.checkNotNull(gLUhalfEdge6);
                if (!Mesh.INSTANCE.__gl_meshSplice(gLUhalfEdge6, e)) {
                    throw new RuntimeException();
                }
                if (!Mesh.INSTANCE.__gl_meshSplice(ePrev, e)) {
                    throw new RuntimeException();
                }
            }
            this.FinishRegion(tess, regPrev);
            Intrinsics.checkNotNull(reg.getEUp());
            regPrev = reg;
        }
        return ePrev;
    }

    public final void AddRightEdges(@NotNull GLUtessellatorImpl tess, @Nullable ActiveRegion regUp, @NotNull GLUhalfEdge eFirst, @NotNull GLUhalfEdge eLast, @Nullable GLUhalfEdge eTopLeft, boolean cleanUp) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        Intrinsics.checkNotNullParameter(eFirst, "eFirst");
        Intrinsics.checkNotNullParameter(eLast, "eLast");
        GLUhalfEdge eTopLeft2 = eTopLeft;
        ActiveRegion reg = null;
        ActiveRegion regPrev = null;
        GLUhalfEdge e = null;
        GLUhalfEdge ePrev = null;
        boolean firstTime = true;
        e = eFirst;
        do {
            GLUvertex gLUvertex = e.getOrg();
            Intrinsics.checkNotNull(gLUvertex);
            GLUhalfEdge gLUhalfEdge = e.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge);
            GLUvertex gLUvertex2 = gLUhalfEdge.getOrg();
            Intrinsics.checkNotNull(gLUvertex2);
            if (!Geom.INSTANCE.VertLeq(gLUvertex, gLUvertex2)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.AddRegionBelow(tess, regUp, e.getSym());
            Intrinsics.checkNotNull(e.getOnext());
        } while (e != eLast);
        if (eTopLeft2 == null) {
            ActiveRegion activeRegion = regUp;
            Intrinsics.checkNotNull(activeRegion);
            ActiveRegion activeRegion2 = this.RegionBelow(activeRegion);
            Intrinsics.checkNotNull(activeRegion2);
            GLUhalfEdge gLUhalfEdge = activeRegion2.getEUp();
            Intrinsics.checkNotNull(gLUhalfEdge);
            GLUhalfEdge gLUhalfEdge2 = gLUhalfEdge.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge2);
            eTopLeft2 = gLUhalfEdge2.getOnext();
        }
        regPrev = regUp;
        ePrev = eTopLeft2;
        while (true) {
            ActiveRegion activeRegion = regPrev;
            Intrinsics.checkNotNull(activeRegion);
            Intrinsics.checkNotNull(this.RegionBelow(activeRegion));
            GLUhalfEdge gLUhalfEdge = reg.getEUp();
            Intrinsics.checkNotNull(gLUhalfEdge);
            Intrinsics.checkNotNull(gLUhalfEdge.getSym());
            GLUvertex gLUvertex = e.getOrg();
            GLUhalfEdge gLUhalfEdge3 = ePrev;
            Intrinsics.checkNotNull(gLUhalfEdge3);
            if (gLUvertex != gLUhalfEdge3.getOrg()) break;
            if (e.getOnext() != ePrev) {
                GLUhalfEdge gLUhalfEdge4 = e.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge4);
                GLUhalfEdge gLUhalfEdge5 = gLUhalfEdge4.getLnext();
                Intrinsics.checkNotNull(gLUhalfEdge5);
                if (!Mesh.INSTANCE.__gl_meshSplice(gLUhalfEdge5, e)) {
                    throw new RuntimeException();
                }
                GLUhalfEdge gLUhalfEdge6 = ePrev.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge6);
                GLUhalfEdge gLUhalfEdge7 = gLUhalfEdge6.getLnext();
                Intrinsics.checkNotNull(gLUhalfEdge7);
                if (!Mesh.INSTANCE.__gl_meshSplice(gLUhalfEdge7, e)) {
                    throw new RuntimeException();
                }
            }
            reg.setWindingNumber(regPrev.getWindingNumber() - e.getWinding());
            reg.setInside(this.IsWindingInside(tess, reg.getWindingNumber()));
            regPrev.setDirty(true);
            if (!firstTime && this.CheckForRightSplice(tess, regPrev)) {
                this.AddWinding(e, ePrev);
                this.DeleteRegion(tess, regPrev);
                if (!Mesh.INSTANCE.__gl_meshDelete(ePrev)) {
                    throw new RuntimeException();
                }
            }
            firstTime = false;
            regPrev = reg;
            ePrev = e;
        }
        regPrev.setDirty(true);
        if (!(regPrev.getWindingNumber() - e.getWinding() == reg.getWindingNumber())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (cleanUp) {
            this.WalkDirtyRegions(tess, regPrev);
        }
    }

    public final void CallCombine(@NotNull GLUtessellatorImpl tess, @NotNull GLUvertex isect, @Nullable Object[] data, @Nullable float[] weights, boolean needed) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        Intrinsics.checkNotNullParameter(isect, "isect");
        double[] coords = new double[]{isect.getCoords()[0], isect.getCoords()[1], isect.getCoords()[2]};
        Object[] outData = new Object[1];
        tess.callCombineOrCombineData(coords, data, weights, outData);
        isect.setData(outData[0]);
        if (isect.getData() == null) {
            if (!needed) {
                Intrinsics.checkNotNull(data);
                isect.setData(data[0]);
            } else if (!tess.getFatalError()) {
                tess.callErrorOrErrorData(100156);
                tess.setFatalError(true);
            }
        }
    }

    public final void SpliceMergeVertices(@NotNull GLUtessellatorImpl tess, @NotNull GLUhalfEdge e1, @NotNull GLUhalfEdge e2) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        Intrinsics.checkNotNullParameter(e1, "e1");
        Intrinsics.checkNotNullParameter(e2, "e2");
        Object[] data = new Object[4];
        float[] fArray = new float[]{0.5f, 0.5f, 0.0f, 0.0f};
        float[] weights = fArray;
        GLUvertex gLUvertex = e1.getOrg();
        Intrinsics.checkNotNull(gLUvertex);
        data[0] = gLUvertex.getData();
        GLUvertex gLUvertex2 = e2.getOrg();
        Intrinsics.checkNotNull(gLUvertex2);
        data[1] = gLUvertex2.getData();
        GLUvertex gLUvertex3 = e1.getOrg();
        Intrinsics.checkNotNull(gLUvertex3);
        this.CallCombine(tess, gLUvertex3, data, weights, false);
        if (!Mesh.INSTANCE.__gl_meshSplice(e1, e2)) {
            throw new RuntimeException();
        }
    }

    public final void VertexWeights(@NotNull GLUvertex isect, @NotNull GLUvertex org, @NotNull GLUvertex dst, @NotNull float[] weights) {
        Intrinsics.checkNotNullParameter(isect, "isect");
        Intrinsics.checkNotNullParameter(org, "org");
        Intrinsics.checkNotNullParameter(dst, "dst");
        Intrinsics.checkNotNullParameter(weights, "weights");
        double t1 = Geom.INSTANCE.VertL1dist(org, isect);
        double t2 = Geom.INSTANCE.VertL1dist(dst, isect);
        weights[0] = (float)(0.5 * t2 / (t1 + t2));
        weights[1] = (float)(0.5 * t1 / (t1 + t2));
        double[] dArray = isect.getCoords();
        dArray[0] = dArray[0] + ((double)weights[0] * org.getCoords()[0] + (double)weights[1] * dst.getCoords()[0]);
        dArray = isect.getCoords();
        dArray[1] = dArray[1] + ((double)weights[0] * org.getCoords()[1] + (double)weights[1] * dst.getCoords()[1]);
        dArray = isect.getCoords();
        dArray[2] = dArray[2] + ((double)weights[0] * org.getCoords()[2] + (double)weights[1] * dst.getCoords()[2]);
    }

    public final void GetIntersectData(@NotNull GLUtessellatorImpl tess, @NotNull GLUvertex isect, @NotNull GLUvertex orgUp, @NotNull GLUvertex dstUp, @NotNull GLUvertex orgLo, @NotNull GLUvertex dstLo) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        Intrinsics.checkNotNullParameter(isect, "isect");
        Intrinsics.checkNotNullParameter(orgUp, "orgUp");
        Intrinsics.checkNotNullParameter(dstUp, "dstUp");
        Intrinsics.checkNotNullParameter(orgLo, "orgLo");
        Intrinsics.checkNotNullParameter(dstLo, "dstLo");
        Object[] data = new Object[4];
        float[] weights = new float[4];
        float[] weights1 = new float[2];
        float[] weights2 = new float[2];
        data[0] = orgUp.getData();
        data[1] = dstUp.getData();
        data[2] = orgLo.getData();
        data[3] = dstLo.getData();
        isect.getCoords()[2] = 0.0;
        isect.getCoords()[1] = isect.getCoords()[2];
        isect.getCoords()[0] = isect.getCoords()[1];
        this.VertexWeights(isect, orgUp, dstUp, weights1);
        this.VertexWeights(isect, orgLo, dstLo, weights2);
        ArrayUtilsKt.arraycopy(weights1, 0, weights, 0, 2);
        ArrayUtilsKt.arraycopy(weights2, 0, weights, 2, 2);
        this.CallCombine(tess, isect, data, weights, true);
    }

    public final boolean CheckForRightSplice(@NotNull GLUtessellatorImpl tess, @NotNull ActiveRegion regUp) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        Intrinsics.checkNotNullParameter(regUp, "regUp");
        ActiveRegion activeRegion = this.RegionBelow(regUp);
        Intrinsics.checkNotNull(activeRegion);
        ActiveRegion regLo = activeRegion;
        GLUhalfEdge gLUhalfEdge = regUp.getEUp();
        Intrinsics.checkNotNull(gLUhalfEdge);
        GLUhalfEdge eUp = gLUhalfEdge;
        GLUhalfEdge gLUhalfEdge2 = regLo.getEUp();
        Intrinsics.checkNotNull(gLUhalfEdge2);
        GLUhalfEdge eLo = gLUhalfEdge2;
        GLUvertex gLUvertex = eUp.getOrg();
        Intrinsics.checkNotNull(gLUvertex);
        GLUvertex gLUvertex2 = eLo.getOrg();
        Intrinsics.checkNotNull(gLUvertex2);
        if (Geom.INSTANCE.VertLeq(gLUvertex, gLUvertex2)) {
            GLUhalfEdge gLUhalfEdge3 = eLo.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge3);
            GLUvertex gLUvertex3 = gLUhalfEdge3.getOrg();
            Intrinsics.checkNotNull(gLUvertex3);
            GLUvertex gLUvertex4 = eUp.getOrg();
            Intrinsics.checkNotNull(gLUvertex4);
            GLUvertex gLUvertex5 = eLo.getOrg();
            Intrinsics.checkNotNull(gLUvertex5);
            if (Geom.INSTANCE.EdgeSign(gLUvertex3, gLUvertex4, gLUvertex5) > 0.0) {
                return false;
            }
            GLUvertex gLUvertex6 = eUp.getOrg();
            Intrinsics.checkNotNull(gLUvertex6);
            GLUvertex gLUvertex7 = eLo.getOrg();
            Intrinsics.checkNotNull(gLUvertex7);
            if (!Geom.INSTANCE.VertEq(gLUvertex6, gLUvertex7)) {
                GLUhalfEdge gLUhalfEdge4 = eLo.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge4);
                if (Mesh.INSTANCE.__gl_meshSplitEdge(gLUhalfEdge4) == null) {
                    throw new RuntimeException();
                }
                GLUhalfEdge gLUhalfEdge5 = eLo.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge5);
                GLUhalfEdge gLUhalfEdge6 = gLUhalfEdge5.getLnext();
                Intrinsics.checkNotNull(gLUhalfEdge6);
                if (!Mesh.INSTANCE.__gl_meshSplice(eUp, gLUhalfEdge6)) {
                    throw new RuntimeException();
                }
                regLo.setDirty(true);
                regUp.setDirty(regLo.getDirty());
            } else if (eUp.getOrg() != eLo.getOrg()) {
                PriorityQ priorityQ = tess.getPq$openrndr_ktessellation();
                Intrinsics.checkNotNull(priorityQ);
                GLUvertex gLUvertex8 = eUp.getOrg();
                Intrinsics.checkNotNull(gLUvertex8);
                priorityQ.pqDelete(gLUvertex8.getPqHandle());
                GLUhalfEdge gLUhalfEdge7 = eLo.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge7);
                GLUhalfEdge gLUhalfEdge8 = gLUhalfEdge7.getLnext();
                Intrinsics.checkNotNull(gLUhalfEdge8);
                this.SpliceMergeVertices(tess, gLUhalfEdge8, eUp);
            }
        } else {
            GLUhalfEdge gLUhalfEdge9 = eUp.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge9);
            GLUvertex gLUvertex9 = gLUhalfEdge9.getOrg();
            Intrinsics.checkNotNull(gLUvertex9);
            GLUvertex gLUvertex10 = eLo.getOrg();
            Intrinsics.checkNotNull(gLUvertex10);
            GLUvertex gLUvertex11 = eUp.getOrg();
            Intrinsics.checkNotNull(gLUvertex11);
            if (Geom.INSTANCE.EdgeSign(gLUvertex9, gLUvertex10, gLUvertex11) < 0.0) {
                return false;
            }
            regUp.setDirty(true);
            ActiveRegion activeRegion2 = this.RegionAbove(regUp);
            Intrinsics.checkNotNull(activeRegion2);
            activeRegion2.setDirty(regUp.getDirty());
            GLUhalfEdge gLUhalfEdge10 = eUp.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge10);
            if (Mesh.INSTANCE.__gl_meshSplitEdge(gLUhalfEdge10) == null) {
                throw new RuntimeException();
            }
            GLUhalfEdge gLUhalfEdge11 = eLo.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge11);
            GLUhalfEdge gLUhalfEdge12 = gLUhalfEdge11.getLnext();
            Intrinsics.checkNotNull(gLUhalfEdge12);
            if (!Mesh.INSTANCE.__gl_meshSplice(gLUhalfEdge12, eUp)) {
                throw new RuntimeException();
            }
        }
        return true;
    }

    public final boolean CheckForLeftSplice(@Nullable GLUtessellatorImpl tess, @Nullable ActiveRegion regUp) {
        ActiveRegion activeRegion = regUp;
        Intrinsics.checkNotNull(activeRegion);
        ActiveRegion activeRegion2 = this.RegionBelow(activeRegion);
        Intrinsics.checkNotNull(activeRegion2);
        ActiveRegion regLo = activeRegion2;
        GLUhalfEdge gLUhalfEdge = regUp.getEUp();
        Intrinsics.checkNotNull(gLUhalfEdge);
        GLUhalfEdge eUp = gLUhalfEdge;
        GLUhalfEdge gLUhalfEdge2 = regLo.getEUp();
        Intrinsics.checkNotNull(gLUhalfEdge2);
        GLUhalfEdge eLo = gLUhalfEdge2;
        GLUhalfEdge e = null;
        GLUhalfEdge gLUhalfEdge3 = eUp.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge3);
        GLUvertex gLUvertex = gLUhalfEdge3.getOrg();
        Intrinsics.checkNotNull(gLUvertex);
        GLUhalfEdge gLUhalfEdge4 = eLo.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge4);
        GLUvertex gLUvertex2 = gLUhalfEdge4.getOrg();
        Intrinsics.checkNotNull(gLUvertex2);
        if (!(!Geom.INSTANCE.VertEq(gLUvertex, gLUvertex2))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        GLUhalfEdge gLUhalfEdge5 = eUp.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge5);
        GLUvertex gLUvertex3 = gLUhalfEdge5.getOrg();
        Intrinsics.checkNotNull(gLUvertex3);
        GLUhalfEdge gLUhalfEdge6 = eLo.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge6);
        GLUvertex gLUvertex4 = gLUhalfEdge6.getOrg();
        Intrinsics.checkNotNull(gLUvertex4);
        if (Geom.INSTANCE.VertLeq(gLUvertex3, gLUvertex4)) {
            GLUhalfEdge gLUhalfEdge7 = eUp.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge7);
            GLUvertex gLUvertex5 = gLUhalfEdge7.getOrg();
            Intrinsics.checkNotNull(gLUvertex5);
            GLUhalfEdge gLUhalfEdge8 = eLo.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge8);
            GLUvertex gLUvertex6 = gLUhalfEdge8.getOrg();
            Intrinsics.checkNotNull(gLUvertex6);
            GLUvertex gLUvertex7 = eUp.getOrg();
            Intrinsics.checkNotNull(gLUvertex7);
            if (Geom.INSTANCE.EdgeSign(gLUvertex5, gLUvertex6, gLUvertex7) < 0.0) {
                return false;
            }
            regUp.setDirty(true);
            ActiveRegion activeRegion3 = this.RegionAbove(regUp);
            Intrinsics.checkNotNull(activeRegion3);
            activeRegion3.setDirty(regUp.getDirty());
            e = Mesh.INSTANCE.__gl_meshSplitEdge(eUp);
            if (e == null) {
                throw new RuntimeException();
            }
            GLUhalfEdge gLUhalfEdge9 = eLo.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge9);
            if (!Mesh.INSTANCE.__gl_meshSplice(gLUhalfEdge9, e)) {
                throw new RuntimeException();
            }
            GLUface gLUface = e.getLface();
            Intrinsics.checkNotNull(gLUface);
            gLUface.setInside(regUp.getInside());
        } else {
            GLUhalfEdge gLUhalfEdge10 = eLo.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge10);
            GLUvertex gLUvertex8 = gLUhalfEdge10.getOrg();
            Intrinsics.checkNotNull(gLUvertex8);
            GLUhalfEdge gLUhalfEdge11 = eUp.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge11);
            GLUvertex gLUvertex9 = gLUhalfEdge11.getOrg();
            Intrinsics.checkNotNull(gLUvertex9);
            GLUvertex gLUvertex10 = eLo.getOrg();
            Intrinsics.checkNotNull(gLUvertex10);
            if (Geom.INSTANCE.EdgeSign(gLUvertex8, gLUvertex9, gLUvertex10) > 0.0) {
                return false;
            }
            regLo.setDirty(true);
            regUp.setDirty(regLo.getDirty());
            e = Mesh.INSTANCE.__gl_meshSplitEdge(eLo);
            if (e == null) {
                throw new RuntimeException();
            }
            GLUhalfEdge gLUhalfEdge12 = eUp.getLnext();
            Intrinsics.checkNotNull(gLUhalfEdge12);
            GLUhalfEdge gLUhalfEdge13 = eLo.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge13);
            if (!Mesh.INSTANCE.__gl_meshSplice(gLUhalfEdge12, gLUhalfEdge13)) {
                throw new RuntimeException();
            }
            GLUhalfEdge gLUhalfEdge14 = e.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge14);
            GLUface gLUface = gLUhalfEdge14.getLface();
            Intrinsics.checkNotNull(gLUface);
            gLUface.setInside(regUp.getInside());
        }
        return true;
    }

    public final boolean CheckForIntersect(@NotNull GLUtessellatorImpl tess, @NotNull ActiveRegion regUp) {
        GLUvertex isect;
        GLUvertex dstLo;
        GLUvertex dstUp;
        GLUvertex orgLo;
        GLUvertex orgUp;
        GLUhalfEdge eLo;
        GLUhalfEdge eUp;
        ActiveRegion regLo;
        ActiveRegion regUp2;
        block35: {
            GLUhalfEdge e;
            block34: {
                block33: {
                    GLUvertex orgMin;
                    double tMaxLo;
                    Intrinsics.checkNotNullParameter(tess, "tess");
                    Intrinsics.checkNotNullParameter(regUp, "regUp");
                    regUp2 = regUp;
                    ActiveRegion activeRegion = this.RegionBelow(regUp2);
                    Intrinsics.checkNotNull(activeRegion);
                    regLo = activeRegion;
                    GLUhalfEdge gLUhalfEdge = regUp2.getEUp();
                    Intrinsics.checkNotNull(gLUhalfEdge);
                    eUp = gLUhalfEdge;
                    GLUhalfEdge gLUhalfEdge2 = regLo.getEUp();
                    Intrinsics.checkNotNull(gLUhalfEdge2);
                    eLo = gLUhalfEdge2;
                    GLUvertex gLUvertex = eUp.getOrg();
                    Intrinsics.checkNotNull(gLUvertex);
                    orgUp = gLUvertex;
                    GLUvertex gLUvertex2 = eLo.getOrg();
                    Intrinsics.checkNotNull(gLUvertex2);
                    orgLo = gLUvertex2;
                    GLUhalfEdge gLUhalfEdge3 = eUp.getSym();
                    Intrinsics.checkNotNull(gLUhalfEdge3);
                    GLUvertex gLUvertex3 = gLUhalfEdge3.getOrg();
                    Intrinsics.checkNotNull(gLUvertex3);
                    dstUp = gLUvertex3;
                    GLUhalfEdge gLUhalfEdge4 = eLo.getSym();
                    Intrinsics.checkNotNull(gLUhalfEdge4);
                    GLUvertex gLUvertex4 = gLUhalfEdge4.getOrg();
                    Intrinsics.checkNotNull(gLUvertex4);
                    dstLo = gLUvertex4;
                    isect = new GLUvertex();
                    e = null;
                    if (!(!Geom.INSTANCE.VertEq(dstLo, dstUp))) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    GLUvertex gLUvertex5 = tess.getEvent$openrndr_ktessellation();
                    Intrinsics.checkNotNull(gLUvertex5);
                    if (!(Geom.INSTANCE.EdgeSign(dstUp, gLUvertex5, orgUp) <= 0.0)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    GLUvertex gLUvertex6 = tess.getEvent$openrndr_ktessellation();
                    Intrinsics.checkNotNull(gLUvertex6);
                    if (!(Geom.INSTANCE.EdgeSign(dstLo, gLUvertex6, orgLo) >= 0.0)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (!(orgUp != tess.getEvent$openrndr_ktessellation() && orgLo != tess.getEvent$openrndr_ktessellation())) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (!(!regUp2.getFixUpperEdge() && !regLo.getFixUpperEdge())) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (orgUp == orgLo) {
                        return false;
                    }
                    double tMinUp = Math.min(orgUp.getT(), dstUp.getT());
                    if (tMinUp > (tMaxLo = Math.max(orgLo.getT(), dstLo.getT()))) {
                        return false;
                    }
                    if (Geom.INSTANCE.VertLeq(orgUp, orgLo) ? Geom.INSTANCE.EdgeSign(dstLo, orgUp, orgLo) > 0.0 : Geom.INSTANCE.EdgeSign(dstUp, orgLo, orgUp) < 0.0) {
                        return false;
                    }
                    this.DebugEvent(tess);
                    Geom.INSTANCE.EdgeIntersect(dstUp, orgUp, dstLo, orgLo, isect);
                    if (!(Math.min(orgUp.getT(), dstUp.getT()) <= isect.getT())) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (!(isect.getT() <= Math.max(orgLo.getT(), dstLo.getT()))) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (!(Math.min(dstLo.getS(), dstUp.getS()) <= isect.getS())) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (!(isect.getS() <= Math.max(orgLo.getS(), orgUp.getS()))) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    GLUvertex gLUvertex7 = tess.getEvent$openrndr_ktessellation();
                    Intrinsics.checkNotNull(gLUvertex7);
                    if (Geom.INSTANCE.VertLeq(isect, gLUvertex7)) {
                        GLUvertex gLUvertex8 = tess.getEvent$openrndr_ktessellation();
                        Intrinsics.checkNotNull(gLUvertex8);
                        isect.setS(gLUvertex8.getS());
                        GLUvertex gLUvertex9 = tess.getEvent$openrndr_ktessellation();
                        Intrinsics.checkNotNull(gLUvertex9);
                        isect.setT(gLUvertex9.getT());
                    }
                    GLUvertex gLUvertex10 = orgMin = Geom.INSTANCE.VertLeq(orgUp, orgLo) ? orgUp : orgLo;
                    if (Geom.INSTANCE.VertLeq(orgMin, isect)) {
                        isect.setS(orgMin.getS());
                        isect.setT(orgMin.getT());
                    }
                    if (Geom.INSTANCE.VertEq(isect, orgUp) || Geom.INSTANCE.VertEq(isect, orgLo)) {
                        this.CheckForRightSplice(tess, regUp2);
                        return false;
                    }
                    GLUvertex gLUvertex11 = tess.getEvent$openrndr_ktessellation();
                    Intrinsics.checkNotNull(gLUvertex11);
                    if (Geom.INSTANCE.VertEq(dstUp, gLUvertex11)) break block33;
                    GLUvertex gLUvertex12 = tess.getEvent$openrndr_ktessellation();
                    Intrinsics.checkNotNull(gLUvertex12);
                    if (Geom.INSTANCE.EdgeSign(dstUp, gLUvertex12, isect) >= 0.0) break block34;
                }
                GLUvertex gLUvertex = tess.getEvent$openrndr_ktessellation();
                Intrinsics.checkNotNull(gLUvertex);
                if (Geom.INSTANCE.VertEq(dstLo, gLUvertex)) break block35;
                GLUvertex gLUvertex13 = tess.getEvent$openrndr_ktessellation();
                Intrinsics.checkNotNull(gLUvertex13);
                if (!(Geom.INSTANCE.EdgeSign(dstLo, gLUvertex13, isect) <= 0.0)) break block35;
            }
            if (dstLo == tess.getEvent$openrndr_ktessellation()) {
                GLUhalfEdge gLUhalfEdge = eUp.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge);
                if (Mesh.INSTANCE.__gl_meshSplitEdge(gLUhalfEdge) == null) {
                    throw new RuntimeException();
                }
                GLUhalfEdge gLUhalfEdge5 = eLo.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge5);
                if (!Mesh.INSTANCE.__gl_meshSplice(gLUhalfEdge5, eUp)) {
                    throw new RuntimeException();
                }
                ActiveRegion activeRegion = this.TopLeftRegion(regUp2);
                Intrinsics.checkNotNull(activeRegion);
                regUp2 = activeRegion;
                if (regUp2 == null) {
                    throw new RuntimeException();
                }
                ActiveRegion activeRegion2 = this.RegionBelow(regUp2);
                Intrinsics.checkNotNull(activeRegion2);
                GLUhalfEdge gLUhalfEdge6 = activeRegion2.getEUp();
                Intrinsics.checkNotNull(gLUhalfEdge6);
                eUp = gLUhalfEdge6;
                ActiveRegion activeRegion3 = this.RegionBelow(regUp2);
                Intrinsics.checkNotNull(activeRegion3);
                this.FinishLeftRegions(tess, activeRegion3, regLo);
                GLUhalfEdge gLUhalfEdge7 = eUp.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge7);
                GLUhalfEdge gLUhalfEdge8 = gLUhalfEdge7.getLnext();
                Intrinsics.checkNotNull(gLUhalfEdge8);
                this.AddRightEdges(tess, regUp2, gLUhalfEdge8, eUp, eUp, true);
                return true;
            }
            if (dstUp == tess.getEvent$openrndr_ktessellation()) {
                GLUhalfEdge gLUhalfEdge = eLo.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge);
                if (Mesh.INSTANCE.__gl_meshSplitEdge(gLUhalfEdge) == null) {
                    throw new RuntimeException();
                }
                GLUhalfEdge gLUhalfEdge9 = eUp.getLnext();
                Intrinsics.checkNotNull(gLUhalfEdge9);
                GLUhalfEdge gLUhalfEdge10 = eLo.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge10);
                GLUhalfEdge gLUhalfEdge11 = gLUhalfEdge10.getLnext();
                Intrinsics.checkNotNull(gLUhalfEdge11);
                if (!Mesh.INSTANCE.__gl_meshSplice(gLUhalfEdge9, gLUhalfEdge11)) {
                    throw new RuntimeException();
                }
                regLo = regUp2;
                regUp2 = this.TopRightRegion(regUp2);
                ActiveRegion activeRegion = this.RegionBelow(regUp2);
                Intrinsics.checkNotNull(activeRegion);
                GLUhalfEdge gLUhalfEdge12 = activeRegion.getEUp();
                Intrinsics.checkNotNull(gLUhalfEdge12);
                GLUhalfEdge gLUhalfEdge13 = gLUhalfEdge12.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge13);
                GLUhalfEdge gLUhalfEdge14 = gLUhalfEdge13.getOnext();
                Intrinsics.checkNotNull(gLUhalfEdge14);
                e = gLUhalfEdge14;
                GLUhalfEdge gLUhalfEdge15 = eLo.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge15);
                GLUhalfEdge gLUhalfEdge16 = gLUhalfEdge15.getLnext();
                Intrinsics.checkNotNull(gLUhalfEdge16);
                regLo.setEUp(gLUhalfEdge16);
                eLo = this.FinishLeftRegions(tess, regLo, null);
                GLUhalfEdge gLUhalfEdge17 = eLo.getOnext();
                Intrinsics.checkNotNull(gLUhalfEdge17);
                GLUhalfEdge gLUhalfEdge18 = eUp.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge18);
                GLUhalfEdge gLUhalfEdge19 = gLUhalfEdge18.getOnext();
                Intrinsics.checkNotNull(gLUhalfEdge19);
                this.AddRightEdges(tess, regUp2, gLUhalfEdge17, gLUhalfEdge19, e, true);
                return true;
            }
            GLUvertex gLUvertex = tess.getEvent$openrndr_ktessellation();
            Intrinsics.checkNotNull(gLUvertex);
            if (Geom.INSTANCE.EdgeSign(dstUp, gLUvertex, isect) >= 0.0) {
                regUp2.setDirty(true);
                ActiveRegion activeRegion = this.RegionAbove(regUp2);
                Intrinsics.checkNotNull(activeRegion);
                activeRegion.setDirty(regUp2.getDirty());
                GLUhalfEdge gLUhalfEdge = eUp.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge);
                if (Mesh.INSTANCE.__gl_meshSplitEdge(gLUhalfEdge) == null) {
                    throw new RuntimeException();
                }
                GLUvertex gLUvertex14 = eUp.getOrg();
                Intrinsics.checkNotNull(gLUvertex14);
                GLUvertex gLUvertex15 = tess.getEvent$openrndr_ktessellation();
                Intrinsics.checkNotNull(gLUvertex15);
                gLUvertex14.setS(gLUvertex15.getS());
                GLUvertex gLUvertex16 = eUp.getOrg();
                Intrinsics.checkNotNull(gLUvertex16);
                GLUvertex gLUvertex17 = tess.getEvent$openrndr_ktessellation();
                Intrinsics.checkNotNull(gLUvertex17);
                gLUvertex16.setT(gLUvertex17.getT());
            }
            GLUvertex gLUvertex18 = tess.getEvent$openrndr_ktessellation();
            Intrinsics.checkNotNull(gLUvertex18);
            if (Geom.INSTANCE.EdgeSign(dstLo, gLUvertex18, isect) <= 0.0) {
                regLo.setDirty(true);
                regUp2.setDirty(regLo.getDirty());
                GLUhalfEdge gLUhalfEdge = eLo.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge);
                if (Mesh.INSTANCE.__gl_meshSplitEdge(gLUhalfEdge) == null) {
                    throw new RuntimeException();
                }
                GLUvertex gLUvertex19 = eLo.getOrg();
                Intrinsics.checkNotNull(gLUvertex19);
                GLUvertex gLUvertex20 = tess.getEvent$openrndr_ktessellation();
                Intrinsics.checkNotNull(gLUvertex20);
                gLUvertex19.setS(gLUvertex20.getS());
                GLUvertex gLUvertex21 = eLo.getOrg();
                Intrinsics.checkNotNull(gLUvertex21);
                GLUvertex gLUvertex22 = tess.getEvent$openrndr_ktessellation();
                Intrinsics.checkNotNull(gLUvertex22);
                gLUvertex21.setT(gLUvertex22.getT());
            }
            return false;
        }
        GLUhalfEdge gLUhalfEdge = eUp.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge);
        if (Mesh.INSTANCE.__gl_meshSplitEdge(gLUhalfEdge) == null) {
            throw new RuntimeException();
        }
        GLUhalfEdge gLUhalfEdge20 = eLo.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge20);
        if (Mesh.INSTANCE.__gl_meshSplitEdge(gLUhalfEdge20) == null) {
            throw new RuntimeException();
        }
        GLUhalfEdge gLUhalfEdge21 = eLo.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge21);
        GLUhalfEdge gLUhalfEdge22 = gLUhalfEdge21.getLnext();
        Intrinsics.checkNotNull(gLUhalfEdge22);
        if (!Mesh.INSTANCE.__gl_meshSplice(gLUhalfEdge22, eUp)) {
            throw new RuntimeException();
        }
        GLUvertex gLUvertex = eUp.getOrg();
        Intrinsics.checkNotNull(gLUvertex);
        gLUvertex.setS(isect.getS());
        GLUvertex gLUvertex23 = eUp.getOrg();
        Intrinsics.checkNotNull(gLUvertex23);
        gLUvertex23.setT(isect.getT());
        GLUvertex gLUvertex24 = eUp.getOrg();
        Intrinsics.checkNotNull(gLUvertex24);
        PriorityQ priorityQ = tess.getPq$openrndr_ktessellation();
        Intrinsics.checkNotNull(priorityQ);
        gLUvertex24.setPqHandle(priorityQ.pqInsert(eUp.getOrg()));
        GLUvertex gLUvertex25 = eUp.getOrg();
        Intrinsics.checkNotNull(gLUvertex25);
        if ((long)gLUvertex25.getPqHandle() == Long.MAX_VALUE) {
            PriorityQ priorityQ2 = tess.getPq$openrndr_ktessellation();
            Intrinsics.checkNotNull(priorityQ2);
            priorityQ2.pqDeletePriorityQ();
            tess.setPq$openrndr_ktessellation(null);
            throw new RuntimeException();
        }
        GLUvertex gLUvertex26 = eUp.getOrg();
        Intrinsics.checkNotNull(gLUvertex26);
        this.GetIntersectData(tess, gLUvertex26, orgUp, dstUp, orgLo, dstLo);
        regLo.setDirty(true);
        regUp2.setDirty(regLo.getDirty());
        ActiveRegion activeRegion = this.RegionAbove(regUp2);
        Intrinsics.checkNotNull(activeRegion);
        activeRegion.setDirty(regUp2.getDirty());
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public final void WalkDirtyRegions(@NotNull GLUtessellatorImpl tess, @NotNull ActiveRegion regUp) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        Intrinsics.checkNotNullParameter(regUp, "regUp");
        regUp = regUp;
        regLo = this.RegionBelow(regUp);
        eUp = null;
        eLo = null;
        while (true) {
            block14: {
                v0 = regLo;
                Intrinsics.checkNotNull(v0);
                if (v0.getDirty()) {
                    regUp = regLo;
                    Intrinsics.checkNotNull(this.RegionBelow(regLo));
                    continue;
                }
                v1 = regUp;
                Intrinsics.checkNotNull(v1);
                if (!v1.getDirty()) {
                    regLo = regUp;
                    if ((regUp = this.RegionAbove(regUp)) == null || !regUp.getDirty()) {
                        return;
                    }
                }
                regUp.setDirty(false);
                Intrinsics.checkNotNull(regUp.getEUp());
                Intrinsics.checkNotNull(regLo.getEUp());
                v2 = eUp.getSym();
                Intrinsics.checkNotNull(v2);
                v3 = v2.getOrg();
                v4 = eLo.getSym();
                Intrinsics.checkNotNull(v4);
                if (v3 != v4.getOrg() && this.CheckForLeftSplice(tess, regUp)) {
                    if (regLo.getFixUpperEdge()) {
                        this.DeleteRegion(tess, regLo);
                        if (!Mesh.INSTANCE.__gl_meshDelete(eLo)) {
                            throw new RuntimeException();
                        }
                        Intrinsics.checkNotNull(this.RegionBelow(regUp));
                        v5 = regLo.getEUp();
                        Intrinsics.checkNotNull(v5);
                        eLo = v5;
                    } else if (regUp.getFixUpperEdge()) {
                        this.DeleteRegion(tess, regUp);
                        if (!Mesh.INSTANCE.__gl_meshDelete(eUp)) {
                            throw new RuntimeException();
                        }
                        Intrinsics.checkNotNull(this.RegionAbove(regLo));
                        v6 = regUp.getEUp();
                        Intrinsics.checkNotNull(v6);
                        eUp = v6;
                    }
                }
                if (eUp.getOrg() == eLo.getOrg()) break block14;
                v7 = eUp.getSym();
                Intrinsics.checkNotNull(v7);
                v8 = v7.getOrg();
                v9 = eLo.getSym();
                Intrinsics.checkNotNull(v9);
                if (v8 == v9.getOrg() || regUp.getFixUpperEdge() || regLo.getFixUpperEdge()) ** GOTO lbl-1000
                v10 = eUp.getSym();
                Intrinsics.checkNotNull(v10);
                if (v10.getOrg() == tess.getEvent$openrndr_ktessellation()) ** GOTO lbl-1000
                v11 = eLo.getSym();
                Intrinsics.checkNotNull(v11);
                if (v11.getOrg() == tess.getEvent$openrndr_ktessellation()) lbl-1000:
                // 2 sources

                {
                    if (this.CheckForIntersect(tess, regUp)) {
                        return;
                    }
                } else lbl-1000:
                // 2 sources

                {
                    this.CheckForRightSplice(tess, regUp);
                }
            }
            if (eUp.getOrg() != eLo.getOrg()) continue;
            v12 = eUp.getSym();
            Intrinsics.checkNotNull(v12);
            v13 = v12.getOrg();
            v14 = eLo.getSym();
            Intrinsics.checkNotNull(v14);
            if (v13 != v14.getOrg()) continue;
            this.AddWinding(eLo, eUp);
            this.DeleteRegion(tess, regUp);
            if (!Mesh.INSTANCE.__gl_meshDelete(eUp)) {
                throw new RuntimeException();
            }
            Intrinsics.checkNotNull(this.RegionAbove(regLo));
        }
    }

    public final void ConnectRightVertex(@NotNull GLUtessellatorImpl tess, @NotNull ActiveRegion regUp, @NotNull GLUhalfEdge eBottomLeft) {
        GLUhalfEdge gLUhalfEdge;
        Intrinsics.checkNotNullParameter(tess, "tess");
        Intrinsics.checkNotNullParameter(regUp, "regUp");
        Intrinsics.checkNotNullParameter(eBottomLeft, "eBottomLeft");
        ActiveRegion regUp2 = regUp;
        GLUhalfEdge eBottomLeft2 = eBottomLeft;
        GLUhalfEdge eNew = null;
        GLUhalfEdge gLUhalfEdge2 = eBottomLeft2.getOnext();
        Intrinsics.checkNotNull(gLUhalfEdge2);
        GLUhalfEdge eTopLeft = gLUhalfEdge2;
        ActiveRegion activeRegion = this.RegionBelow(regUp2);
        Intrinsics.checkNotNull(activeRegion);
        ActiveRegion regLo = activeRegion;
        GLUhalfEdge gLUhalfEdge3 = regUp2.getEUp();
        Intrinsics.checkNotNull(gLUhalfEdge3);
        GLUhalfEdge eUp = gLUhalfEdge3;
        GLUhalfEdge gLUhalfEdge4 = regLo.getEUp();
        Intrinsics.checkNotNull(gLUhalfEdge4);
        GLUhalfEdge eLo = gLUhalfEdge4;
        boolean degenerate = false;
        GLUhalfEdge gLUhalfEdge5 = eUp.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge5);
        GLUvertex gLUvertex = gLUhalfEdge5.getOrg();
        GLUhalfEdge gLUhalfEdge6 = eLo.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge6);
        if (gLUvertex != gLUhalfEdge6.getOrg()) {
            this.CheckForIntersect(tess, regUp2);
        }
        GLUvertex gLUvertex2 = eUp.getOrg();
        Intrinsics.checkNotNull(gLUvertex2);
        GLUvertex gLUvertex3 = tess.getEvent$openrndr_ktessellation();
        Intrinsics.checkNotNull(gLUvertex3);
        if (Geom.INSTANCE.VertEq(gLUvertex2, gLUvertex3)) {
            GLUhalfEdge gLUhalfEdge7 = eTopLeft.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge7);
            GLUhalfEdge gLUhalfEdge8 = gLUhalfEdge7.getLnext();
            Intrinsics.checkNotNull(gLUhalfEdge8);
            if (!Mesh.INSTANCE.__gl_meshSplice(gLUhalfEdge8, eUp)) {
                throw new RuntimeException();
            }
            ActiveRegion activeRegion2 = this.TopLeftRegion(regUp2);
            Intrinsics.checkNotNull(activeRegion2);
            regUp2 = activeRegion2;
            if (regUp2 == null) {
                throw new RuntimeException();
            }
            ActiveRegion activeRegion3 = this.RegionBelow(regUp2);
            Intrinsics.checkNotNull(activeRegion3);
            GLUhalfEdge gLUhalfEdge9 = activeRegion3.getEUp();
            Intrinsics.checkNotNull(gLUhalfEdge9);
            eTopLeft = gLUhalfEdge9;
            ActiveRegion activeRegion4 = this.RegionBelow(regUp2);
            Intrinsics.checkNotNull(activeRegion4);
            this.FinishLeftRegions(tess, activeRegion4, regLo);
            degenerate = true;
        }
        GLUvertex gLUvertex4 = eLo.getOrg();
        Intrinsics.checkNotNull(gLUvertex4);
        GLUvertex gLUvertex5 = tess.getEvent$openrndr_ktessellation();
        Intrinsics.checkNotNull(gLUvertex5);
        if (Geom.INSTANCE.VertEq(gLUvertex4, gLUvertex5)) {
            GLUhalfEdge gLUhalfEdge10 = eLo.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge10);
            GLUhalfEdge gLUhalfEdge11 = gLUhalfEdge10.getLnext();
            Intrinsics.checkNotNull(gLUhalfEdge11);
            if (!Mesh.INSTANCE.__gl_meshSplice(eBottomLeft2, gLUhalfEdge11)) {
                throw new RuntimeException();
            }
            eBottomLeft2 = this.FinishLeftRegions(tess, regLo, null);
            degenerate = true;
        }
        if (degenerate) {
            GLUhalfEdge gLUhalfEdge12 = eBottomLeft2.getOnext();
            Intrinsics.checkNotNull(gLUhalfEdge12);
            this.AddRightEdges(tess, regUp2, gLUhalfEdge12, eTopLeft, eTopLeft, true);
            return;
        }
        GLUvertex gLUvertex6 = eLo.getOrg();
        Intrinsics.checkNotNull(gLUvertex6);
        GLUvertex gLUvertex7 = eUp.getOrg();
        Intrinsics.checkNotNull(gLUvertex7);
        if (Geom.INSTANCE.VertLeq(gLUvertex6, gLUvertex7)) {
            GLUhalfEdge gLUhalfEdge13 = eLo.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge13);
            GLUhalfEdge gLUhalfEdge14 = gLUhalfEdge13.getLnext();
            gLUhalfEdge = gLUhalfEdge14;
            Intrinsics.checkNotNull(gLUhalfEdge14);
        } else {
            gLUhalfEdge = eUp;
        }
        eNew = gLUhalfEdge;
        GLUhalfEdge gLUhalfEdge15 = eBottomLeft2.getOnext();
        Intrinsics.checkNotNull(gLUhalfEdge15);
        GLUhalfEdge gLUhalfEdge16 = gLUhalfEdge15.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge16);
        eNew = Mesh.INSTANCE.__gl_meshConnect(gLUhalfEdge16, eNew);
        GLUhalfEdge gLUhalfEdge17 = eNew.getOnext();
        Intrinsics.checkNotNull(gLUhalfEdge17);
        this.AddRightEdges(tess, regUp2, eNew, gLUhalfEdge17, eNew.getOnext(), false);
        GLUhalfEdge gLUhalfEdge18 = eNew.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge18);
        ActiveRegion activeRegion5 = gLUhalfEdge18.getActiveRegion();
        Intrinsics.checkNotNull(activeRegion5);
        activeRegion5.setFixUpperEdge(true);
        this.WalkDirtyRegions(tess, regUp2);
    }

    public final void ConnectLeftDegenerate(@NotNull GLUtessellatorImpl tess, @NotNull ActiveRegion regUp, @NotNull GLUvertex vEvent) {
        GLUhalfEdge eLast;
        Intrinsics.checkNotNullParameter(tess, "tess");
        Intrinsics.checkNotNullParameter(regUp, "regUp");
        Intrinsics.checkNotNullParameter(vEvent, "vEvent");
        ActiveRegion regUp2 = regUp;
        GLUhalfEdge eTopLeft = null;
        GLUhalfEdge eTopRight = null;
        GLUhalfEdge gLUhalfEdge = regUp2.getEUp();
        Intrinsics.checkNotNull(gLUhalfEdge);
        GLUhalfEdge e = gLUhalfEdge;
        GLUvertex gLUvertex = e.getOrg();
        Intrinsics.checkNotNull(gLUvertex);
        if (Geom.INSTANCE.VertEq(gLUvertex, vEvent)) {
            GLUhalfEdge gLUhalfEdge2 = vEvent.getAnEdge();
            Intrinsics.checkNotNull(gLUhalfEdge2);
            this.SpliceMergeVertices(tess, e, gLUhalfEdge2);
            return;
        }
        GLUhalfEdge gLUhalfEdge3 = e.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge3);
        GLUvertex gLUvertex2 = gLUhalfEdge3.getOrg();
        Intrinsics.checkNotNull(gLUvertex2);
        if (!Geom.INSTANCE.VertEq(gLUvertex2, vEvent)) {
            GLUhalfEdge gLUhalfEdge4 = e.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge4);
            if (Mesh.INSTANCE.__gl_meshSplitEdge(gLUhalfEdge4) == null) {
                throw new RuntimeException();
            }
            if (regUp2.getFixUpperEdge()) {
                GLUhalfEdge gLUhalfEdge5 = e.getOnext();
                Intrinsics.checkNotNull(gLUhalfEdge5);
                if (!Mesh.INSTANCE.__gl_meshDelete(gLUhalfEdge5)) {
                    throw new RuntimeException();
                }
                regUp2.setFixUpperEdge(false);
            }
            GLUhalfEdge gLUhalfEdge6 = vEvent.getAnEdge();
            Intrinsics.checkNotNull(gLUhalfEdge6);
            if (!Mesh.INSTANCE.__gl_meshSplice(gLUhalfEdge6, e)) {
                throw new RuntimeException();
            }
            this.SweepEvent(tess, vEvent);
            return;
        }
        regUp2 = this.TopRightRegion(regUp2);
        ActiveRegion activeRegion = this.RegionBelow(regUp2);
        Intrinsics.checkNotNull(activeRegion);
        ActiveRegion reg = activeRegion;
        GLUhalfEdge gLUhalfEdge7 = reg.getEUp();
        Intrinsics.checkNotNull(gLUhalfEdge7);
        GLUhalfEdge gLUhalfEdge8 = gLUhalfEdge7.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge8);
        eTopRight = gLUhalfEdge8;
        GLUhalfEdge gLUhalfEdge9 = eTopRight.getOnext();
        Intrinsics.checkNotNull(gLUhalfEdge9);
        eTopLeft = eLast = gLUhalfEdge9;
        if (reg.getFixUpperEdge()) {
            if (!(eTopLeft != eTopRight)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.DeleteRegion(tess, reg);
            if (!Mesh.INSTANCE.__gl_meshDelete(eTopRight)) {
                throw new RuntimeException();
            }
            GLUhalfEdge gLUhalfEdge10 = eTopLeft.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge10);
            GLUhalfEdge gLUhalfEdge11 = gLUhalfEdge10.getLnext();
            Intrinsics.checkNotNull(gLUhalfEdge11);
            eTopRight = gLUhalfEdge11;
        }
        GLUhalfEdge gLUhalfEdge12 = vEvent.getAnEdge();
        Intrinsics.checkNotNull(gLUhalfEdge12);
        if (!Mesh.INSTANCE.__gl_meshSplice(gLUhalfEdge12, eTopRight)) {
            throw new RuntimeException();
        }
        if (!Geom.INSTANCE.EdgeGoesLeft(eTopLeft)) {
            eTopLeft = null;
        }
        GLUhalfEdge gLUhalfEdge13 = eTopRight.getOnext();
        Intrinsics.checkNotNull(gLUhalfEdge13);
        this.AddRightEdges(tess, regUp2, gLUhalfEdge13, eLast, eTopLeft, true);
    }

    public final void ConnectLeftVertex(@NotNull GLUtessellatorImpl tess, @NotNull GLUvertex vEvent) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        Intrinsics.checkNotNullParameter(vEvent, "vEvent");
        ActiveRegion regUp = null;
        ActiveRegion reg = null;
        GLUhalfEdge eLo = null;
        GLUhalfEdge eNew = null;
        ActiveRegion tmp = new ActiveRegion();
        GLUhalfEdge gLUhalfEdge = vEvent.getAnEdge();
        Intrinsics.checkNotNull(gLUhalfEdge);
        tmp.setEUp(gLUhalfEdge.getSym());
        Dict dict = tess.getDict$openrndr_ktessellation();
        Intrinsics.checkNotNull(dict);
        DictNode dictNode = Dict.Companion.dictSearch(dict, tmp);
        Intrinsics.checkNotNull(dictNode);
        Object object = Dict.Companion.dictKey(dictNode);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.openrndr.ktessellation.ActiveRegion");
        regUp = (ActiveRegion)object;
        ActiveRegion activeRegion = this.RegionBelow(regUp);
        Intrinsics.checkNotNull(activeRegion);
        ActiveRegion regLo = activeRegion;
        GLUhalfEdge gLUhalfEdge2 = regUp.getEUp();
        Intrinsics.checkNotNull(gLUhalfEdge2);
        GLUhalfEdge eUp = gLUhalfEdge2;
        GLUhalfEdge gLUhalfEdge3 = regLo.getEUp();
        Intrinsics.checkNotNull(gLUhalfEdge3);
        eLo = gLUhalfEdge3;
        GLUhalfEdge gLUhalfEdge4 = eUp.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge4);
        GLUvertex gLUvertex = gLUhalfEdge4.getOrg();
        Intrinsics.checkNotNull(gLUvertex);
        GLUvertex gLUvertex2 = eUp.getOrg();
        Intrinsics.checkNotNull(gLUvertex2);
        if (Geom.INSTANCE.EdgeSign(gLUvertex, vEvent, gLUvertex2) == 0.0) {
            this.ConnectLeftDegenerate(tess, regUp, vEvent);
            return;
        }
        GLUhalfEdge gLUhalfEdge5 = eLo.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge5);
        GLUvertex gLUvertex3 = gLUhalfEdge5.getOrg();
        Intrinsics.checkNotNull(gLUvertex3);
        GLUhalfEdge gLUhalfEdge6 = eUp.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge6);
        GLUvertex gLUvertex4 = gLUhalfEdge6.getOrg();
        Intrinsics.checkNotNull(gLUvertex4);
        ActiveRegion activeRegion2 = reg = Geom.INSTANCE.VertLeq(gLUvertex3, gLUvertex4) ? regUp : regLo;
        if (regUp.getInside() || reg.getFixUpperEdge()) {
            if (reg == regUp) {
                GLUhalfEdge gLUhalfEdge7 = vEvent.getAnEdge();
                Intrinsics.checkNotNull(gLUhalfEdge7);
                GLUhalfEdge gLUhalfEdge8 = gLUhalfEdge7.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge8);
                GLUhalfEdge gLUhalfEdge9 = eUp.getLnext();
                Intrinsics.checkNotNull(gLUhalfEdge9);
                eNew = Mesh.INSTANCE.__gl_meshConnect(gLUhalfEdge8, gLUhalfEdge9);
                if (eNew == null) {
                    throw new RuntimeException();
                }
            } else {
                GLUhalfEdge gLUhalfEdge10 = eLo.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge10);
                GLUhalfEdge gLUhalfEdge11 = gLUhalfEdge10.getOnext();
                Intrinsics.checkNotNull(gLUhalfEdge11);
                GLUhalfEdge gLUhalfEdge12 = gLUhalfEdge11.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge12);
                GLUhalfEdge gLUhalfEdge13 = vEvent.getAnEdge();
                Intrinsics.checkNotNull(gLUhalfEdge13);
                GLUhalfEdge tempHalfEdge = Mesh.INSTANCE.__gl_meshConnect(gLUhalfEdge12, gLUhalfEdge13);
                GLUhalfEdge gLUhalfEdge14 = tempHalfEdge.getSym();
                Intrinsics.checkNotNull(gLUhalfEdge14);
                eNew = gLUhalfEdge14;
            }
            if (reg.getFixUpperEdge()) {
                if (!this.FixUpperEdge(reg, eNew)) {
                    throw new RuntimeException();
                }
            } else {
                ActiveRegion activeRegion3 = this.AddRegionBelow(tess, regUp, eNew);
                Intrinsics.checkNotNull(activeRegion3);
                this.ComputeWinding(tess, activeRegion3);
            }
            this.SweepEvent(tess, vEvent);
        } else {
            GLUhalfEdge gLUhalfEdge15 = vEvent.getAnEdge();
            Intrinsics.checkNotNull(gLUhalfEdge15);
            GLUhalfEdge gLUhalfEdge16 = vEvent.getAnEdge();
            Intrinsics.checkNotNull(gLUhalfEdge16);
            this.AddRightEdges(tess, regUp, gLUhalfEdge15, gLUhalfEdge16, null, true);
        }
    }

    public final void SweepEvent(@NotNull GLUtessellatorImpl tess, @NotNull GLUvertex vEvent) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        Intrinsics.checkNotNullParameter(vEvent, "vEvent");
        ActiveRegion regUp = null;
        GLUhalfEdge e = null;
        tess.setEvent$openrndr_ktessellation(vEvent);
        this.DebugEvent(tess);
        GLUhalfEdge gLUhalfEdge = vEvent.getAnEdge();
        Intrinsics.checkNotNull(gLUhalfEdge);
        e = gLUhalfEdge;
        while (e.getActiveRegion() == null) {
            Intrinsics.checkNotNull(e.getOnext());
            if (e != vEvent.getAnEdge()) continue;
            this.ConnectLeftVertex(tess, vEvent);
            return;
        }
        ActiveRegion activeRegion = e.getActiveRegion();
        Intrinsics.checkNotNull(activeRegion);
        ActiveRegion activeRegion2 = this.TopLeftRegion(activeRegion);
        Intrinsics.checkNotNull(activeRegion2);
        regUp = activeRegion2;
        ActiveRegion activeRegion3 = this.RegionBelow(regUp);
        Intrinsics.checkNotNull(activeRegion3);
        ActiveRegion reg = activeRegion3;
        GLUhalfEdge gLUhalfEdge2 = reg.getEUp();
        Intrinsics.checkNotNull(gLUhalfEdge2);
        GLUhalfEdge eTopLeft = gLUhalfEdge2;
        GLUhalfEdge eBottomLeft = this.FinishLeftRegions(tess, reg, null);
        if (eBottomLeft.getOnext() == eTopLeft) {
            this.ConnectRightVertex(tess, regUp, eBottomLeft);
        } else {
            GLUhalfEdge gLUhalfEdge3 = eBottomLeft.getOnext();
            Intrinsics.checkNotNull(gLUhalfEdge3);
            this.AddRightEdges(tess, regUp, gLUhalfEdge3, eTopLeft, eTopLeft, true);
        }
    }

    public final void AddSentinel(@NotNull GLUtessellatorImpl tess, double t) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        ActiveRegion reg = new ActiveRegion();
        GLUmesh gLUmesh = tess.getMesh$openrndr_ktessellation();
        Intrinsics.checkNotNull(gLUmesh);
        GLUhalfEdge gLUhalfEdge = Mesh.INSTANCE.__gl_meshMakeEdge(gLUmesh);
        Intrinsics.checkNotNull(gLUhalfEdge);
        GLUhalfEdge e = gLUhalfEdge;
        if (e == null) {
            throw new RuntimeException();
        }
        GLUvertex gLUvertex = e.getOrg();
        Intrinsics.checkNotNull(gLUvertex);
        gLUvertex.setS(4.0E150);
        GLUvertex gLUvertex2 = e.getOrg();
        Intrinsics.checkNotNull(gLUvertex2);
        gLUvertex2.setT(t);
        GLUhalfEdge gLUhalfEdge2 = e.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge2);
        GLUvertex gLUvertex3 = gLUhalfEdge2.getOrg();
        Intrinsics.checkNotNull(gLUvertex3);
        gLUvertex3.setS(-4.0E150);
        GLUhalfEdge gLUhalfEdge3 = e.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge3);
        GLUvertex gLUvertex4 = gLUhalfEdge3.getOrg();
        Intrinsics.checkNotNull(gLUvertex4);
        gLUvertex4.setT(t);
        GLUhalfEdge gLUhalfEdge4 = e.getSym();
        Intrinsics.checkNotNull(gLUhalfEdge4);
        tess.setEvent$openrndr_ktessellation(gLUhalfEdge4.getOrg());
        reg.setEUp(e);
        reg.setWindingNumber(0);
        reg.setInside(false);
        reg.setFixUpperEdge(false);
        reg.setSentinel(true);
        reg.setDirty(false);
        Dict dict = tess.getDict$openrndr_ktessellation();
        Intrinsics.checkNotNull(dict);
        reg.setNodeUp(Dict.Companion.dictInsert(dict, reg));
        if (reg.getNodeUp() == null) {
            throw new RuntimeException();
        }
    }

    public final void InitEdgeDict(@NotNull GLUtessellatorImpl tess) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        tess.setDict$openrndr_ktessellation(Dict.Companion.dictNewDict(tess, new Dict.DictLeq(tess){
            final /* synthetic */ GLUtessellatorImpl $tess;
            {
                this.$tess = $tess;
            }

            public boolean leq(Object frame, Object key1, Object key2) {
                Intrinsics.checkNotNullParameter(frame, "frame");
                Intrinsics.checkNotNullParameter(key1, "key1");
                Intrinsics.checkNotNullParameter(key2, "key2");
                return Sweep.INSTANCE.EdgeLeq(this.$tess, (ActiveRegion)key1, (ActiveRegion)key2);
            }
        }));
        if (tess.getDict$openrndr_ktessellation() == null) {
            throw new RuntimeException();
        }
        this.AddSentinel(tess, -4.0E150);
        this.AddSentinel(tess, 4.0E150);
    }

    public final void DoneEdgeDict(@NotNull GLUtessellatorImpl tess) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        ActiveRegion reg = null;
        int fixedEdges = 0;
        while (true) {
            String string;
            ActiveRegion activeRegion;
            Dict dict = tess.getDict$openrndr_ktessellation();
            Intrinsics.checkNotNull(dict);
            ActiveRegion it = activeRegion = (ActiveRegion)Dict.Companion.dictKey(Dict.Companion.dictMin(dict));
            boolean bl = false;
            reg = it;
            if (activeRegion == null) break;
            ActiveRegion activeRegion2 = reg;
            Intrinsics.checkNotNull(activeRegion2);
            if (!activeRegion2.getSentinel()) {
                if (!reg.getFixUpperEdge()) {
                    string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!(++fixedEdges == 1)) {
                    string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
            }
            if (!(reg.getWindingNumber() == 0)) {
                string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.DeleteRegion(tess, reg);
        }
        Dict dict = tess.getDict$openrndr_ktessellation();
        Intrinsics.checkNotNull(dict);
        Dict.Companion.dictDeleteDict(dict);
    }

    public final void RemoveDegenerateEdges(@NotNull GLUtessellatorImpl tess) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        GLUhalfEdge e = null;
        GLUhalfEdge eNext = null;
        GLUhalfEdge eLnext = null;
        GLUmesh gLUmesh = tess.getMesh$openrndr_ktessellation();
        Intrinsics.checkNotNull(gLUmesh);
        GLUhalfEdge eHead = gLUmesh.getEHead();
        GLUhalfEdge gLUhalfEdge = eHead.getNext();
        Intrinsics.checkNotNull(gLUhalfEdge);
        e = gLUhalfEdge;
        while (e != eHead) {
            Intrinsics.checkNotNull(e.getNext());
            Intrinsics.checkNotNull(e.getLnext());
            GLUvertex gLUvertex = e.getOrg();
            Intrinsics.checkNotNull(gLUvertex);
            GLUhalfEdge gLUhalfEdge2 = e.getSym();
            Intrinsics.checkNotNull(gLUhalfEdge2);
            GLUvertex gLUvertex2 = gLUhalfEdge2.getOrg();
            Intrinsics.checkNotNull(gLUvertex2);
            if (Geom.INSTANCE.VertEq(gLUvertex, gLUvertex2)) {
                GLUhalfEdge gLUhalfEdge3 = e.getLnext();
                Intrinsics.checkNotNull(gLUhalfEdge3);
                if (gLUhalfEdge3.getLnext() != e) {
                    this.SpliceMergeVertices(tess, eLnext, e);
                    if (!Mesh.INSTANCE.__gl_meshDelete(e)) {
                        throw new RuntimeException();
                    }
                    e = eLnext;
                    GLUhalfEdge gLUhalfEdge4 = e.getLnext();
                    Intrinsics.checkNotNull(gLUhalfEdge4);
                    eLnext = gLUhalfEdge4;
                }
            }
            if (eLnext.getLnext() == e) {
                if (eLnext != e) {
                    if (eLnext == eNext || eLnext == eNext.getSym()) {
                        GLUhalfEdge gLUhalfEdge5 = eNext.getNext();
                        Intrinsics.checkNotNull(gLUhalfEdge5);
                        eNext = gLUhalfEdge5;
                    }
                    if (!Mesh.INSTANCE.__gl_meshDelete(eLnext)) {
                        throw new RuntimeException();
                    }
                }
                if (e == eNext || e == eNext.getSym()) {
                    GLUhalfEdge gLUhalfEdge6 = eNext.getNext();
                    Intrinsics.checkNotNull(gLUhalfEdge6);
                    eNext = gLUhalfEdge6;
                }
                if (!Mesh.INSTANCE.__gl_meshDelete(e)) {
                    throw new RuntimeException();
                }
            }
            e = eNext;
        }
    }

    public final boolean InitPriorityQ(@NotNull GLUtessellatorImpl tess) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        GLUvertex v = null;
        tess.setPq$openrndr_ktessellation(PriorityQ.Companion.pqNewPriorityQ(new PriorityQ.Leq(){

            public boolean leq(Object key1, Object key2) {
                Intrinsics.checkNotNull(key1, "null cannot be cast to non-null type org.openrndr.ktessellation.GLUvertex");
                GLUvertex gLUvertex = (GLUvertex)key1;
                Intrinsics.checkNotNull(key2, "null cannot be cast to non-null type org.openrndr.ktessellation.GLUvertex");
                return Geom.INSTANCE.VertLeq(gLUvertex, (GLUvertex)key2);
            }
        }));
        PriorityQ pq = tess.getPq$openrndr_ktessellation();
        if (pq == null) {
            return false;
        }
        GLUmesh gLUmesh = tess.getMesh$openrndr_ktessellation();
        Intrinsics.checkNotNull(gLUmesh);
        GLUvertex vHead = gLUmesh.getVHead();
        GLUvertex gLUvertex = vHead.getNext();
        Intrinsics.checkNotNull(gLUvertex);
        v = gLUvertex;
        while (v != vHead) {
            v.setPqHandle(pq.pqInsert(v));
            if ((long)v.getPqHandle() == Long.MAX_VALUE) break;
            Intrinsics.checkNotNull(v.getNext());
        }
        if (v != vHead || !pq.pqInit()) {
            PriorityQ priorityQ = tess.getPq$openrndr_ktessellation();
            Intrinsics.checkNotNull(priorityQ);
            priorityQ.pqDeletePriorityQ();
            tess.setPq$openrndr_ktessellation(null);
            return false;
        }
        return true;
    }

    public final void DonePriorityQ(@NotNull GLUtessellatorImpl tess) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        PriorityQ priorityQ = tess.getPq$openrndr_ktessellation();
        Intrinsics.checkNotNull(priorityQ);
        priorityQ.pqDeletePriorityQ();
    }

    public final boolean RemoveDegenerateFaces(@NotNull GLUmesh mesh) {
        Intrinsics.checkNotNullParameter(mesh, "mesh");
        GLUface f = null;
        GLUface fNext = null;
        GLUhalfEdge e = null;
        GLUface gLUface = mesh.getFHead().getNext();
        Intrinsics.checkNotNull(gLUface);
        f = gLUface;
        while (f != mesh.getFHead()) {
            Intrinsics.checkNotNull(f.getNext());
            Intrinsics.checkNotNull(f.getAnEdge());
            if (!(e.getLnext() != e)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            GLUhalfEdge gLUhalfEdge = e.getLnext();
            Intrinsics.checkNotNull(gLUhalfEdge);
            if (gLUhalfEdge.getLnext() == e) {
                GLUhalfEdge gLUhalfEdge2 = e.getOnext();
                Intrinsics.checkNotNull(gLUhalfEdge2);
                this.AddWinding(gLUhalfEdge2, e);
                if (!Mesh.INSTANCE.__gl_meshDelete(e)) {
                    return false;
                }
            }
            f = fNext;
        }
        return true;
    }

    public final boolean __gl_computeInterior(@NotNull GLUtessellatorImpl tess) {
        Intrinsics.checkNotNullParameter(tess, "tess");
        GLUvertex v = null;
        GLUvertex vNext = null;
        tess.setFatalError(false);
        this.RemoveDegenerateEdges(tess);
        if (!this.InitPriorityQ(tess)) {
            return false;
        }
        this.InitEdgeDict(tess);
        while (true) {
            GLUvertex gLUvertex;
            PriorityQ priorityQ = tess.getPq$openrndr_ktessellation();
            Intrinsics.checkNotNull(priorityQ);
            GLUvertex it = gLUvertex = (GLUvertex)priorityQ.pqExtractMin();
            boolean bl = false;
            v = it;
            if (gLUvertex == null) break;
            while (true) {
                PriorityQ priorityQ2 = tess.getPq$openrndr_ktessellation();
                Intrinsics.checkNotNull(priorityQ2);
                vNext = (GLUvertex)priorityQ2.pqMinimum();
                if (vNext == null) break;
                GLUvertex gLUvertex2 = v;
                Intrinsics.checkNotNull(gLUvertex2);
                if (!Geom.INSTANCE.VertEq(vNext, gLUvertex2)) break;
                PriorityQ priorityQ3 = tess.getPq$openrndr_ktessellation();
                Intrinsics.checkNotNull(priorityQ3);
                Object object = priorityQ3.pqExtractMin();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.openrndr.ktessellation.GLUvertex");
                vNext = (GLUvertex)object;
                GLUhalfEdge gLUhalfEdge = v.getAnEdge();
                Intrinsics.checkNotNull(gLUhalfEdge);
                GLUhalfEdge gLUhalfEdge2 = vNext.getAnEdge();
                Intrinsics.checkNotNull(gLUhalfEdge2);
                this.SpliceMergeVertices(tess, gLUhalfEdge, gLUhalfEdge2);
            }
            GLUvertex gLUvertex3 = v;
            Intrinsics.checkNotNull(gLUvertex3);
            this.SweepEvent(tess, gLUvertex3);
        }
        Dict dict = tess.getDict$openrndr_ktessellation();
        Intrinsics.checkNotNull(dict);
        Object object = Dict.Companion.dictKey(Dict.Companion.dictMin(dict));
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.openrndr.ktessellation.ActiveRegion");
        GLUhalfEdge gLUhalfEdge = ((ActiveRegion)object).getEUp();
        Intrinsics.checkNotNull(gLUhalfEdge);
        tess.setEvent$openrndr_ktessellation(gLUhalfEdge.getOrg());
        this.DebugEvent(tess);
        this.DoneEdgeDict(tess);
        this.DonePriorityQ(tess);
        GLUmesh gLUmesh = tess.getMesh$openrndr_ktessellation();
        Intrinsics.checkNotNull(gLUmesh);
        if (!this.RemoveDegenerateFaces(gLUmesh)) {
            return false;
        }
        GLUmesh gLUmesh2 = tess.getMesh$openrndr_ktessellation();
        Intrinsics.checkNotNull(gLUmesh2);
        Mesh.INSTANCE.__gl_meshCheckMesh(gLUmesh2);
        return true;
    }
}

