/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.LinearType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0018\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0000*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0002J\u0015\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00028\u0000H\u00a6\u0004\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u0000H\u0096\u0004\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00028\u0000H\u0096\u0004\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J!\u0010\u001b\u001a\u00028\u00002\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001dH&\u00a2\u0006\u0002\u0010\u001eR\u0012\u0010\u0003\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005R\u0012\u0010\f\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001f"}, d2={"Lorg/openrndr/math/EuclideanVector;", "T", "Lorg/openrndr/math/LinearType;", "zero", "getZero", "()Lorg/openrndr/math/EuclideanVector;", "length", "", "getLength", "()D", "normalized", "getNormalized", "squaredLength", "getSquaredLength", "distanceTo", "other", "(Lorg/openrndr/math/EuclideanVector;)D", "squaredDistanceTo", "areaBetween", "dot", "right", "projectedOn", "on", "(Lorg/openrndr/math/EuclideanVector;)Lorg/openrndr/math/EuclideanVector;", "reflectedOver", "surfaceNormal", "atan2", "map", "function", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Lorg/openrndr/math/EuclideanVector;", "openrndr-math"})
public interface EuclideanVector<T extends EuclideanVector<T> & LinearType<T>>
extends LinearType<T> {
    @NotNull
    public T getZero();

    public double getLength();

    @NotNull
    public T getNormalized();

    public double getSquaredLength();

    public double distanceTo(@NotNull T var1);

    public double squaredDistanceTo(@NotNull T var1);

    public double areaBetween(@NotNull T var1);

    public double dot(@NotNull T var1);

    @NotNull
    public T projectedOn(@NotNull T var1);

    @NotNull
    public T reflectedOver(@NotNull T var1);

    public double atan2(@NotNull T var1);

    @NotNull
    public T map(@NotNull Function1<? super Double, Double> var1);

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static <T extends EuclideanVector<T> & LinearType<T>> T getNormalized(@NotNull EuclideanVector<T> $this) {
            double l = $this.getLength();
            return (T)(l == 0.0 ? $this.getZero() : (EuclideanVector)$this.div(l));
        }

        public static <T extends EuclideanVector<T> & LinearType<T>> double areaBetween(@NotNull EuclideanVector<T> $this, @NotNull T other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return Math.sqrt($this.getSquaredLength() * other.getSquaredLength() - Math.pow($this.dot(other), 2.0));
        }

        @NotNull
        public static <T extends EuclideanVector<T> & LinearType<T>> T projectedOn(@NotNull EuclideanVector<T> $this, @NotNull T on) {
            Intrinsics.checkNotNullParameter(on, "on");
            return (T)((EuclideanVector)on.times($this.dot(on) / on.dot(on)));
        }

        @NotNull
        public static <T extends EuclideanVector<T> & LinearType<T>> T reflectedOver(@NotNull EuclideanVector<T> $this, @NotNull T surfaceNormal) {
            Intrinsics.checkNotNullParameter(surfaceNormal, "surfaceNormal");
            return (T)((EuclideanVector)$this.minus(((EuclideanVector)surfaceNormal.times($this.dot(surfaceNormal))).times(2.0)));
        }

        public static <T extends EuclideanVector<T> & LinearType<T>> double atan2(@NotNull EuclideanVector<T> $this, @NotNull T other) {
            Intrinsics.checkNotNullParameter(other, "other");
            T u = $this.getNormalized();
            T v = other.getNormalized();
            double x = u.dot(v);
            double y = Math.sqrt(1.0 - x * x);
            return Math.atan2(y, x);
        }
    }
}

