/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.EuclideanVector;
import org.openrndr.math.IntVector3;
import org.openrndr.math.LinearType;
import org.openrndr.math.Spherical;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3$;
import org.openrndr.math.Vector4;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0087\b\u0018\u0000 N2\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\u00020\u0003:\u0003MNOB\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nB3\b\u0010\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\b\u0010\u000fJ\u0011\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\fH\u0086\u0002J\t\u0010\u001f\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010$\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0005H\u0096\u0002J\u0011\u0010'\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0005H\u0096\u0002J\u0011\u0010'\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010(\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0000H\u0096\u0004J\u0011\u0010)\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000H\u0086\u0004J\u001c\u0010,\u001a\u00020\u00002\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050.H\u0016J\u0006\u0010/\u001a\u000200J\u0010\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0000H\u0016J\u0010\u00103\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0000H\u0016J\u0016\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u0005J\u0006\u00109\u001a\u00020:J\t\u0010;\u001a\u00020\u0005H\u00c6\u0003J\t\u0010<\u001a\u00020\u0005H\u00c6\u0003J\t\u0010=\u001a\u00020\u0005H\u00c6\u0003J'\u0010>\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010?\u001a\u00020@2\b\u00102\u001a\u0004\u0018\u00010AH\u00d6\u0003J\t\u0010B\u001a\u00020\fH\u00d6\u0001J\t\u0010C\u001a\u00020DH\u00d6\u0001J%\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\u00002\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0001\u00a2\u0006\u0002\bLR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u001b\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0019R\u0014\u0010*\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0010R\u0014\u0010+\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0010R\u0011\u00106\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b6\u00108\u00a8\u0006P"}, d2={"Lorg/openrndr/math/Vector3;", "Lorg/openrndr/math/LinearType;", "Lorg/openrndr/math/EuclideanVector;", "Ljava/lang/Record;", "x", "", "y", "z", "<init>", "(DDD)V", "(D)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IDDDLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()D", "zero", "()Lorg/openrndr/math/Vector3;", "xyz0", "Lorg/openrndr/math/Vector4;", "()Lorg/openrndr/math/Vector4;", "xyz1", "xy", "Lorg/openrndr/math/Vector2;", "()Lorg/openrndr/math/Vector2;", "yx", "zx", "xz", "get", "i", "unaryMinus", "plus", "right", "d", "minus", "times", "v", "scale", "div", "dot", "cross", "length", "squaredLength", "map", "function", "Lkotlin/Function1;", "toDoubleArray", "", "distanceTo", "other", "squaredDistanceTo", "mix", "o", "spherical", "Lorg/openrndr/math/Spherical;", "()Lorg/openrndr/math/Spherical;", "toInt", "Lorg/openrndr/math/IntVector3;", "component1", "component2", "component3", "copy", "equals", "", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_math", "Axis", "Companion", "$serializer", "openrndr-math"})
public final class Vector3
extends Record
implements LinearType<Vector3>,
EuclideanVector<Vector3> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    private final double z;
    @NotNull
    private static final Vector3 ZERO = new Vector3(0.0, 0.0, 0.0);
    @NotNull
    private static final Vector3 ONE = new Vector3(1.0, 1.0, 1.0);
    @NotNull
    private static final Vector3 UNIT_XYZ = (Vector3)ONE.getNormalized();
    @NotNull
    private static final Vector3 UNIT_X = new Vector3(1.0, 0.0, 0.0);
    @NotNull
    private static final Vector3 UNIT_Y = new Vector3(0.0, 1.0, 0.0);
    @NotNull
    private static final Vector3 UNIT_Z = new Vector3(0.0, 0.0, 1.0);
    @NotNull
    private static final Vector3 INFINITY = new Vector3(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final double x() {
        return this.x;
    }

    public final double y() {
        return this.y;
    }

    public final double z() {
        return this.z;
    }

    public Vector3(double x) {
        this(x, x, x);
    }

    @NotNull
    public Vector3 zero() {
        return ZERO;
    }

    @NotNull
    public final Vector4 xyz0() {
        return new Vector4(this.x, this.y, this.z, 0.0);
    }

    @NotNull
    public final Vector4 xyz1() {
        return new Vector4(this.x, this.y, this.z, 1.0);
    }

    @NotNull
    public final Vector2 xy() {
        return new Vector2(this.x, this.y);
    }

    @NotNull
    public final Vector2 yx() {
        return new Vector2(this.y, this.x);
    }

    @NotNull
    public final Vector2 zx() {
        return new Vector2(this.z, this.x);
    }

    @NotNull
    public final Vector2 xz() {
        return new Vector2(this.x, this.z);
    }

    public final double get(int i) {
        return switch (i) {
            case 0 -> this.x;
            case 1 -> this.y;
            case 2 -> this.z;
            default -> throw new RuntimeException("unsupported index");
        };
    }

    @NotNull
    public final Vector3 unaryMinus() {
        return new Vector3(-this.x, -this.y, -this.z);
    }

    @Override
    @NotNull
    public Vector3 plus(@NotNull Vector3 right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Vector3(this.x + right.x, this.y + right.y, this.z + right.z);
    }

    @Override
    @NotNull
    public final Vector3 plus(double d) {
        return new Vector3(this.x + d, this.y + d, this.z + d);
    }

    @Override
    @NotNull
    public Vector3 minus(@NotNull Vector3 right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Vector3(this.x - right.x, this.y - right.y, this.z - right.z);
    }

    @Override
    @NotNull
    public final Vector3 minus(double d) {
        return new Vector3(this.x - d, this.y - d, this.z - d);
    }

    @NotNull
    public final Vector3 times(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vector3(this.x * v.x, this.y * v.y, this.z * v.z);
    }

    @Override
    @NotNull
    public Vector3 times(double scale) {
        return new Vector3(this.x * scale, this.y * scale, this.z * scale);
    }

    @Override
    @NotNull
    public Vector3 div(double scale) {
        return new Vector3(this.x / scale, this.y / scale, this.z / scale);
    }

    @NotNull
    public final Vector3 div(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vector3(this.x / v.x, this.y / v.y, this.z / v.z);
    }

    @Override
    public double dot(@NotNull Vector3 right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.x * right.x + this.y * right.y + this.z * right.z;
    }

    @NotNull
    public final Vector3 cross(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vector3(this.y * v.z - this.z * v.y, -(this.x * v.z - this.z * v.x), this.x * v.y - this.y * v.x);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double squaredLength() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    @Override
    @NotNull
    public Vector3 map(@NotNull Function1<? super Double, Double> function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return new Vector3(((Number)function2.invoke((Double)this.x)).doubleValue(), ((Number)function2.invoke((Double)this.y)).doubleValue(), ((Number)function2.invoke((Double)this.z)).doubleValue());
    }

    @NotNull
    public final double[] toDoubleArray() {
        double[] dArray = new double[]{this.x, this.y, this.z};
        return dArray;
    }

    @Override
    public double distanceTo(@NotNull Vector3 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        double dx = other.x - this.x;
        double dy = other.y - this.y;
        double dz = other.z - this.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    @Override
    public double squaredDistanceTo(@NotNull Vector3 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        double dx = other.x - this.x;
        double dy = other.y - this.y;
        double dz = other.z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    @NotNull
    public final Vector3 mix(@NotNull Vector3 o, double mix) {
        Intrinsics.checkNotNullParameter(o, "o");
        return this.times(1.0 - mix).plus(o.times(mix));
    }

    @NotNull
    public final Spherical spherical() {
        return Spherical.Companion.fromVector(this);
    }

    @NotNull
    public final IntVector3 toInt() {
        return new IntVector3((int)this.x, (int)this.y, (int)this.z);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    @NotNull
    public final Vector3 copy(double x, double y, double z) {
        return new Vector3(x, y, z);
    }

    public static /* synthetic */ Vector3 copy$default(Vector3 vector3, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = vector3.x;
        }
        if ((n & 2) != 0) {
            d2 = vector3.y;
        }
        if ((n & 4) != 0) {
            d3 = vector3.z;
        }
        return vector3.copy(d, d2, d3);
    }

    @Override
    @NotNull
    public String toString() {
        return "Vector3(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }

    @Override
    public int hashCode() {
        int result = Double.hashCode(this.x);
        result = result * 31 + Double.hashCode(this.y);
        result = result * 31 + Double.hashCode(this.z);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector3)) {
            return false;
        }
        Vector3 vector3 = (Vector3)other;
        if (Double.compare(this.x, vector3.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, vector3.y) != 0) {
            return false;
        }
        return Double.compare(this.z, vector3.z) == 0;
    }

    @NotNull
    public Vector3 normalized() {
        return EuclideanVector.DefaultImpls.getNormalized(this);
    }

    @Override
    public double areaBetween(@NotNull Vector3 other) {
        return EuclideanVector.DefaultImpls.areaBetween(this, (EuclideanVector)other);
    }

    @Override
    @NotNull
    public Vector3 projectedOn(@NotNull Vector3 on) {
        return (Vector3)EuclideanVector.DefaultImpls.projectedOn(this, (EuclideanVector)on);
    }

    @Override
    @NotNull
    public Vector3 reflectedOver(@NotNull Vector3 surfaceNormal) {
        return (Vector3)EuclideanVector.DefaultImpls.reflectedOver(this, (EuclideanVector)surfaceNormal);
    }

    @Override
    public double atan2(@NotNull Vector3 other) {
        return EuclideanVector.DefaultImpls.atan2(this, (EuclideanVector)other);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_math(Vector3 self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeDoubleElement(serialDesc, 0, self.x);
        output.encodeDoubleElement(serialDesc, 1, self.y);
        output.encodeDoubleElement(serialDesc, 2, self.z);
    }

    public /* synthetic */ Vector3(int seen0, double x, double y, double z, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 7, $serializer.INSTANCE.getDescriptor());
        }
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/openrndr/math/Vector3$Axis;", "", "direction", "Lorg/openrndr/math/Vector3;", "<init>", "(Ljava/lang/String;ILorg/openrndr/math/Vector3;)V", "getDirection", "()Lorg/openrndr/math/Vector3;", "X", "Y", "Z", "openrndr-math"})
    public static final class Axis
    extends Enum<Axis> {
        @NotNull
        private final Vector3 direction;
        public static final /* enum */ Axis X = new Axis(Companion.getUNIT_X());
        public static final /* enum */ Axis Y = new Axis(Companion.getUNIT_Y());
        public static final /* enum */ Axis Z = new Axis(Companion.getUNIT_Y());
        private static final /* synthetic */ Axis[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Axis(Vector3 direction) {
            this.direction = direction;
        }

        @NotNull
        public final Vector3 getDirection() {
            return this.direction;
        }

        public static Axis[] values() {
            return (Axis[])$VALUES.clone();
        }

        public static Axis valueOf(String value) {
            return Enum.valueOf(Axis.class, value);
        }

        @NotNull
        public static EnumEntries<Axis> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = axisArray = new Axis[]{Axis.X, Axis.Y, Axis.Z};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/openrndr/math/Vector3$Companion;", "", "<init>", "()V", "ZERO", "Lorg/openrndr/math/Vector3;", "getZERO", "()Lorg/openrndr/math/Vector3;", "ONE", "getONE", "UNIT_XYZ", "getUNIT_XYZ", "UNIT_X", "getUNIT_X", "UNIT_Y", "getUNIT_Y", "UNIT_Z", "getUNIT_Z", "INFINITY", "getINFINITY", "fromSpherical", "s", "Lorg/openrndr/math/Spherical;", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-math"})
    @SourceDebugExtension(value={"SMAP\nVector3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vector3.kt\norg/openrndr/math/Vector3$Companion\n+ 2 Functions.kt\norg/openrndr/math/FunctionsKt\n*L\n1#1,153:1\n86#2:154\n86#2:155\n*S KotlinDebug\n*F\n+ 1 Vector3.kt\norg/openrndr/math/Vector3$Companion\n*L\n33#1:154\n34#1:155\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vector3 getZERO() {
            return ZERO;
        }

        @NotNull
        public final Vector3 getONE() {
            return ONE;
        }

        @NotNull
        public final Vector3 getUNIT_XYZ() {
            return UNIT_XYZ;
        }

        @NotNull
        public final Vector3 getUNIT_X() {
            return UNIT_X;
        }

        @NotNull
        public final Vector3 getUNIT_Y() {
            return UNIT_Y;
        }

        @NotNull
        public final Vector3 getUNIT_Z() {
            return UNIT_Z;
        }

        @NotNull
        public final Vector3 getINFINITY() {
            return INFINITY;
        }

        @NotNull
        public final Vector3 fromSpherical(@NotNull Spherical s) {
            Intrinsics.checkNotNullParameter(s, "s");
            double $this$asRadians$iv = s.phi();
            boolean $i$f$getAsRadians = false;
            double phi = $this$asRadians$iv * (Math.PI / 180);
            double $this$asRadians$iv2 = s.theta();
            boolean $i$f$getAsRadians2 = false;
            double theta = $this$asRadians$iv2 * (Math.PI / 180);
            double sinPhiRadius = Math.sin(phi) * s.radius();
            return new Vector3(sinPhiRadius * Math.sin(theta), Math.cos(phi) * s.radius(), sinPhiRadius * Math.cos(theta));
        }

        @NotNull
        public final KSerializer<Vector3> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

