/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.panel.elements;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.events.Event;
import org.openrndr.math.Vector2;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0002#$B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001b\u001a\u00020\bJ\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bJ\b\u0010\u001e\u001a\u00020\u001aH\u0002J\u0016\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0005R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006%"}, d2={"Lorg/openrndr/panel/elements/Envelope;", "", "constant", "", "<init>", "(D)V", "points", "", "Lorg/openrndr/math/Vector2;", "getPoints", "()Ljava/util/List;", "activePoint", "getActivePoint", "()Lorg/openrndr/math/Vector2;", "setActivePoint", "(Lorg/openrndr/math/Vector2;)V", "value", "offset", "getOffset", "()D", "setOffset", "events", "Lorg/openrndr/panel/elements/Envelope$Events;", "getEvents", "()Lorg/openrndr/panel/elements/Envelope$Events;", "insertPoint", "", "v", "findNearestPoint", "removePoint", "fixBounds", "updatePoint", "old", "new", "t", "EnvelopeChangedEvent", "Events", "orx-panel"})
@SourceDebugExtension(value={"SMAP\nEnvelopeEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvelopeEditor.kt\norg/openrndr/panel/elements/Envelope\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n2341#2,14:231\n1010#2,2:245\n*S KotlinDebug\n*F\n+ 1 EnvelopeEditor.kt\norg/openrndr/panel/elements/Envelope\n*L\n40#1:231,14\n80#1:245,2\n*E\n"})
public final class Envelope {
    @NotNull
    private final List<Vector2> points;
    @Nullable
    private Vector2 activePoint;
    private double offset;
    @NotNull
    private final Events events;

    public Envelope(double constant) {
        Vector2[] vector2Array = new Vector2[]{new Vector2(0.5, constant)};
        this.points = CollectionsKt.mutableListOf(vector2Array);
        this.events = new Events();
    }

    public /* synthetic */ Envelope(double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        this(d);
    }

    @NotNull
    public final List<Vector2> getPoints() {
        return this.points;
    }

    @Nullable
    public final Vector2 getActivePoint() {
        return this.activePoint;
    }

    public final void setActivePoint(@Nullable Vector2 vector2) {
        this.activePoint = vector2;
    }

    public final double getOffset() {
        return this.offset;
    }

    public final void setOffset(double value) {
        this.offset = value;
        this.events.getEnvelopeChanged().trigger(new EnvelopeChangedEvent(this));
    }

    @NotNull
    public final Events getEvents() {
        return this.events;
    }

    public final void insertPoint(@NotNull Vector2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        int n = this.points.size();
        for (int i = 0; i < n; ++i) {
            if (!(this.points.get(i).x() > v.x())) continue;
            this.points.add(i, v);
            this.activePoint = v;
            this.events.getEnvelopeChanged().trigger(new EnvelopeChangedEvent(this));
            return;
        }
        this.points.add(v);
        this.activePoint = v;
        this.fixBounds();
        this.events.getEnvelopeChanged().trigger(new EnvelopeChangedEvent(this));
    }

    @Nullable
    public final Vector2 findNearestPoint(@NotNull Vector2 v) {
        Object v0;
        Intrinsics.checkNotNullParameter(v, "v");
        Iterable $this$minByOrNull$iv = this.points;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                Vector2 it = (Vector2)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.minus(v).length();
                do {
                    Object e$iv = iterator$iv.next();
                    Vector2 it2 = (Vector2)e$iv;
                    $i$a$-minByOrNull-Envelope$findNearestPoint$1 = false;
                    double v$iv = it2.minus(v).length();
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    public final void removePoint(@NotNull Vector2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.points.remove(v);
        if (v == this.activePoint) {
            this.activePoint = null;
        }
        this.fixBounds();
        this.events.getEnvelopeChanged().trigger(new EnvelopeChangedEvent(this));
    }

    private final void fixBounds() {
        if (this.points.size() >= 2) {
            Vector2 it;
            if (!(this.points.get(0).x() == 0.0)) {
                it = Vector2.copy$default(this.points.get(0), 0.0, 0.0, 2, null);
                boolean bl = false;
                if (this.activePoint == this.points.get(0)) {
                    this.activePoint = it;
                }
                this.points.set(0, it);
            }
            if (!(this.points.get(this.points.size() - 1).x() == 1.0)) {
                it = Vector2.copy$default(this.points.get(this.points.size() - 1), 1.0, 0.0, 2, null);
                boolean bl = false;
                if (this.activePoint == this.points.get(this.points.size() - 1)) {
                    this.activePoint = it;
                }
                this.points.set(this.points.size() - 1, it);
            }
        }
    }

    public final void updatePoint(@NotNull Vector2 old, @NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter(old, "old");
        Intrinsics.checkNotNullParameter(vector2, "new");
        int index = this.points.indexOf(old);
        if (index != -1) {
            this.points.set(index, vector2);
        }
        if (old == this.activePoint) {
            this.activePoint = vector2;
        }
        List<Vector2> $this$sortBy$iv = this.points;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Vector2 it = (Vector2)a;
                    boolean bl = false;
                    Comparable comparable = Double.valueOf(it.x());
                    it = (Vector2)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.x());
                }
            });
        }
        this.fixBounds();
        this.events.getEnvelopeChanged().trigger(new EnvelopeChangedEvent(this));
    }

    public final double value(double t) {
        double st = RangesKt.coerceIn(t, 0.0, 1.0);
        if (this.points.size() == 1) {
            return this.points.get(0).y();
        }
        if (this.points.size() == 2) {
            return this.points.get(0).y() * (1.0 - st) + this.points.get(1).y() * st;
        }
        if (st == 0.0) {
            return this.points.get(0).y();
        }
        if (st == 1.0) {
            return this.points.get(this.points.size() - 1).y();
        }
        int n = this.points.size() - 1;
        for (int i = 0; i < n; ++i) {
            if (!(this.points.get(i).x() <= st) || !(this.points.get(i + 1).x() > st)) continue;
            Vector2 left = this.points.get(i);
            Vector2 right = this.points.get(i + 1);
            double dt = right.x() - left.x();
            if (dt > 0.0) {
                double f = (t - left.x()) / dt;
                return left.y() * (1.0 - f) + right.y() * f;
            }
            return left.y();
        }
        return this.points.get(0).y();
    }

    public Envelope() {
        this(0.0, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/openrndr/panel/elements/Envelope$EnvelopeChangedEvent;", "", "envelope", "Lorg/openrndr/panel/elements/Envelope;", "<init>", "(Lorg/openrndr/panel/elements/Envelope;)V", "getEnvelope", "()Lorg/openrndr/panel/elements/Envelope;", "orx-panel"})
    public static final class EnvelopeChangedEvent {
        @NotNull
        private final Envelope envelope;

        public EnvelopeChangedEvent(@NotNull Envelope envelope) {
            Intrinsics.checkNotNullParameter(envelope, "envelope");
            this.envelope = envelope;
        }

        @NotNull
        public final Envelope getEnvelope() {
            return this.envelope;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/openrndr/panel/elements/Envelope$Events;", "", "<init>", "()V", "envelopeChanged", "Lorg/openrndr/events/Event;", "Lorg/openrndr/panel/elements/Envelope$EnvelopeChangedEvent;", "getEnvelopeChanged", "()Lorg/openrndr/events/Event;", "orx-panel"})
    public static final class Events {
        @NotNull
        private final Event<EnvelopeChangedEvent> envelopeChanged = new Event("envelope-changed", false, 2, null);

        @NotNull
        public final Event<EnvelopeChangedEvent> getEnvelopeChanged() {
            return this.envelopeChanged;
        }
    }
}

