/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.panel.elements;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.CharacterEvent;
import org.openrndr.KeyEvent;
import org.openrndr.MouseEvent;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.LineCap;
import org.openrndr.events.Event;
import org.openrndr.extra.textwriter.Cursor;
import org.openrndr.extra.textwriter.TextWriter;
import org.openrndr.math.Vector2;
import org.openrndr.panel.ControlManager;
import org.openrndr.panel.FontManager;
import org.openrndr.panel.elements.Body;
import org.openrndr.panel.elements.DisposableElement;
import org.openrndr.panel.elements.Element;
import org.openrndr.panel.elements.ElementKt;
import org.openrndr.panel.elements.ElementType;
import org.openrndr.panel.elements.FocusEvent;
import org.openrndr.panel.elements.Range;
import org.openrndr.panel.elements.SliderMode;
import org.openrndr.panel.style.Color;
import org.openrndr.panel.style.StyleSheetKt;
import org.openrndr.shape.RectangleKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0002;<B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u00100\u001a\u00020 2\u0006\u0010!\u001a\u00020 J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R$\u0010&\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%R$\u0010*\u001a\u00020)2\u0006\u0010!\u001a\u00020)@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u000e\u0010/\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00101\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u000e\u00105\u001a\u00020 X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/openrndr/panel/elements/Slider;", "Lorg/openrndr/panel/elements/Element;", "Lorg/openrndr/panel/elements/DisposableElement;", "<init>", "()V", "disposed", "", "getDisposed", "()Z", "setDisposed", "(Z)V", "handlesKeyboardFocus", "getHandlesKeyboardFocus", "label", "", "getLabel", "()Ljava/lang/String;", "setLabel", "(Ljava/lang/String;)V", "precision", "", "getPrecision", "()I", "setPrecision", "(I)V", "mode", "Lorg/openrndr/panel/elements/SliderMode;", "getMode", "()Lorg/openrndr/panel/elements/SliderMode;", "setMode", "(Lorg/openrndr/panel/elements/SliderMode;)V", "v", "", "value", "getValue", "()D", "setValue", "(D)V", "interactiveValue", "getInteractiveValue", "setInteractiveValue", "Lorg/openrndr/panel/elements/Range;", "range", "getRange", "()Lorg/openrndr/panel/elements/Range;", "setRange", "(Lorg/openrndr/panel/elements/Range;)V", "realValue", "clean", "events", "Lorg/openrndr/panel/elements/Slider$Events;", "getEvents", "()Lorg/openrndr/panel/elements/Slider$Events;", "margin", "keyboardInput", "draw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "ValueChangedEvent", "Events", "orx-panel"})
public final class Slider
extends Element
implements DisposableElement {
    private boolean disposed;
    private final boolean handlesKeyboardFocus;
    @NotNull
    private String label = "";
    private int precision = 3;
    @NotNull
    private SliderMode mode = SliderMode.RANGE;
    @NotNull
    private Range range = new Range(0.0, 10.0);
    private double realValue;
    @NotNull
    private final Events events = new Events();
    private final double margin;
    @NotNull
    private String keyboardInput = "";

    public Slider() {
        super(new ElementType("slider"));
        this.handlesKeyboardFocus = true;
        this.margin = 7.0;
        this.getMouse().getPressed().listen(arg_0 -> Slider._init_$lambda$0(this, arg_0));
        this.getMouse().getClicked().listen(arg_0 -> Slider._init_$lambda$1(this, arg_0));
        this.getMouse().getDragged().listen(arg_0 -> Slider._init_$lambda$2(this, arg_0));
        this.getMouse().getScrolled().listen(arg_0 -> Slider._init_$lambda$3(this, arg_0));
        this.getKeyboard().getFocusLost().listen(arg_0 -> Slider._init_$lambda$4(this, arg_0));
        this.getKeyboard().getCharacter().listen(arg_0 -> Slider._init_$lambda$5(this, arg_0));
        this.getKeyboard().getRepeated().listen(arg_0 -> Slider._init_$lambda$6(this, arg_0));
        this.getKeyboard().getPressed().listen(arg_0 -> Slider._init_$lambda$7(this, arg_0));
    }

    @Override
    public boolean getDisposed() {
        return this.disposed;
    }

    @Override
    public void setDisposed(boolean bl) {
        this.disposed = bl;
    }

    @Override
    public boolean getHandlesKeyboardFocus() {
        return this.handlesKeyboardFocus;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.label = string;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final void setPrecision(int n) {
        this.precision = n;
    }

    @NotNull
    public final SliderMode getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull SliderMode sliderMode) {
        Intrinsics.checkNotNullParameter((Object)sliderMode, "<set-?>");
        this.mode = sliderMode;
    }

    public final double getValue() {
        return this.realValue;
    }

    public final void setValue(double v) {
        double oldV = this.realValue;
        this.realValue = this.clean(v);
        if (!(this.realValue == oldV)) {
            this.getDraw().setDirty(true);
            this.events.getValueChanged().trigger(new ValueChangedEvent(this, false, oldV, this.realValue));
        }
    }

    private final double getInteractiveValue() {
        return this.realValue;
    }

    private final void setInteractiveValue(double v) {
        double oldV = this.realValue;
        this.realValue = this.clean(v);
        if (!(this.realValue == oldV)) {
            this.getDraw().setDirty(true);
            this.events.getValueChanged().trigger(new ValueChangedEvent(this, true, oldV, this.realValue));
        }
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    public final void setRange(@NotNull Range value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.range = value;
        this.setValue(this.getValue());
    }

    public final double clean(double value) {
        double cleanV = RangesKt.coerceIn(value, this.range.min(), this.range.max());
        String string = "%.0" + this.precision + "f";
        Object[] objectArray = new Object[]{cleanV};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        double quantized = Double.parseDouble(StringsKt.replace$default(string2, ",", ".", false, 4, null));
        return quantized;
    }

    @NotNull
    public final Events getEvents() {
        return this.events;
    }

    @Override
    public void draw(@NotNull Drawer drawer) {
        Element element;
        Object object;
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        Element element2 = this.root();
        Object object2 = element2 instanceof Body ? (Body)element2 : null;
        FontImageMap fontImageMap = object2 != null && (object2 = ((Body)object2).getControlManager()) != null && (object2 = ((ControlManager)object2).getFontManager()) != null ? ((FontManager)object2).font(this.getComputedStyle()) : null;
        Intrinsics.checkNotNull(fontImageMap);
        FontImageMap f = fontImageMap;
        Drawer.translate$default(drawer, 0.0, (this.getLayout().getScreenHeight() - (10.0 + f.getHeight())) / (double)2, null, 4, null);
        Color color = StyleSheetKt.getColor(this.getComputedStyle());
        Intrinsics.checkNotNull(color, "null cannot be cast to non-null type org.openrndr.panel.style.Color.RGBa");
        drawer.setFill(((Color.RGBa)color).getColor());
        Color color2 = StyleSheetKt.getColor(this.getComputedStyle());
        Intrinsics.checkNotNull(color2, "null cannot be cast to non-null type org.openrndr.panel.style.Color.RGBa");
        drawer.setStroke(((Color.RGBa)color2).getColor());
        drawer.setStrokeWeight(8.0);
        drawer.setLineCap(LineCap.ROUND);
        double x = (this.getValue() - this.range.min()) / this.range.span() * (this.getLayout().getScreenWidth() - (double)2 * this.margin);
        Color color3 = StyleSheetKt.getColor(this.getComputedStyle());
        Intrinsics.checkNotNull(color3, "null cannot be cast to non-null type org.openrndr.panel.style.Color.RGBa");
        drawer.setStroke(((Color.RGBa)color3).getColor().opacify(0.25));
        drawer.lineSegment(this.margin + 0.0, 2.0, this.margin + this.getLayout().getScreenWidth() - (double)2 * this.margin, 2.0);
        if (this.mode == SliderMode.RANGE) {
            Color color4 = StyleSheetKt.getColor(this.getComputedStyle());
            Intrinsics.checkNotNull(color4, "null cannot be cast to non-null type org.openrndr.panel.style.Color.RGBa");
            drawer.setStroke(((Color.RGBa)color4).getColor().opacify(1.0));
            drawer.lineSegment(this.margin, 2.0, this.margin + x, 2.0);
            Color color5 = StyleSheetKt.getColor(this.getComputedStyle());
            Intrinsics.checkNotNull(color5, "null cannot be cast to non-null type org.openrndr.panel.style.Color.RGBa");
            drawer.setFill(((Color.RGBa)color5).getColor().opacify(1.0));
            drawer.setStroke(null);
            drawer.setStrokeWeight(0.0);
            drawer.circle(this.margin + x, 2.0, 5.0);
        }
        if (this.mode == SliderMode.POINT && this.precision == 0) {
            int n;
            List lineSegments = new ArrayList();
            int i = (int)this.range.min();
            if (i <= (n = (int)this.range.max())) {
                while (true) {
                    double lx = ((double)i - this.range.min()) / this.range.span() * (this.getLayout().getScreenWidth() - (double)2 * this.margin);
                    drawer.setStrokeWeight(1.0);
                    Color color6 = StyleSheetKt.getColor(this.getComputedStyle());
                    Intrinsics.checkNotNull(color6, "null cannot be cast to non-null type org.openrndr.panel.style.Color.RGBa");
                    drawer.setStroke(((Color.RGBa)color6).getColor().opacify(0.5));
                    lineSegments.add(new Vector2(this.margin + lx, -2.0));
                    lineSegments.add(new Vector2(this.margin + lx, 4.0));
                    if (i == n) break;
                    ++i;
                }
            }
            drawer.lineSegments(lineSegments);
        }
        if (this.mode == SliderMode.SEGMENT) {
            Color color7 = StyleSheetKt.getColor(this.getComputedStyle());
            Intrinsics.checkNotNull(color7, "null cannot be cast to non-null type org.openrndr.panel.style.Color.RGBa");
            drawer.setStroke(((Color.RGBa)color7).getColor().opacify(1.0));
            double sx = (this.getValue() - this.range.min()) / (this.range.span() + 1.0) * (this.getLayout().getScreenWidth() - (double)2 * this.margin) + this.margin;
            double ex = (this.getValue() + 1.0 - this.range.min()) / (this.range.span() + 1.0) * (this.getLayout().getScreenWidth() - (double)2 * this.margin) + this.margin;
            drawer.setStrokeWeight(8.0);
            drawer.lineSegment(sx, 2.0, ex, 2.0);
            drawer.setStroke(null);
            drawer.setStrokeWeight(0.0);
            List lineSegments = new ArrayList();
            int i = (int)this.range.min();
            int n = (int)this.range.max() + 1;
            if (i <= n) {
                while (true) {
                    double lx = ((double)i - this.range.min()) / (this.range.span() + 1.0) * (this.getLayout().getScreenWidth() - (double)2 * this.margin);
                    drawer.setStrokeWeight(1.0);
                    Color color8 = StyleSheetKt.getColor(this.getComputedStyle());
                    Intrinsics.checkNotNull(color8, "null cannot be cast to non-null type org.openrndr.panel.style.Color.RGBa");
                    drawer.setStroke(((Color.RGBa)color8).getColor().opacify(0.5));
                    lineSegments.add(new Vector2(this.margin + lx, -2.0));
                    lineSegments.add(new Vector2(this.margin + lx, 4.0));
                    if (i == n) break;
                    ++i;
                }
            }
            drawer.lineSegments(lineSegments);
        }
        if (this.mode == SliderMode.POINT) {
            Color color9 = StyleSheetKt.getColor(this.getComputedStyle());
            Intrinsics.checkNotNull(color9, "null cannot be cast to non-null type org.openrndr.panel.style.Color.RGBa");
            drawer.setFill(((Color.RGBa)color9).getColor().opacify(1.0));
            drawer.setStroke(null);
            drawer.circle(this.margin + x, 2.0, 8.0);
        }
        if ((object = (element = this.root()) instanceof Body ? (Body)element : null) != null && (object = ((Body)object).getControlManager()) != null && (object = ((ControlManager)object).getFontManager()) != null) {
            Object it = object;
            boolean bl = false;
            FontImageMap font = ((FontManager)it).font(this.getComputedStyle());
            TextWriter writer = new TextWriter(drawer);
            drawer.setFontMap(font);
            drawer.setFill(StyleSheetKt.getEffectiveColor(this.getComputedStyle()));
            writer.setCursor(new Cursor(0.0, 8.0));
            writer.setBox(RectangleKt.Rectangle(0.0, 8.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
            writer.newLine();
            TextWriter.text$default(writer, this.label, false, 2, null);
            if (((CharSequence)this.keyboardInput).length() == 0) {
                String string = "%.0" + this.precision + "f";
                Object[] objectArray = new Object[]{this.getValue()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                String valueFormatted = string2;
                double tw = writer.textWidth(valueFormatted);
                writer.getCursor().setX(this.getLayout().getScreenWidth() - tw);
                v13 = TextWriter.text$default(writer, valueFormatted, false, 2, null);
            } else {
                double tw = writer.textWidth(this.keyboardInput);
                writer.getCursor().setX(this.getLayout().getScreenWidth() - tw);
                v13 = TextWriter.text$default(writer, this.keyboardInput, false, 2, null);
            }
        } else {
            v13 = null;
        }
    }

    @Override
    public void dispose() {
        DisposableElement.DefaultImpls.dispose(this);
    }

    private static final Unit _init_$lambda$0(Slider this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        double t = (it.getPosition().x() - this$0.getLayout().getScreenX() - this$0.margin) / (this$0.getLayout().getScreenWidth() - 2.0 * this$0.margin);
        this$0.setInteractiveValue(t * this$0.range.span() + this$0.range.min());
        it.cancelPropagation();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(Slider this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        double t = (it.getPosition().x() - this$0.getLayout().getScreenX() - this$0.margin) / (this$0.getLayout().getScreenWidth() - 2.0 * this$0.margin);
        this$0.setInteractiveValue(t * this$0.range.span() + this$0.range.min());
        it.cancelPropagation();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(Slider this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        double t = (it.getPosition().x() - this$0.getLayout().getScreenX() - this$0.margin) / (this$0.getLayout().getScreenWidth() - 2.0 * this$0.margin);
        this$0.setInteractiveValue(t * this$0.range.span() + this$0.range.min());
        it.cancelPropagation();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(Slider this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (Math.abs(it.getRotation().y()) < 0.001) {
            this$0.setInteractiveValue(this$0.getInteractiveValue() + this$0.range.span() * 0.001 * it.getRotation().x());
            it.cancelPropagation();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(Slider this$0, FocusEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.keyboardInput = "";
        this$0.getDraw().setDirty(true);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(Slider this$0, CharacterEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Character[] characterArray = new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('.'), Character.valueOf(','), Character.valueOf('-')};
        if (SetsKt.setOf(characterArray).contains(Character.valueOf(it.getCharacter()))) {
            try {
                String candidate = this$0.keyboardInput + it.getCharacter();
                if (candidate.length() > 1) {
                    NumberFormat.getInstance().parse(candidate).doubleValue();
                }
                this$0.keyboardInput = candidate;
                ElementKt.requestRedraw(this$0);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        it.cancelPropagation();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(Slider this$0, KeyEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        double delta = Math.pow(10.0, -((double)this$0.precision - 0.0));
        if (it.getKey() == 262) {
            this$0.setInteractiveValue(this$0.getInteractiveValue() + delta);
            it.cancelPropagation();
        }
        if (it.getKey() == 263) {
            this$0.setInteractiveValue(this$0.getInteractiveValue() - delta);
            it.cancelPropagation();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$7(Slider this$0, KeyEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        double delta = Math.pow(10.0, -((double)this$0.precision - 0.0));
        if (it.getKey() == 262) {
            this$0.setInteractiveValue(this$0.getInteractiveValue() + delta);
            it.cancelPropagation();
        }
        if (it.getKey() == 263) {
            this$0.setInteractiveValue(this$0.getInteractiveValue() - delta);
            it.cancelPropagation();
        }
        if (it.getKey() == 259) {
            if (!(((CharSequence)this$0.keyboardInput).length() == 0)) {
                String string = this$0.keyboardInput.substring(0, this$0.keyboardInput.length() - 1);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                this$0.keyboardInput = string;
                this$0.getDraw().setDirty(true);
            }
            it.cancelPropagation();
        }
        if (it.getKey() == 256) {
            this$0.keyboardInput = "";
            this$0.getDraw().setDirty(true);
            it.cancelPropagation();
        }
        if (it.getKey() == 257) {
            try {
                double number = NumberFormat.getInstance().parse(this$0.keyboardInput).doubleValue();
                this$0.setInteractiveValue(RangesKt.coerceIn(number, this$0.range.min(), this$0.range.max()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this$0.keyboardInput = "";
            this$0.getDraw().setDirty(true);
            it.cancelPropagation();
        }
        if (it.getKey() == 268) {
            this$0.setInteractiveValue(this$0.range.min());
            this$0.keyboardInput = "";
            it.cancelPropagation();
        }
        if (it.getKey() == 269) {
            this$0.setInteractiveValue(this$0.range.max());
            this$0.keyboardInput = "";
            it.cancelPropagation();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/openrndr/panel/elements/Slider$Events;", "", "<init>", "()V", "valueChanged", "Lorg/openrndr/events/Event;", "Lorg/openrndr/panel/elements/Slider$ValueChangedEvent;", "getValueChanged", "()Lorg/openrndr/events/Event;", "orx-panel"})
    public static final class Events {
        @NotNull
        private final Event<ValueChangedEvent> valueChanged = new Event("slider-value-changed", false, 2, null);

        @NotNull
        public final Event<ValueChangedEvent> getValueChanged() {
            return this.valueChanged;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/openrndr/panel/elements/Slider$ValueChangedEvent;", "", "source", "Lorg/openrndr/panel/elements/Slider;", "interactive", "", "oldValue", "", "newValue", "<init>", "(Lorg/openrndr/panel/elements/Slider;ZDD)V", "getSource", "()Lorg/openrndr/panel/elements/Slider;", "getInteractive", "()Z", "getOldValue", "()D", "getNewValue", "orx-panel"})
    public static final class ValueChangedEvent {
        @NotNull
        private final Slider source;
        private final boolean interactive;
        private final double oldValue;
        private final double newValue;

        public ValueChangedEvent(@NotNull Slider source, boolean interactive, double oldValue, double newValue) {
            Intrinsics.checkNotNullParameter(source, "source");
            this.source = source;
            this.interactive = interactive;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @NotNull
        public final Slider getSource() {
            return this.source;
        }

        public final boolean getInteractive() {
            return this.interactive;
        }

        public final double getOldValue() {
            return this.oldValue;
        }

        public final double getNewValue() {
            return this.newValue;
        }
    }
}

