/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.panel.elements;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.MouseEvent;
import org.openrndr.Program;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.FontMap;
import org.openrndr.draw.LineCap;
import org.openrndr.draw.LoadFontKt;
import org.openrndr.events.Event;
import org.openrndr.extra.textwriter.TextWriter;
import org.openrndr.panel.ControlManager;
import org.openrndr.panel.FontManager;
import org.openrndr.panel.elements.Body;
import org.openrndr.panel.elements.DisposableElement;
import org.openrndr.panel.elements.Element;
import org.openrndr.panel.elements.ElementType;
import org.openrndr.panel.style.LinearDimension;
import org.openrndr.panel.style.StyleSheet;
import org.openrndr.panel.style.StyleSheetKt;
import org.openrndr.shape.RectangleKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0002!\"B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006#"}, d2={"Lorg/openrndr/panel/elements/Toggle;", "Lorg/openrndr/panel/elements/Element;", "Lorg/openrndr/panel/elements/DisposableElement;", "<init>", "()V", "disposed", "", "getDisposed", "()Z", "setDisposed", "(Z)V", "label", "", "getLabel", "()Ljava/lang/String;", "setLabel", "(Ljava/lang/String;)V", "value", "getValue", "setValue", "events", "Lorg/openrndr/panel/elements/Toggle$Events;", "getEvents", "()Lorg/openrndr/panel/elements/Toggle$Events;", "widthHint", "", "getWidthHint", "()Ljava/lang/Double;", "emit", "", "draw", "drawer", "Lorg/openrndr/draw/Drawer;", "ValueChangedEvent", "Events", "orx-panel"})
public final class Toggle
extends Element
implements DisposableElement {
    private boolean disposed;
    @NotNull
    private String label = "";
    private boolean value;
    @NotNull
    private final Events events = new Events();

    public Toggle() {
        super(new ElementType("toggle"));
        this.getMouse().getPressed().listen(Toggle::_init_$lambda$1);
        this.getMouse().getClicked().listen(arg_0 -> Toggle._init_$lambda$2(this, arg_0));
    }

    @Override
    public boolean getDisposed() {
        return this.disposed;
    }

    @Override
    public void setDisposed(boolean bl) {
        this.disposed = bl;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.label = string;
    }

    public final boolean getValue() {
        return this.value;
    }

    public final void setValue(boolean bl) {
        this.value = bl;
    }

    @NotNull
    public final Events getEvents() {
        return this.events;
    }

    @Override
    @Nullable
    public Double getWidthHint() {
        StyleSheet style = this.getComputedStyle();
        boolean bl = false;
        Element element = this.root();
        Object object = element instanceof Body ? (Body)element : null;
        if (object == null || (object = ((Body)object).getControlManager()) == null || (object = ((ControlManager)object).getFontManager()) == null || (object = ((FontManager)object).resolve(StyleSheetKt.getFontFamily(style))) == null) {
            object = "broken";
        }
        Object fontUrl = object;
        LinearDimension linearDimension = StyleSheetKt.getFontSize(style);
        LinearDimension.PX pX = linearDimension instanceof LinearDimension.PX ? (LinearDimension.PX)linearDimension : null;
        double fontSize = pX != null ? pX.getValue() : 14.0;
        Element element2 = this.root();
        Object object2 = element2 instanceof Body ? (Body)element2 : null;
        if (object2 == null || (object2 = ((Body)object2).getControlManager()) == null || (object2 = ((ControlManager)object2).getProgram()) == null) {
            throw new IllegalStateException("no program".toString());
        }
        Object program2 = object2;
        FontImageMap fontMap = LoadFontKt.loadFont$default((Program)program2, (String)fontUrl, fontSize, null, 0.0, null, 28, null);
        TextWriter writer = new TextWriter(null);
        writer.setBox(RectangleKt.Rectangle(0.0, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
        writer.getDrawStyle().setFontMap(fontMap);
        writer.newLine();
        writer.text(this.label, false);
        double d = writer.getCursor().getX();
        LinearDimension linearDimension2 = StyleSheetKt.getHeight(this.getComputedStyle());
        Intrinsics.checkNotNull(linearDimension2, "null cannot be cast to non-null type org.openrndr.panel.style.LinearDimension.PX");
        return d + ((LinearDimension.PX)linearDimension2).getValue() - 8.0 + 5.0;
    }

    public final void emit() {
        this.events.getValueChanged().trigger(new ValueChangedEvent(this, this.value, this.value));
    }

    @Override
    public void draw(@NotNull Drawer drawer) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        drawer.pushModel();
        double checkBoxSize = this.getLayout().getScreenHeight() - 8.0;
        Drawer.translate$default(drawer, 0.0, (this.getLayout().getScreenHeight() - checkBoxSize) / 2.0, null, 4, null);
        drawer.setStrokeWeight(1.0);
        drawer.setStroke(StyleSheetKt.getEffectiveColor(this.getComputedStyle()));
        drawer.setFill(null);
        drawer.rectangle(0.0, 0.0, checkBoxSize, checkBoxSize);
        if (this.value) {
            drawer.setStrokeWeight(2.0);
            drawer.setStroke(StyleSheetKt.getEffectiveColor(this.getComputedStyle()));
            drawer.setFill(null);
            drawer.setLineCap(LineCap.ROUND);
            drawer.lineSegment(5.0, 5.0, checkBoxSize / 2.0 - 2.0, checkBoxSize / 2.0 - 2.0);
            drawer.lineSegment(checkBoxSize / 2.0 + 2.0, checkBoxSize / 2.0 + 2.0, checkBoxSize - 5.0, checkBoxSize - 5.0);
            drawer.lineSegment(checkBoxSize - 5.0, 5.0, checkBoxSize / 2.0 + 2.0, checkBoxSize / 2.0 - 2.0);
            drawer.lineSegment(checkBoxSize / 2.0 - 2.0, checkBoxSize / 2.0 + 2.0, 5.0, checkBoxSize - 5.0);
        }
        drawer.popModel();
        Element element = this.root();
        Object object = element instanceof Body ? (Body)element : null;
        FontImageMap fontImageMap = object != null && (object = ((Body)object).getControlManager()) != null && (object = ((ControlManager)object).getFontManager()) != null ? ((FontManager)object).font(this.getComputedStyle()) : null;
        Intrinsics.checkNotNull(fontImageMap);
        drawer.setFontMap(fontImageMap);
        double d = this.getLayout().getScreenHeight() / 2.0;
        FontMap fontMap = drawer.getFontMap();
        Intrinsics.checkNotNull(fontMap);
        Drawer.translate$default(drawer, 5.0 + checkBoxSize, d + fontMap.getHeight() / 2.0, null, 4, null);
        drawer.setStroke(null);
        drawer.setFill(StyleSheetKt.getEffectiveColor(this.getComputedStyle()));
        drawer.text(this.label, 0.0, 0.0);
    }

    @Override
    public void dispose() {
        DisposableElement.DefaultImpls.dispose(this);
    }

    private static final Unit _init_$lambda$1(MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.cancelPropagation();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(Toggle this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.value = !this$0.value;
        this$0.getDraw().setDirty(true);
        this$0.events.getValueChanged().trigger(new ValueChangedEvent(this$0, !this$0.value, this$0.value));
        it.cancelPropagation();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/openrndr/panel/elements/Toggle$Events;", "", "<init>", "()V", "valueChanged", "Lorg/openrndr/events/Event;", "Lorg/openrndr/panel/elements/Toggle$ValueChangedEvent;", "getValueChanged", "()Lorg/openrndr/events/Event;", "orx-panel"})
    public static final class Events {
        @NotNull
        private final Event<ValueChangedEvent> valueChanged = new Event("toggle-value-changed", false, 2, null);

        @NotNull
        public final Event<ValueChangedEvent> getValueChanged() {
            return this.valueChanged;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/openrndr/panel/elements/Toggle$ValueChangedEvent;", "", "source", "Lorg/openrndr/panel/elements/Toggle;", "oldValue", "", "newValue", "<init>", "(Lorg/openrndr/panel/elements/Toggle;ZZ)V", "getSource", "()Lorg/openrndr/panel/elements/Toggle;", "getOldValue", "()Z", "getNewValue", "orx-panel"})
    public static final class ValueChangedEvent {
        @NotNull
        private final Toggle source;
        private final boolean oldValue;
        private final boolean newValue;

        public ValueChangedEvent(@NotNull Toggle source, boolean oldValue, boolean newValue) {
            Intrinsics.checkNotNullParameter(source, "source");
            this.source = source;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @NotNull
        public final Toggle getSource() {
            return this.source;
        }

        public final boolean getOldValue() {
            return this.oldValue;
        }

        public final boolean getNewValue() {
            return this.newValue;
        }
    }
}

