/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.Transient;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.EuclideanVector;
import org.openrndr.shape.BezierSegment;
import org.openrndr.shape.ShapeToolsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u000f\bf\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003J\u0015\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u000e0\u001e2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u001f\u0010#\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010$\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010%J\u0018\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\b\b\u0002\u0010$\u001a\u00020\u000eH\u0016J$\u0010'\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e0\u001e0\u00052\b\b\u0002\u0010$\u001a\u00020\u000eH\u0016J \u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010)\u001a\u00020\u001f2\b\b\u0002\u0010$\u001a\u00020\u000eH\u0016J,\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e0\u001e0\u00052\u0006\u0010)\u001a\u00020\u001f2\b\b\u0002\u0010$\u001a\u00020\u000eH\u0016J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u000eH&R\u001e\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000e8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00028\u00008&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\u0010\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010 \u001a\u00020\n8&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b!\u0010\u0010\u001a\u0004\b\"\u0010\f\u00a8\u0006."}, d2={"Lorg/openrndr/shape/Path;", "T", "Lorg/openrndr/math/EuclideanVector;", "", "segments", "", "Lorg/openrndr/shape/BezierSegment;", "getSegments", "()Ljava/util/List;", "closed", "", "getClosed", "()Z", "length", "", "getLength$annotations", "()V", "getLength", "()D", "infinity", "getInfinity$annotations", "getInfinity", "()Lorg/openrndr/math/EuclideanVector;", "position", "ut", "(D)Lorg/openrndr/math/EuclideanVector;", "direction", "curvature", "tForLength", "segment", "Lkotlin/Pair;", "", "empty", "getEmpty$annotations", "getEmpty", "pointAtLength", "distanceTolerance", "(DD)Lorg/openrndr/math/EuclideanVector;", "adaptivePositions", "adaptivePositionsWithT", "equidistantPositions", "pointCount", "equidistantPositionsWithT", "sub", "t0", "t1", "openrndr-shape"})
public interface Path<T extends EuclideanVector<T>> {
    @NotNull
    public List<BezierSegment<T>> getSegments();

    public boolean getClosed();

    public double getLength();

    @NotNull
    public T getInfinity();

    @NotNull
    public T position(double var1);

    @NotNull
    public T direction(double var1);

    public double curvature(double var1);

    public double tForLength(double var1);

    @NotNull
    public Pair<Integer, Double> segment(double var1);

    public boolean getEmpty();

    @NotNull
    public T pointAtLength(double var1, double var3);

    @NotNull
    public List<T> adaptivePositions(double var1);

    @NotNull
    public List<Pair<T, Double>> adaptivePositionsWithT(double var1);

    @NotNull
    public List<T> equidistantPositions(int var1, double var2);

    @NotNull
    public List<Pair<T, Double>> equidistantPositionsWithT(int var1, double var2);

    @NotNull
    public Path<T> sub(double var1, double var3);

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Path.kt\norg/openrndr/shape/Path$DefaultImpls\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,209:1\n1#2:210\n1557#3:211\n1628#3,3:212\n1863#3,2:215\n*S KotlinDebug\n*F\n+ 1 Path.kt\norg/openrndr/shape/Path$DefaultImpls\n*L\n166#1:211\n166#1:212,3\n174#1:215,2\n*E\n"})
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        public static <T extends EuclideanVector<T>> double getLength(@NotNull Path<T> $this) {
            Iterable iterable = $this.getSegments();
            double d = 0.0;
            for (Object t : iterable) {
                void it;
                BezierSegment bezierSegment = (BezierSegment)t;
                double d2 = d;
                boolean bl = false;
                double d3 = it.getLength();
                d = d2 + d3;
            }
            return d;
        }

        @Transient
        public static /* synthetic */ void getLength$annotations() {
        }

        @Transient
        public static /* synthetic */ void getInfinity$annotations() {
        }

        @NotNull
        public static <T extends EuclideanVector<T>> T position(@NotNull Path<T> $this, double ut) {
            T t;
            if ($this.getEmpty()) {
                return $this.getInfinity();
            }
            double t2 = RangesKt.coerceIn(ut, 0.0, 1.0);
            if (t2 == 0.0) {
                t = $this.getSegments().get(0).getStart();
            } else if (t2 == 1.0) {
                t = CollectionsKt.last($this.getSegments()).getEnd();
            } else {
                Pair<Integer, Double> pair = $this.segment(t2);
                int segment = ((Number)pair.component1()).intValue();
                double segmentOffset = ((Number)pair.component2()).doubleValue();
                t = $this.getSegments().get(segment).position(segmentOffset);
            }
            return t;
        }

        @NotNull
        public static <T extends EuclideanVector<T>> T direction(@NotNull Path<T> $this, double ut) {
            T t;
            if ($this.getEmpty()) {
                return $this.getInfinity();
            }
            double t2 = RangesKt.coerceIn(ut, 0.0, 1.0);
            if (t2 == 0.0) {
                t = $this.getSegments().get(0).direction(0.0);
            } else if (t2 == 1.0) {
                t = CollectionsKt.last($this.getSegments()).direction(1.0);
            } else {
                Pair<Integer, Double> pair = $this.segment(t2);
                int segment = ((Number)pair.component1()).intValue();
                double segmentOffset = ((Number)pair.component2()).doubleValue();
                t = $this.getSegments().get(segment).direction(segmentOffset);
            }
            return t;
        }

        public static <T extends EuclideanVector<T>> double curvature(@NotNull Path<T> $this, double ut) {
            double d;
            if ($this.getEmpty()) {
                return 0.0;
            }
            double t = RangesKt.coerceIn(ut, 0.0, 1.0);
            if (t == 0.0) {
                d = $this.getSegments().get(0).curvature(0.0);
            } else if (t == 1.0) {
                d = CollectionsKt.last($this.getSegments()).curvature(1.0);
            } else {
                Pair<Integer, Double> pair = $this.segment(t);
                int segment = ((Number)pair.component1()).intValue();
                double segmentOffset = ((Number)pair.component2()).doubleValue();
                d = $this.getSegments().get(segment).curvature(segmentOffset);
            }
            return d;
        }

        public static <T extends EuclideanVector<T>> double tForLength(@NotNull Path<T> $this, double length) {
            double remaining = length;
            if (length <= 0.0) {
                return 0.0;
            }
            if ($this.getSegments().size() == 1) {
                return CollectionsKt.first($this.getSegments()).tForLength(length);
            }
            Iterator iterator2 = ((Iterable)$this.getSegments()).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int index = n++;
                BezierSegment segment = (BezierSegment)iterator2.next();
                double segmentLength = segment.getLength();
                if (segmentLength > remaining) {
                    return (segment.tForLength(remaining) + (double)index) / (double)$this.getSegments().size();
                }
                remaining -= segmentLength;
            }
            return 1.0;
        }

        @NotNull
        public static <T extends EuclideanVector<T>> Pair<Integer, Double> segment(@NotNull Path<T> $this, double ut) {
            Pair<Integer, Double> pair;
            if ($this.getEmpty()) {
                return new Pair<Integer, Double>(0, 0.0);
            }
            double t = RangesKt.coerceIn(ut, 0.0, 1.0);
            if (t == 0.0) {
                pair = new Pair<Integer, Double>(0, 0.0);
            } else if (t == 1.0) {
                pair = new Pair<Integer, Double>($this.getSegments().size() - 1, 1.0);
            } else {
                int segment = (int)(t * (double)$this.getSegments().size());
                double segmentOffset = t * (double)$this.getSegments().size() - (double)segment;
                return new Pair<Integer, Double>(segment, segmentOffset);
            }
            return pair;
        }

        @Transient
        public static /* synthetic */ void getEmpty$annotations() {
        }

        @NotNull
        public static <T extends EuclideanVector<T>> T pointAtLength(@NotNull Path<T> $this, double length, double distanceTolerance) {
            if ($this.getEmpty()) {
                return $this.getInfinity();
            }
            if (length <= 0.0) {
                return CollectionsKt.first($this.getSegments()).getStart();
            }
            if (length >= $this.getLength()) {
                return CollectionsKt.last($this.getSegments()).getEnd();
            }
            double remainingLength = length;
            for (BezierSegment<T> segment : $this.getSegments()) {
                double segmentLength = segment.getLength();
                if (segmentLength > remainingLength) {
                    return segment.pointAtLength(remainingLength, distanceTolerance);
                }
                remainingLength -= segmentLength;
            }
            return CollectionsKt.last($this.getSegments()).getEnd();
        }

        public static /* synthetic */ EuclideanVector pointAtLength$default(Path path, double d, double d2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: pointAtLength");
            }
            if ((n & 2) != 0) {
                d2 = 0.5;
            }
            return path.pointAtLength(d, d2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static <T extends EuclideanVector<T>> List<T> adaptivePositions(@NotNull Path<T> $this, double distanceTolerance) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this.adaptivePositionsWithT(distanceTolerance);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((EuclideanVector)it.getFirst());
            }
            return (List)destination$iv$iv;
        }

        public static /* synthetic */ List adaptivePositions$default(Path path, double d, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: adaptivePositions");
            }
            if ((n & 1) != 0) {
                d = 0.5;
            }
            return path.adaptivePositions(d);
        }

        @NotNull
        public static <T extends EuclideanVector<T>> List<Pair<T, Double>> adaptivePositionsWithT(@NotNull Path<T> $this, double distanceTolerance) {
            List adaptivePoints = new ArrayList();
            int segmentCount = $this.getSegments().size();
            Iterator iterator2 = ((Iterable)$this.getSegments()).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int segmentIndex = n++;
                BezierSegment segment = (BezierSegment)iterator2.next();
                List samples2 = segment.adaptivePositionsWithT(distanceTolerance);
                Iterable $this$forEach$iv = samples2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl = false;
                    Pair last2 = (Pair)CollectionsKt.lastOrNull(adaptivePoints);
                    if (last2 != null && !(((EuclideanVector)last2.getFirst()).squaredDistanceTo((EuclideanVector)it.getFirst()) > 0.0)) continue;
                    adaptivePoints.add(Pair.copy$default(it, null, (((Number)it.getSecond()).doubleValue() + (double)segmentIndex) / (double)segmentCount, 1, null));
                }
            }
            return adaptivePoints;
        }

        public static /* synthetic */ List adaptivePositionsWithT$default(Path path, double d, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: adaptivePositionsWithT");
            }
            if ((n & 1) != 0) {
                d = 0.5;
            }
            return path.adaptivePositionsWithT(d);
        }

        @NotNull
        public static <T extends EuclideanVector<T>> List<T> equidistantPositions(@NotNull Path<T> $this, int pointCount, double distanceTolerance) {
            return $this.getEmpty() ? CollectionsKt.emptyList() : CollectionsKt.take((Iterable)ShapeToolsKt.sampleEquidistant($this.adaptivePositions(distanceTolerance), pointCount + ($this.getClosed() ? 1 : 0)), pointCount);
        }

        public static /* synthetic */ List equidistantPositions$default(Path path, int n, double d, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: equidistantPositions");
            }
            if ((n2 & 2) != 0) {
                d = 0.5;
            }
            return path.equidistantPositions(n, d);
        }

        @NotNull
        public static <T extends EuclideanVector<T>> List<Pair<T, Double>> equidistantPositionsWithT(@NotNull Path<T> $this, int pointCount, double distanceTolerance) {
            return $this.getEmpty() ? CollectionsKt.emptyList() : CollectionsKt.take((Iterable)ShapeToolsKt.sampleEquidistantWithT($this.adaptivePositionsWithT(distanceTolerance), pointCount + ($this.getClosed() ? 1 : 0)), pointCount);
        }

        public static /* synthetic */ List equidistantPositionsWithT$default(Path path, int n, double d, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: equidistantPositionsWithT");
            }
            if ((n2 & 2) != 0) {
                d = 0.5;
            }
            return path.equidistantPositionsWithT(n, d);
        }
    }
}

