/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.OpenEndRange;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.LinearType;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector2$;
import org.openrndr.math.YPolarity;
import org.openrndr.shape.IntRectangle;
import org.openrndr.shape.IntRectangleKt;
import org.openrndr.shape.LineSegment;
import org.openrndr.shape.Movable;
import org.openrndr.shape.Rectangle$;
import org.openrndr.shape.RectangleKt;
import org.openrndr.shape.Scalable2D;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeContourProvider;
import org.openrndr.shape.ShapeProvider;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 m2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\b\u0012\u0004\u0012\u00020\u00000\u00052\u00020\u0006:\u0002mnB!\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rB5\b\u0010\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\f\u0010\u0012J\u0018\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\nH\u0016J\u0018\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\n2\b\b\u0002\u0010*\u001a\u00020\nJ.\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\n2\b\b\u0002\u0010+\u001a\u00020\n2\b\b\u0002\u0010,\u001a\u00020\n2\b\b\u0002\u0010-\u001a\u00020\nH\u0007J\u001a\u0010.\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\n2\b\b\u0002\u0010+\u001a\u00020\nH\u0007J\u000e\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020\nJ\u000e\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020\nJ\u0010\u00103\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\bH\u0007J\u0010\u00104\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\bH\u0016J\u0010\u00105\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\bH\u0016J(\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\n2\u0006\u00108\u001a\u00020\n2\u0006\u00109\u001a\u00020\n2\u0006\u0010:\u001a\u00020\nH\u0016J \u00106\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\n2\u0006\u00109\u001a\u00020\n2\u0006\u0010:\u001a\u00020\nH\u0016J\u0018\u0010;\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\nH\u0016J\u0010\u0010=\u001a\u00020\u00002\b\b\u0002\u0010\u001e\u001a\u00020\nJ\u0010\u0010>\u001a\u00020\u00002\b\b\u0002\u0010\u001f\u001a\u00020\nJ\u0010\u0010?\u001a\u00020@2\b\b\u0002\u0010\u001f\u001a\u00020\nJ\u0010\u0010A\u001a\u00020@2\b\b\u0002\u0010\u001e\u001a\u00020\nJ\u0011\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\bH\u0086\u0002J\u000e\u0010E\u001a\u00020C2\u0006\u0010F\u001a\u00020\u0000J\u0011\u0010G\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\nH\u0096\u0002J\u0011\u0010H\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\nH\u0096\u0002J\u0011\u0010I\u001a\u00020\u00002\u0006\u0010J\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010K\u001a\u00020\u00002\u0006\u0010J\u001a\u00020\u0000H\u0096\u0002J\"\u0010L\u001a\u00020\u00002\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0M2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0MJ&\u0010L\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\n2\u0006\u0010O\u001a\u00020\n2\u0006\u0010P\u001a\u00020\n2\u0006\u0010Q\u001a\u00020\nJ\u0006\u0010R\u001a\u00020SJ\u0010\u0010X\u001a\u00020\u00002\b\b\u0002\u0010Y\u001a\u00020UJ\t\u0010\\\u001a\u00020\bH\u00c6\u0003J\t\u0010]\u001a\u00020\nH\u00c6\u0003J\t\u0010^\u001a\u00020\nH\u00c6\u0003J'\u0010_\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010`\u001a\u00020C2\b\u0010F\u001a\u0004\u0018\u00010aH\u00d6\u0003J\t\u0010b\u001a\u00020\u000fH\u00d6\u0001J\t\u0010c\u001a\u00020dH\u00d6\u0001J%\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020\u00002\u0006\u0010h\u001a\u00020i2\u0006\u0010j\u001a\u00020kH\u0001\u00a2\u0006\u0002\blR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\u0019\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\u001a\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014R\u0011\u0010\u001b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0013R\u0014\u0010\u001c\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0013R\u0011\u0010 \u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0014R\u0011\u0010!\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0014R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010$R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010'R\u0011\u0010T\u001a\u00020U8F\u00a2\u0006\u0006\u001a\u0004\bT\u0010VR\u0011\u0010W\u001a\u00020U8F\u00a2\u0006\u0006\u001a\u0004\bW\u0010VR\u0011\u0010Z\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bZ\u0010[\u00a8\u0006o"}, d2={"Lorg/openrndr/shape/Rectangle;", "Lorg/openrndr/shape/Movable;", "Lorg/openrndr/shape/Scalable2D;", "Lorg/openrndr/shape/ShapeProvider;", "Lorg/openrndr/shape/ShapeContourProvider;", "Lorg/openrndr/math/LinearType;", "Ljava/lang/Record;", "corner", "Lorg/openrndr/math/Vector2;", "width", "", "height", "<init>", "(Lorg/openrndr/math/Vector2;DD)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILorg/openrndr/math/Vector2;DDLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()Lorg/openrndr/math/Vector2;", "()D", "xRange", "Lkotlin/ranges/OpenEndRange;", "()Lkotlin/ranges/OpenEndRange;", "yRange", "center", "area", "dimensions", "scale", "position", "u", "v", "x", "y", "shape", "Lorg/openrndr/shape/Shape;", "()Lorg/openrndr/shape/Shape;", "contour", "Lorg/openrndr/shape/ShapeContour;", "()Lorg/openrndr/shape/ShapeContour;", "offsetEdges", "offset", "offsetY", "scaleY", "anchorU", "anchorV", "scaled", "widthScaledTo", "fitWidth", "heightScaledTo", "fitHeight", "moved", "movedBy", "movedTo", "scaledBy", "xScale", "yScale", "uAnchor", "vAnchor", "scaledTo", "size", "flippedHorizontally", "flippedVertically", "horizontal", "Lorg/openrndr/shape/LineSegment;", "vertical", "contains", "", "point", "intersects", "other", "times", "div", "plus", "right", "minus", "sub", "Lkotlin/ranges/ClosedFloatingPointRange;", "u0", "v0", "u1", "v1", "toInt", "Lorg/openrndr/shape/IntRectangle;", "majorAxis", "Lorg/openrndr/math/Vector2$Axis;", "()Lorg/openrndr/math/Vector2$Axis;", "minorAxis", "ratio", "axis", "normalized", "()Lorg/openrndr/shape/Rectangle;", "component1", "component2", "component3", "copy", "equals", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_shape", "Companion", "$serializer", "openrndr-shape"})
public final class Rectangle
extends Record
implements Movable,
Scalable2D,
ShapeProvider,
ShapeContourProvider,
LinearType<Rectangle> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector2 corner;
    private final double width;
    private final double height;
    @NotNull
    private static final Rectangle EMPTY = RectangleKt.Rectangle(0.0, 0.0, 0.0, 0.0);

    public Rectangle(@NotNull Vector2 corner, double width, double height) {
        Intrinsics.checkNotNullParameter(corner, "corner");
        this.corner = corner;
        this.width = width;
        this.height = height;
    }

    public /* synthetic */ Rectangle(Vector2 vector2, double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d2 = d;
        }
        this(vector2, d, d2);
    }

    @NotNull
    public final Vector2 corner() {
        return this.corner;
    }

    public final double width() {
        return this.width;
    }

    public final double height() {
        return this.height;
    }

    @NotNull
    public final OpenEndRange<Double> xRange() {
        return RangesKt.rangeUntil(Math.min(this.corner.x(), this.corner.x() + this.width), Math.max(this.corner.x(), this.corner.x() + this.width));
    }

    @NotNull
    public final OpenEndRange<Double> yRange() {
        return RangesKt.rangeUntil(Math.min(this.corner.y(), this.corner.y() + this.height), Math.max(this.corner.y(), this.corner.y() + this.height));
    }

    @NotNull
    public final Vector2 center() {
        return this.corner.plus(new Vector2(this.width / (double)2, this.height / (double)2));
    }

    public final double area() {
        return this.width * this.height;
    }

    @NotNull
    public final Vector2 dimensions() {
        return new Vector2(this.width, this.height);
    }

    @NotNull
    public Vector2 scale() {
        return this.dimensions();
    }

    @Override
    @NotNull
    public Vector2 position(double u, double v) {
        return this.corner.plus(new Vector2(u * this.width, v * this.height));
    }

    public final double x() {
        return this.corner.x();
    }

    public final double y() {
        return this.corner.y();
    }

    @NotNull
    public Shape shape() {
        return new Shape(CollectionsKt.listOf(this.contour()));
    }

    @NotNull
    public ShapeContour contour() {
        ShapeContour shapeContour;
        if (!(!Intrinsics.areEqual(this.corner, Vector2.Companion.getINFINITY()) && this.corner.x() == this.corner.x() && this.corner.y() == this.corner.y() && this.width == this.width && this.height == this.height)) {
            shapeContour = ShapeContour.Companion.getEMPTY();
        } else {
            Vector2[] vector2Array = new Vector2[]{this.corner, this.corner.plus(new Vector2(this.width, 0.0)), this.corner.plus(new Vector2(this.width, this.height)), this.corner.plus(new Vector2(0.0, this.height))};
            shapeContour = ShapeContour.Companion.fromPoints(CollectionsKt.listOf(vector2Array), true, YPolarity.CW_NEGATIVE_Y);
        }
        return shapeContour;
    }

    @NotNull
    public final Rectangle offsetEdges(double offset, double offsetY) {
        return new Rectangle(new Vector2(this.corner.x() - offset, this.corner.y() - offsetY), this.width + (double)2 * offset, this.height + (double)2 * offsetY);
    }

    public static /* synthetic */ Rectangle offsetEdges$default(Rectangle rectangle, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = d;
        }
        return rectangle.offsetEdges(d, d2);
    }

    @Deprecated(message="Vague naming", replaceWith=@ReplaceWith(expression="scaledBy(scale, scaleY)", imports={}))
    @NotNull
    public final Rectangle scale(double scale, double scaleY, double anchorU, double anchorV) {
        return this.scaledBy(scale, scaleY, anchorU, anchorV);
    }

    public static /* synthetic */ Rectangle scale$default(Rectangle rectangle, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = d;
        }
        if ((n & 4) != 0) {
            d3 = 0.5;
        }
        if ((n & 8) != 0) {
            d4 = 0.5;
        }
        return rectangle.scale(d, d2, d3, d4);
    }

    @Deprecated(message="Doesn't account for anchor placement", replaceWith=@ReplaceWith(expression="scaledBy(scale, scaleY)", imports={}))
    @NotNull
    public final Rectangle scaled(double scale, double scaleY) {
        return new Rectangle(this.corner, this.width * scale, this.height * scaleY);
    }

    public static /* synthetic */ Rectangle scaled$default(Rectangle rectangle, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = d;
        }
        return rectangle.scaled(d, d2);
    }

    @NotNull
    public final Rectangle widthScaledTo(double fitWidth) {
        double scale = fitWidth / this.width;
        return new Rectangle(this.corner, fitWidth, this.height * scale);
    }

    @NotNull
    public final Rectangle heightScaledTo(double fitHeight) {
        double scale = fitHeight / this.height;
        return new Rectangle(this.corner, this.width * scale, fitHeight);
    }

    @Deprecated(message="Vague naming", replaceWith=@ReplaceWith(expression="movedBy(offset)", imports={}))
    @NotNull
    public final Rectangle moved(@NotNull Vector2 offset) {
        Intrinsics.checkNotNullParameter(offset, "offset");
        return new Rectangle(this.corner.plus(offset), this.width, this.height);
    }

    @Override
    @NotNull
    public Rectangle movedBy(@NotNull Vector2 offset) {
        Intrinsics.checkNotNullParameter(offset, "offset");
        return new Rectangle(this.corner.plus(offset), this.width, this.height);
    }

    @Override
    @NotNull
    public Rectangle movedTo(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        return new Rectangle(position, this.width, this.height);
    }

    @Override
    @NotNull
    public Rectangle scaledBy(double xScale, double yScale, double uAnchor, double vAnchor) {
        Vector2 anchorPosition = this.position(uAnchor, vAnchor);
        Vector2 d = this.corner.minus(anchorPosition);
        Vector2 nd = anchorPosition.plus(d.times(new Vector2(xScale, yScale)));
        return new Rectangle(nd, this.width * xScale, this.height * yScale);
    }

    @Override
    @NotNull
    public Rectangle scaledBy(double scale, double uAnchor, double vAnchor) {
        return this.scaledBy(scale, scale, uAnchor, vAnchor);
    }

    @Override
    @NotNull
    public Rectangle scaledTo(double width, double height) {
        return new Rectangle(this.corner, width, height);
    }

    @Override
    @NotNull
    public Rectangle scaledTo(double size) {
        return this.scaledTo(size, size);
    }

    @NotNull
    public final Rectangle flippedHorizontally(double u) {
        return u == 0.5 ? (Rectangle)Scalable2D.DefaultImpls.scaledBy$default(this, -1.0, 1.0, 0.0, 0.0, 12, null) : ((Rectangle)Scalable2D.DefaultImpls.scaledBy$default(this, -1.0, 1.0, 0.0, 0.0, 12, null)).movedBy(new Vector2((u * (double)2 - 1.0) * this.width, 0.0));
    }

    public static /* synthetic */ Rectangle flippedHorizontally$default(Rectangle rectangle, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return rectangle.flippedHorizontally(d);
    }

    @NotNull
    public final Rectangle flippedVertically(double v) {
        return v == 0.5 ? (Rectangle)Scalable2D.DefaultImpls.scaledBy$default(this, 1.0, -1.0, 0.0, 0.0, 12, null) : ((Rectangle)Scalable2D.DefaultImpls.scaledBy$default(this, 1.0, -1.0, 0.0, 0.0, 12, null)).movedBy(new Vector2(0.0, (v * (double)2 - 1.0) * this.height));
    }

    public static /* synthetic */ Rectangle flippedVertically$default(Rectangle rectangle, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return rectangle.flippedVertically(d);
    }

    @NotNull
    public final LineSegment horizontal(double v) {
        return new LineSegment(this.position(0.0, v), this.position(1.0, v));
    }

    public static /* synthetic */ LineSegment horizontal$default(Rectangle rectangle, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return rectangle.horizontal(d);
    }

    @NotNull
    public final LineSegment vertical(double u) {
        return new LineSegment(this.position(u, 0.0), this.position(u, 1.0));
    }

    public static /* synthetic */ LineSegment vertical$default(Rectangle rectangle, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return rectangle.vertical(d);
    }

    public final boolean contains(@NotNull Vector2 point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return point.x() >= this.corner.x() && point.x() < this.corner.x() + this.width && point.y() >= this.corner.y() && point.y() < this.corner.y() + this.height;
    }

    public final boolean intersects(@NotNull Rectangle other) {
        Intrinsics.checkNotNullParameter(other, "other");
        boolean above = this.y() + this.height < other.y();
        boolean below = this.y() > other.y() + other.height;
        boolean rightOf = this.x() > other.x() + other.width;
        boolean leftOf = this.x() + this.width < other.x();
        return !above && !below && !leftOf && !rightOf;
    }

    @Override
    @NotNull
    public Rectangle times(double scale) {
        return new Rectangle(this.corner.times(scale), this.width * scale, this.height * scale);
    }

    @Override
    @NotNull
    public Rectangle div(double scale) {
        return new Rectangle(this.corner.div(scale), this.width / scale, this.height / scale);
    }

    @Override
    @NotNull
    public Rectangle plus(@NotNull Rectangle right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Rectangle(this.corner.plus(right.corner), this.width + right.width, this.height + right.height);
    }

    @Override
    @NotNull
    public Rectangle minus(@NotNull Rectangle right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Rectangle(this.corner.minus(right.corner), this.width - right.width, this.height - right.height);
    }

    @NotNull
    public final Rectangle sub(@NotNull ClosedFloatingPointRange<Double> u, @NotNull ClosedFloatingPointRange<Double> v) {
        Intrinsics.checkNotNullParameter(u, "u");
        Intrinsics.checkNotNullParameter(v, "v");
        return this.sub(((Number)u.getStart()).doubleValue(), ((Number)v.getStart()).doubleValue(), ((Number)u.getEndInclusive()).doubleValue(), ((Number)v.getEndInclusive()).doubleValue());
    }

    @NotNull
    public final Rectangle sub(double u0, double v0, double u1, double v1) {
        Vector2 p0 = this.position(u0, v0);
        Vector2 p1 = this.position(u1, v1);
        double width = p1.x() - p0.x();
        double height = p1.y() - p0.y();
        return RectangleKt.Rectangle(p0.x(), p0.y(), width, height);
    }

    @NotNull
    public final IntRectangle toInt() {
        return IntRectangleKt.IntRectangle((int)this.x(), (int)this.y(), (int)this.width, (int)this.height);
    }

    @NotNull
    public final Vector2.Axis majorAxis() {
        return this.width >= this.height ? Vector2.Axis.X : Vector2.Axis.Y;
    }

    @NotNull
    public final Vector2.Axis minorAxis() {
        return this.width <= this.height ? Vector2.Axis.X : Vector2.Axis.Y;
    }

    @NotNull
    public final Rectangle ratio(@NotNull Vector2.Axis axis) {
        Intrinsics.checkNotNullParameter((Object)axis, "axis");
        double scale = 1.0 / this.dimensions().dot(axis.getDirection());
        return Companion.fromCenter(Vector2.Companion.getZERO(), this.width * scale, this.height * scale);
    }

    public static /* synthetic */ Rectangle ratio$default(Rectangle rectangle, Vector2.Axis axis, int n, Object object) {
        if ((n & 1) != 0) {
            axis = rectangle.majorAxis();
        }
        return rectangle.ratio(axis);
    }

    @NotNull
    public final Rectangle normalized() {
        double nx = this.x();
        double ny = this.y();
        if (this.width < 0.0) {
            nx += this.width;
        }
        if (this.height < 0.0) {
            ny += this.height;
        }
        return RectangleKt.Rectangle(nx, ny, Math.abs(this.width), Math.abs(this.height));
    }

    @NotNull
    public final Vector2 component1() {
        return this.corner;
    }

    public final double component2() {
        return this.width;
    }

    public final double component3() {
        return this.height;
    }

    @NotNull
    public final Rectangle copy(@NotNull Vector2 corner, double width, double height) {
        Intrinsics.checkNotNullParameter(corner, "corner");
        return new Rectangle(corner, width, height);
    }

    public static /* synthetic */ Rectangle copy$default(Rectangle rectangle, Vector2 vector2, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = rectangle.corner;
        }
        if ((n & 2) != 0) {
            d = rectangle.width;
        }
        if ((n & 4) != 0) {
            d2 = rectangle.height;
        }
        return rectangle.copy(vector2, d, d2);
    }

    @Override
    @NotNull
    public String toString() {
        return "Rectangle(corner=" + this.corner + ", width=" + this.width + ", height=" + this.height + ")";
    }

    @Override
    public int hashCode() {
        int result = this.corner.hashCode();
        result = result * 31 + Double.hashCode(this.width);
        result = result * 31 + Double.hashCode(this.height);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Rectangle)) {
            return false;
        }
        Rectangle rectangle = (Rectangle)other;
        if (!Intrinsics.areEqual(this.corner, rectangle.corner)) {
            return false;
        }
        if (Double.compare(this.width, rectangle.width) != 0) {
            return false;
        }
        return Double.compare(this.height, rectangle.height) == 0;
    }

    @Override
    @NotNull
    public Vector2 position(@NotNull Vector2 uv) {
        return Scalable2D.DefaultImpls.position(this, uv);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_shape(Rectangle self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeSerializableElement(serialDesc, 0, Vector2$.serializer.INSTANCE, self.corner);
        output.encodeDoubleElement(serialDesc, 1, self.width);
        if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : Double.compare(self.height, self.width) != 0) {
            output.encodeDoubleElement(serialDesc, 2, self.height);
        }
    }

    public /* synthetic */ Rectangle(int seen0, Vector2 corner, double width, double height, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 3, $serializer.INSTANCE.getDescriptor());
        }
        this.corner = corner;
        this.width = width;
        this.height = (seen0 & 4) == 0 ? this.width : height;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tJ(\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tJ\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/openrndr/shape/Rectangle$Companion;", "", "<init>", "()V", "fromCenter", "Lorg/openrndr/shape/Rectangle;", "center", "Lorg/openrndr/math/Vector2;", "width", "", "height", "fromAnchor", "anchorUV", "anchor", "EMPTY", "getEMPTY", "()Lorg/openrndr/shape/Rectangle;", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-shape"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Rectangle fromCenter(@NotNull Vector2 center, double width, double height) {
            Intrinsics.checkNotNullParameter(center, "center");
            return this.fromAnchor(new Vector2(0.5, 0.5), center, width, height);
        }

        public static /* synthetic */ Rectangle fromCenter$default(Companion companion, Vector2 vector2, double d, double d2, int n, Object object) {
            if ((n & 4) != 0) {
                d2 = d;
            }
            return companion.fromCenter(vector2, d, d2);
        }

        @NotNull
        public final Rectangle fromAnchor(@NotNull Vector2 anchorUV, @NotNull Vector2 anchor, double width, double height) {
            Intrinsics.checkNotNullParameter(anchorUV, "anchorUV");
            Intrinsics.checkNotNullParameter(anchor, "anchor");
            return RectangleKt.Rectangle(anchor.x() - width * anchorUV.x(), anchor.y() - height * anchorUV.y(), width, height);
        }

        public static /* synthetic */ Rectangle fromAnchor$default(Companion companion, Vector2 vector2, Vector2 vector22, double d, double d2, int n, Object object) {
            if ((n & 8) != 0) {
                d2 = d;
            }
            return companion.fromAnchor(vector2, vector22, d, d2);
        }

        @NotNull
        public final Rectangle getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final KSerializer<Rectangle> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

