pico-8 cartridge // http://www.pico-8.com
version 42
__lua__
tick = 0
rad = 0
mult=1
prtcls = {}
bomb = {
  x = 52,
  y = 94
}
keks = {}
stars = {}
added_keks = false
intro = {
    load = function()
        cls(13)
        color(6)
        print("kexfabriken",64-20,64+12)
        spr(64,64-16,64-24,4,4)
        spr(6,84,95,6,6)
        spr(68,6,95,2,6)
    end,
    last = 32767 -- max time
}
-- WARNING SCREEN
scene_1 = {
  load = function()
    cls()
    print("EMERGENCY", 47, 85)
    spr(64,64-16,64-24,4,4)
    music(0)
  end,
  last = 32767,
  blink_t = time(),
  show = true
}
-- ANIM START
scene_2 = {
    load = function()
        -- Scene 1 init function
          d = {
            pixX = 0,
            pixY = 32,
            wid = 32,
            hght = 32,
            locX = 48,
            locY = 48,
            dispW = 32,
            dispH = 32,
            flipX = false,
            flipY = false,
            intro = true,
        }
        star1 = {x=5, y=0, s=1}
        star2 = {x=22, y=21, s=2}
        star3 = {x=76, y=88, s=3}
        star4 = {x=7, y=67, s=1}
        star5 = {x=29, y=54, s=2}
        star6 = {x=65, y=30, s=3}
        star7 = {x=72, y=58, s=1}
        star8 = {x=74, y=63, s=2}
        star9 = {x=88, y=88, s=1}
        star10 = {x=99, y=22, s=2}
        star11 = {x=105, y=43, s=3}
        star12 = {x=118, y=67, s=2}
        add(stars,star1)
        add(stars,star2)
        add(stars,star3)
        add(stars,star4)
        add(stars,star5)
        add(stars,star6)
        add(stars,star7)
        add(stars,star8)
        add(stars,star9)
        add(stars,star10)
        add(stars,star11)
        add(stars,star12)
        music(2)
    end,
    last = 32767
}
scene_3 ={
  load = function()
    cls(7)
  end,
  last = 32767,
  tick = 0
}
credits = {
  load = function()
    cls()
  end,
  last = 32767
}
current_scene = intro

function _init()
    intro.load()
    intro.last = time()
end

function shift()
  cls()
  absH = d.locY + d.dispH

  if absH < 127 and d.intro then
      d.locY += ((128-d.dispH) - d.locY) * 0.06
      
      if d.dispW > 16 then
          d.dispW -= abs((20 - d.dispW) * 0.05)
          d.dispH -= abs((26 - d.dispH) * 0.05)
          d.locX += ((54 - d.locX) * 0.05)
      end
    draw_stars()
    elseif d.intro then
      kek1 = {x=14,y=20,type="flow"}
      kek2 = {x=34,y=20,type="flow"}
      kek3 = {x=54,y=20,type="flow"}
      kek4 = {x=74,y=20,type="flow"}
      add(keks,kek1)
      add(keks,kek2)
      add(keks,kek3)
      add(keks,kek4)
      d.intro = false
    end
    
  if not d.intro then
    if absH > 122 then
      d.locY -= 0.3
      draw_stars()
    end

    if count(prtcls) < 80 then
        add_particle(d.locX+7+rnd(6),d.locY+25)
        add_particle(d.locX+7+rnd(6),d.locY+25)
        add_particle(d.locX+7+rnd(6),d.locY+25)
        add_particle(d.locX+7+rnd(6),d.locY+25)
    end
    update_particles()
    draw_particles()
    update_stars()
  end
end

function _update()
    if current_scene == intro and t() > current_scene.last + 3 then
        load_scene(scene_1)
    end
    if current_scene == scene_1 and t() > current_scene.last + 9 then
        load_scene(scene_2)
    end
    if current_scene == scene_2 and t() > current_scene.last + 14 then
        load_scene(scene_3)
    end
    if current_scene == scene_1 then
    -- Main loop scene 1
      if t() > scene_1.blink_t +.4 then
        if show == true then
          color(6)
          print("EMERGENCY", 47, 85)
          scene_1.blink_t = t()
          if scene_1.last + 1 < t() then
            print("BAD KEX R HERE", 35, 92)
          end
          if scene_1.last + 3 < t() then
            print("WE NEED YOU KEXFABRIKEN", 22, 99)
          end
          if scene_1.last + 5 < t() then
            print("ONLY YOU CAN SAVE US", 24, 106)
          end
          if scene_1.last + 6 < t() then
            print("ONLY YOU CAN SAVE US.", 24, 106)
          end
          if scene_1.last + 7 < t() then
            print("ONLY YOU CAN SAVE US..", 24, 106)
          end
          if scene_1.last + 8 < t() then
            print("ONLY YOU CAN SAVE US...", 24, 106)
          end
          show = false
        else 
          color(8)
          print("EMERGENCY", 47, 85)
          scene_1.blink_t = t()
          show = true
        end
      end 
    end
    if current_scene == scene_2 then
        -- Main loop scene 2
        cls(0)
        shift()
        sspr(d.pixX,d.pixY,d.wid,d.hght,d.locX,d.locY, d.dispW, d.dispH, d.flipX)
        update_keks()
        if scene_2.last +4 < t() and not added_keks then
          kek1 = {x=36,y=10,type="flow"}
          kek2 = {x=56,y=10,type="flow"}
          kek3 = {x=76,y=10,type="flow"}
          kek4 = {x=96,y=10,type="flow"}
          kek5 = {x=116,y=10,type="flow"}
          add(keks,kek1)
          add(keks,kek2)
          add(keks,kek3)
          add(keks,kek4)
          add(keks,kek5)
          added_keks = true
        end
        if scene_2.last +6 < t() then
          shoot_bomb()
        end
        if scene_2.last + 10 < t() then
          update_explosion()
        end
    end
    if current_scene == scene_3 then
        -- Main loop scene 3
        scene_3.tick +=1
        if scene_3.tick < 64 then
          -- Top box
          rectfill(0,0,128,scene_3.tick,0)
          -- bottom box
          rectfill(0,128-scene_3.tick,128,128,0)
        elseif scene_3.tick <= 128 then
          cls()
          rectfill(scene_3.tick-64,64,128-(scene_3.tick-64),64,7)
        else
          load_scene(credits)
        end
    end
    if current_scene == credits then
      -- Main loop credits
      if current_scene.last + 1 < t(0) then
        print("thanks revision", 35,40)
      end
      if current_scene.last + 3 < t(0) then
        print("first demo by spiderbro & samar", 5, 52)
      end
      if current_scene.last + 5 < t(0) then
        print("special thanks to scrapper", 15, 61)
        print("for the music", 37, 68);
      end
    end
end

function load_scene(scene)
    scene.load()
    scene.last = time()
    current_scene = scene
end

--kek system
function update_keks()
  for k in all(keks) do
    if k.type=="flow" then
      k.x = sin(t())*5+k.x
      k.y = cos(t())*2+k.y
    end
    spr(18, k.x, k.y)
  end
end

-- particle code
function add_particle(x, y)
  add(prtcls, {
    x = x,
    y = y,
    vx = rnd(2) - 1,
    vy = rnd(1) - 1,
    c = rnd(3) + 8,
    lifetime = rnd(10)+10
  })
end

function update_particles()
  local i = 1
  while i <= #prtcls do
    local p = prtcls[i]
    p.x = p.x - p.vx
    p.y = p.y - p.vy
    p.lifetime = p.lifetime - 1
    
    if p.lifetime <= 0 then
      del(prtcls, p)
    else
      i = i + 1
    end
  end
end

function draw_particles()
  for p in all(prtcls) do
    pset(p.x, p.y, p.c)
  end
end

function draw_stars()
  for s in all(stars) do
    spr(48, s.x, s.y)
  end
end

--star system
function update_stars()
  for s in all(stars) do
    s.y = s.y + s.s
    if s.y > 128 then
      s.y -= 128
    end
    spr(48, s.x, s.y)
  end
end

function shoot_bomb()
  bomb.y = lerp(34,bomb.y,0.95)
  spr(19,bomb.x,bomb.y)
end

function lerp(tar,pos,perc)
  return (1-perc)*tar + perc*pos;
end

function update_explosion()
	tick += 1
	if tick%1==0 then
		rad += 1
		mult+=.18
	end
  circfill(56,38,rad*mult,7)
end

__gfx__
00000000000990000000000077777777700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000009aa9000070070070000007077000000000000000000000000000700000000000000000000000000000000000000000000000000000000000000000
0070070009a99a900070070070700707077000000000000000000000000000700000000000000000000000000000000000000000000000000000000000000000
000770009a9aa9a90070070070700707700000000000000000007000000000700000000000000000000000000000000000000000000000000000000000000000
000770009a9aa9a90000000070000007000000000000000000007000000000700000000000770000000000000000000000000000000000000000000000000000
0070070009a99a900700007070077007000000000000000000007700000007700000000007700000000000000000000000000000000000000000000000000000
00000000009aa9000077770070000007000000000000000000000700000007000000000770000000000000000000000000000000000000000000000000000000
00000000000990000000000077777777000000000000000000000700000007000000007700000000000000000000000000000000000000000000000000000000
00000000400000000024440000000000000000000000000000000770000007000000077000000000000000000000000000000000000000000000000000000000
00000004440000000244404000555500000000000000000000000070000007000000770000000000000000000000000000000000000000000000000000000000
00000044444000002404444405d88d50000000000000000000000077000007000007700000000000000000000000000000000000000000000000000000000000
0000044444440000244404445d8668d5000000000000000000000007000000000000000000000000000000000000000000000000000000000000000000000000
0000444044444000244444045d8668d5000000000000000007000000000000000000000000000000000000000000000000000000000000000000000000000000
00044440444444002240444205d88d50000000000000000077000000000777700000000000000000000000000000000000000000000000000000000000000000
00444000004440000224442000555500000000000000000077000000007000077000000000000000000000000000000000000000000000000000000000000000
04444440444400000022220000000000000000000000000000700000070070000700000000000000000000000000000000000000000000000000000000000000
44444440444000000000000000000000000000000000000000077000700000000070000000000000000000000000000000000000000000000000000000000000
04444444440000000000000000000000000000000000000000000707007000070070000000000000000000000000000000000000000000000000000000000000
00444444400000000000000000000000000000000000000000000070000000000077777770000007777770000000000000000000000000000000000000000000
00044444000000000070000070000000000000007000000000000070000007000700000007000770000007000000000000000000000000000000000000000000
00004440000000000070000070000000000700000700000000000070770000007000000000707700000000700000000000000000000000000000000000000000
00000400000000000070000070000000007000000070000000000077007000070000000000070000000000700000000000000000000000000000000000000000
00000000000000000070000070000000070000000007070000000000000700770000000000007000000000700000000000000000000000000000000000000000
00000000000000000077000077000000007000000000700000000000000707007700000000007000000000700000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000770007077000000070000000000700000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000070000700000707777000007000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000700007777777000700777777000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000700070000070000700070000700000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000700070000007000070070000700000000000000000000000000000000000000000
00001000000000000000000000000000000000000000000000000000000007000070000007000070070000070000000000000000000000000000000000000000
00011100000000000000000000000000000000000000000000000000000007000070000000700070007000070000000000000000000000000000000000000000
00001000000000000000000000000000000000000000000000000000000007000070000000700070007000007000000000000000000000000000000000000000
07777777000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777000000000000000000000000000000000000060000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777000000000000000000000000000000000000066000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777000000000000000000000000000000000000076000000000000000000000000000000000000000000000000000000000000000000000000000000000
0777777700000000000000000000000000000005a000076000000000000000000000000000000000000000000000000000000000000000000000000000000000
0777777700000000000000000000000000000555a000066000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777000000000000000000000000000055555500066000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777000000000000000000000000005555555500066000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777000000000000000000000000000077717000066000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777000000000000000000000000000077777000066000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777000000000000000000000000000004770000444400000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777000000770000007700000077000004440000077000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777000077770000777700007777000000700000744000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777000777770007777700077777000000700007000000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777007777770077777700777777000007777770000000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777077777770777777707777777000070700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777077777770777777707777777000700700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777777777777777777777777777066666700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0777777777777777777777777777777706ccc6700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0777777777777777777777777777777706c666700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0777777770077777777777777777777706ccc6700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
077777777007777777777777777777770666c6700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0777777770077777777777777777777706ccc6070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777700777007770007700777007066666070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777700770007000000700070007000007070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777700700077007770770000077000007077770000000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777700000777000000777000777000077000070000000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777700000077007777770000077000070000070000000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777700770007000000700070007000070000077000000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777700777007770007700777007000070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
07777777777777777777777777777777000077000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__sfx__
000a00001a00113051130311302113011130010000100001130011a0511a0311a0211a0111a00100001000011a00113051130311302113011130010000100001130011a0511a0311a0211a0111a0010000100001
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
010800002600000000240000000024000000002400000000260000000000000000002400000000000000000026000000000000000000000000000000000000002900000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0f0800001a050000001a030000001a020000001a01000000180500000018030000001802000000180100000013050000001303000000130200000013010000001305000000130300000013020000001301000000
0f0800001305000000130400000013030000001303000000130200000013020000001301000000130100000013050000001304000000130300000013030000001302000000130200000013010000001301000000
0f080000130500000013040000001303000000130300000013020000001302000000180400000018040000001a050000001a040000001a030000001a030000001a020000001a020000001a010000001a01000000
0f080000130500000013040000001303000000130300000013020000001302000000180400000018040000001a050000001a040000001a030000001a030000001d050000001d030000001d020000001d01000000
010800001f02513025180250c0251f02513025180250c0251f02513025180250c0251f02513025180250c0251f02513025180250c0251f02513025180250c0251f02513025180250c0251f02513025180250c025
010800001f0301a030170301f0301a030170301f0301a0301f0301a030160301f0301a030160301f0301a0301e0301a030150301e0301a030150301e0301a0301e0301a030150301e0301a030150301e0301a030
6308000018613246003c600136003c620136003c6100060018613246003c600136003c620136003c6100060018613246003c600136003c620136003c6100060018613246003c600136003c620136003c61000600
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011000001a0001d000210001a0001d000210001a0001d000180001c0001f000180001c0001f000180001c0001a0001d000210001a0001d000210001a0001d000180001c0001f000180001c0001f000180001c000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
910800002655026550265200050024550245502452000500265502655026520005002455024550245200050026550265502652000500005000050000500005002955029550295200050000500005000050000500
910800002b5502b5502b520005002e5002e5002e500005002e5502e5502e52000500005000050000500005002b5502b5502b52000500005000050000500005000050000500005000050029550295200050000500
000800000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000800000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__music__
00 00494344
02 00424344
01 0450430a
00 0551430a
00 0651430a
00 0450430a
00 0410080a
00 0511080a
00 0611080a
02 0410080a