pico-8 cartridge // http://www.pico-8.com
version 42
__lua__
bPoints="\
        23,7,7,16,7,29,19,29,\
        19,29,37,28,35,42,9,46,\
        30,24,61,21,61,14,39,9,\
        39,9,32,17,42,23,33,36,\
        62,34,44,38,45,30,56,24,\
        56,23,70,27,39,45,77,34,\
        85,22,65,21,69,39,83,35,\
        82,41,110,30,112,14,95,16,\
        96,16,91,22,81,38,103,41,\
        10,53,8,64,8,70,5,91,\
        9,53,34,52,31,75,3,76,\
        3,76,47,64,35,87,0,91,\
        45,73,37,74,33,82,42,85,\
        42,85,51,84,56,73,45,73,\
        60,50,63,64,59,74,55,88,\
        71,49,66,59,66,73,63,88,\
        48,59,76,59,76,65,67,65,\
        79,51,76,65,64,93,84,83,\
        84,83,107,83,107,71,99,72,\
        99,72,80,67,82,94,104,90"
calculatedCurve={}
t=-10
c=7
max_beziera_len=5

function calc_point(i,offset)
    x=bPoints[1+offset*8]*(1-i)*(1-i)*(1-i)
    x+=3*bPoints[3+offset*8]*i*(1-i)*(1-i)
    x+=3*bPoints[5+offset*8]*i*i*(1-i)
    x+=bPoints[7+offset*8]*i*i*i

    y=bPoints[2+offset*8]*(1-i)*(1-i)*(1-i)
    y+=3*bPoints[4+offset*8]*i*(1-i)*(1-i)
    y+=3*bPoints[6+offset*8]*i*i*(1-i)
    y+=bPoints[8+offset*8]*i*i*i

    return flr(x+0.5),flr(y+0.5)
end

function init_beziera()
    bPoints=split(bPoints)
    curvesCount=(#bPoints)/8
    last_x, last_y=-1,-1
    for j=0,curvesCount-1 do
        for i=0,1,0.01 do
            x,y=calc_point(i,j)
            -- printh(x.." "..y,"log.txt")
            if x!=last_x or y!=last_y then
                add(calculatedCurve,x)
                add(calculatedCurve,y)
                last_x,last_y=x,y
            end
        end
    end
end

function _init()
    init_beziera()  
end
function _update()
    t+=1
    if(max_beziera_len<#calculatedCurve)then
        max_beziera_len+=3
        if(max_beziera_len>#calculatedCurve)then
            max_beziera_len=#calculatedCurve-1
        end
    end
end

function draw_beziera()
    for i=1,max_beziera_len do
        pset(calculatedCurve[i*2+1],calculatedCurve[i*2+2],c)
    end
end

function _draw()
    -- if t<0 then
    --     cls()
    --     -- printh(t,"log.txt",true)
    -- elseif t<#calculatedCurve then
    --     pset(calculatedCurve[t*2+1],calculatedCurve[t*2+2],c)
    -- end
    cls()
    draw_beziera()
end
__gfx__
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00700700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00077000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00077000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00700700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
