/*

 FISHFORM-BODY_TILES.C

 Tile Source File.

 Info:
  Form                 : All tiles as one unit.
  Format               : Gameboy 4 color.
  Compression          : None.
  Counter              : None.
  Tile size            : 8 x 8
  Tiles                : 0 to 15

  Palette colors       : Included.
  SGB Palette          : None.
  CGB Palette          : None.

  Convert to metatiles : No.

 This file was generated by GBTD v2.2

*/
#include <gb/gb.h>
#include <gb/gbdecompress.h>
#include <gb/cgb.h>

#pragma bank 255
BANKREF(fishform_body_tiles)

#define NUM_SPRITE_TILES      22
#define NUM_SPRITE_PALETTES   6

const palette_color_t* const fishformSpriteCGBPal[] =
{
  /* Gameboy Color palette 0 */
  0,
  8520,
  17038,
  23413,
  /* Gameboy Color palette 1 */
  0,
  31214,
  17326,
  24494,
  /* Gameboy Color palette 2 */
  0,
  16893,
  31228,
  16989,
  /* Gameboy Color palette 3 */
  0,
  17373,
  17149,
  0,
  /* Gameboy Color palette 4 */
  0,
  11497,
  24144,
  28347,
  /* Gameboy Color palette 5 */
  0,
  179,
  8638,
  23423,
};

/* Start of tile array. */
const unsigned char fishform_body_tiles[] =
{
  0x03,0x00,0xC7,0x80,0x70,0x34,0xD9,0x86,
  0xFC,0xFA,0xF0,0x83,0xF4,0xFF,0xDC,0x34,
  0x38,0x20,0x3C,0x28,0x34,0x28,0x3C,0x20,
  0x18,0x18,0x10,0x30,0x00,0x00,0x08,0x30,
  0x00,0x48,0x70,0x94,0xE8,0x48,0xF8,0x24,
  0x79,0x3E,0x08,0x0E,0x83,0xD3,0xFF,0xD2,
  0x08,0x06,0x00,0x2E,0x00,0x56,0x3C,0xA4,
  0x58,0x8C,0x78,0x50,0x78,0x20,0x30,0x00,
  0x18,0x00,0x3C,0x43,0x00,0x7E,0xC9,0x00,
  0x3C,0x00,0x18,0x00,0x00,0x18,0x18,0x7E,
  0x7E,0x03,0xFF,0xD5,0xE7,0xE7,0x42,0x42,
  0x00,0x00,0x7C,0x00,0xFE,0x00,0xE2,0x00,
  0xC0,0x00,0xC0,0x00,0xC3,0x00,0x66,0x00,
  0x3C,0x00,0x84,0xD2,0xFF,0xC6,0xE7,0x00,
  0xC3,0x00,0xC3,0x00,0xE7,0x84,0xCE,0xFF,
  0xC1,0x00,0x18,0x88,0xBD,0xFF,0x83,0xC1,
  0xFF,0xC5,0x24,0x24,0x3C,0x3C,0xFF,0xFF,
  0x03,0x7E,0xC5,0xFF,0xFF,0x3C,0x3C,0x24,
  0x24,0x04,0x00,0xC2,0xFF,0x00,0xFF,0x85,
  0xD4,0xFF,0x83,0x52,0xFF,0x83,0xC7,0xFF,
  0xC0,0xFF,0x84,0x95,0xFF,0xC0,0x18,0x08,
  0x00,0xC0,0x38,0x42,0x00,0x7C,0xC1,0x00,
  0x38,0x90,0xEF,0xFF,0x86,0xE0,0xFF,0xC0,
  0x38,0x05,0x7C,0xC0,0x38,0x87,0xF0,0xFF,
  0x43,0x00,0x38,0x89,0xBF,0xFF,0x8C,0xEF,
  0xFF,0x09,0x38,0xDF,0x00,0x00,0x30,0x00,
  0xBC,0x78,0xFE,0x7C,0xBF,0x7E,0x9F,0x7E,
  0x41,0x3E,0x1E,0x00,0x01,0x00,0x0F,0x00,
  0x18,0x07,0x33,0x0F,0x6F,0x1F,0x4F,0x3F,
  0x5F,0x3F,0xDF,0x3F,0x85,0xF0,0xFF,0xC2,
  0x30,0x0F,0x67,0x8E,0xF0,0xFF,0xC6,0x63,
  0x1F,0x47,0x3F,0x47,0x3F,0xCF,0x86,0xE0,
  0xFF,0xC0,0x33,0x84,0xE0,0xFF,0xC3,0x4F,
  0x3F,0xCF,0x3F,0x00
};

uint8_t set_fishform_sprite_tiles(uint8_t start_idx) BANKED {
  gb_decompress_sprite_data(start_idx, fishform_body_tiles);
  return NUM_SPRITE_TILES;
}

uint8_t set_fishform_sprite_palettes(uint8_t start_idx) BANKED {
  set_sprite_palette(start_idx, NUM_SPRITE_PALETTES, fishformSpriteCGBPal);
  return NUM_SPRITE_PALETTES;
}

/* End of FISHFORM-BODY_TILES.C */
