#include "data\\shaders\\FastNoiseLite.h"

#define SHAPE_BOX 0
#define SHAPE_SPHERE 1
#define SHAPE_PLANE 2

struct Effector
{
	float4x4 mtx;
  float4x4 inv_mtx;
	int shape;
	int mode;
	float force_strength;
	float _pad;
};

float3 CalcDisplacement(Effector effector, float3 pos)
{
  float4x4 inv_mtx = transpose(effector.inv_mtx);
  float3 local_pos = mul(float4(pos,1.0f),inv_mtx).xyz;

	fnl_state noise = fnlCreateState();
  noise.noise_type = FNL_NOISE_PERLIN;
  noise.seed = 1337;
  noise.frequency = 20.0f;

  if (effector.shape == SHAPE_BOX)
  {
    if (abs(local_pos.x) > 1.0) return pos;
    if (abs(local_pos.y) > 1.0) return pos;
    if (abs(local_pos.z) > 1.0) return pos;

		float4x4 mtx = transpose(effector.mtx);
		float3 up = mul(float4(0,1,0, 0), mtx).xyz;
		float n = fnlGetNoise2D(noise, local_pos.x, local_pos.y)*0.5+0.5;

    return pos + up*effector.force_strength*lerp(0.1,1.0,n);
  }
  else if (effector.shape == SHAPE_SPHERE)
  {
		if (length(local_pos) <= 1.0f)
		{
			float len = length(local_pos);
			float n = fnlGetNoise3D(noise, local_pos.x, local_pos.y, local_pos.z)*0.5+0.5;
			return pos + normalize(local_pos)*effector.force_strength*len*lerp(0.1,1.0,n);
		}

  }
  else if (effector.shape == SHAPE_PLANE)
  {
		if (dot(float3(0,1,0), local_pos) <= 0.0f)
		{
			float4x4 mtx = transpose(effector.mtx);
			float3 up = mul(float4(0,1,0, 0), mtx).xyz;
			float n = fnlGetNoise2D(noise, local_pos.x, local_pos.y)*0.5+0.5;
			return pos + up*effector.force_strength*lerp(0.1,1.0,n);
		}

  }

  return pos;
}
