#include "data\\shaders\\particles\\particles_common.h"
#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\lights.h"
#include "data\\shaders\\pcss.h"

StructuredBuffer<DirLight> g_dir_lights : register(t0, space1);

StructuredBuffer<CullableLight> g_cullable_lights : register(t1, space1);
StructuredBuffer<uint2> g_light_grid : register(t2, space1);
StructuredBuffer<uint> g_light_index : register(t3, space1);
StructuredBuffer<float4x4> g_shadows_view_proj : register(t4, space1);

//StructuredBuffer<Material> g_materials : register(t5, space1);

Texture2D g_shadow_maps[10] : register(t0, space2);
//Texture2D g_mat_tex[] : register(t0, space3);

SamplerState g_sam_point : register(s0);
SamplerState g_sam_linear : register(s2);
SamplerComparisonState g_sam_shadow : register(s6);

//https://www.geeks3d.com/20130122/normal-mapping-without-precomputed-tangent-space-vectors/
float3x3 cotangent_frame(float3 N, float3 p, float2 uv)
{
    // get edge vectors of the pixel triangle
    float3 dp1 = ddx_fine( p );
    float3 dp2 = ddy_fine( p );
    float2 duv1 = ddx_fine( uv );
    float2 duv2 = ddy_fine( uv );

    // solve the linear system
    float3 dp2perp = cross( dp2, N );
    float3 dp1perp = cross( N, dp1 );
    float3 T = dp2perp * duv1.x + dp1perp * duv2.x;
    float3 B = dp2perp * duv1.y + dp1perp * duv2.y;

    // construct a scale-invariant frame
    float invmax = rsqrt( max( dot(T,T), dot(B,B) ) );
    return float3x3( T * invmax, B * invmax, N );
}

PixelCNMOut main(VertexPPNTOut pin)
{
    PixelCNMOut pout;
    float3 color = float3(0.0f, 0.0f, 0.0f);

    Material mat = g_mat; //= g_materials[pin.mat_index];
    //mat.diffuse = float3(1,1,1);
    //mat.roughness = 0.1;
    //mat.specular = float3(0.04,0.04,0.05);
    //mat.metalness = 0.8f;
    //mat.emissive = float3(0.0,0.0,0.0);
    //mat.hardness = 0.8f;

    float3 n = normalize(pin.normal);
    float3 v = normalize(-pin.pos_v);

    for (uint i = 0; i < (uint)g_num_dir_lights; ++i)
    {
      int shadow_index = g_dir_lights[i].shadow_map_index;
      float shadow_factor = 1.0f;

      if (shadow_index >= 0)
      {
        if (pin.pos_v.z > cascade_ranges[0])
        {
          ++shadow_index;
        }
        if (pin.pos_v.z > cascade_ranges[1])
        {
          ++shadow_index;
        }

        float3 l_uv = WorldToScreen(pin.pos_w, g_shadows_view_proj[shadow_index]);
        l_uv.z = saturate(l_uv.z - 0.0009f);

        shadow_factor = PCF16(g_shadow_maps[shadow_index], g_sam_shadow, l_uv.xy, l_uv.z, 0.001f);
        shadow_factor = lerp(shadow_factor, 1.0f, saturate((pin.pos_v.z - cascade_ranges[2]) / 10.0f));
      }

      color += calc_dir_light(g_dir_lights[i], mat, n, v, shadow_factor);
    }

    if (g_num_cullable_lights > 0)
    {
        float2 pos_xy = pin.pos_h.xy;
        uint grid_index = GridIndex(pos_xy, g_screen_size.x);
        uint num_lights = g_light_grid[grid_index].y;
        uint offset = g_light_grid[grid_index].x;
        for (i = 0; i < num_lights; ++i)
        {
          CullableLight light = g_cullable_lights[g_light_index[offset + i]];

          if (light.type > 1)
          {
            float shadow_factor = 1.0f;
            if (light.shadow_map_index >= 0)
            {
              int shadow_index = light.shadow_map_index;
              float3 l_uv = WorldToScreen(pin.pos_w, g_shadows_view_proj[shadow_index]);
              l_uv.z -= 0.00006f;
              shadow_factor = PCF16(g_shadow_maps[shadow_index], g_sam_shadow, l_uv.xy, l_uv.z, 0.001f);
            }

            color += calc_spot_light(light, mat, n, pin.pos_v, v, shadow_factor);
          }
          else
            color += calc_point_light(light, mat, n, pin.pos_v, v);
        }
    }

    pout.color = float4(color + mat.emissive, 1.0f);
    pout.normal = float4(n, pin.pos_v.z);
    pout.material = float4(mat.roughness,mat.metalness,mat.custom.x,mat.custom.y);
    return pout;
}
