#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\pbd\\pbd_common.h"

StructuredBuffer<Particle> particles : register(t0);
StructuredBuffer<DistConstraint> constraints : register(t1);

VertexPCOut main(uint id : SV_VertexID)
{
	VertexPCOut vout;
	uint constraint_idx = id/2;
  uint point_idx = id%2;
  
  DistConstraint constraint = constraints[constraint_idx]; 

  float3 pos = point_idx == 0 ? float3(particles[constraint.p0].p_x,particles[constraint.p0].p_y,particles[constraint.p0].p_z) 
  : float3(particles[constraint.p1].p_x,particles[constraint.p1].p_y,particles[constraint.p1].p_z);
  
  float4 clip_pos = mul(float4(pos, 1.0f), g_view_proj);
  if (constraint.flags > 0)
      clip_pos = float4(0,0,0,0);
  
  vout.pos_h = clip_pos;
  vout.color = float4(1,0,0,1);
  return vout;
}