#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\pbd\\pbd_common.h"

cbuffer PerMesh : register( b0 )
{
  float4x4 world;
  int particle_offset;
  int constraint_offset;
  uint max_edges;
  uint max_particles;
}

StructuredBuffer<float3> mesh : register( t0 );
RWStructuredBuffer<Particle> particles : register(u0);

[numthreads(8,1,1)]
void main(uint3 dispatch_thread_id  : SV_DispatchThreadID)
{
 uint index = dispatch_thread_id.x;
 if (index >= max_particles)
   return;
 
 uint p_index = particle_offset + index;
 
 float3 pos = mul(float4(mesh[index],1.0f), world).xyz;
 
 particles[p_index].p_x = pos.x;
 particles[p_index].p_y = pos.y;
 particles[p_index].p_z = pos.z;
 
 particles[p_index].prev_x = 0.0;
 particles[p_index].prev_y = 0.0;
 particles[p_index].prev_z = 0.0;

 particles[p_index].v_x = 0.0;
 particles[p_index].v_y = 0.0;
 particles[p_index].v_z = 0.0;

 particles[p_index].w = 1.0;
 particles[p_index].flags = 0;
 particles[p_index].mat_index = 0;
 particles[p_index].normal = float3(0,0,0);
 particles[p_index].softbody = 0;
 particles[p_index].num_constraints = 0;
 
}