#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\pbd\\pbd_common.h"

StructuredBuffer<Particle> in_particles : register( t0 );
RWStructuredBuffer<Particle> out_particles : register(u0);

cbuffer PerFrame : register(b0)
{
  double delta_time;
  uint max_particles;
  uint max_constraints;
}

[numthreads(8,1,1)]
void main(uint3 dispatch_thread_id  : SV_DispatchThreadID)
{  
  uint index = dispatch_thread_id.x;
  
  if (index >= max_particles)
    return;
  
  Particle particle = in_particles[index];

  particle.v_x = (particle.p_x - particle.prev_x) / delta_time;
  particle.v_y = (particle.p_y - particle.prev_y) / delta_time;
  particle.v_z = (particle.p_z - particle.prev_z) / delta_time;

  //collision with plane
  if (particle.p_y <= 0.0f)
  {   
    particle.p_y = 0.0;
    
    particle.v_x = 0.0;
    particle.v_y = 0.0;
    particle.v_z = 0.0;
  }

  out_particles[index] = particle;
}