#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"

Texture2D g_input : register(t0);
Texture2D g_normal : register(t2);
Texture2D g_material : register(t3);
SamplerState g_sam_point : register(s0);
SamplerState g_sam_linear : register(s2);

static const float weights[8] = { 0.071303, 0.131514, 0.189879, 0.321392, 0.452906,  0.584419, 0.715932, 0.847445 };

float biasNormalDepth(float3 sourceNormal, float sourceDepth, float2 uv)
{
	float4 otherNormal = g_normal.Sample(g_sam_point, uv);

	float3 normalDelta = abs(otherNormal.xyz - sourceNormal);
	float depthDelta = abs(otherNormal.w - sourceDepth);

	return step(normalDelta.x+normalDelta.y+normalDelta.z, g_ssr_normal_bias) * step(depthDelta, g_ssr_depth_bias);
}

void processSample(float2 uv, float3 sourceNormal, float sourceDepth, float i, float blurQuality, float2 stepSize, inout float4 accumulator, inout float denominator)
{
	float2 offsetUV = stepSize * i + uv;
	float bias = biasNormalDepth( sourceNormal, sourceDepth, offsetUV);
	float coeff = weights[ int(blurQuality - abs(i)) ] * bias;
	accumulator += g_input.Sample(g_sam_linear, offsetUV) * coeff;
	denominator += coeff;
}

float4 main(VertexTOut pin) : SV_Target
{
	float2 uv = pin.uv;

	float4 vNormal = g_normal.Sample(g_sam_point, uv);
	float3 sourceNormal = vNormal.xyz;
	float sourceDepth = vNormal.w;

	float roughness = g_material.Sample(g_sam_point, uv).x;

	float2 texel_offset = float2(16.0f / g_screen_size.x, 0.0f);
	float2 stepSize = texel_offset * saturate(roughness);
	float4 acc = g_input.Sample(g_sam_linear, uv) * 0.214607;
	float denominator = 0.214607;

	float blurQuality = 4.0;
	float offset = 0.0f;

	[unroll]
	for (int i = 0; i < 20; ++i)
	{
		offset = fmod(offset, 2.0f);
		offset += 0.2f;

		float dir = (i == 10) ? 1.0f : float(sign(i - 10));
		processSample(uv, sourceNormal, sourceDepth, dir*offset, blurQuality, stepSize, acc, denominator);
	}

	return acc / denominator;
}
