#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\lights.h"

StructuredBuffer<CullableLight> g_cullable_lights : register(t1, space1);

VertexOutPIOut main(VertexPNTIn vin, uint instance_id : SV_InstanceID)
{
  CullableLight light = g_cullable_lights[instance_id];
  
	VertexOutPIOut vout;
  
  bool scattering = light.scatt_density > 0.0f && light.scatt_multiplier > 0.0f;

  float3 pos = light.position + vin.pos * light.radius;

  if (!scattering)
  {
    pos += float3(0,0,-1000.0f);
  }

  float4 clip_pos = mul(float4(pos, 1.0f), g_proj);
  vout.pos_h = clip_pos;
  vout.instance_id = instance_id;
  vout.clip_pos = clip_pos;
  vout.pos_v = pos;
  
  return vout;
}