﻿#pragma once

class Model;
class Mesh;
class ModelNode {
	public:
		std::string name;
		smallvec<ModelNode*, 100> children;

		std::unordered_map<std::string, ModelNode*> children_map;
	  bool is_dynamic_physics_object = false;

		glm::bvec3 rot_locked = glm::bvec3(true, true, true);

		glm::vec3 position;
		glm::quat rotation;
		glm::vec3 scale;

		// JPH::Shape* collision_shape = nullptr;

		// JPH::Ref<JPH::ShapeSettings::ShapeResult> out_shape;
		JPH::Ref<JPH::Shape> collision_shape;
		// JPH::Ref<JPH::MeshShape> mesh_shape;


		// JPH::MeshShape collision_mesh_shape;


		smallvec<Mesh*, 100> meshes;
		smallvec<Mesh*, 100> mesh_outlines;

		// Matrix<float> transform_matrix;
		aiMatrix4x4 ai_transform_matrix;
		glm::mat4 transform_matrix;


		// auto name = scene->mRootNode->mName;


		ModelNode() = default;
		ModelNode(aiNode* node, Model* model);
};
