float getMagnitude(sampler2D spectTex, float frequency, float time) {
    vec2 spectSize = textureSize(spectTex, 0);
    vec2 spectCoord;
    spectCoord.x = frequency;
    spectCoord.y = 1. - (time * 60.0 / spectSize.y);
    return texture(spectTex, spectCoord).r;
}

vec4 textureSpect(sampler2D spectTex, vec2 uv, float time) {
    float frequency = uv.x;
    float height = uv.y;
    float magnitude = getMagnitude(spectTex, frequency, time);
    if (magnitude > height) {
        if (height <= 0.5) {  // If magnitude <= 0.5: blend green to yellow
            return vec4(mix(vec3(0.0, 1.0, 0.0), vec3(1.0, 1.0, 0.0), height * 2.0), 1.0);
        } else {  // If magnitude > 0.5: blend yellow to red
            return vec4(mix(vec3(1.0, 1.0, 0.0), vec3(1.0, 0.0, 0.0), (height - 0.5) * 2.0), 1.0);
        }
    } else {
        return vec4(0.0, 0.0, 0.0, 0.0);
    }
}
