#version 410
#pragma include "filter_common.glsl"

uniform int u_KawasePass;
uniform int u_RadiusIndex;


// Based on: https://www.shadertoy.com/view/stVXD3
vec4 kawasePass(sampler2D tex, vec2 offset, vec2 uv) {
    vec3 col = texture(tex, uv + offset * vec2(1.0, 1.0)).rgb;
    col += texture(tex, uv + offset * vec2(-1.0, 1.0)).rgb;
    col += texture(tex, uv + offset * vec2(-1.0, -1.0)).rgb;
    col += texture(tex, uv + offset * vec2(1.0, -1.0)).rgb;
    return vec4(col * .25, 1.);
}


float getRadius(int radiusIndex) {
    float radii[3];
    radii[0] = bloomRadius;
    radii[1] = blurRadius;
    radii[2] = dofRadius;
    return radii[radiusIndex];
}


void main() {
    float radius = getRadius(u_RadiusIndex);
    vec2 jitter = hash22(gl_FragCoord.xy + ((u_KawasePass == 2) ? vec2(osg_FrameTime) : vec2(0.0)));
    vec2 offset = vec2(jitter.x * u_InvAspectRatio, jitter.y) * radius * ((4 - u_KawasePass) - (u_KawasePass / 2));

//    vec4 mainColor = texture(p3d_Texture0, uv);
//    p3d_FragColor = vec4(kawasePass(p3d_Texture0, offset, uv).rgb, mainColor.a);

    p3d_FragColor = vec4(kawasePass(p3d_Texture0, offset, uv).rgb, 1.0);
}
