Amiga CPU Blit Read-Only (Proof of Concept ROM)
===============================================

Racing The Beam on the Amiga without RAM
----------------------------------------

Target requirements:  
  - Motorola 68000 CPU @ 7 MHz (fixed timing)
  - PAL on reset (NTSC is not yet implemented)

This demo is for PAL, but for the Revision 2025
the used display window is only 320x180 (16:9).

```
; NOTE: This is the Revision 2025 entry version
; TODO: cleanup, much more coding documentation
```

![A500 without CIAs, Paula, and RAM](README.jpg)


Details
-------

DMA Time Slot Allocation / Horizontal Line
(Amiga Hardware Reference Manual - edited/fixed):  
![DMA Time Slot Allocation / Horizontal Line](dmasloth.png)

With active ROM overlay and/or read-only RAM, we have:  
  - 17 stable CPU registers as work memory, for everything
  - no stack (exceptions/interrupts more or less unusable)
  - no bitplane/sprite/copper DMA, no blits (but BLTNZERO)

Normally the DMA controller (Agnus) fetches the bitplane data words
from Chip RAM and sends it to the video processor (Denise) by writing
to the BPLxDAT registers. The Denise converts that planar registers into
a color lookup and serializes it for the video DAC (Vidiot).
Since this conversion is triggered by BPL1DAT and BPLxDAT can be written
by the CPU, we are able to draw the complete scan line with the CPU.
Even sprites can be displayed (writing to SPRxDATA enables the sprite).

Copy of my DMA time slot allocation development spreadsheet:  
```
DDDDDDDEEE0000000000000000111111111111111122222222222222223333333333333333444444444444444455555555555555556666666666666666777777777777777788888888888888889999999999999999AAAAAAAAAAAAAAAABBBBBBBBBBBBBBBBCCCCCCCCCCCCCCCCDDDDDDDDD|
9ABCDEF0120123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF012345678|
_____|_b__M_M_M_M_d_d_d_a_a_a_a_s_s_s_s_s_s_s_s_s_s_s_s_s_s_s_s___b_______b_______b_______b_______b_______b_______b_______b_______b_______b_______b_______b_______b_______b_______b_______b_______b_______b_______b_______b_______b|
_____|+1__|______________________________________-3______-2______-1_______1_______2_______3_______4_______5_______6_______7_______8_______9______10______11______12______13______14______15______16______17______18______19______20|
_____|____|_______________________________________________________________|<----------------------|-----------------------SPR1DAT----------------------------------------->---->__________________________________|_______|________|
_____|____|_______________________________________________________________|________<--------------|-------------------------------SPR2DAT----------------------------------------->---->__________________________|_______|________|
_____|____|_______________________________________________________________|________________<------|---------------------------------------SPR3DAT----------------------------------------->---->__________________|_______|________|
_____|____|_______________________________________________________________|_______________________|<----------------------------------------------SPR4DAT----------------------------------------->---->__________|_______|________|
_____|____|_______________________________________________________________|_______________________|________<----------------------------------------------SPR5DAT----------------------------------------->---->__|_______|________|
_____|____|_______________________________________________________________|_______________________|________________<----------------------------------------------SPR6DAT----------------------------------------->---->__|________|
_____|____|_______________________________________________________________|_______________________|_______________________|<----------------------------------------------SPR7DAT---------------------------------|------->---->___|
---->|____|_______________________________________________________________|_______________________|________<--------------|-------------------------------------------SHADOW--------------------------------------|-------|------->|
---->|____|_______________________________________________________________|<---------zero---------><----------------------|------------------------------------GRID-----------------------------------------------><-left-><-zero->|
---->|____|_______________________________________________________________|<----------------------|-----------------------|---------------------------SPR0DAT-----------------------------------------------------|-------|--------|
_____.R.r.-W.w.p________________________________________________________MOVE.L_(a0)+,(A5)_________|_______________________|_______________________________________________________________________________________|_______|________|
_____|__________.R.r.p.W.w.p.R.r.p.W.w.p.R.r.p.W.w.p.R.r.p.W.w.p________MOVE.L_(a2)+,(d16,A5){4}__|_______________________|_______________________________________________________________________________________|_______|________|
MOVE.W_D0,(A4)__________________________________________________.w.p______|_______________________|_______________________|_______________________________________________________________________________________|_______|________|
MOVE.W_-(a1),Dn_____________________________________________________..r.p_________________________|________________________\______________________________________________________________________________________|_______|________|
MOVE.L_(a2)+,(d16,A5){2}_________________________________________________.R.r.p.W.w.p.R.r.p.W.w.p_|_________________________\_____________________________________________________________________________________|_______|________|
MOVE.W_d1,(A4)___________________________________________________________________________________.w.p____.w.p____.w.p____.w.p\___.w.p____.w.p####.w.p####.w.p####.w.p####.w.p####.w.p####.w.p####.w.p####.w.p##___|_______|________|
MOVE.W_(a2)+,d3______________________________________________________________________________________.r.p____________.r.p_____\___________________________________________________________________________________|_______|________|
MOVE.W_d3,(a3)[+]____________________________________________________________________________________________.w.p____________.w.p_________________________________________________________________________________|_______|________|
SUBQ.L_#2,a3_________________________________________________________________________________________________________________________.p.._________________________________________________________________________|_______|________|
MOVE.W_#$8000,(A4)_____________________________________________________________________________________________________________________________________________________________________________________________.p.w.p########______|
SUBA.W_(a7)+,a2______________________________________________________________________________________________________________________________________________________________________________________________________________.r.p..|
..p.p|__________________________________________________________________DBF_d7_____________________________________________________________________________________________________________________________________________________|
___________________________________________________________________________________________________________________________________________________________________________________________________________________________________|
___________________________________________________________________________________________________________________________________________________________________________________________________________________________________|
```


Notes
-----

Previous research states:  
  - [v0.3.2](https://github.com/nicodex/amiga-ocs-cpubltro/tree/v0.3.2)
    LoRes fullscreen animation with gradient
  - [v0.2.1](https://github.com/nicodex/amiga-ocs-cpubltro/tree/v0.2.1)
    `EHB42 mode`, static 352x280 image
  - [v0.1](https://github.com/nicodex/amiga-ocs-cpubltro/tree/v0.1)
    `EHB42 mode`, simple loop counter

`EHB42 mode` is my name for an Amiga OCS/ECS chipset anomaly:  
With `BPLCON0.BPU = 7` the Agnus fills 4 bitplanes with DMA,
but the Denise draws 6 bitplanes (in Extra Half Brite mode).
`BPL5DAT/BPL6DAT` are not written by the Agnus and can/have
to be filled by CPU. This can/will be used for nice effects.


License
-------

This work is 'public domain' and licensed under the [CC0 1.0 Universal](LICENSES/CC0-1.0.txt) license.

- [TLDRLegal: CC0 1.0 Universal](https://www.tldrlegal.com/license/creative-commons-cc0-1-0-universal)
- [gnu.org/licenses: CC0 1.0 Universal](https://www.gnu.org/licenses/license-list.html#CC0)

This project attempts to conform to the [REUSE](https://reuse.software/) recommendations.


